/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.constant.TaxRateConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.PartitionSaveTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.constant.RuleSettingConstant;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class SmallScaleIncomeFormPlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    public static final String PAGE_ACCOUNTING = "tcvat_accdetail_income";
    public static final String PAGE_TAB = "tcvat_income_invoice_tab";
    private static final String PAGE_TCVAT_XGM_ACCOUNT_SUMMARY = "tcvat_xgm_account_summary";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        Object deadLine = customParams.get("deadLine");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        QFilter periodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
        QFilter deadLineFilter = new QFilter("deadline", "=", deadLine);
        IDataModel model = this.getModel();
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)metaData.getIncome().getAccountMetaDataName(), (String)MetadataUtil.getAllSubFieldString((String)metaData.getIncome().getAccountMetaDataName()), (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter}, (String)"taxperiod,description desc");
        ArrayList strings = Lists.newArrayList((Object[])new String[]{TaxRateConstant.getExcludeTaxCN(), TaxRateConstant.getExportMsTaxCN(), TaxRateConstant.getExportTsTaxCN()});
        if (genericObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("ruleid", dynamicObject.get("ruleid"), rowIndex);
                model.setValue("taxperiod", dynamicObject.get("taxperiod"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("description", dynamicObject.get("description"), rowIndex);
                model.setValue("taxmethod", dynamicObject.get("taxmethod"), rowIndex);
                if (strings.contains(dynamicObject.getString("taxmethod"))) {
                    model.setValue("taxrate", (Object)TaxRateConstant.getNullDataString(), rowIndex);
                } else {
                    model.setValue("taxrate", dynamicObject.get("taxrate"), rowIndex);
                }
                model.setValue("jzjt", dynamicObject.get("jzjt"), rowIndex);
                model.setValue("specialinvoiceamount", dynamicObject.get("specialinvoiceamount"), rowIndex);
                model.setValue("specialtaxamount", dynamicObject.get("specialtaxamount"), rowIndex);
                model.setValue("otherinvoiceamount", dynamicObject.get("otherinvoiceamount"), rowIndex);
                model.setValue("othertaxamount", dynamicObject.get("othertaxamount"), rowIndex);
                model.setValue("noneinvoiceamount", dynamicObject.get("noneinvoiceamount"), rowIndex);
                model.setValue("nonetaxamount", dynamicObject.get("nonetaxamount"), rowIndex);
                model.setValue("totalinvoiceamount", dynamicObject.get("totalinvoiceamount"), rowIndex);
                model.setValue("totaltaxamount", dynamicObject.get("totaltaxamount"), rowIndex);
                model.setValue("pricetaxamount", dynamicObject.get("pricetaxamount"), rowIndex);
                this.markEditCell(model, rowIndex, "entryentity");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        super.afterCreateData(null);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataInfo incomeDraftMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap).getIncome();
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        Long ruleid = (Long)this.getModel().getValue("ruleid", rowIndex);
        String fieldName = evt.getFieldName();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("orgid", customParamMap.get("orgid"));
        String taxperiod = (String)this.getModel().getValue("taxperiod", rowIndex);
        customParams.put("taxperiod", taxperiod);
        customParams.put("taxpayertype", customParamMap.get("taxpayertype"));
        customParams.put("billstatus", customParamMap.get("billstatus"));
        customParams.put("id", this.getModel().getValue("id", rowIndex));
        customParams.put("fieldName", fieldName);
        customParams.put("taxaccountserialno", serialno);
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleid, (String)RuleTypeEnum.INCOME.getEntry());
        customParams.put("invoiceseqs", rule != null && rule.getBoolean("invoiceseqs") ? "true" : "false");
        customParams.put("wkpseqs", rule != null && rule.getBoolean("wkpseqs") ? "true" : "false");
        customParams.put("qtfpseqs", rule != null && rule.getBoolean("qtfpseqs") ? "true" : "false");
        customParams.put("description", this.getModel().getValue("description", rowIndex));
        customParams.put("updateDraft", incomeDraftMetaData.getAccountMetaDataName());
        customParams.put("amount", this.getModel().getValue(fieldName, rowIndex));
        customParams.put("draftnumber", customParamMap.get("draftnumber"));
        customParams.put("drafttype", customParamMap.get("drafttype"));
        customParams.put("deadline", customParamMap.get("deadLine"));
        customParams.put("skssqq", customParamMap.get("skssqq"));
        customParams.put("skssqz", customParamMap.get("skssqz"));
        customParams.put("draftpurpose", customParamMap.get("draftpurpose"));
        switch (fieldName) {
            case "specialinvoiceamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u9500\u552e\u989d", (String)"SmallScaleIncomeFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4e0d\u542b\u7a0e\u9500\u552e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"IncomeFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_ZYSR);
                customParams.put("entry", DraftConstant.XGMNSR_INVOICE_DETAIL);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)PAGE_TAB, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "specialtaxamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"SmallScaleIncomeFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u7a0e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"IncomeFormPlugin_00", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_ZYSE);
                customParams.put("entry", DraftConstant.XGMNSR_INVOICE_DETAIL);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)PAGE_TAB, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "otherinvoiceamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u9500\u552e\u989d", (String)"SmallScaleIncomeFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("entry", incomeDraftMetaData.getDetailMetaDataNameMap().get(PAGE_ACCOUNTING));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u5f00\u5177\u5176\u4ed6\u53d1\u7968\u9500\u552e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"SmallScaleIncomeFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_QTSR);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)PAGE_TAB, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "othertaxamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"SmallScaleIncomeFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("entry", incomeDraftMetaData.getDetailMetaDataNameMap().get(PAGE_ACCOUNTING));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u5f00\u5177\u5176\u4ed6\u53d1\u7968\u7a0e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"SmallScaleIncomeFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_QTSE);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)PAGE_TAB, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "noneinvoiceamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u9500\u552e\u989d", (String)"SmallScaleIncomeFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("entry", incomeDraftMetaData.getDetailMetaDataNameMap().get(PAGE_ACCOUNTING));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u672a\u5f00\u7968\u9500\u552e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"SmallScaleIncomeFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_WKPSR);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)PAGE_TAB, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "nonetaxamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"SmallScaleIncomeFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("entry", incomeDraftMetaData.getDetailMetaDataNameMap().get(PAGE_ACCOUNTING));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u672a\u5f00\u7968\u7a0e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"SmallScaleIncomeFormPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_WKPSE);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)PAGE_TAB, (IFormView)this.getView(), customParams, (IFormPlugin)this);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (PAGE_TAB.endsWith(actionId)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String orgidStr = (String)customParams.get("orgid");
            String skssqqStr = (String)customParams.get("skssqq");
            String skssqzStr = (String)customParams.get("skssqz");
            Date skssqq = DateUtils.stringToDate((String)skssqqStr);
            Date skssqz = DateUtils.stringToDate((String)skssqzStr);
            String taxpayerType = (String)customParams.get("taxpayertype");
            TcvatEngineModel model = TaxDeclareHelper.buildEngineModel(orgidStr, skssqqStr, skssqzStr, taxpayerType, null, customParams.getOrDefault("draftpurpose", "nssb"));
            Object deadLine = customParams.get("deadLine");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgidStr));
            QFilter deadLineFilter = new QFilter("deadline", "=", (Object)(deadLine == null ? "" : deadLine));
            QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
            DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getIncome().getAccountMetaDataName(), (String)"id,serialno,taxperiod,businesstype,description,specialinvoiceamount,othertaxamount,businessamount,pricetaxamount,taxmethodtype,taxrate,jzjt,specialtaxamount,otherinvoiceamount,nonetaxamount,noneinvoiceamount,totalinvoiceamount,totaltaxamount,taxreductioncode,taxreductionname,taxreductiontype,taxreductionid,taxmethod,deadline,org,ruleid,invoiceamount,accountingamount,taxamount", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
            if (genericObjects.size() > 0) {
                List<DynamicObject> groupSummaryDataList;
                String taxperiod = skssqqStr.substring(0, 7);
                TcvatEngineModel model1 = new TcvatEngineModel(orgidStr, skssqqStr, skssqzStr);
                model.getCustom().put("skssqq", skssqq);
                model.getCustom().put("skssqz", skssqz);
                model.getCustom().put("taxperiod", taxperiod);
                model.getCustom().put("deadLine", customParams.get("deadLine"));
                QFilter periodFilter = new QFilter("taxperiod", "=", (Object)taxperiod);
                model.setDraftMetaDataDTO(DraftMetaDataDTO.getMetaData((String)customParams.get("draftpurpose"), taxpayerType));
                if (taxpayerType != null) {
                    DeleteServiceHelper.delete((String)model.getDraftMetaDataDTO().getIncome().getDetailMetaDataNameMap().get(DraftConstant.XGMNSR_TAX_DEDUCTION_SUM), (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
                }
                if (!(groupSummaryDataList = IncomeUtils.groupSummaryData("SmallScaleIncomeEngine", model, (List<DynamicObject>)genericObjects)).isEmpty()) {
                    ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
                }
            }
        }
    }
}

