/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.DraftExportConstant;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.AbstractAccountService;
import kd.taxc.tcvat.business.service.account.DeductionService;
import kd.taxc.tcvat.business.service.account.WaitDeductionFormService;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;

public class WaitDeductionFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
TreeNodeQueryListener {
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String CACHE_KEY = "key";
    private static final String FIRST_COLUMN = "id";
    private static final String LAST_COLUMN = "serialno";
    private static final String DRAFT_TYPE = "drafttype";
    private static final String ORG_ID = "orgid";
    private static final String TAX_PERIOD = "taxperiod";
    private static final String DEDUCTION_TYPE = "deductiontype";
    private static final String SERIAL_NO = "serialno";
    private static final String COUNT = "count";
    private static final String AMOUNT = "amount";
    private static final String TAX_AMOUNT = "taxamount";
    static final String PAGE_TAB = "tcvat_income_invoice_tab";
    private Set<String> deductionList = Sets.newHashSet((Object[])new String[]{"VAT_JXDK_DDK_1", "VAT_JXDK_DDK_2", "VAT_JXDK_DDK_3", "VAT_JXDK_DDK_4", "VAT_JXDK_DDK_5", "VAT_JXDK_DDK_6", "VAT_JXDK_DDK_7", "VAT_JXDK_DDK_8", "VAT_JXDK_DDK_9", "VAT_JXDK_DDK_00"});
    public static final String TCVAT_WAIT_DEDUCTION_DET = "tcvat_wait_deduction_det";
    private WaitDeductionFormService waitDeductionFormService = new WaitDeductionFormService();

    public void registerListener(EventObject e) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        entryGrid.summary();
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addCellClickListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        DraftMetaDataInfo waitDeduction = metaData.getWaitDeduction();
        Object orgid = customParams.get(ORG_ID);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter taxPeriodFilter = new QFilter(TAX_PERIOD, "in", PeriodService.getPeriodList(skssqq, skssqz));
        String deadLine = TaxDeclareHelper.getDeadLine(metaData.getDraftPurpose(), orgid.toString(), skssqq, skssqz);
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)deadLine);
        IDataModel model = this.getModel();
        DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)waitDeduction.getAccountMetaDataName(), (String)MetadataUtil.getAllFieldToQuery((String)waitDeduction.getAccountMetaDataName()), (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter}, (String)"taxperiod,deductiontype");
        List summary = genericObjects.stream().filter(obj -> {
            QFilter qFilter = new QFilter("taxaccountserialno", "=", (Object)obj.getString("serialno"));
            return QueryServiceHelper.exists((String)waitDeduction.getDetailMetaDataNameMap().get(TCVAT_WAIT_DEDUCTION_DET), (QFilter[])new QFilter[]{qFilter});
        }).collect(Collectors.toList());
        if (summary.size() > 0) {
            int rowIndex = 0;
            for (DynamicObject dynamicObject : summary) {
                QFilter qFilter = new QFilter(FIRST_COLUMN, "=", (Object)dynamicObject.getLong(DEDUCTION_TYPE));
                DynamicObject deductiontype = QueryServiceHelper.queryOne((String)"tpo_tcvat_bizdef", (String)"id, number, name", (QFilter[])new QFilter[]{qFilter});
                if (!this.deductionList.contains(deductiontype.getString("number"))) continue;
                model.createNewEntryRow(TREEENTRYENTITY);
                model.setValue(FIRST_COLUMN, dynamicObject.get(FIRST_COLUMN), rowIndex);
                model.setValue("org", dynamicObject.get("org"), rowIndex);
                model.setValue(TAX_PERIOD, dynamicObject.get(TAX_PERIOD), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue(DEDUCTION_TYPE, (Object)deductiontype.getString("number"), rowIndex);
                Object count = dynamicObject.get(COUNT);
                Object amount = dynamicObject.get(AMOUNT);
                Object taxamount = dynamicObject.get(TAX_AMOUNT);
                model.setValue(COUNT, count, rowIndex);
                model.setValue(AMOUNT, amount, rowIndex);
                model.setValue(TAX_AMOUNT, taxamount, rowIndex);
                AbstractAccountService.markEditCell(model, this.getView(), rowIndex, TREEENTRYENTITY);
                ++rowIndex;
            }
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntryGrid.setCollapse(true);
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{TREEENTRYENTITY});
        }
        this.getView().setVisible(Boolean.valueOf("ajsb".equalsIgnoreCase(deadLine)), new String[]{TAX_PERIOD});
        String entityId = this.getView().getEntityId();
        String pluginName = DraftExportConstant.getClassName((String)entityId);
        IPageCache parentPageCache = null;
        if (this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null && this.getView().getParentView().getParentView().getParentView() != null) {
            parentPageCache = this.getView().getParentView().getParentView().getParentView().getPageCache();
        }
        if (parentPageCache != null) {
            parentPageCache.put("draftPageId", this.getView().getPageId());
            parentPageCache.put("entryEntityName", TREEENTRYENTITY);
            parentPageCache.put("pluginFeildExpandStr", null);
            parentPageCache.put("draftDataDtoPluginName", pluginName);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        DraftMetaDataInfo waitDeduction = metaData.getWaitDeduction();
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (this.isExpandRow(propertyName)) {
            return;
        }
        DynamicObject dataEntity = changeData.getDataEntity();
        String deductiontype = dataEntity.getString(DEDUCTION_TYPE);
        if (deductiontype == null) {
            return;
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(TREEENTRYENTITY);
        boolean success = this.waitDeductionFormService.validateChange(dynamicObjects, propertyName, deductiontype);
        if (!success) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91d1\u989d\u4e0d\u53ef\u4ee5\u4e3a\u8d1f\u6570\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"WaitDeductionFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)dataEntity.get(FIRST_COLUMN), (String)waitDeduction.getAccountMetaDataName());
        object.set(propertyName, newValue);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String entryKey = ((EntryGrid)evt.getSource()).getEntryKey();
        int rowIndex = evt.getRowIndex();
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entryKey, rowIndex);
        String fieldName = evt.getFieldName();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        DraftMetaDataInfo waitDeduction = metaData.getWaitDeduction();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        String deductiontype = selectedRow.getString(DEDUCTION_TYPE);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tcvat_bizdef", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)deductiontype)});
        customParams.put("draftpurpose", customParamMap.get("draftpurpose"));
        customParams.put("updateDraft", waitDeduction.getAccountMetaDataName());
        customParams.put(ORG_ID, customParamMap.get(ORG_ID));
        customParams.put(FIRST_COLUMN, this.getModel().getValue(FIRST_COLUMN, rowIndex));
        customParams.put("fieldName", fieldName);
        customParams.put("type", fieldName);
        customParams.put(DEDUCTION_TYPE, deductiontype);
        customParams.put("cellName", DeductionService.getCellName(fieldName, ""));
        customParams.put("description", dynamicObject.getString("name"));
        customParams.put(AMOUNT, this.getModel().getValue(fieldName, rowIndex));
        customParams.put("draftnumber", customParamMap.get("draftnumber"));
        customParams.put(DRAFT_TYPE, customParamMap.get(DRAFT_TYPE));
        customParams.put("billstatus", customParamMap.get("billstatus"));
        customParams.put("entry", waitDeduction.getDetailMetaDataNameMap().get(TCVAT_WAIT_DEDUCTION_DET));
        customParams.put("taxaccountserialno", selectedRow.getString("serialno"));
        customParams.put("customCaption", String.format(ResManager.loadKDString((String)"%s\u660e\u7ec6\u5217\u8868", (String)"WaitDeductionFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), dynamicObject.getString("name")));
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)PAGE_TAB, (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    private boolean isExpandRow(String propertyName) {
        if (propertyName.equals(FIRST_COLUMN)) {
            this.getPageCache().put(CACHE_KEY, propertyName);
            return true;
        }
        if (propertyName.equals("serialno")) {
            this.getPageCache().remove(CACHE_KEY);
            return true;
        }
        return this.getPageCache().get(CACHE_KEY) != null;
    }
}

