/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.account.AccountSelectFormService;
import kd.taxc.tcvat.business.service.account.hzsb.HzAccountSelectFormService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.common.dto.draft.DraftDto;
import kd.taxc.tcvat.common.enums.TaxdataTabEnum;

public class HzAccountSelectFormPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static Log logger = LogFactory.getLog(HzAccountSelectFormPlugin.class);
    private static final String TABAP = "tabap";
    private static final String BTN_FASTSETTING = "btnfastsetting";
    private static final String BTN_FASTSETTING_AP = "vectorap";
    private HzAccountSelectFormService hzAccountSelectFormService = new HzAccountSelectFormService();
    private DraftDto draftDto = new DraftDto();
    private IPageCache parentPageCache;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, TABAP);
        this.addClickListeners(new String[]{BTN_FASTSETTING});
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button && ((Button)evt.getSource()).getKey().equals(BTN_FASTSETTING)) {
            IPageCache parentPageCache = this.getParentPageCache();
            String orgid = parentPageCache.get("orgid");
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("orgid", orgid);
            customParams.put("ruletype", "private");
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tcvat_rule_configs", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("taxpayertype", customParams.get("taxPayerType"));
        DraftMetaDataDTO metaDataDTO = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
        boolean readonly = (Boolean)customParams.get("readonly");
        if (readonly) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
        } else {
            this.getView().setVisible(Boolean.valueOf(customParams.get("from") == null), new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
        }
        if ("zzsybnsr_ybhz".equals(customParams.get("taxPayerType")) || "zzsybnsr_yz_zjg".equals(customParams.get("taxPayerType")) || "zzsybnsr_hz_zjg".equals(customParams.get("taxPayerType"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fzprepay"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"income"});
        }
        this.draftDto.setOrgId(Long.parseLong(customParams.get("orgid").toString()));
        this.draftDto.setStartDate(DateUtils.getDayFirst((Date)DateUtils.stringToDate((String)((String)customParams.get("skssqq")))));
        this.draftDto.setEndDate(DateUtils.getDayLast((Date)DateUtils.stringToDate((String)((String)customParams.get("skssqz")))));
        DynamicObjectCollection collection = this.hzAccountSelectFormService.queryYbhzPolicyConfirm(this.draftDto);
        Map<String, String> declareMap = collection.stream().collect(Collectors.toMap(o -> o.getString("orgid"), o -> o.getString("hzdeclaretype"), (k1, k2) -> k1));
        List orgList = declareMap.keySet().stream().map(s -> Long.valueOf(s)).collect(Collectors.toList());
        String rulePurpose = (String)customParams.get("rulePurpose");
        Map rules = RuleUtils.getSharingAndOrgRules(orgList, (RuleTypeEnum)RuleTypeEnum.ALL, (String)"ybnsr", (String)rulePurpose);
        if (rules.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"diff", "rollout", "taxreduction", "perpre"});
        } else {
            this.getView().setVisible(Boolean.valueOf(((List)rules.get(RuleTypeEnum.DIFF)).size() > 0), new String[]{"diff"});
            this.getView().setVisible(Boolean.valueOf(((List)rules.get(RuleTypeEnum.ROLL_OUT)).size() > 0), new String[]{"rollout"});
            this.getView().setVisible(Boolean.valueOf(((List)rules.get(RuleTypeEnum.REDUCE)).size() > 0), new String[]{"taxreduction"});
            List deduct = (List)rules.get(RuleTypeEnum.DEDUCT);
            this.getView().setVisible(Boolean.valueOf("sjjt".equals(metaDataDTO.getDraftPurpose()) && deduct.size() > 0), new String[]{"deduct"});
            this.getView().setVisible(Boolean.valueOf(!"sjjt".equals(metaDataDTO.getDraftPurpose())), new String[]{"deduction"});
            this.getView().setVisible(Boolean.valueOf(deduct.stream().anyMatch(o -> o.getString("deducttype.number").startsWith("VAT_JXDK_DDK_"))), new String[]{"waitdeduction"});
            this.getView().setVisible(Boolean.valueOf(rules.get(RuleTypeEnum.PERPRE) != null && ((List)rules.get(RuleTypeEnum.PERPRE)).size() > 0), new String[]{"perpre"});
        }
        this.getView().setVisible(Boolean.valueOf(!"N".equals(customParams.get("deductionrate"))), new String[]{"decrease"});
        Boolean existRecord = this.getJzjtJxseTabVisible(customParams, metaDataDTO);
        this.getView().setVisible(existRecord, new String[]{"jzjtjxse"});
        Tab tab = (Tab)this.getControl(TABAP);
        if (null != tab) {
            AccountSelectFormService.showPage("HzAccountSelectFormPlugin", this.getView(), this.getPageCache(), tab.getCurrentTab());
            this.setParenCache(tab.getCurrentTab());
        }
    }

    private Boolean getJzjtJxseTabVisible(Map<String, Object> customParams, DraftMetaDataDTO metaDataDTO) {
        try {
            String accountMetaDataName = metaDataDTO.getJzjtjxse().getAccountMetaDataName();
            String taxPayerType = metaDataDTO.getTaxPayerType();
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            Date startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            Date endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)customParams.get("orgid")));
            return QueryServiceHelper.exists((String)accountMetaDataName, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return Boolean.TRUE;
        }
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        for (int i = 0; i < tabName.length; ++i) {
            Tab tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        AccountSelectFormService.setVisibleForFastSetting(this.getView(), evt.getTabKey());
        AccountSelectFormService.showPage("HzAccountSelectFormPlugin", this.getView(), this.getPageCache(), evt.getTabKey());
        this.setParenCache(evt.getTabKey());
    }

    private void setParenCache(String sheetName) {
        IPageCache parentPageCache = this.getParentPageCache();
        if (parentPageCache != null) {
            parentPageCache.put("sheetName", TaxdataTabEnum.getNameByValue(sheetName));
        }
    }

    private IPageCache getParentPageCache() {
        if (this.parentPageCache == null && this.getView().getParentView() != null) {
            this.parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        }
        return this.parentPageCache;
    }
}

