/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.account.DeductionService;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.formplugin.account.AbstractEditPopFormPlugin;

public class HzDeductionInputDetailsFormPlugin
extends AbstractEditPopFormPlugin {
    private DeductionService deductionService = new DeductionService();

    public void initialize() {
        BillList billlist = (BillList)this.getControl("billlistap");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        QFilter qFilter = new QFilter("taxaccountserialno", "=", customParams.get("taxaccountserialno"));
        if (StringUtil.equals((CharSequence)"nssb", (CharSequence)((String)customParams.get("draftpurpose")))) {
            qFilter.and(new QFilter("deductiontype", "=", customParams.get("deductiontype")));
        }
        billlist.setFilter(qFilter);
        billlist.setOrderBy("baseinvoicetype.number desc");
        billlist.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject d = e.getRowData();
        if (columnDesc.getKey().equals("jzjtxse") || columnDesc.getKey().equals("xsehe") || columnDesc.getKey().equals("hfbl")) {
            String consumertype = d.getString("consumertype");
            if ("4".equals(consumertype)) {
                e.setFormatValue((Object)"--");
            } else if ("5".equals(consumertype) && columnDesc.getKey().equals("hfbl")) {
                DecimalFormat df = new DecimalFormat("#0.00");
                String str = df.format(Double.parseDouble(d.getString("hfbl")) * 100.0);
                e.setFormatValue((Object)(str + "%"));
            }
        }
    }

    @Override
    protected void queryRightList(Map<String, Object> customParams) {
    }

    @Override
    protected boolean check(Map<String, Object> customParams) {
        BigDecimal taxamount = this.deductionService.queryUpdateDraft(customParams, "taxamount");
        boolean result = this.deductionService.check(customParams, "inputtaxamount", (BigDecimal)this.getModel().getValue(DraftConstant.ADJUSTSUMAMOUNT), taxamount);
        if (result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5e94\u5f53\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7a0e\u989d\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"HzDeductionInputDetailsFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return true;
        }
        return super.check(customParams);
    }
}

