/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.PartitionSaveTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.utils.ReductionUtils;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class HzTaxReductionAccountFormPlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    private static final String FIELD_CURRENT_AMOUNT = "currentamount";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        DraftMetaDataInfo taxReduction = metaData.getTaxReduction();
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        Object deadLine = customParams.get("deadLine");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)(Objects.isNull(deadLine) ? "" : deadLine));
        QFilter taxPeriodFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", customParams.get("taxpayertype"));
        IDataModel model = this.getModel();
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)taxReduction.getAccountMetaDataName(), (String)"serialno,description,org,suborg, declaretype,levelname,taxreductioncode,taxreductionname,taxreductiontype,currentamount,startdate,enddate", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter, taxpayertypeFilter}, (String)"levelname, suborg");
        if (genericObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("taxperiod", (Object)dynamicObject.getDate("startdate"), rowIndex);
                model.setValue("org", dynamicObject.getDynamicObject("suborg").get("id"), rowIndex);
                model.setValue("declaretype", (Object)dynamicObject.getString("declaretype"), rowIndex);
                model.setValue("levelname", (Object)dynamicObject.getString("levelname"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("description", dynamicObject.get("description"), rowIndex);
                model.setValue("taxreductioncode", dynamicObject.get("taxreductioncode"), rowIndex);
                model.setValue("taxreductionname", dynamicObject.get("taxreductionname"), rowIndex);
                model.setValue("taxreductiontype", dynamicObject.get("taxreductiontype"), rowIndex);
                model.setValue(FIELD_CURRENT_AMOUNT, dynamicObject.get(FIELD_CURRENT_AMOUNT), rowIndex);
                this.markEditCell(model, rowIndex, "entryentity");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
            this.getView().setVisible(Boolean.valueOf("zzsybnsr_ybhz".equals(customParams.get("taxpayertype"))), new String[]{"declaretype"});
            this.getView().setVisible(Boolean.valueOf("ajsb".equalsIgnoreCase(Objects.isNull(deadLine) ? "" : String.valueOf(deadLine))), new String[]{"taxperiod"});
        }
        super.afterCreateData(null);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        String fieldName = evt.getFieldName();
        DynamicObject suborg = (DynamicObject)this.getModel().getValue("org", rowIndex);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        customParams.put("draftpurpose", customParamMap.get("draftpurpose"));
        customParams.put("updateDraft", metaData.getTaxReduction().getAccountMetaDataName());
        customParams.put("orgid", suborg.get("id"));
        customParams.put("id", this.getModel().getValue("id", rowIndex));
        customParams.put("fieldName", fieldName);
        customParams.put("draftnumber", customParamMap.get("draftnumber"));
        customParams.put("billstatus", customParamMap.get("billstatus"));
        customParams.put("description", this.getModel().getValue("description", rowIndex));
        customParams.put("amount", this.getModel().getValue(fieldName, rowIndex));
        customParams.put("drafttype", customParamMap.get("drafttype"));
        customParams.put("taxpayertype", customParamMap.get("taxpayertype"));
        customParams.put("entry", metaData.getTaxReduction().getDetailMetaDataNameMap().get(DraftConstant.YBHZ_TAX_REDUCTION_DETAIL));
        customParams.put("taxaccountserialno", serialno);
        customParams.put("mainorgid", customParamMap.get("orgid"));
        if (StringUtils.equals((CharSequence)FIELD_CURRENT_AMOUNT, (CharSequence)evt.getFieldName())) {
            customParams.put("customCaption", ResManager.loadKDString((String)"\u51cf\u514d\u7a0e\u53f0\u8d26\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"HzTaxReductionAccountFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            customParams.put("cellName", ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d", (String)"HzTaxReductionAccountFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("tcvat_income_invoice_tab".endsWith(actionId)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
            String entityName = metaData.getTaxReduction().getAccountMetaDataName();
            String orgidStr = (String)customParams.get("orgid");
            String skssqqStr = (String)customParams.get("skssqq");
            String skssqzStr = (String)customParams.get("skssqz");
            String taxPayerType = (String)customParams.get("taxpayertype");
            Date skssqq = DateUtils.stringToDate((String)skssqqStr);
            Date skssqz = DateUtils.stringToDate((String)skssqzStr);
            Object deadLine = customParams.get("deadLine");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgidStr));
            QFilter deadLineFilter = new QFilter("deadline", "=", (Object)(deadLine == null ? "" : deadLine));
            QFilter startdateFilter = new QFilter("startdate", "=", (Object)skssqq);
            QFilter enddateFilter = new QFilter("enddate", "=", (Object)skssqz);
            QFilter taxPayerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)entityName, (String)MetadataUtil.getAllFieldToQuery((String)entityName), (QFilter[])new QFilter[]{orgFilter, startdateFilter, enddateFilter, deadLineFilter, taxPayerTypeFilter}, (String)"startdate");
            if (genericObjects.size() > 0) {
                List<DynamicObject> groupSummaryDataList;
                TcvatEngineModel model = new TcvatEngineModel(orgidStr, skssqqStr, skssqzStr);
                model.getCustom().put("skssqq", skssqqStr);
                model.getCustom().put("skssqz", skssqzStr);
                model.getCustom().put("deadLine", deadLine == null ? "" : deadLine);
                DeleteServiceHelper.delete((String)metaData.getTaxReduction().getDetailMetaDataNameMap().get(DraftConstant.YBHZ_TAX_REDUCETION_SUM), (QFilter[])new QFilter[]{orgFilter, startdateFilter, enddateFilter, taxPayerTypeFilter});
                String taxpayerType = (String)customParams.get("taxpayertype");
                model.setDraftMetaDataDTO(DraftMetaDataDTO.getMetaData((String)customParams.get("draftpurpose"), taxPayerType));
                String templateType = "zzsybnsr";
                if (taxpayerType != null) {
                    templateType = taxpayerType.startsWith("zzs") ? taxpayerType : "zzs" + taxpayerType;
                }
                if (!(groupSummaryDataList = ReductionUtils.groupSummaryData(templateType, model, (List<DynamicObject>)genericObjects)).isEmpty()) {
                    ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
                }
            }
        }
    }
}

