/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.TextEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.constant.RuleSettingConstant;
import kd.taxc.tcvat.formplugin.account.AbstractEditPopFormPlugin;

public class YbHzAccountingDetailsFormPlugin
extends AbstractEditPopFormPlugin {
    private static final String DIFF_DETAIL_ENTITY = "tcvat_hz_accdetail_diff";
    private static final String ROLLOUT_DETAIL_ENTITY = "tcvat_hz_accdetail_rout";
    private static final String INCOME_INVOICE_DETAIL_ENTITY = "tcvat_hz_income_invoice";
    private static final String INCOME_DETAIL_ENTITY = "tcvat_hz_accdetail_income";
    private static final String TAX_REDUCTION_DETAIL_ENTITY = "tcvat_hz_taxreduce_deta";
    private static final String HZ_WAIT_DEDUCT_DETAIL_ENTITY = "tcvat_hz_wait_deduct_det";
    private RuleService ruleService = new RuleService();

    @Override
    public void queryRightList(Map<String, Object> customParams) {
        boolean isIncomeZyfp = INCOME_INVOICE_DETAIL_ENTITY.equals(customParams.get("entry"));
        QFilter qFilter = new QFilter("taxaccountserialno", "=", customParams.get("taxaccountserialno"));
        Object type = customParams.get("type");
        boolean countCell = "count".equals(type);
        this.getView().setVisible(Boolean.valueOf(!countCell), new String[]{"amountfield"});
        this.getView().setVisible(Boolean.valueOf(countCell), new String[]{"count"});
        String selectFields = "org,startdate,table,amountfield,datatype,datadirection,fetchamount,amount,filtercondition,absolute,conditionjson";
        if (Objects.equals(DraftConstant.YBHZ_JZJT_JXSE_ACCDETAIL, customParams.get("entry"))) {
            selectFields = selectFields + ",suborg";
        } else if (Objects.equals(INCOME_DETAIL_ENTITY, customParams.get("entry"))) {
            qFilter.and("type", "=", type);
            selectFields = "org,startdate,table,amountfield,datatype,datadirection,fetchamount,amount,filtercondition,absolute,suborg,taxrate,taxamount,exrate,conditionjson,differenceinvoice";
        } else if (Objects.equals(INCOME_INVOICE_DETAIL_ENTITY, customParams.get("entry"))) {
            qFilter.and("type", "=", type);
            selectFields = "org,startdate,table,amountfield,datatype,datadirection,fetchamount,invoiceamount,filtercondition,absolute,suborg,taxrate,taxamount,conditionjson,differenceinvoice";
        } else if (Objects.equals(HZ_WAIT_DEDUCT_DETAIL_ENTITY, customParams.get("entry"))) {
            selectFields = "org,startdate,table,amountfield,datatype,datadirection,fetchamount,amount,filtercondition,absolute,suborg,declaretype,conditionjson";
            String fieldName = String.valueOf(customParams.get("fieldName"));
            if ("amount".equals(fieldName)) {
                qFilter.and("type", "=", (Object)"amount");
            } else if ("taxamount".equals(fieldName)) {
                qFilter.and("type", "=", (Object)"taxamount");
            } else if ("count".equals(fieldName)) {
                qFilter.and("type", "=", (Object)"count");
            }
        }
        IDataModel model = this.getModel();
        String entityName = (String)customParams.get("entry");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        Map<Long, String> nsrmcMap = null;
        if (Objects.equals(HZ_WAIT_DEDUCT_DETAIL_ENTITY, entityName) || Objects.equals(INCOME_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(INCOME_INVOICE_DETAIL_ENTITY, customParams.get("entry"))) {
            Set suborg = dynamicObjects.stream().map(d -> d.getLong("suborg")).collect(Collectors.toSet());
            DynamicObjectCollection nsrmcList = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org,taxpayer", (QFilter[])new QFilter[]{new QFilter("org", "in", suborg)});
            nsrmcMap = nsrmcList.stream().collect(Collectors.toMap(d -> d.getLong("org"), d -> d.getString("taxpayer"), (v1, v2) -> v1));
        }
        if (dynamicObjects.size() > 0) {
            if (Objects.equals(INCOME_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(INCOME_INVOICE_DETAIL_ENTITY, customParams.get("entry"))) {
                TextEdit nsrmc = (TextEdit)this.getControl("nsrmc");
                nsrmc.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d6\u6570\u7ec4\u7ec7", (String)"YbHzAccountingDetailsFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0])));
            }
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", dynamicObjects.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                long orgId;
                model.setValue("taxperiod", dynamicObject.get("startdate"), rowIndex);
                model.setValue("table", dynamicObject.get("table"), rowIndex);
                model.setValue("amountfield", dynamicObject.get("amountfield"), rowIndex);
                model.setValue("count", dynamicObject.get("amountfield"), rowIndex);
                model.setValue("datatype", dynamicObject.get("datatype"), rowIndex);
                model.setValue("datadirection", dynamicObject.get("datadirection"), rowIndex);
                model.setValue("absolute", dynamicObject.get("absolute"), rowIndex);
                model.setValue("fetchamount", dynamicObject.get("fetchamount"), rowIndex);
                model.setValue("currentamount", isIncomeZyfp ? dynamicObject.get("invoiceamount") : dynamicObject.get("amount"), rowIndex);
                model.setValue("amount", isIncomeZyfp ? dynamicObject.get("invoiceamount") : dynamicObject.get("amount"), rowIndex);
                model.setValue("invoiceamount", isIncomeZyfp ? dynamicObject.get("invoiceamount") : dynamicObject.get("amount"), rowIndex);
                model.setValue("filtercondition", dynamicObject.get("filtercondition"), rowIndex);
                model.setValue("conditionjson", dynamicObject.get("conditionjson"), rowIndex);
                if (dynamicObject.containsProperty("exrate")) {
                    model.setValue("exrate", dynamicObject.get("exrate"), rowIndex);
                }
                if (dynamicObject.containsProperty("differenceinvoice")) {
                    model.setValue("differenceinvoice", dynamicObject.get("differenceinvoice"), rowIndex);
                }
                model.setValue("filtercondition_tag", dynamicObject.get("filtercondition"), rowIndex);
                if (Objects.equals(INCOME_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(INCOME_INVOICE_DETAIL_ENTITY, customParams.get("entry"))) {
                    orgId = dynamicObject.getLong("suborg");
                    if (nsrmcMap != null) {
                        model.setValue("nsrmc", (Object)nsrmcMap.get(orgId), rowIndex);
                    }
                    model.setValue("taxrate", dynamicObject.get("taxrate"), rowIndex);
                    model.setValue("taxamount", dynamicObject.get("taxamount"), rowIndex);
                    model.setValue("taxamount1", dynamicObject.get("taxamount"), rowIndex);
                } else if (Objects.equals(HZ_WAIT_DEDUCT_DETAIL_ENTITY, customParams.get("entry"))) {
                    orgId = dynamicObject.getLong("suborg");
                    model.setValue("org", (Object)orgId, rowIndex);
                    if (nsrmcMap != null) {
                        model.setValue("nsrmc", (Object)nsrmcMap.get(orgId), rowIndex);
                    }
                    model.setValue("declaretype", dynamicObject.get("declaretype"), rowIndex);
                } else if (Objects.equals(DraftConstant.YBHZ_JZJT_JXSE_ACCDETAIL, customParams.get("entry"))) {
                    model.setValue("org", (Object)dynamicObject.getLong("suborg"), rowIndex);
                }
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
            this.getView().setVisible(Boolean.FALSE, new String[]{"declaretype", "org", "orgname", "nsrmc"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"taxrate", "taxamount", "taxamount1"});
        if (Objects.equals(INCOME_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(INCOME_INVOICE_DETAIL_ENTITY, customParams.get("entry"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"amount", "currentamount"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nsrmc"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"exrate"});
            if (Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_QTSE) || Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_WKPSE) || Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_ZYSE)) {
                Object invoiceseqs = customParams.get("invoiceseqs");
                Object wkpseqs = customParams.get("wkpseqs");
                Object qtfpseqs = customParams.get("qtfpseqs");
                boolean a = Objects.equals(wkpseqs, "false") && Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_WKPSE);
                boolean b = Objects.equals(qtfpseqs, "false") && Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_QTSE);
                boolean c = Objects.equals(invoiceseqs, "false") && Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_ZYSE);
                boolean showTaxrate = a || b || c;
                this.getView().setVisible(Boolean.valueOf(showTaxrate), new String[]{"taxrate"});
                this.getView().setVisible(Boolean.valueOf(showTaxrate), new String[]{"invoiceamount"});
                this.getView().setVisible(Boolean.valueOf(!showTaxrate), new String[]{"taxamount"});
                this.getView().setVisible(Boolean.valueOf(showTaxrate), new String[]{"taxamount1"});
            } else if (Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_QTSR) || Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_WKPSR) || Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_ZYSR)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"invoiceamount"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"exrate"});
        }
        if (Objects.equals(INCOME_INVOICE_DETAIL_ENTITY, customParams.get("entry"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"exrate"});
        }
        if (Objects.equals(DIFF_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(TAX_REDUCTION_DETAIL_ENTITY, customParams.get("entry"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"amount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoiceamount"});
        }
        if (Objects.equals(ROLLOUT_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(DraftConstant.YBHZ_JZJT_JXSE_ACCDETAIL, customParams.get("entry"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"currentamount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoiceamount"});
        }
        if (Objects.equals(HZ_WAIT_DEDUCT_DETAIL_ENTITY, customParams.get("entry"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"orgname", "amount", "invoiceamount", "currentamount"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"declaretype", "org", "nsrmc"});
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            entry.setColumnProperty("fetchamount", "header", (Object)ResManager.loadKDString((String)"\u53d6\u6570\u6570\u503c", (String)"YbHzAccountingDetailsFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (Objects.equals(DraftConstant.YBHZ_JZJT_JXSE_ACCDETAIL, customParams.get("entry"))) {
            String value = ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d", (String)"YbHzAccountingDetailsFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]);
            this.changeFiledName("amount", value);
        }
    }

    public void changeFiledName(String field, String newName) {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.setColumnProperty(field, "header", (Object)new LocaleString(newName));
    }

    @Override
    protected void addCustomParams(Map<String, Object> customParams) {
        super.addCustomParams(customParams);
        Object draftEntry = customParams.get("draftEntry");
        if (this.ruleService.isIncomeRuleSumEntry((String)draftEntry)) {
            customParams.put("ruleEntry", "tcvat_rule_income");
        }
    }
}

