/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class YbhzJzjtJxseDraftFormPlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    private static final String FIELD_CURRENT_AMOUNT = "inputtax";
    private static final String ENTRYENTITY = "entryentity";
    private static final Log LOGGER = LogFactory.getLog(YbhzJzjtJxseDraftFormPlugin.class);

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addPackageDataListener(this::packageData);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject d;
        String jzjtlx;
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        String columnDescKey = columnDesc.getKey();
        if ((columnDescKey.equals("jzjtamount") || columnDescKey.equals("amountsum") || columnDescKey.equals("splitrate")) && "jzjt".equals(jzjtlx = (d = e.getRowData()).getString("jzjtlx"))) {
            e.setFormatValue((Object)"--");
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataInfo taxReductionMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams).getJzjtjxse();
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
        String taxPayerType = (String)customParams.get("taxpayertype");
        QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)taxReductionMetaData.getAccountMetaDataName(), (String)"id,suborg,levelname,declaretype,org,startdate,serialno,bizname,jzjtlx,inputtax,jzjtamount,amountsum,splitrate,jzjtjxtax", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter}, (String)"levelname,suborg");
        IDataModel model = this.getModel();
        if (genericObjects.length > 0) {
            Set suborgs = Arrays.stream(genericObjects).map(o -> o.getLong("suborg.id")).collect(Collectors.toSet());
            QFilter qFilter1 = new QFilter("org", "in", suborgs);
            DynamicObjectCollection taxpayers = QueryServiceHelper.query((String)"bastax_taxorg", (String)"taxpayer,org", (QFilter[])new QFilter[]{qFilter1});
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY, genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                model.setValue("suborg", (Object)dynamicObject.getLong("suborg.id"), rowIndex);
                DynamicObject orgDyn = taxpayers.stream().filter(o -> Objects.equals(o.getLong("org"), dynamicObject.getLong("suborg.id"))).findFirst().orElse(null);
                model.setValue("suborgname", (Object)(orgDyn != null ? orgDyn.getString("taxpayer") : ""), rowIndex);
                model.setValue("taxperiod", (Object)DateUtils.format((Date)dynamicObject.getDate("startdate")), rowIndex);
                model.setValue("levelname", dynamicObject.get("levelname"), rowIndex);
                model.setValue("declaretype", dynamicObject.get("declaretype"), rowIndex);
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("org", dynamicObject.get("org"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("bizname", dynamicObject.get("bizname"), rowIndex);
                model.setValue("jzjtlx", dynamicObject.get("jzjtlx"), rowIndex);
                model.setValue(FIELD_CURRENT_AMOUNT, dynamicObject.get(FIELD_CURRENT_AMOUNT), rowIndex);
                model.setValue("jzjtamount", dynamicObject.get("jzjtamount"), rowIndex);
                model.setValue("amountsum", dynamicObject.get("amountsum"), rowIndex);
                model.setValue("splitrate", dynamicObject.get("splitrate"), rowIndex);
                model.setValue("jzjtjxtax", dynamicObject.get("jzjtjxtax"), rowIndex);
                this.markEditCell(model, rowIndex, ENTRYENTITY);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView(ENTRYENTITY);
        }
        super.afterCreateData(null);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        String fieldName = evt.getFieldName();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        if (FIELD_CURRENT_AMOUNT.equals(fieldName)) {
            String caption = ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u53d6\u6570\u660e\u7ec6", (String)"YbnsrJzjtJxseDraftFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCaption(caption);
            parameter.setFormId("tcvat_income_invoice_tab");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("taxaccountserialno", (Object)serialno);
            parameter.setCustomParam("entry", (Object)metaData.getJzjtjxse().getDetailMetaDataNameMap().get(DraftConstant.YBHZ_JZJT_JXSE_ACCDETAIL));
            parameter.setCustomParam("updateDraft", (Object)metaData.getJzjtjxse().getAccountMetaDataName());
            DynamicObject suborg = (DynamicObject)this.getModel().getValue("suborg", rowIndex);
            parameter.setCustomParam("orgid", suborg == null ? Long.valueOf(0L) : suborg.getString("id"));
            parameter.setCustomParam("mainorgid", customParamMap.get("orgid"));
            parameter.setCustomParam("id", this.getModel().getValue("id", rowIndex));
            parameter.setCustomParam("fieldName", (Object)fieldName);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d", (String)"YbnsrJzjtJxseDraftFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            parameter.setCustomParam("description", this.getModel().getValue("bizname", rowIndex));
            parameter.setCustomParam("amount", this.getModel().getValue(fieldName, rowIndex));
            parameter.setCustomParam("draftnumber", customParamMap.get("draftnumber"));
            parameter.setCustomParam("drafttype", customParamMap.get("drafttype"));
            parameter.setCustomParam("billstatus", customParamMap.get("billstatus"));
            parameter.setCustomParam("draftpurpose", customParamMap.get("draftpurpose"));
            parameter.setCustomParam("taxPayerType", customParamMap.get("taxpayertype"));
            parameter.setCustomParam("taxpayertype", customParamMap.get("taxpayertype"));
            parameter.setCustomParam("skssqq", customParamMap.get("skssqq"));
            parameter.setCustomParam("skssqz", customParamMap.get("skssqz"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hyperLinkClick");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }
}

