/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb.ybqy;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.PolicyConfirmService;

public class YbPolicyConfirmation
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private IPageCache parentPageCache;
    private static final String ORGID_KEY = "orgid";
    private static final String STATUS_KEY = "status";
    private static final String DEDUCTION_RATE = "deductionrate";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String POLICY_CONFIRM_PAGE = "tcvat_ybhz_policy_confirm";

    public void initialize() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getView().setVisible(Boolean.valueOf(!"zzsybnsr_yz_zjg".equals(customParams.get("taxPayerType"))), new String[]{"nrhzsb"});
    }

    public void registerListener(EventObject e) {
        BasedataEdit object = (BasedataEdit)this.getControl("belongsorg");
        object.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        object.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.initDatas(customParams);
        this.writeToParentCache();
    }

    public void afterLoadData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("page", POLICY_CONFIRM_PAGE);
        PolicyConfirmService.controlEdit(customParams, this.getView());
        this.setDeductionRateSelectValue(customParams);
        this.writeToParentCache();
    }

    public void initDatas(Map<String, Object> customParams) {
        IDataModel dataModel = this.getModel();
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        Long orgid = customParams.get(ORGID_KEY) != null ? Long.parseLong(String.valueOf(customParams.get(ORGID_KEY))) : Long.parseLong("0");
        Object status = customParams.get(STATUS_KEY);
        dataModel.setValue(ORGID_KEY, (Object)orgid);
        this.getModel().setValue(STARTDATE, (Object)DateUtils.stringToDate((String)skssqq));
        this.getModel().setValue(ENDDATE, (Object)DateUtils.stringToDate((String)skssqz));
        QFilter qFilter = new QFilter(ORGID_KEY, "=", (Object)orgid);
        Date start = DateUtils.stringToDate((String)skssqq);
        Date end = DateUtils.stringToDate((String)skssqz);
        QFilter SkssqFilter = new QFilter(STARTDATE, ">=", (Object)DateUtils.getDayFirst((Date)start)).and(new QFilter(ENDDATE, "<=", (Object)DateUtils.getDayLast((Date)end)));
        Object planid = customParams.get("planid");
        DynamicObject declareTypeAndWay = QueryServiceHelper.queryOne((String)"tctb_org_group_latest", (String)"id, summaryorgtype,prelevyrate,fixedratio, zfjgsefpfs, zjggdbl, summaryway, orgrow.declaration as declaration", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(String.valueOf(planid)))});
        this.setPorperty(customParams, declareTypeAndWay);
        customParams.put("page", POLICY_CONFIRM_PAGE);
        this.setDeductionRateSelectValue(customParams);
        String ruleAndDraftPurpose = (String)customParams.get("draftpurpose");
        if ("1".equals(status)) {
            this.initPolicyConfirm(start, end, orgid.toString(), declareTypeAndWay, ruleAndDraftPurpose);
        } else {
            DynamicObjectCollection temp = QueryServiceHelper.query((String)POLICY_CONFIRM_PAGE, (String)"id", (QFilter[])new QFilter[]{qFilter, SkssqFilter, new QFilter("draftpurpose", "=", (Object)ruleAndDraftPurpose)});
            for (DynamicObject dobj : temp) {
                this.getPageCache().put("mainId", String.valueOf(dobj.getLong("id")));
                DynamicObject dispatchorder = BusinessDataServiceHelper.loadSingle((Object)dobj.getLong("id"), (String)POLICY_CONFIRM_PAGE);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)POLICY_CONFIRM_PAGE);
                DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
                EntityType entityType = (EntityType)mainEntityType.getAllEntities().get("entryentity");
                DataEntityPropertyCollection propertyCollection = entityType.getProperties();
                EntityType hzEntityType = (EntityType)mainEntityType.getAllEntities().get("hzentryentity");
                DataEntityPropertyCollection hzPropertyCollection = hzEntityType.getProperties();
                for (IDataEntityProperty property : mainPros) {
                    if (!property.getName().equals("entryentity") && !property.getName().equals("hzentryentity")) {
                        this.getModel().setValue(property.getName(), dispatchorder.get(property.getName()));
                        this.getModel().setDataChanged(false);
                        continue;
                    }
                    DynamicObjectCollection entryid = dispatchorder.getDynamicObjectCollection("entryentity");
                    entryid.sort((Comparator)new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject o1, DynamicObject o2) {
                            Long o2sub;
                            DynamicObject o1Object = o1.getDynamicObject("suborg");
                            DynamicObject o2Object = o2.getDynamicObject("suborg");
                            Long o1sub = o1Object.getLong("id");
                            return o1sub.compareTo(o2sub = Long.valueOf(o2Object.getLong("id"))) == 0 ? (o1.getDynamicObject("taxation").getString("name").compareTo(o2.getDynamicObject("taxation").getString("name")) == 0 ? o1.getDynamicObject("rate").getString("number").compareTo(o2.getDynamicObject("rate").getString("number")) : o1.getDynamicObject("taxation").getString("name").compareTo(o2.getDynamicObject("taxation").getString("name"))) : o2.getString("ruledeclaretype").compareTo(o1.getString("ruledeclaretype"));
                        }
                    });
                    this.getModel().deleteEntryData("entryentity");
                    for (DynamicObject d : entryid) {
                        int index = this.getModel().createNewEntryRow("entryentity");
                        for (IDataEntityProperty entProperty : propertyCollection) {
                            this.getModel().getEntryRowEntity("entryentity", index).set(entProperty.getName(), d.get(entProperty.getName()));
                        }
                    }
                    DynamicObjectCollection entryid2 = dispatchorder.getDynamicObjectCollection("hzentryentity");
                    entryid2.sort((Comparator)new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject o1, DynamicObject o2) {
                            String o1Object = o1.getString("levelname");
                            String o2Object = o2.getString("levelname");
                            return o2Object.compareTo(o1Object);
                        }
                    });
                    this.getModel().deleteEntryData("hzentryentity");
                    for (DynamicObject d : entryid2) {
                        int index = this.getModel().createNewEntryRow("hzentryentity");
                        for (IDataEntityProperty entProperty : hzPropertyCollection) {
                            this.getModel().getEntryRowEntity("hzentryentity", index).set(entProperty.getName(), d.get(entProperty.getName()));
                        }
                    }
                }
            }
            this.getView().updateView();
        }
    }

    private void setPorperty(Map<String, Object> customParams, DynamicObject declareTypeAndWay) {
        this.getView().setVisible(Boolean.valueOf(!"zzsybnsr_ybfz".equals(customParams.get("taxPayerType"))), new String[]{"incomeflex", "hztaxname", "labelap", DEDUCTION_RATE});
        this.getView().setVisible(Boolean.valueOf("zzsybnsr_ybfz".equals(customParams.get("taxPayerType"))), new String[]{"fzdeclaretype"});
        this.getView().getParentView().setVisible(Boolean.valueOf(!"zzsybnsr_ybfz".equals(customParams.get("taxPayerType"))), new String[]{"recalc"});
        this.getView().getParentView().setEnable(Boolean.valueOf(!"zzsybnsr_ybfz".equals(customParams.get("taxPayerType"))), new String[]{"next"});
        this.getView().sendFormAction(this.getView().getParentView());
        if ("zzsybnsr_ybfz".equals(customParams.get("taxPayerType"))) {
            this.getModel().setValue("hzqylx", (Object)declareTypeAndWay.getString("summaryorgtype"));
            this.getModel().setValue("hzfs", (Object)declareTypeAndWay.getString("summaryway"));
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u88ab\u6c47\u603b\u4f01\u4e1a\u65e0\u9700\u8fdb\u884c\u7eb3\u7a0e\u7533\u62a5", (String)"YbPolicyConfirmation_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
    }

    public void initPolicyConfirm(Date startDate, Date endDate, String orgid, DynamicObject declareTypeAndWay, String ruleAndDraftPurpose) {
        DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgid, (Date)startDate, (Date)endDate);
        if (null == dynamicObject) {
            return;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"orgrow.orgid as orgid,orgrow.levelname as levelname,orgrow.declaration,orgrow.issuesbb as issuesbb,orgrow.parentid as parentid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)declareTypeAndWay.getLong("id"))}, (String)"orgrow.level");
        Map<String, DynamicObject> orgMap = collection.stream().collect(Collectors.toMap(k -> k.getString(ORGID_KEY), v -> v, (k1, k2) -> k1));
        List orgidList = collection.stream().map(c -> c.getLong(ORGID_KEY)).distinct().collect(Collectors.toList());
        QFilter orgFilter = new QFilter(ORGID_KEY, "=", (Object)Long.valueOf(orgid));
        DynamicObject category = TaxBaseDataUtils.queryCategoryByTaxtype((Long)Long.parseLong(orgid), (String)"zzs");
        IDataModel model = this.getModel();
        int rowNo = 0;
        model.setValue(STARTDATE, (Object)startDate);
        model.setValue(ENDDATE, (Object)endDate);
        model.setValue(ORGID_KEY, (Object)orgid);
        model.setValue(STATUS_KEY, (Object)"1");
        model.setValue("creator", (Object)RequestContext.get().getOrgId());
        model.setValue("createtime", (Object)new Date());
        model.setValue("hzqylx", (Object)declareTypeAndWay.getString("summaryorgtype"));
        model.setValue("hzfs", (Object)declareTypeAndWay.getString("summaryway"));
        model.setValue("prelevyrate", (Object)declareTypeAndWay.getString("prelevyrate"));
        model.setValue("fixedratio", (Object)declareTypeAndWay.getString("fixedratio"));
        model.setValue("assignplan", (Object)declareTypeAndWay.getString("zfjgsefpfs"));
        BigDecimal zjggdbl = declareTypeAndWay.getBigDecimal("zjggdbl");
        model.setValue("zjggdbl", (Object)(zjggdbl == null ? new BigDecimal("0.2") : zjggdbl.divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP)));
        if (category != null) {
            DynamicObject taxMain = (DynamicObject)category.getParent();
            model.setValue("registertype", taxMain.get("registertype"));
            model.setValue("codeandname", taxMain.get("codeandname"));
            model.setValue("taxplayeraptitude", (Object)("zzs" + category.getString("taxpayertype")));
            model.setValue("levytype", (Object)category.getString("levytype"));
            model.setValue("deadline", (Object)TaxDeclareHelper.getDeadLine(ruleAndDraftPurpose, orgid, startDate, endDate));
        }
        model.setValue("draftpurpose", (Object)ruleAndDraftPurpose);
        Date preStart = DateUtils.addMonth((Date)startDate, (int)-1);
        Date preEnd = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)endDate, (int)-1));
        QFilter preStartFilter = new QFilter(STARTDATE, ">=", (Object)preStart);
        QFilter preEndFilter = new QFilter(ENDDATE, "<=", (Object)preEnd);
        QFilter draftpurpose = new QFilter("draftpurpose", "=", (Object)ruleAndDraftPurpose);
        DynamicObject prePolicyObject = BusinessDataServiceHelper.loadSingle((String)POLICY_CONFIRM_PAGE, (String)"deductionrate, entryentity.suborg, entryentity.ruleid, entryentity.belongsorg, hzentryentity.assignorg, hzentryentity.normalgoods, hzentryentity.jzjtgoods, hzentryentity.normaltax, hzentryentity.jzjttax", (QFilter[])new QFilter[]{orgFilter, preStartFilter, preEndFilter, draftpurpose});
        if (null == prePolicyObject) {
            prePolicyObject = BusinessDataServiceHelper.newDynamicObject((String)POLICY_CONFIRM_PAGE);
        }
        model.setValue(DEDUCTION_RATE, (Object)(null != prePolicyObject.getString(DEDUCTION_RATE) ? prePolicyObject.getString(DEDUCTION_RATE) : ""));
        QFilter qFilter = new QFilter(ORGID_KEY, "=", (Object)Long.valueOf(orgid));
        QFilter qFilter1 = new QFilter(STARTDATE, ">=", (Object)startDate);
        QFilter qFilter2 = new QFilter(ENDDATE, "<=", (Object)endDate);
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)ruleAndDraftPurpose);
        DeleteServiceHelper.delete((String)POLICY_CONFIRM_PAGE, (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, draftpurposeFilter});
        model.beginInit();
        int i = 0;
        for (Long suborgid : orgidList) {
            Map sharingAndOrgRules = RuleUtils.getSharingAndOrgRules((Long)suborgid, (RuleTypeEnum)RuleTypeEnum.INCOME, (String)"ybnsr", (String)ruleAndDraftPurpose);
            List incomeRuleList = RuleUtils.sortIncomeRules((List)((List)sharingAndOrgRules.get(RuleTypeEnum.INCOME)));
            String declaretype = "1";
            if (suborgid.compareTo(Long.valueOf(orgid)) == 0) {
                declaretype = "2";
            }
            if (incomeRuleList != null && incomeRuleList.size() != 0) {
                model.batchCreateNewEntryRow("entryentity", incomeRuleList.size());
                for (DynamicObject incomeRule : incomeRuleList) {
                    String orgidStr;
                    Optional<DynamicObject> preBelongs = prePolicyObject.getDynamicObjectCollection("entryentity").parallelStream().filter(e -> e.getDynamicObject("suborg").getString("id").equals(String.valueOf(suborgid)) && e.getString("ruleid").equals(incomeRule.getString("id"))).findFirst();
                    String name = incomeRule.getString("name");
                    Long ruleId = incomeRule.getLong("id");
                    model.setValue("org", (Object)orgid, rowNo);
                    model.setValue("suborg", (Object)suborgid, rowNo);
                    model.setValue("jzjt", incomeRule.get("jzjt"), rowNo);
                    model.setValue("taxation", incomeRule.get("taxation"), rowNo);
                    model.setValue("rate", incomeRule.get("taxrate"), rowNo);
                    model.setValue("ruledeclaretype", (Object)declaretype, rowNo);
                    model.setValue("servicedesc", (Object)name, rowNo);
                    model.setValue("ruleid", (Object)ruleId, rowNo);
                    Long belongorg = suborgid;
                    if ("2".equals(this.getModel().getValue("hzfs")) && orgMap.get(orgidStr = String.valueOf(suborgid)) != null && "3".equals(orgMap.get(orgidStr).getString("levelname"))) {
                        belongorg = orgMap.get(orgidStr).getLong("parentid");
                    }
                    model.setValue("belongsorg", preBelongs.isPresent() ? preBelongs.get().getDynamicObject("belongsorg").get("id") : belongorg, rowNo);
                    model.setValue("rowno", (Object)rowNo, rowNo);
                    ++rowNo;
                }
            }
            Optional<DynamicObject> preHzentry = prePolicyObject.getDynamicObjectCollection("hzentryentity").parallelStream().filter(e -> e.getDynamicObject("assignorg").getString("id").equals(String.valueOf(suborgid))).findFirst();
            model.createNewEntryRow("hzentryentity");
            model.setValue("assignorg", (Object)suborgid, i);
            DynamicObject orgObj = orgMap.get(suborgid.toString());
            model.setValue("levelname", orgObj.get("levelname"), i);
            model.setValue("issuesbb", orgObj.get("issuesbb"), i);
            model.setValue("hzdeclaretype", (Object)declaretype, i);
            model.setValue("hzorg", (Object)orgid, i);
            model.setValue("assignrowno", (Object)orgid, i);
            model.setValue("normalgoods", (Object)(preHzentry.isPresent() ? preHzentry.get().getString("normalgoods") : "0"), i);
            model.setValue("jzjtgoods", (Object)(preHzentry.isPresent() ? preHzentry.get().getString("jzjtgoods") : "0"), i);
            model.setValue("normaltax", (Object)(preHzentry.isPresent() ? preHzentry.get().getString("normaltax") : "0"), i);
            model.setValue("jzjttax", (Object)(preHzentry.isPresent() ? preHzentry.get().getString("jzjttax") : "0"), i);
            ++i;
        }
        model.endInit();
        this.getView().updateView("hzentryentity");
        this.getView().updateView("entryentity");
    }

    public void setDeductionRateSelectValue(Map<String, Object> customParams) {
        ComboEdit deductionRateComboEdit = (ComboEdit)this.getControl(DEDUCTION_RATE);
        Date preStart = DateUtils.addMonth((Date)DateUtils.stringToDate((String)((String)customParams.get("skssqq"))), (int)-1);
        Date preEnd = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)((String)customParams.get("skssqz"))), (int)-1));
        QFilter preDateFilter = new QFilter(STARTDATE, ">=", (Object)preStart).and(new QFilter(ENDDATE, "<=", (Object)preEnd));
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        ArrayList<ComboItem> items = PolicyConfirmService.setDeductionRateSelectValue(draftpurpose, customParams, this.getView(), this.getModel(), this.getPageCache(), preDateFilter);
        deductionRateComboEdit.setComboItems(items);
        Long id = (Long)this.getModel().getValue("id");
        if (id == null || id == 0L) {
            String bqsfsyjzzc = PolicyConfirmService.queryBqsfsyjzzcDefaultValue(draftpurpose, this.getView().getFormShowParameter().getFormId(), Long.parseLong((String)customParams.get(ORGID_KEY)), (String)customParams.get("skssqq"), (String)customParams.get("skssqz"), preDateFilter);
            this.getModel().setValue("bqsfsyjzzc", (Object)bqsfsyjzzc);
            this.getPageCache().put("bqsfsyjzzc", bqsfsyjzzc);
        }
    }

    private void writeToParentCache() {
        IPageCache parentPageCache = this.getParentPageCache();
        if (null != parentPageCache) {
            parentPageCache.put(DEDUCTION_RATE, String.valueOf(this.getModel().getValue(DEDUCTION_RATE)));
        }
    }

    private IPageCache getParentPageCache() {
        if (this.parentPageCache == null && null != this.getView().getParentView()) {
            this.parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        }
        return this.parentPageCache;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean pass = Boolean.FALSE;
        if (e.getProperty().getName().equals("belongsorg") && null == e.getChangeSet()[0].getNewValue()) {
            pass = Boolean.TRUE;
        }
        this.writeToParentCache();
        this.save(pass);
        PolicyConfirmService.resetDraftData(this.getView().getFormShowParameter().getCustomParams());
        DeclareStepsUtils.resetParentSteps((int)TaxStepsConstant.getTcvatYbnsrYBHz().size(), (String)"1", (String)"1", (IFormView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        QFilter entryidFilter = new QFilter("id", "=", (Object)Long.valueOf(String.valueOf(customParams.get("planid"))));
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        formShowParameter.getListFilterParameter().getQFilters().add(entryidFilter);
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        EntryGrid billList = (EntryGrid)this.getControl("entryentity");
        if (afterF7SelectEvent.getListSelectedRow() != null) {
            this.getModel().setValue("belongsorg", (Object)afterF7SelectEvent.getListSelectedRow().getMainOrgId(), billList.getSelectRows()[0]);
        }
    }

    public void save(Boolean pass) {
        if (pass.booleanValue()) {
            this.getView().getParentView().setEnable(Boolean.FALSE, new String[]{"next"});
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u4e3a\u51c6\u786e\u586b\u5199\u300a\u6c47\u603b\u7eb3\u7a0e\u4f01\u4e1a\u589e\u503c\u7a0e\u5206\u914d\u8868\u300b\u7684\u9500\u552e\u6536\u5165\u76f8\u5173\u680f\u76ee\uff0c\u8bf7\u9009\u62e9\u6536\u5165\u5bf9\u5e94\u7684\u5f52\u5c5e\u7ec4\u7ec7\u3002", (String)"YbPolicyConfirmation_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        this.getView().getParentView().setEnable(Boolean.TRUE, new String[]{"next"});
    }
}

