/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.hzsb.ybqy;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.zlb.ZlbService;

public class YbTaxApportionFormPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(YbTaxApportionFormPlugin.class);
    private static final String TCVAT_ZLB_APPORTBILL = "tcvat_zlb_apportbill";
    private static final String TCVAT_YBHZ_YZ_TAXRATE_DET = "tcvat_ybhz_yz_taxrate_det";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        long orgId = Long.parseLong(orgid);
        String startdate = (String)customParams.get("skssqq");
        String enddate = (String)customParams.get("skssqz");
        Date skssqq = DateUtils.stringToDate((String)startdate);
        Date skssqz = DateUtils.stringToDate((String)enddate);
        DynamicObject confirm = this.getPolicyConfirm();
        Map<String, Boolean> issuesbbMap = null;
        if (confirm != null) {
            this.getModel().setValue("prelevyrate", confirm.get("prelevyrate"));
            this.getModel().setValue("fixedratio", confirm.get("fixedratio"));
            if ("1".equals(confirm.getString("prelevyrate"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"ljxse"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"zjgsqqbljxse"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"zjgdqxse"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"zjgdqqbljxse"});
            }
            DynamicObjectCollection issuesbbCollection = QueryServiceHelper.query((String)"tcvat_ybhz_policy_confirm", (String)"hzentryentity.assignorg as assignorg,hzentryentity.issuesbb as issuesbb", (QFilter[])new QFilter[]{new QFilter("id", "=", confirm.get("id"))});
            issuesbbMap = issuesbbCollection.stream().collect(Collectors.toMap(k -> k.getString("assignorg"), v -> v.getBoolean("issuesbb")));
        }
        IFormView parentView = this.getView().getParentView();
        IFormView ppView = null;
        if (parentView != null) {
            ppView = parentView.getParentView();
        }
        IPageCache ppCache = this.getPageCache();
        if (ppView != null) {
            ppCache = ppView.getPageCache();
        }
        Map dataMap = FormulaService.query((IPageCache)ppCache, (String)"draft_zzsybnsr_ybhz", (String)orgid, (String)startdate, (String)enddate, (boolean)false);
        BigDecimal ynsehj = ZlbService.calcTotalAmount(dataMap, "tcvat_zlb_zzsybnsr_ybhz#29#ybxm", "tcvat_zlb_zzsybnsr_ybhz#29#jzjtxm");
        this.getModel().setValue("zjgynse", (Object)ynsehj);
        BigDecimal ybxm = StringUtil.isNotBlank((CharSequence)((CharSequence)dataMap.get("tcvat_zlb_zzsybnsr_ybhz#5#ybxm"))) ? BigDecimalUtil.toBigDecimal(dataMap.get("tcvat_zlb_zzsybnsr_ybhz#5#ybxm")) : BigDecimal.ZERO;
        BigDecimal jzjtxm = StringUtil.isNotBlank((CharSequence)((CharSequence)dataMap.get("tcvat_zlb_zzsybnsr_ybhz#5#jzjtxm"))) ? BigDecimalUtil.toBigDecimal(dataMap.get("tcvat_zlb_zzsybnsr_ybhz#5#jzjtxm")) : BigDecimal.ZERO;
        BigDecimal zlbAmount = BigDecimalUtil.addObject((Object)ybxm, (Object)jzjtxm);
        this.getModel().setValue("zjgdqxse", (Object)zlbAmount);
        DynamicObject currentDetailParam = QueryServiceHelper.queryOne((String)TCVAT_YBHZ_YZ_TAXRATE_DET, (String)"zjgsqqbljxse,zjgdqqbljxse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("startdate", "=", (Object)skssqq), new QFilter("enddate", "=", (Object)skssqz)});
        this.getModel().setValue("zjgsqqbljxse", (Object)(currentDetailParam != null ? currentDetailParam.getBigDecimal("zjgsqqbljxse") : BigDecimal.ZERO));
        this.getModel().setValue("zjgdqqbljxse", (Object)(currentDetailParam != null ? currentDetailParam.getBigDecimal("zjgdqqbljxse") : BigDecimal.ZERO));
        DynamicObjectCollection list = QueryServiceHelper.query((String)TCVAT_ZLB_APPORTBILL, (String)"id,org,suborg,declaretype,dqxse,ljxse,jsbl,ynse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("startdate", "=", (Object)skssqq), new QFilter("enddate", "=", (Object)skssqz)});
        if (!list.isEmpty()) {
            this.getModel().beginInit();
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", list.size());
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject dyo = (DynamicObject)list.get(i);
                this.getModel().setValue("entryid", dyo.get("id"), i);
                this.getModel().setValue("org", dyo.get("org"), i);
                this.getModel().setValue("suborg", dyo.get("suborg"), i);
                String declaretype = dyo.getString("declaretype");
                this.getModel().setValue("declaretype", (Object)declaretype, i);
                this.getModel().setValue("dqxse", dyo.get("dqxse"), i);
                this.getModel().setValue("ljxse", dyo.get("ljxse"), i);
                if (issuesbbMap == null || issuesbbMap.get(dyo.getString("suborg")) == null) {
                    this.getModel().setValue("issuesbb", (Object)Boolean.FALSE, i);
                } else {
                    this.getModel().setValue("issuesbb", (Object)issuesbbMap.get(dyo.getString("suborg")), i);
                }
                if (confirm != null && "1".equals(confirm.getString("prelevyrate")) && "2".equals(declaretype)) {
                    this.getModel().setValue("jsbl", (Object)"\u2014\u2014");
                } else {
                    this.getModel().setValue("jsbl", (Object)dyo.getBigDecimal("jsbl").setScale(10, RoundingMode.HALF_UP).toPlainString(), i);
                }
                this.getModel().setValue("ynse", dyo.get("ynse"), i);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
        String edit = ppCache.get("edit");
        int count = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < count; ++i) {
            this.getView().setEnable(Boolean.valueOf("true".equals(edit)), i, new String[]{"ynse"});
        }
        this.getView().setEnable(Boolean.valueOf("true".equals(edit)), new String[]{"zjgsqqbljxse"});
        if (null != this.getView().getParentView()) {
            this.getView().getParentView().addClientCallBack("0", Integer.valueOf(0));
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        long orgId = Long.parseLong(orgid);
        String startdate = (String)customParams.get("skssqq");
        String enddate = (String)customParams.get("skssqz");
        Date skssqq = DateUtils.stringToDate((String)startdate);
        Date skssqz = DateUtils.stringToDate((String)enddate);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            if (!entryentity.isEmpty()) {
                Object[] entryids = entryentity.stream().map(e -> e.get("entryid")).toArray();
                DynamicObject[] load = BusinessDataServiceHelper.load((Object[])entryids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_ZLB_APPORTBILL));
                Map<Long, DynamicObject> updateMap = Stream.of(load).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
                for (DynamicObject object : entryentity) {
                    long entryid = object.getLong("entryid");
                    DynamicObject update = updateMap.get(entryid);
                    if (update == null) continue;
                    update.set("ynse", object.get("ynse"));
                    update.set("jsbl", object.get("jsbl"));
                }
                SaveServiceHelper.save((DynamicObject[])load);
                if (null != this.getView().getParentView()) {
                    this.getView().getParentView().addClientCallBack("0", Integer.valueOf(0));
                    this.getView().sendFormAction(this.getView().getParentView());
                }
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCVAT_YBHZ_YZ_TAXRATE_DET);
            dynamicObject.set("org", (Object)orgId);
            dynamicObject.set("startdate", (Object)skssqq);
            dynamicObject.set("enddate", (Object)skssqz);
            dynamicObject.set("zjgsqqbljxse", this.getModel().getValue("zjgsqqbljxse"));
            dynamicObject.set("zjgdqqbljxse", this.getModel().getValue("zjgdqqbljxse"));
            try (TXHandle h = TX.requiresNew();){
                try {
                    QFilter qFilter = new QFilter("org", "=", (Object)orgId).and("startdate", "=", (Object)skssqq).and("enddate", "=", (Object)skssqz);
                    DeleteServiceHelper.delete((String)TCVAT_YBHZ_YZ_TAXRATE_DET, (QFilter[])qFilter.toArray());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
                catch (Exception e2) {
                    LOGGER.error((Throwable)e2);
                    h.markRollback();
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("zjgsqqbljxse".equals(name) && "2".equals(this.getModel().getValue("prelevyrate"))) {
            BigDecimal zjgdqqbljxse = (BigDecimal)this.getModel().getValue("zjgdqqbljxse");
            BigDecimal zjgynse = (BigDecimal)this.getModel().getValue("zjgynse");
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
                if (!"true".equals(dynamicObject.getString("issuesbb"))) continue;
                if (BigDecimal.ZERO.compareTo(zjgdqqbljxse) != 0) {
                    BigDecimal ljxse = dynamicObject.getBigDecimal("ljxse");
                    BigDecimal rate = ljxse.divide(zjgdqqbljxse, 10, RoundingMode.HALF_UP);
                    BigDecimal taxAmount = rate.multiply(zjgynse);
                    this.getModel().setValue("jsbl", (Object)rate.toPlainString(), i);
                    this.getModel().setValue("ynse", (Object)taxAmount, i);
                    continue;
                }
                this.getModel().setValue("jsbl", (Object)BigDecimal.ZERO.setScale(10).toPlainString(), i);
                this.getModel().setValue("ynse", (Object)BigDecimal.ZERO.setScale(2), i);
            }
        }
    }

    private DynamicObject getPolicyConfirm() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        String orgid = (String)customParams.get("orgid");
        String startdate = (String)customParams.get("skssqq");
        String enddate = (String)customParams.get("skssqz");
        return TcvatDraftService.loadPolicyConfirm(metaData.getDraftPurpose(), metaData.getTaxPayerType(), metaData.getTemplateType(), orgid, startdate, enddate);
    }
}

