/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.wfrecord;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.mscommon.writeoff.form.manual.IWfManualExtService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections4.CollectionUtils;

public class WfRecordManualEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IWfManualExtService {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        orgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultOrg();
        this.setDateRange();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate opt = (FormOperate)args.getSource();
        String optKey = opt.getOperateKey();
        if ("query".equals(optKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            Date startdate = (Date)this.getModel().getValue("startdate");
            Date enddate = (Date)this.getModel().getValue("enddate");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u7684\u7a0e\u52a1\u7ec4\u7ec7", (String)"WfRecordManualEditPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (startdate == null || enddate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u65e5\u671f\u8303\u56f4", (String)"WfRecordManualEditPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void setDateRange() {
        this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
        this.getModel().setValue("enddate", (Object)DateUtils.getDayLast((Date)new Date()));
    }

    public void setDefaultOrg() {
        long orgId = RequestContext.get().getOrgId();
        TaxResult taxcMainByOrgId = TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId);
        if (Boolean.TRUE.equals(taxcMainByOrgId.getData())) {
            this.getModel().setValue("org", (Object)orgId);
        }
    }

    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters, Map<String, Object> pageDataMap) {
        IDataModel model = (IDataModel)pageDataMap.get("model");
        DynamicObject org = (DynamicObject)model.getValue("org");
        Long orgId = Optional.ofNullable(org).map(s -> s.getLong("id")).orElseGet(() -> 0L);
        Date startdate = (Date)model.getValue("startdate");
        Date enddate = (Date)model.getValue("enddate");
        enddate = DateUtils.getDayLast((Date)enddate);
        if ("entry_a".equals(curEntryKey)) {
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            TaxResult accountingOrgId = OrgRelationDataServiceHelper.getAccountingOrgIdByTaxcOrgId((Long)orgId);
            List data = (List)accountingOrgId.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                orgFilter.or(new QFilter("org", "in", (Object)data));
            }
            billFilters.add(orgFilter);
            billFilters.add(new QFilter("voucherdate", ">=", (Object)startdate).and(new QFilter("voucherdate", "<=", (Object)enddate)));
        }
        if ("entry_b".equals(curEntryKey)) {
            billFilters.add(new QFilter("taxorg", "=", (Object)orgId));
            billFilters.add(new QFilter("issuetime", ">=", (Object)startdate).and(new QFilter("issuetime", "<=", (Object)enddate)));
        }
    }

    public void dealFieldsValueByBiz(TableValueSetter tableValueSetter, String curEntryKey) {
        int i;
        int count;
        if ("entry_a".equals(curEntryKey)) {
            count = tableValueSetter.getCount();
            for (i = 0; i < count; ++i) {
                BigDecimal debitlocalcurrency_a = (BigDecimal)tableValueSetter.get("debitlocalcurrency_a", i);
                BigDecimal creditlocalcurrency_a = (BigDecimal)tableValueSetter.get("creditlocalcurrency_a", i);
                debitlocalcurrency_a = debitlocalcurrency_a == null ? BigDecimal.ZERO : debitlocalcurrency_a;
                creditlocalcurrency_a = creditlocalcurrency_a == null ? BigDecimal.ZERO : creditlocalcurrency_a;
                tableValueSetter.set("je_a", (Object)debitlocalcurrency_a.add(creditlocalcurrency_a), i);
            }
        }
        if ("entry_b".equals(curEntryKey)) {
            count = tableValueSetter.getCount();
            for (i = 0; i < count; ++i) {
                BigDecimal amount_b = (BigDecimal)tableValueSetter.get("amount_b", i);
                amount_b = amount_b == null ? BigDecimal.ZERO : amount_b;
                tableValueSetter.set("je_b", (Object)amount_b, i);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (listTaxResult != null && listTaxResult.getData() != null && !((List)listTaxResult.getData()).isEmpty()) {
            QFilter idsFilter = new QFilter("id", "in", listTaxResult.getData());
            event.setCustomQFilters((List)Lists.newArrayList((Object[])new QFilter[]{idsFilter}));
        }
        OrgUtils.addFilterByConditionBeforeF7Select((Object)event, (IFormView)this.getView(), null, null, null);
    }
}

