/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.wkpsr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportPluginNew;
import kd.taxc.tcvat.business.service.wkpsr.TcvatWkpsrService;

public class TcvatWkpsrFormPlugin
extends AbstractDeclareReportPluginNew {
    private static Log LOGGER = LogFactory.getLog(TcvatWkpsrFormPlugin.class);
    private TcvatWkpsrService wkpsrService = TcvatWkpsrService.getInstance();
    private static final String TAXPERIOD = "taxperiod";
    private static final String BTN_FASTSETTING = "btnfastsetting";
    private static final String VIEWFLOWCHART = "viewflowchart";
    private static final String WKPSR_QUERY_LIST = "tcvat_wkpsr_query_list";
    private static final String WKPSR_DATA = "tcvat_wkpsr_data";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"recalc", BTN_FASTSETTING});
        this.addItemClickListeners(new String[]{"toolbarapdeclare"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = this.getDefaultHashPermOrg(customParams);
        String orgId = String.valueOf(orgid);
        if (orgid != null) {
            this.getPageCache().put("orgid", orgId);
        }
        this.initTaxPeriod((String)customParams.get(TAXPERIOD));
        this.setBtnStatus(orgId, this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), "edit");
        boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgId, (String)"tcvat", (String)"zzs");
        if (orgid != null && !checkResult) {
            this.getModel().setValue("org", (Object)orgid);
            this.getPageCache().put("orgid", orgId);
        } else {
            this.getModel().setValue("org", null);
            this.getPageCache().put("orgid", null);
        }
        super.afterCreateNewData(e);
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)Long.parseLong(orgid));
        if (zerodeclare) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String orgname = org != null ? org.getString("name") : "";
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u751f\u6210\u672a\u5f00\u7968\u6536\u5165\u53f0\u8d26\u3002", (String)"TcvatWkpsrFormPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
            return false;
        }
        return true;
    }

    private Long getDefaultHashPermOrg(Map<String, Object> customParams) {
        String paramOrg = (String)customParams.get("orgid");
        long org = StringUtils.isNotBlank((CharSequence)paramOrg) ? Long.parseLong(paramOrg) : RequestContext.get().getOrgId();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        return OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (e.getProperty().getName().equals("org")) {
            String taxPayType;
            DynamicObject org;
            Object object = changeData[0].getNewValue();
            if (null == object && null != changeData[0].getOldValue()) {
                boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)((DynamicObject)changeData[0].getOldValue()).get("id").toString(), (String)"tcvat", (String)this.getTaxType());
                if (checkResult) {
                    return;
                }
                this.getModel().setValue("org", changeData[0].getOldValue());
            }
            if (null == (org = (DynamicObject)this.getModel().getValue("org"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcvatWkpsrFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Object value = this.getModel().getValue(TAXPERIOD);
            if (value == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u7a0e\u671f", (String)"TcvatWkpsrFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            String orgid = org.getString("id");
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)"tcvat", (String)this.getTaxType());
            boolean checkOrgTaxConfig = this.checkOrgTaxConfig(orgid, this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
            DynamicObject type = OrgChangeRecordUtil.loadChangeRecord((String)orgid, (Date)DateUtils.stringToDate((String)this.getPageCache().get("skssqq")), (Date)DateUtils.stringToDate((String)this.getPageCache().get("skssqz")));
            String string = taxPayType = type != null ? type.getString("taxpayertype") : "";
            if (checkResult || !checkOrgTaxConfig) {
                this.getModel().setValue("org", changeData[0].getOldValue());
            } else if (!taxPayType.equals("ybnsr")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u529f\u80fd\u6682\u672a\u5bf9\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u5f00\u653e", (String)"TcvatWkpsrFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getModel().setValue("org", changeData[0].getOldValue());
            } else {
                this.getPageCache().put("orgid", orgid);
                this.showInnerPage(org.getString("id"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), false, "edit");
            }
        } else if (e.getProperty().getName().equals(TAXPERIOD)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (null == org) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcvatWkpsrFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Date taxperiod = (Date)changeData[0].getNewValue();
            if (taxperiod != null) {
                String skssqq = DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)taxperiod));
                this.getPageCache().put("skssqq", skssqq);
                String skssqz = DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)taxperiod));
                this.getPageCache().put("skssqz", skssqz);
            } else {
                this.getPageCache().remove("skssqq");
                this.getPageCache().remove("skssqz");
            }
            this.showInnerPage(org.getString("id"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), false, "edit");
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Object value = this.getModel().getValue(TAXPERIOD);
        if (value == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u7a0e\u671f", (String)"TcvatWkpsrFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (operationResult != null && operationResult.isSuccess()) {
            if ("save".equals(operateKey) || VIEWFLOWCHART.equals(operateKey)) {
                if ("save".equals(operateKey)) {
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    if (null == org) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcvatWkpsrFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                        return;
                    }
                    if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TcvatWkpsrFormPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
                        return;
                    }
                    String pageid = this.getPageCache().get("declarepageid");
                    IFormView childView = this.getView().getView(pageid);
                    IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
                    JSONObject declareData = null;
                    boolean noData = true;
                    if (StringUtils.isNotBlank((CharSequence)childPageCache.get("declareData"))) {
                        declareData = (JSONObject)SerializationUtils.fromJsonString((String)childPageCache.get("declareData"), JSONObject.class);
                        noData = declareData.getJSONArray("dynRowList").stream().map(o -> (JSONObject)JSON.toJSON((Object)o)).map(o -> o.getJSONArray("rowList")).allMatch(JSONArray::isEmpty);
                    }
                    if (noData) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u4fdd\u5b58\u6570\u636e\u3002", (String)"TcvatWkpsrFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                        return;
                    }
                    Boolean wkpsrNegative = (Boolean)SystemParamUtil.getAppParameter((String)"tcvat", (String)"negativedeclare", (long)org.getLong("id"));
                    if (Boolean.FALSE.equals(wkpsrNegative)) {
                        List lessThanZero;
                        Map data = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid_save", Map.class);
                        if (declareData != null && data == null) {
                            JSONObject dataJson = declareData.getJSONObject("data");
                            data = dataJson.getInnerMap();
                        }
                        if (data != null && !(lessThanZero = data.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith("bqyysbdwkjfpxse") && BigDecimal.ZERO.compareTo(new BigDecimal((String)e.getValue())) > 0).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) {
                            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5f00\u7968\u6536\u5165\u4e0d\u5141\u8bb8\u8d1f\u6570\u7533\u62a5\uff0c\u8bf7\u68c0\u67e5\u7b2c%s\u884c\u7684\u201c\u672c\u671f\u7528\u4e8e\u7533\u62a5\u7684\u672a\u5f00\u5177\u53d1\u7968\u9500\u552e\u989d\u201d\u3002", (String)"TcvatWkpsrFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]);
                            StringBuilder sb = new StringBuilder();
                            for (String lessKey : lessThanZero) {
                                String[] split = lessKey.split("#");
                                String dataEntry = split[0];
                                String ewblxh = split[1];
                                if (!"1".equals(ewblxh)) continue;
                                sb.append(dataEntry.replace(WKPSR_DATA, "")).append('\u3001');
                            }
                            if (sb.length() > 0) {
                                this.getView().showErrorNotification(String.format(msg, sb.substring(0, sb.length() - 1)));
                                return;
                            }
                        }
                    }
                    LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"TcvatWkpsrFormPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                    this.getView().showLoading(saveMsg, 3000);
                    this.save();
                    this.wkpsrService.syncWkpsrData(this.getPageCache().get("orgid"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), this.getTemplateType(), this.getPageCache().get("cache_sbbid"));
                    String sbbidStr = this.getPageCache().get("cache_sbbid");
                    long sbbid = Long.parseLong(sbbidStr);
                    DynamicObject sbb = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tcvat_nsrxx");
                    sbb.set("creator", (Object)RequestContext.get().getCurrUserId());
                    sbb.set("createtime", (Object)new Date());
                    SaveServiceHelper.update((DynamicObject)sbb);
                } else {
                    OpenStyle openStyle = new OpenStyle();
                    openStyle.setShowType(ShowType.MainNewTabPage);
                    try {
                        WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)this.getPageCache().get("cache_sbbid"), (OpenStyle)openStyle);
                    }
                    catch (Exception e2) {
                        LOGGER.error("viewFlowchart ---- " + ThrowableHelper.toString((Exception)e2));
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe", (String)"TcvatWkpsrFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                    }
                }
            } else {
                super.afterDoOperation(args);
                String key = args.getOperateKey();
                if ("submit".equals(key) || "unsubmit".equals(key) || "audit".equals(key) || "unaudit".equals(key)) {
                    DynamicObject declareMain = this.getDeclareMain(this.getPageCache().get("orgid"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), this.getTemplateType());
                    this.wkpsrService.updateWkpsrDataBillStatus(this.getPageCache().get("cache_sbbid"), declareMain.getString("billstatus"));
                }
            }
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button && ((Button)evt.getSource()).getKey().equals(BTN_FASTSETTING)) {
            String orgid = this.getPageCache().get("orgid");
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("orgid", orgid);
            customParams.put("parent", "1890542731327992832");
            PageShowCommon.showBillList((String)"bos_templatetreelist", (ShowType)ShowType.MainNewTabPage, (String)"tcvat_tz_rule_config", (IFormView)this.getView(), customParams, null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        String orgId = this.getPageCache().get("orgid");
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        if ("recalc".equals(callBackId)) {
            if (orgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TcvatWkpsrFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (e.getResult() == MessageBoxResult.Yes) {
                this.showInnerPage(orgId, skssqq, skssqz, true, "edit");
            }
        } else {
            super.confirmCallBack(e);
        }
    }

    public void init() {
    }

    public String getTaxType() {
        return "zzs";
    }

    public String getTemplateType() {
        return "zzstz";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        this.initTaxPeriod((String)customParams.get(TAXPERIOD));
    }

    public void showInnerPage(String orgid, String startDate, String endDate, boolean refresh, String operationStatus) {
        if (StringUtils.isBlank((CharSequence)orgid) || StringUtils.isBlank((CharSequence)startDate) || StringUtils.isBlank((CharSequence)endDate)) {
            return;
        }
        DynamicObject declareMain = this.getDeclareMain(orgid, startDate, endDate, this.getTemplateType());
        if (this.isInFlow()) {
            super.showInnerPage(orgid, startDate, endDate, false, "read");
        } else if (declareMain == null) {
            super.showInnerPage(orgid, startDate, endDate, true, "edit");
        } else if ("A".equals(declareMain.getString("billstatus"))) {
            super.showInnerPage(orgid, startDate, endDate, refresh, refresh ? "edit" : "read");
        } else {
            super.showInnerPage(orgid, startDate, endDate, false, "read");
        }
        this.initBill();
    }

    private boolean isInFlow() {
        String inFlow = (String)this.getView().getFormShowParameter().getCustomParam("inFlow");
        return "true".equals(inFlow);
    }

    public void submit(String key) {
        String sbbid = null;
        DynamicObject declare = YbnsrService.queryYbnsr((String)this.getPageCache().get("orgid"), (String)this.getTemplateType(), (String)this.getPageCache().get("skssqq"), (String)this.getPageCache().get("skssqz"), null);
        if (declare != null) {
            sbbid = declare.getString("id");
        }
        if (!StringUtils.isEmpty(sbbid)) {
            boolean flag = DeclareUtils.submit((IFormView)this.getView(), Collections.singletonList(sbbid), (String)key, (String)WKPSR_QUERY_LIST, (boolean)false);
            if (flag) {
                String orgId = this.getPageCache().get("orgid");
                String startDate = this.getPageCache().get("skssqq");
                String endDate = this.getPageCache().get("skssqz");
                this.setBtnStatus(orgId, startDate, endDate, "read");
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"TcvatWkpsrFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        this.operationSbb("read");
    }

    public void operationSbb(String operationType) {
        DynamicObject declareMain = this.getDeclareMain(this.getPageCache().get("orgid"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), this.getTemplateType());
        if (declareMain == null) {
            super.operationSbb("edit");
        } else if ("A".equals(declareMain.getString("billstatus"))) {
            super.operationSbb(operationType);
        } else {
            super.operationSbb("read");
        }
        this.setBtnStatus(this.getPageCache().get("orgid"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), operationType);
        this.initBill();
    }

    public void setBtnStatus(String orgid, String startDate, String endDate, String operationStatus) {
        String templateType = this.getTemplateType();
        DynamicObject dyo = YbnsrService.queryYbnsr((String)orgid, (String)templateType, (String)startDate, (String)endDate, null);
        if (this.isInFlow()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarapdeclare", "recalc", BTN_FASTSETTING});
        } else if (dyo != null && "read".equals(operationStatus)) {
            String billstatus = dyo.getString("billstatus");
            this.getModel().setValue("billstatus", (Object)billstatus);
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"submit", "edit", "close"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"save", "audit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"submit", "recalc", "save"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"unsubmit"});
            }
            if ("B".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"audit", "submit", "close"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"save", "recalc", "edit"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"submit", "unaudit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"audit", "unsubmit"});
            }
            if ("C".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"audit", "close"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"save", "edit", "recalc", "submit"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"audit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"unaudit"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit", "close", "submit", "audit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"recalc", "save", "close"});
        }
    }

    private void initBill() {
        String orgId = this.getPageCache().get("orgid");
        DynamicObject object = this.getDeclareMain(orgId, this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), this.getTemplateType());
        if (object != null) {
            this.getModel().setValue("billstatus", object.get("billstatus"));
            this.getModel().setValue("billno", object.get("billno"));
        } else {
            String billno = this.getPageCache().get("billno");
            if (StringUtils.isBlank((CharSequence)billno)) {
                billno = DeclareServiceHelper.generateSBBNo((String)WKPSR_QUERY_LIST, (String)orgId);
                this.getPageCache().put("billno", billno);
            }
            this.getModel().setValue("billstatus", null);
            this.getModel().setValue("billno", (Object)billno);
        }
    }

    private void initTaxPeriod(String taxperiodStr) {
        Date taxperiod = (Date)this.getModel().getValue(TAXPERIOD);
        if (taxperiod == null) {
            if (StringUtils.isNotBlank((CharSequence)taxperiodStr)) {
                taxperiod = DateUtils.stringToDate((String)taxperiodStr);
            } else {
                Date lastMonth = DateUtils.addMonth((Date)new Date(), (int)-1);
                taxperiod = DateUtils.getFirstDateOfMonth((Date)lastMonth);
            }
            this.getModel().setValue(TAXPERIOD, (Object)taxperiod);
        }
        String skssqq = DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)taxperiod));
        this.getPageCache().put("skssqq", skssqq);
        String skssqz = DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)taxperiod));
        this.getPageCache().put("skssqz", skssqz);
    }

    protected String getUniKey(String orgId, String skssqq, String skssqz, String templateType) {
        return String.format("%1s_%2s_%3s_%4s", orgId, skssqq, skssqz, templateType);
    }
}

