/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account.wkpsr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;

public class TcvatWkpsrQueryListPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(TcvatWkpsrQueryListPlugin.class);
    private static final String ORGID_KEY = "orgid";
    private static final String NEW = "new";
    private static final String VIEWFLOWCHART = "viewflowchart";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void initialize() {
        BillList billlist = (BillList)this.getControl("billlistap");
        QFilter qFilter = new QFilter("type", "=", (Object)"zzstz");
        billlist.setFilter(qFilter);
        billlist.setOrderBy("id desc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        QFilter typeFilter = new QFilter("type", "=", (Object)"zzstz");
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.setFilter(typeFilter);
        billlist.getQueryFilterParameter().setOrderBy("id desc");
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        if (null != customList && customList.size() > 0) {
            for (Map map : customList) {
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf("skssqq");
                if (index == -1) continue;
                List valueList = (List)map.get("Value");
                this.getPageCache().put("skssqq", SerializationUtils.toJsonString((Object)valueList));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        for (QFilter eQFilter : e.getQFilters()) {
            for (QFilter filter : eQFilter.recombine()) {
                if ("skssqq".equals(filter.getProperty())) {
                    if ("<".equals(filter.getCP())) {
                        resultFilter.add(new QFilter("skssqz", "<=", filter.getValue()));
                        continue;
                    }
                    resultFilter.add(filter);
                    continue;
                }
                resultFilter.add(filter);
            }
        }
        e.getQFilters().clear();
        e.getQFilters().addAll(resultFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        OperationResult opResult = evt.getOperationResult();
        String operateKey = evt.getOperateKey();
        if (NEW.equals(operateKey) && opResult.isSuccess()) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("tcvat_wkpsr");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(param);
        }
        if (VIEWFLOWCHART.equals(operateKey)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55", (String)"TcvatWkpsrQueryListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
            if (collect.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4e2a\u6d41\u7a0b\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c", (String)"TcvatWkpsrQueryListPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            try {
                WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)list.get(0).getPrimaryKeyValue(), (OpenStyle)openStyle);
            }
            catch (Exception e) {
                LOGGER.error(ThrowableHelper.toString((Exception)e));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe", (String)"TcvatWkpsrQueryListPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcvat_nsrxx");
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put(ORGID_KEY, object.getDynamicObject("org").getString("id"));
        String startDate = DateUtils.format((Date)object.getDate("skssqq"), (String)"yyyy-MM-dd");
        customParams.put("taxperiod", startDate);
        PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tcvat_wkpsr", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("skssqq".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("skssqq"), (Date)data.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        }
    }
}

