/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.apphome;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.list.ListShowParameter;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.formplugin.apphome.abstractOrganization.abstractOrganization;

public class OrganizationCardPlugin
extends abstractOrganization {
    private static final String POSTLAB = "postlab";
    private static final String AUDLAB = "audlab";
    private static final String DOING = "doing";
    private static final String DONE = "done";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{AUDLAB, POSTLAB, DOING, DONE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (Arrays.asList(AUDLAB, POSTLAB, DOING, DONE).contains(source.getKey())) {
            String status = "editing";
            if (AUDLAB.equals(source.getKey()) || DOING.equals(source.getKey())) {
                status = "editing";
            } else if (POSTLAB.equals(source.getKey()) || DONE.equals(source.getKey())) {
                status = "declared";
            }
            Map params = this.getView().getFormShowParameter().getCustomParams();
            String periodMonth = DateUtils.format((Date)DateUtils.addMonth((Date)new Date(), (int)-1), (String)"yyyy-MM");
            params.put("filterconfig", "true");
            params.put("orgid", "");
            params.put("type", "");
            params.put("periodMonth", periodMonth);
            params.put("declarestatus", status);
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("tcvat_zzs_declare_list");
            listShowParameter.setFormId("bos_list");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u67e5\u8be2", (String)"OrganizationCardPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            listShowParameter.setCustomParams(params);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }
}

