/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.declare;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.declare.TaxDeclareEditService;

public class NewTaxDeclareEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(NewTaxDeclareEditPlugin.class);
    private static final String EDIT = "edit";
    private static final String SAVE = "save";
    private static final String CANCEL = "cancel";
    private static final String RECALC_KEY = "recalc";
    private static final String REFRESH = "refresh";
    private static final String SUBMIT_KEY = "submit";
    private static final String CLOSE = "baritemap2";
    private static final String CHILD_PAGE_ID = "CHILD_PAGE_ID";
    private static final String PARAM_TYPE = "type";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ORG = "org";
    public static final String TPO_TEMPLATE_TYPE = "tpo_template_type";
    public static final String ORGID = "orgid";
    public static final String ENABLE = "1";
    public static final String CACHE_SBBID = "cache_sbbid";

    public void afterCreateNewData(EventObject e) {
        QFilter qFilter;
        DynamicObject templateType;
        this.setBtnEnable(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL, SAVE});
        String type = this.getParam(PARAM_TYPE);
        Boolean refreshFrom = (Boolean)this.getView().getFormShowParameter().getCustomParams().get(REFRESH);
        if (StringUtils.isEmpty((CharSequence)type)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u5b9a\u7533\u62a5\u8868\u7c7b\u578b", (String)"NewTaxDeclareEditPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if ("fjsf".equals(type) && "2".equals(this.getParam("datatype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY});
        }
        if (StringUtils.isNotBlank((Object)refreshFrom) && !refreshFrom.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ORG});
            this.getView().setEnable(Boolean.FALSE, new String[]{RECALC_KEY, REFRESH});
            this.getPageCache().put(type + REFRESH, refreshFrom.toString());
        }
        if ((templateType = QueryServiceHelper.queryOne((String)TPO_TEMPLATE_TYPE, (String)"number", (QFilter[])new QFilter[]{qFilter = new QFilter("number", "=", (Object)type)})) == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7533\u62a5\u8868\u7c7b\u578b%s", (String)"NewTaxDeclareEditPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), type));
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put(PARAM_TYPE, type);
        if (null != customParams.get(ORGID)) {
            this.getModel().setValue(ORG, customParams.get(ORGID));
            this.getPageCache().put(ORGID, (String)customParams.get(ORGID));
        } else {
            List nodeList = OrgUtils.getAllPermNodes((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"zzs");
            String currOrgId = String.valueOf(RequestContext.get().getOrgId());
            try {
                DynamicObject org = (DynamicObject)this.getView().getParentView().getModel().getValue(ORG);
                currOrgId = org.getString("id");
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
            TreeNode defaultOrg = null;
            for (TreeNode node : nodeList) {
                if (!currOrgId.equals(node.getId())) continue;
                defaultOrg = node;
                break;
            }
            if (defaultOrg == null) {
                List roots = TreeUtils.findRoot((List)nodeList);
                defaultOrg = CollectionUtils.isEmpty((Collection)roots) ? null : (TreeNode)roots.get(0);
            }
            String orgId = defaultOrg != null ? defaultOrg.getId() : "0";
            this.getPageCache().put(ORGID, orgId);
            this.getModel().setValue(ORG, (Object)orgId);
        }
        if (OrgCheckUtil.check((IFormView)this.getView(), (String)this.getPageCache().get(ORGID), (String)"fjsf", (String)TaxAppEnum.getEnumInstanceByAppid((String)"fjsf").getCategoryCode())) {
            return;
        }
        boolean b = this.checkZzsXfsEnable();
        if (b) {
            if (customParams.get(SKSSQQ) != null && customParams.get(SKSSQZ) != null) {
                String[] taxLimits = this.getTaxLimits();
                if (taxLimits != null) {
                    Date skssqz;
                    String taxLimit = taxLimits[0];
                    Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
                    switch (taxLimit) {
                        case "season": {
                            skssqz = DateUtils.getLastDateOfSeason((Date)skssqq);
                            break;
                        }
                        default: {
                            skssqz = DateUtils.getLastDateOfMonth((Date)skssqq);
                        }
                    }
                    this.getModel().setValue(SKSSQQ, (Object)skssqq);
                    this.getPageCache().put(SKSSQQ, DateUtils.format((Date)skssqq));
                    this.getModel().setValue(SKSSQZ, (Object)skssqz);
                    this.getPageCache().put(SKSSQZ, DateUtils.format((Date)skssqz));
                }
            } else {
                this.initStartAndEndDate(false);
            }
        }
        if (b && this.checkMainTaxExist()) {
            if (this.existTemplate()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7f3a\u5c11\u7533\u62a5\u8868\u6a21\u677f", (String)"NewTaxDeclareEditPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            this.setBtnEnable(true);
            this.showDeclare("read", false);
        }
    }

    private void setBtnEnable(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{EDIT});
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{RECALC_KEY});
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{SUBMIT_KEY});
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{REFRESH});
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "toolbarapdeclare"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object org = this.getModel().getValue(ORG);
        if (SKSSQZ.equals(name) || SKSSQQ.equals(name) || ORG.equals(name)) {
            ChangeData[] changeData;
            Date skssqq = (Date)this.getModel().getValue(SKSSQQ);
            Date skssqz = (Date)this.getModel().getValue(SKSSQZ);
            if (org == null || skssqq == null || skssqz == null) {
                return;
            }
            if (e.getProperty().getName().equals(ORG) && (changeData = e.getChangeSet()) != null && changeData.length > 0) {
                DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
                if (null == newOrg) {
                    this.getView().getModel().setValue(ORG, (Object)this.getPageCache().get(ORGID));
                    return;
                }
                String neworgid = newOrg.getString("id");
                String appid = this.getView().getFormShowParameter().getAppId();
                if ("fjsf".equals(this.getParam(PARAM_TYPE))) {
                    appid = "fjsf";
                }
                if (OrgCheckUtil.check((IFormView)this.getView(), (String)neworgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode())) {
                    this.getModel().setValue(ORG, (Object)this.getPageCache().get(ORGID));
                    return;
                }
                this.getPageCache().put(ORGID, neworgid);
                boolean b = this.checkZzsXfsEnable();
                if (b) {
                    this.initStartAndEndDate(true);
                }
                boolean b1 = this.checkMainTaxExist();
                if (!b || !b1) {
                    this.setBtnEnable(false);
                }
                if (b && b1) {
                    this.showDeclare("read", false);
                }
            }
            if (SKSSQQ.equals(name)) {
                if (StringUtil.isNotEmpty((CharSequence)this.getPageCache().get("code_change_start"))) {
                    this.getPageCache().remove("code_change_start");
                    return;
                }
                this.getPageCache().put(SKSSQQ, DateUtils.format((Date)skssqq));
                if (!this.propertyChangeValidate(skssqq, skssqz)) {
                    this.setBtnEnable(false);
                    return;
                }
                this.showDeclare("read", false);
            }
            if (SKSSQZ.equals(name)) {
                if (StringUtil.isNotEmpty((CharSequence)this.getPageCache().get("code_change_end"))) {
                    this.getPageCache().remove("code_change_end");
                    return;
                }
                this.getPageCache().put(SKSSQZ, DateUtils.format((Date)skssqz));
                if (!this.propertyChangeValidate(skssqq, skssqz)) {
                    this.setBtnEnable(false);
                    return;
                }
                this.showDeclare("read", false);
            }
        }
    }

    private boolean propertyChangeValidate(Date skssqq, Date skssqz) {
        if (!this.isValidDates(skssqq, skssqz)) {
            return false;
        }
        return this.checkMainTaxExist();
    }

    private void initStartAndEndDate(boolean orgChange) {
        Date skssqz;
        Date skssqq;
        String taxLimit;
        String[] taxLimits = this.getTaxLimits();
        if (taxLimits == null) {
            return;
        }
        switch (taxLimit = taxLimits[0]) {
            case "season": {
                skssqq = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)new Date(), (int)-3));
                skssqz = DateUtils.getLastDateOfSeason((Date)skssqq);
                break;
            }
            default: {
                skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
                skssqz = DateUtils.getLastDateOfMonth((Date)skssqq);
            }
        }
        if (orgChange && !StringUtil.equals((CharSequence)DateUtils.format((Date)skssqq), (CharSequence)DateUtils.format((Date)((Date)this.getModel().getValue(SKSSQQ))))) {
            this.getPageCache().put("code_change_start", "true");
        }
        this.getPageCache().put(SKSSQQ, DateUtils.format((Date)skssqq));
        this.getModel().setValue(SKSSQQ, (Object)skssqq);
        if (orgChange && !StringUtil.equals((CharSequence)DateUtils.format((Date)skssqz), (CharSequence)DateUtils.format((Date)((Date)this.getModel().getValue(SKSSQZ))))) {
            this.getPageCache().put("code_change_end", "true");
        }
        this.getPageCache().put(SKSSQZ, DateUtils.format((Date)skssqz));
        this.getModel().setValue(SKSSQZ, (Object)skssqz);
    }

    private boolean isValidDates(Date startDate, Date endDate) {
        boolean isvalid = false;
        if (!this.checkZzsXfsEnable()) {
            return false;
        }
        String[] taxLimits = this.getTaxLimits();
        if (taxLimits == null) {
            return false;
        }
        for (String taxLimit : taxLimits) {
            boolean temp = DateUtils.validDateRange((String)taxLimit, (Date)startDate, (Date)endDate);
            isvalid |= temp;
        }
        if (!isvalid) {
            String errMsg = TaxDeclareEditService.buildErrorMsg(taxLimits);
            this.getView().showTipNotification(errMsg);
            return false;
        }
        return true;
    }

    private boolean checkZzsXfsEnable() {
        DynamicObject xfsCategory;
        String zzsEnable = null;
        String xfsEnable = null;
        String orgId = this.getPageCache().get(ORGID);
        DynamicObject zzsCategory = TaxBaseDataUtils.queryCategoryByTaxtype((Long)Long.valueOf(orgId), (String)"zzs");
        if (zzsCategory != null) {
            this.getPageCache().put("taxPayerType", zzsCategory.getString("taxpayertype"));
            zzsEnable = zzsCategory.getString("enable");
        }
        if ((xfsCategory = TaxBaseDataUtils.queryCategoryByTaxtype((Long)Long.valueOf(orgId), (String)"xfs")) != null) {
            xfsEnable = xfsCategory.getString("enable");
        }
        if (!StringUtils.equals(zzsEnable, (CharSequence)ENABLE) && !StringUtils.equals((CharSequence)xfsEnable, (CharSequence)ENABLE)) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u589e\u503c\u7a0e\u548c\u6d88\u8d39\u7a0e\u7a0e\u79cd\u5747\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c\uff0c\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91\u2014\u57fa\u7840\u8d44\u6599\u2014\u7a0e\u52a1\u4fe1\u606f\u8fdb\u884c\u542f\u7528\u3002", (String)"NewTaxDeclareEditPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]), this.getOrgName());
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    private String[] getTaxLimits() {
        DynamicObject xfsCategory;
        String zzsDeadline = null;
        String xfsDeadline = null;
        String zzsEnable = null;
        String xfsEnable = null;
        String orgId = this.getPageCache().get(ORGID);
        DynamicObject zzsCategory = TaxBaseDataUtils.queryCategoryByTaxtype((Long)Long.valueOf(orgId), (String)"zzs");
        if (zzsCategory != null) {
            zzsDeadline = zzsCategory.getString("deadline");
            this.getPageCache().put("taxPayerType", zzsCategory.getString("taxpayertype"));
            zzsEnable = zzsCategory.getString("enable");
        }
        if ((xfsCategory = TaxBaseDataUtils.queryCategoryByTaxtype((Long)Long.valueOf(orgId), (String)"xfs")) != null) {
            xfsDeadline = xfsCategory.getString("deadline");
            xfsEnable = xfsCategory.getString("enable");
        }
        if (!StringUtils.equals(zzsEnable, (CharSequence)ENABLE) && !StringUtils.equals(xfsEnable, (CharSequence)ENABLE)) {
            return null;
        }
        if (StringUtils.equals(zzsEnable, (CharSequence)ENABLE) && StringUtils.equals((CharSequence)xfsEnable, (CharSequence)ENABLE)) {
            boolean flag3;
            boolean flag1 = StringUtil.isNotBlank((CharSequence)zzsDeadline) && "ajsb".equals(zzsDeadline) && StringUtil.isNotBlank((CharSequence)xfsDeadline) && "ajsb".equals(xfsDeadline);
            boolean flag2 = StringUtil.isBlank((CharSequence)xfsDeadline) && "ajsb".equals(zzsDeadline);
            boolean bl = flag3 = StringUtil.isBlank((CharSequence)zzsDeadline) && "ajsb".equals(xfsDeadline);
            if (flag1 || flag2 || flag3) {
                this.getPageCache().put("deadLine", "ajsb");
                return new String[]{"season"};
            }
            this.getPageCache().put("deadLine", "aysb");
            return new String[]{"month"};
        }
        if (StringUtils.equals((CharSequence)zzsEnable, (CharSequence)ENABLE) && "ajsb".equals(zzsDeadline) || StringUtils.equals((CharSequence)xfsEnable, (CharSequence)ENABLE) && "ajsb".equals(xfsDeadline)) {
            this.getPageCache().put("deadLine", "ajsb");
            return new String[]{"season"};
        }
        this.getPageCache().put("deadLine", "aysb");
        return new String[]{"month"};
    }

    public void itemClick(ItemClickEvent evt) {
        if (EDIT.equals(evt.getItemKey())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (null != org && ("fjsf".equals(this.getParam(PARAM_TYPE)) ? LicenseCheckServiceHelper.check((Object)org.getString("id"), (IFormView)this.getView(), (String)"fjsf") : LicenseCheckServiceHelper.check((Object)org.getString("id"), (IFormView)this.getView(), (String)"tcvat"))) {
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{CANCEL, SAVE});
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT, CLOSE});
            this.showDeclare(EDIT, false);
        }
        if (CANCEL.equals(evt.getItemKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL, SAVE});
            this.getView().setVisible(Boolean.TRUE, new String[]{EDIT, CLOSE});
            if (StringUtils.equals((CharSequence)String.valueOf(Boolean.FALSE), (CharSequence)this.getPageCache().get(this.getParam(PARAM_TYPE) + REFRESH))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{RECALC_KEY});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{RECALC_KEY});
            }
            this.showDeclare("read", false);
        }
        if (SAVE.equals(evt.getItemKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL, SAVE});
            this.getView().setVisible(Boolean.TRUE, new String[]{EDIT, CLOSE, REFRESH});
            if (StringUtils.equals((CharSequence)String.valueOf(Boolean.FALSE), (CharSequence)this.getPageCache().get(this.getParam(PARAM_TYPE) + REFRESH))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{RECALC_KEY});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{RECALC_KEY});
            }
            this.saveClick();
            this.showDeclare("read", false);
        }
        if (RECALC_KEY.equals(evt.getItemKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL, SAVE});
            this.getView().setVisible(Boolean.TRUE, new String[]{EDIT});
            this.recale();
        }
        if (REFRESH.equals(evt.getItemKey())) {
            this.showDeclare("read", false);
        }
        if (SUBMIT_KEY.equals(evt.getItemKey())) {
            this.submit();
        }
    }

    public void submit() {
        DynamicObject declare;
        String sbbid = this.getPageCache().get(CACHE_SBBID);
        if (StringUtils.isEmpty((CharSequence)sbbid) && (declare = TaxDeclareEditService.queryNsrxx(this.getPageCache().get(ORGID), this.getPageCache().get(SKSSQQ), this.getPageCache().get(SKSSQZ), new QFilter(PARAM_TYPE, "=", (Object)"fjsf"))) != null) {
            sbbid = declare.getString("id");
            this.getPageCache().put(CACHE_SBBID, sbbid);
        }
        if (!StringUtils.isEmpty((CharSequence)sbbid)) {
            ArrayList<String> pklist = new ArrayList<String>();
            pklist.add(sbbid);
            boolean flag = DeclareUtils.submit((IFormView)this.getView(), pklist, (String)SUBMIT_KEY, (String)"tcvat_nsrxx", (boolean)false);
            if (flag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{SAVE, CANCEL});
                this.getView().setEnable(Boolean.FALSE, new String[]{EDIT, SUBMIT_KEY, RECALC_KEY});
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c", (String)"NewTaxDeclareEditPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (RECALC_KEY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.showDeclare("read", true);
        }
    }

    private void showDeclare(String operation, boolean refresh) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(10);
        String startdate = this.getPageCache().get(SKSSQQ);
        String enddate = this.getPageCache().get(SKSSQZ);
        DynamicObject template = TemplateUtilsOld.getTemplateObject((String)this.getPageCache().get(PARAM_TYPE), (Date)DateUtils.stringToDate((String)startdate), (Date)DateUtils.stringToDate((String)enddate));
        if (template == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7f3a\u5c11\u7533\u62a5\u8868\u6a21\u677f", (String)"NewTaxDeclareEditPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null) {
            String orgId = org.getString("id");
            Date skssqq = (Date)this.getModel().getValue(SKSSQQ);
            Date skssqz = (Date)this.getModel().getValue(SKSSQZ);
            customParams.put(ORGID, orgId);
            customParams.put(SKSSQQ, DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd"));
            customParams.put(SKSSQZ, DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            customParams.put("templatetype", this.getPageCache().get(PARAM_TYPE));
            customParams.put("operation", operation);
            customParams.put("ParentCache", "false");
            if (refresh) {
                customParams.put(REFRESH, "true");
            }
            boolean readonly = false;
            boolean isDeclare = this.isDeclared(orgId, startdate, enddate);
            if (isDeclare) {
                readonly = true;
            }
            this.getView().setEnable(Boolean.valueOf(!readonly), new String[]{RECALC_KEY});
            this.getView().setEnable(Boolean.valueOf(!readonly), new String[]{EDIT});
            this.getView().setEnable(Boolean.valueOf(!readonly), new String[]{SUBMIT_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{REFRESH});
            customParams.put("readonly", readonly);
            customParams.put("taxPayerType", this.getPageCache().get("taxPayerType"));
            customParams.put("deadline", this.getPageCache().get("deadLine"));
            param.setFormId("bdtaxr_declare_old");
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.InContainer);
            param.getOpenStyle().setTargetKey("flexpanelap");
            String pageid = param.getPageId();
            this.getPageCache().put(CHILD_PAGE_ID, pageid);
            this.getView().showForm(param);
        }
    }

    private boolean isDeclared(String orgId, String startdate, String enddate) {
        QFilter taxTypeQfilter = new QFilter(PARAM_TYPE, "=", (Object)"fjsf");
        DynamicObject declare = TaxDeclareEditService.queryNsrxx(orgId, startdate, enddate, taxTypeQfilter);
        this.getPageCache().put("cache_billstatus", "A");
        if (declare != null) {
            String status = declare.getString("declarestatus");
            String billstatus = declare.getString("billstatus");
            String id = declare.getString("id");
            this.getPageCache().put("cache_billstatus", billstatus);
            this.getPageCache().put(CACHE_SBBID, id);
            if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
                DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
                String orgName = "";
                if (org != null) {
                    orgName = org.getString("name");
                }
                String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279", (String)"NewTaxDeclareEditPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]);
                if ("C".equals(billstatus)) {
                    statusName = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"NewTaxDeclareEditPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
                if ("declared".equals(status)) {
                    statusName = ResManager.loadKDString((String)"\u7533\u62a5", (String)"NewTaxDeclareEditPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
                String msg = String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u201c%1$s\u201d\u5c5e\u671f\u9644\u52a0\u7a0e\u8d39\u5df2\u201c%2$s\u201d\uff0c\u53ea\u80fd\u67e5\u770b\u6570\u636e\uff0c\u4e0d\u80fd\u7f16\u8f91\u4fee\u6539\u3002", (String)"NewTaxDeclareEditPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, statusName);
                this.getView().showTipNotification(msg, Integer.valueOf(5000));
                return true;
            }
        }
        return false;
    }

    private void saveClick() {
        String pageid = this.getPageCache().get(CHILD_PAGE_ID);
        IFormView childView = this.getView().getView(pageid);
        if (childView != null) {
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
            IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
            List pluginList = pluginProxy.getPlugIns();
            Object taxDeclarePlugin = null;
            for (IFormPlugin plugin : pluginList) {
                if (!plugin.getPluginName().endsWith("TaxDeclarePlugin")) continue;
                taxDeclarePlugin = plugin;
            }
            if (taxDeclarePlugin != null) {
                Class<?> pluginClass = taxDeclarePlugin.getClass();
                try {
                    Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class);
                    saveClick.invoke(taxDeclarePlugin, childPageCache);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.showDeclare("read", false);
            }
        }
    }

    private boolean existTemplate() {
        String type = this.getPageCache().get(PARAM_TYPE);
        String skssqq = this.getPageCache().get(SKSSQQ);
        String skssqz = this.getPageCache().get(SKSSQZ);
        DynamicObject template = TemplateUtilsOld.getTemplateObject((String)type, (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
        return template == null;
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get(param);
    }

    private void recale() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"NewTaxDeclareEditPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"NewTaxDeclareEditPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5c06\u5bfc\u81f4\u539f\u6709\u7eb3\u7a0e\u7533\u62a5\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"NewTaxDeclareEditPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private boolean checkMainTaxExist() {
        String orgId = this.getPageCache().get(ORGID);
        String startdate = this.getPageCache().get(SKSSQQ);
        String enddate = this.getPageCache().get(SKSSQZ);
        if (StringUtil.isEmpty((CharSequence)startdate) || StringUtil.isEmpty((CharSequence)enddate)) {
            return false;
        }
        QFilter taxTypeQfilter = new QFilter(PARAM_TYPE, "like", (Object)"zzs%").or(PARAM_TYPE, "like", (Object)"xfs%").or(PARAM_TYPE, "like", (Object)"fjsf%");
        DynamicObject declare = TaxDeclareEditService.queryNsrxx(orgId, startdate, enddate, taxTypeQfilter);
        if (declare == null) {
            String taxLimitTips = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)startdate), (Date)DateUtils.stringToDate((String)enddate));
            String msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u7684\u589e\u503c\u7a0e\u6216\u6d88\u8d39\u7a0e\u7533\u62a5\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u8fdb\u884c\u76f8\u5173\u7a0e\u79cd\u7684\u7eb3\u7a0e\u7533\u62a5\u3002", (String)"NewTaxDeclareEditPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]), this.getOrgName(), taxLimitTips);
            this.getView().showErrorNotification(msg);
        }
        return declare != null;
    }

    private String getOrgName() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        String orgName = "";
        if (org != null) {
            orgName = org.getString("name");
        }
        return orgName;
    }
}

