/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.declare;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportPluginNew;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.common.dto.draft.DraftDto;

public class TcvatDeclarePlugin
extends AbstractDeclareReportPluginNew {
    private DraftDto draftDto = new DraftDto();
    private static final String ORGID_KEY = "orgid";
    protected static final String OLD_ORGID_KEY = "oldorgid";
    private static final String TAXPAYER_TYPE_KEY = "taxPayerType";
    private static final String ZB = "zb";
    private static final String FB1 = "fb1";
    private static final String FB2 = "fb2";
    private static final String FB3 = "fb3";
    private static final String FB4 = "fb4";
    private static final String FB5 = "fb5";
    private static final String JMS = "jms";
    private static final String ASSIGN = "assign";
    private static final String XGMNSRZB = "xgmnsrzb";
    private static final String XGMNSRFLZL = "xgmnsrflzl";
    private static final String XGMNSRFLZL2 = "xgmnsrflzl2";
    private static final String XGMNSRMSXM = "xgmnsrmsxm";
    private static final String FJSFYBTSE = "fjsfybtse";

    private void setDataFlex(String templateType) {
        String formId;
        if (null == templateType) {
            return;
        }
        switch (templateType) {
            case "zzsybnsr": 
            case "ybnsr": 
            case "zzsybnsr_ybhz": 
            case "zzsybnsr_hz_zjg": 
            case "zzsybnsr_yz_zjg": 
            case "zzsybnsr_yz_fzjg": {
                formId = "tcvat_ybnsr_dataflex";
                break;
            }
            case "zzsxgmnsr": 
            case "xgmnsr": {
                formId = "tcvat_xgmnsr_dataflex";
                break;
            }
            default: {
                formId = "tcvat_ybnsr_dataflex";
            }
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("dataflex");
        parameter.setFormId(formId);
        parameter.setCustomParam("sheetid", (Object)"0");
        this.getView().showForm(parameter);
        String pageId = parameter.getPageId();
        this.getPageCache().put("pageId", pageId);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String orgid;
        String key = evt.getItemKey();
        super.beforeItemClick(evt);
        if ("save".equals(key) && null != (orgid = this.getPageCache().get(ORGID_KEY)) && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(orgid)).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TcvatDeclarePlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        String templateType = this.getTemplateType();
        if (!Pattern.matches("[a-zA-Z\\_]+", templateType)) {
            this.getView().showErrorNotification(templateType);
            return false;
        }
        this.getView().setVisible(Boolean.valueOf(!"zzsybnsr_hz_fzjg".equalsIgnoreCase(templateType)), new String[]{"viewdraft"});
        DynamicObject declareMain = this.getDeclareMain(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), templateType);
        if (null == declareMain) {
            declareMain = this.getDeclareMain(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), "zzsybnsr");
        }
        String deadLine = this.getPageCache().get("deadLine");
        String planid = this.getPageCache().get("planid");
        if ("ajsb".equals(deadLine) && StringUtils.isNotBlank((CharSequence)planid)) {
            this.getPageCache().remove("zzsybnsr_ybfz" + this.getPageCache().get(ORGID_KEY));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5b63\u5ea6\u6c47\u603b\u7533\u62a5\uff0c\u8bf7\u8c03\u6574\u7a0e\u79cd\u5361\u7247\u7684\u57fa\u7840\u4fe1\u606f\u3002", (String)"TcvatDeclarePlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"recalc"});
            return false;
        }
        boolean zerodeclare = null != declareMain ? declareMain.getBoolean("zerodeclare") : SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"zerodeclare", (long)Long.parseLong(orgid));
        this.getView().getFormShowParameter().setCustomParam("templatetype", (Object)"zzsybnsr");
        Date startDate = DateUtils.stringToDate((String)skssqq);
        Date endDate = DateUtils.stringToDate((String)skssqz);
        QFilter filterList = new QFilter("org", "=", (Object)Long.valueOf(orgid)).and(new QFilter("skssqq", "<=", (Object)startDate)).and(new QFilter("skssqz", ">=", (Object)endDate)).and(new QFilter("type", "in", Arrays.asList("zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg", "zzsybnsr_yz_fzjg"))).and(new QFilter("type", "!=", (Object)templateType));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tcvat_zzs_declare_list", (String)"type", (QFilter[])new QFilter[]{filterList});
        String orgName = OrgUtils.getOrgNameById((String)orgid);
        if (null != object) {
            String declareType = (String)TemplateTypeConstant.getMap().get(object.getString("type"));
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\u5df2\u5b58\u5728\u5c5e\u671f\u4e3a\u3010%2$s\u3011\u81f3\u3010%3$s\u3011\u7684\u3010%4$s\u3011\u7533\u62a5\u8868,\u65e0\u9700\u751f\u6210\u3002", (String)"TcvatDeclarePlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, skssqq, skssqz, declareType));
            return false;
        }
        if (!zerodeclare) {
            Boolean checkResult;
            QFilter filter;
            DynamicObject hzQuery;
            QFilter orgAndDateFilter = new QFilter("org", "=", (Object)Long.valueOf(orgid)).and(new QFilter("startdate", ">=", (Object)DateUtils.getDayFirst((Date)startDate))).and(new QFilter("enddate", "<=", (Object)DateUtils.getDayLast((Date)endDate))).and(new QFilter("drafttype", ">=", (Object)"zzs"));
            DynamicObject query = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"templatetype", (QFilter[])new QFilter[]{orgAndDateFilter});
            String hzOrgId = this.getPageCache().get("hzOrgId");
            if (query != null && !templateType.equals(query.getString("templatetype").replace("draft_", ""))) {
                String draftType = query.getString("templatetype").replace("draft_", "");
                boolean dl = "zzsybnsr".equals(draftType) || "zzsxgmnsr".equals(draftType);
                String declareType = this.getPageCache().get("declareType");
                if (dl && ("2".equals(declareType) || "zzsybnsr_yz_fzjg".equals(templateType) || "zzsybnsr_hz_fzjg".equals(templateType))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\u5df2\u5b58\u5728\u3010%2$s\u3011-\u3010%3$s\u3011\u7684\u72ec\u7acb\u7533\u62a5\u5e95\u7a3f\uff0c\u4f46\u67e5\u8be2\u5230\u5b58\u5728\u6c47\u603b\u7533\u62a5\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u539f\u6709\u72ec\u7acb\u5e95\u7a3f\u540e\u91cd\u65b0\u751f\u6210\u6c47\u603b\u5e95\u7a3f\u8fd8\u662f\u8c03\u6574\u6c47\u603b\u65b9\u6848\u3002", (String)"TcvatDeclarePlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, skssqq, skssqz));
                    return false;
                }
                if (!dl && "3".equals(declareType)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\u5df2\u5b58\u5728\u3010%2$s\u3011-\u3010%3$s\u3011\u4f5c\u4e3a\u603b\u673a\u6784\u7684\u6c47\u603b\u7533\u62a5\u5e95\u7a3f\uff0c\u4f46\u67e5\u8be2\u5230\u5b58\u5728\u73b0\u884c\u6c47\u603b\u7533\u62a5\u4e2d\u4e3a\u5206\u652f\u673a\u6784\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u539f\u6709\u5e95\u7a3f\u540e\u91cd\u65b0\u751f\u6210\u5e95\u7a3f\u8fd8\u662f\u8c03\u6574\u6c47\u603b\u65b9\u6848\u3002", (String)"TcvatDeclarePlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, skssqq, skssqz));
                    return false;
                }
            } else if (query == null && !StringUtils.equals((CharSequence)orgid, (CharSequence)hzOrgId) && hzOrgId != null && (hzQuery = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"templatetype", (QFilter[])new QFilter[]{filter = new QFilter("org", "=", (Object)Long.valueOf(hzOrgId)).and(new QFilter("startdate", ">=", (Object)DateUtils.getDayFirst((Date)startDate))).and(new QFilter("enddate", "<=", (Object)DateUtils.getDayLast((Date)endDate))).and(new QFilter("drafttype", ">=", (Object)"zzs"))})) != null && ("draft_zzsybnsr".equals(hzQuery.getString("templatetype")) || "draft_zzsxgmnsr".equals(hzQuery.getString("templatetype")))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\u7684\u603b\u673a\u6784\u751f\u6210\u4e86\u72ec\u7acb\u7533\u62a5\u7684\u5e95\u7a3f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u539f\u6709\u7684\u603b\u673a\u6784\u5e95\u7a3f\u540e\u91cd\u65b0\u751f\u6210\u5e95\u7a3f\u8fd8\u662f\u8c03\u6574\u6c47\u603b\u65b9\u6848\u3002", (String)"TcvatDeclarePlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
                return false;
            }
            if (!(checkResult = Boolean.valueOf(this.ybhzyzCheck(this.getPageCache().get(OLD_ORGID_KEY)))).booleanValue()) {
                return false;
            }
        }
        if ("zzsybnsr_hz_fzjg".equals(templateType)) {
            if (this.getPageCache().get(orgid + skssqq + skssqz + templateType) == null) {
                String oldOrg = this.getPageCache().get(OLD_ORGID_KEY);
                String setOrg = this.getPageCache().get("setOrg");
                if (!StringUtils.equals((CharSequence)setOrg, (CharSequence)orgid)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u4e3a\u4ec5\u6c47\u603b\u4e0d\u5206\u914d\u4e0d\u9884\u5f81\u7533\u62a5\u65b9\u5f0f\u7684\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u751f\u6210\u7533\u62a5\u8868\u3002", (String)"TcvatDeclarePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
                    this.getPageCache().put("setOrg", oldOrg);
                    this.getModel().setValue("org", (Object)oldOrg);
                } else {
                    this.getPageCache().remove("setOrg");
                }
                this.getPageCache().put(orgid + skssqq + skssqz + templateType, "1");
            }
            return false;
        }
        return true;
    }

    private boolean ybhzyzCheck(Object orgid) {
        if (null == orgid) {
            return false;
        }
        String templateType = this.getTemplateType();
        if ("zzsybnsr_yz_zjg".equals(templateType) || "zzsybnsr_yz_fzjg".equals(templateType)) {
            Map<String, String> checkMap = this.isYzZjgDraftExist();
            if ("true".equals(checkMap.get("rollback"))) {
                this.getView().showTipNotification(checkMap.get("msg"));
                this.getPageCache().put(ORGID_KEY, orgid.toString());
                Map<String, String> checkMap2 = this.isYzZjgDraftExist();
                if (!"true".equals(checkMap2.get("rollback"))) {
                    this.getModel().setValue("org", orgid);
                }
                return false;
            }
            if (null != checkMap.get("msg")) {
                this.getView().showTipNotification(checkMap.get("msg"));
            }
        }
        return true;
    }

    protected void initStartAndEndDate(boolean orgChange) {
        if (orgChange) {
            this.getModel().beginInit();
            super.initStartAndEndDate(true);
            this.getModel().endInit();
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
        } else {
            super.initStartAndEndDate(false);
        }
    }

    public void orgCheckResultHandle(String oldorgid, String orgid, boolean checkResult) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        if (checkResult) {
            this.getPageCache().put(ORGID_KEY, oldorgid);
            this.getPageCache().put(OLD_ORGID_KEY, oldorgid);
            this.getModel().setValue("org", (Object)(StringUtils.isNotBlank((CharSequence)oldorgid) ? Long.valueOf(oldorgid) : null));
        } else {
            boolean check;
            this.getPageCache().put(ORGID_KEY, orgid);
            oldorgid = oldorgid != null ? ((check = OrgCheckUtil.check((IFormView)this.getView(), (String)oldorgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode())) ? orgid : oldorgid) : orgid;
            this.getPageCache().put(OLD_ORGID_KEY, oldorgid);
            this.initStartAndEndDate(true);
            this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"), Boolean.FALSE);
        }
    }

    private Map<String, String> isYzZjgDraftExist() {
        HashMap<String, String> checkMap = new HashMap<String, String>(8);
        String currentOrg = this.getPageCache().get(ORGID_KEY);
        String orgName = OrgUtils.getOrgNameById((String)currentOrg);
        String startDateStr = this.getPageCache().get("skssqq");
        String endDateStr = this.getPageCache().get("skssqz");
        Date startDate = DateUtils.stringToDate((String)startDateStr);
        Date endDate = DateUtils.stringToDate((String)endDateStr);
        String taxlimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
        DynamicObject declarePlanObject = OrgUtils.getOrgDeclarePlan((Long)Long.valueOf(currentOrg), (Date)startDate, (Date)endDate);
        if (declarePlanObject == null) {
            checkMap.put("msg", ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u603b\u673a\u6784\u7eb3\u7a0e\u603b\u89c8\u8868\u3002", (String)"TcvatDeclarePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return checkMap;
        }
        DynamicObject currentOrgPlanData = declarePlanObject.getDynamicObjectCollection("orgrow").stream().filter(c -> c.getDynamicObject(ORGID_KEY).getString("id").equals(currentOrg)).findFirst().get();
        checkMap.put("levelname", currentOrgPlanData.getString("levelname"));
        if ("2".equals(currentOrgPlanData.getString("levelname")) && !currentOrgPlanData.getBoolean("issuesbb") && !YbnsrService.isExistsSbbs(Collections.singletonList(currentOrg), Arrays.asList(TaxTypeEnum.TCVAT.getTemplates()), (String)taxlimit, (String)startDateStr, (String)endDateStr)) {
            checkMap.put("msg", String.format(ResManager.loadKDString((String)"%s\u4e0d\u652f\u6301\u751f\u6210\u7533\u62a5\u8868\u3002\u8bf7\u786e\u8ba4\u6240\u5c5e\u7684\u3010\u6c47\u603b\u65b9\u6848\u3011\u7684\u201c\u51fa\u5177\u7533\u62a5\u8868\u201d\u5f00\u5173\u662f\u5426\u6253\u5f00\u3002", (String)"TcvatDeclarePlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
            checkMap.put("rollback", "true");
            return checkMap;
        }
        if ("3".equals(currentOrgPlanData.getString("levelname")) && ("3".equals(declarePlanObject.getString("prelevyrate")) || "2".equals(declarePlanObject.getString("prelevyrate")) || "1".equals(declarePlanObject.getString("prelevyrate")))) {
            checkMap.put("msg", String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u4e3a\u9884\u5f81\u6c47\u603b\u7533\u62a5\u7684\u4e09\u7ea7\u673a\u6784\uff0c\u65e0\u9700\u751f\u6210\u7533\u62a5\u8868\u3002", (String)"TcvatDeclarePlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]), orgName));
            checkMap.put("rollback", "true");
            return checkMap;
        }
        String zjgOrg = currentOrgPlanData.getString("collectorg");
        DynamicObjectCollection zlbNsrxxData = YbnsrService.queryZzsSbb(Collections.singletonList(zjgOrg), (String)"draft_zzsybnsr_ybhz", (String)startDateStr, (String)endDateStr);
        if (zlbNsrxxData.size() == 0) {
            checkMap.put("msg", ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u603b\u673a\u6784\u7eb3\u7a0e\u603b\u89c8\u8868\u3002", (String)"TcvatDeclarePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return checkMap;
        }
        if (currentOrg.equals(zjgOrg)) {
            List levelTwoOrgList = declarePlanObject.getDynamicObjectCollection("orgrow").stream().filter(d -> null != d.getDynamicObject("parentid") && zjgOrg.equals(d.getDynamicObject("parentid").getString("id"))).map(m -> m.getDynamicObject(ORGID_KEY).getString("id")).collect(Collectors.toList());
            DynamicObjectCollection leveTwoOrgSBB = YbnsrService.queryZzsSbb(levelTwoOrgList, (String)"zzsybnsr_yz_fzjg", (String)startDateStr, (String)endDateStr);
            if (levelTwoOrgList.size() != leveTwoOrgSBB.size()) {
                checkMap.put("msg", ResManager.loadKDString((String)"\u9644\u8868\u56db\u7684\u5206\u652f\u673a\u6784\u9884\u7f34\u672c\u671f\u53d1\u751f\u989d\u4ece\u5206\u652f\u673a\u6784\u7533\u62a5\u8868\u53d6\u6570\uff0c\u8bf7\u5148\u5728\u3010\u589e\u503c\u7a0e\u7533\u62a5\u3011\u9875\u9762\u4e2d\u751f\u6210\u5168\u90e8\u5206\u652f\u673a\u6784\u7533\u62a5\u8868\u3002\u5206\u652f\u673a\u6784\u751f\u6210\u7533\u62a5\u8868\u540e\u70b9\u51fb\u201c\u91cd\u65b0\u8ba1\u7b97\u201d\u53ef\u53d6\u5230\u5206\u652f\u673a\u6784\u7533\u62a5\u8868\u7684\u6570\u3002", (String)"TcvatDeclarePlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
                return checkMap;
            }
        }
        return checkMap;
    }

    public void init() {
        String msg;
        String orgId = this.getPageCache().get(ORGID_KEY);
        if (StringUtils.isEmpty((CharSequence)orgId) || Objects.equals(orgId, "0") || Objects.equals(orgId, "null")) {
            return;
        }
        this.setDataFlex(this.getTemplateType());
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        if (!super.isValidDates(startDate, endDate, Boolean.FALSE).booleanValue()) {
            this.getPageCache().remove("zzsybnsr_ybfz" + orgId);
        }
        if ((msg = this.getPageCache().get("zzsybnsr_ybfz" + orgId)) != null) {
            this.getView().showConfirm(msg, MessageBoxOptions.OK, ConfirmTypes.Save, null);
        }
    }

    public String getTaxType() {
        return "zzs";
    }

    public String getTemplateType() {
        String orgId = this.getPageCache().get(ORGID_KEY);
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        if (StringUtils.isBlank((CharSequence)startDate) || StringUtils.isBlank((CharSequence)endDate)) {
            return null;
        }
        Map<String, Object> cache = TaxDeclareHelper.getTemplateType("declare", orgId, startDate, endDate, "nssb");
        if (null != cache.get("orgmsg")) {
            return (String)cache.get("orgmsg");
        }
        String taxpayertype = (String)cache.get("taxpayertype");
        this.getPageCache().put("nowTaxPayerType", taxpayertype);
        String taxPayerType = this.getCachedTaxPayerType();
        if (taxPayerType != null) {
            taxpayertype = taxPayerType;
        }
        this.getPageCache().put(TAXPAYER_TYPE_KEY, taxpayertype);
        this.getPageCache().put("hzOrgId", (String)cache.get("hzOrgId"));
        this.getPageCache().put("declareType", (String)cache.get("declareType"));
        this.getPageCache().put("deadLine", (String)cache.get("deadLine"));
        this.getPageCache().put("planid", (String)cache.get("planid"));
        this.getPageCache().put("registerType", this.getTaxRegisterType(orgId));
        this.getPageCache().put("prelevyrate", (String)cache.get("prelevyrate"));
        if (!(Boolean.TRUE.equals(cache.get("zerodeclare")) || "zzsybnsr_yz_fzjg".equals(taxpayertype) || "zzsybnsr_hz_fzjg".equals(taxpayertype) || null != this.getPageCache().get("zzsybnsr_ybfz" + orgId))) {
            this.getPageCache().put("zzsybnsr_ybfz" + orgId, (String)cache.get("taxpayertypemsg"));
        }
        DynamicObject zlb = YbnsrService.queryYbnsr((String)orgId, (String)("draft_" + taxpayertype), (String)startDate, (String)endDate, (int)0, null);
        this.getPageCache().put("zlbid", null == zlb ? "0" : zlb.getString("id"));
        String templatetype = (String)cache.get("templatetype");
        if (taxPayerType != null) {
            templatetype = taxPayerType;
        }
        return templatetype;
    }

    private String getCachedTaxPayerType() {
        String orgId = this.getPageCache().get(ORGID_KEY);
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        String taxPayerType = this.getPageCache().get(TAXPAYER_TYPE_KEY);
        if (taxPayerType != null) {
            taxPayerType = taxPayerType.replace("draft_", "").replace("_sjjt", "");
            String templateTypeCachedKey = this.getPageCache().get("templateTypeCachedKey");
            if (templateTypeCachedKey == null) {
                templateTypeCachedKey = "templateType_" + orgId + "_" + startDate + "_" + endDate;
                this.getPageCache().put("templateTypeCachedKey", templateTypeCachedKey);
                this.getPageCache().put(templateTypeCachedKey, taxPayerType);
            } else {
                taxPayerType = this.getPageCache().get("templateType_" + orgId + "_" + startDate + "_" + endDate);
            }
        } else {
            this.getPageCache().put("templateTypeCachedKey", "null");
        }
        return taxPayerType;
    }

    private String getTaxRegisterType(String orgId) {
        DynamicObject dynamicObject = PeriodService.loadTaxMain(orgId);
        return dynamicObject != null ? dynamicObject.getString("registertype.id") : null;
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        TaxDeclareHelper.initPeriod(getModel, getPageCache, orgId, customParams, false);
        this.getView().updateView("skssqq");
        this.getView().updateView("skssqz");
    }

    public Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        if (!TaxDeclarationService.isNature(startDate, endDate)) {
            if (Boolean.TRUE.equals(needMsg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u6708\u6216\u6574\u5b63\u5ea6", (String)"TcvatDeclarePlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
            return Boolean.FALSE;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.draftDto.setOrgId(org.getLong("id"));
        this.draftDto.setStartDate(startDate);
        this.draftDto.setEndDate(endDate);
        if (!TaxDeclareHelper.validByTaxLimit(this.draftDto)) {
            if (Boolean.TRUE.equals(needMsg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u671f\u95f4\u4e0e\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TcvatDeclarePlugin_14", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean isNewTemplate() {
        String startDate = this.getPageCache().get("skssqq");
        Date skssqq = DateUtils.stringToDate((String)startDate);
        return skssqq.compareTo(DateUtils.stringToDate((String)"2021-07-01")) >= 0;
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
        this.getPageCache().put("datamap", JsonUtil.toJson(dataMap));
        this.getPageCache().put("sheetid", sheetid);
        boolean isNewTemplate = this.isNewTemplate();
        this.zzsxgmnsr(sheetid, isNewTemplate);
        switch (this.getPageCache().get(TAXPAYER_TYPE_KEY)) {
            case "ybnsr": 
            case "zzsybnsr": 
            case "zzsybnsr_ybhz": 
            case "zzsybnsr_hz_zjg": 
            case "zzsybnsr_yz_zjg": 
            case "zzsybnsr_yz_fzjg": {
                this.zzsybnsr(dataMap, sheetid, isNewTemplate);
                break;
            }
            case "xgmnsr": 
            case "zzsxgmnsr": {
                this.zzsxgmnsr(sheetid, isNewTemplate);
                break;
            }
        }
        this.getView().getView(this.getPageCache().get("pageId")).addClientCallBack(sheetid);
        this.getView().sendFormAction(this.getView().getView(this.getPageCache().get("pageId")));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Map<String, Object> cache;
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if ("onekeygenerate".equals(afterDoOperationEventArgs.getOperateKey()) && !(cache = TaxDeclareHelper.checkBeforeGetTemplateType(org.getString("id"), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate))).isEmpty()) {
            String orgmsg = (String)cache.get("orgmsg");
            this.getView().showErrorNotification(orgmsg);
            return;
        }
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("edit".equals(afterDoOperationEventArgs.getOperateKey())) {
            String cachedTaxPayerType = this.getCachedTaxPayerType();
            String nowTaxPayerType = this.getPageCache().get("nowTaxPayerType");
            String templateType = StringUtil.isBlank((CharSequence)this.getPageCache().get(TAXPAYER_TYPE_KEY)) ? this.getTemplateType() : this.getPageCache().get(TAXPAYER_TYPE_KEY);
            Map map = this.chooseDeclareFormByDataType(org.getString("id"), templateType, startDate, endDate);
            this.getView().setVisible(Boolean.valueOf((cachedTaxPayerType == null || StringUtils.equals((CharSequence)cachedTaxPayerType, (CharSequence)nowTaxPayerType)) && StringUtils.equals((CharSequence)"1", (CharSequence)((String)map.get("datatype")))), new String[]{"recalc"});
            this.getView().setVisible(Boolean.valueOf((cachedTaxPayerType == null || StringUtils.equals((CharSequence)cachedTaxPayerType, (CharSequence)nowTaxPayerType)) && !"zzsybnsr_yz_fzjg".equals(nowTaxPayerType) && StringUtils.equals((CharSequence)"1", (CharSequence)((String)map.get("datatype")))), new String[]{"onekeygenerate"});
        }
    }

    private void zzsybnsr(Map<String, String> dataMap, String sheetid, boolean isNewTemplate) {
        this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.FALSE, new String[]{ZB, FB1, FB2, FB3, FB4, FB5, JMS, ASSIGN});
        List<String> ncpList = Arrays.asList("1388990221600714752", "1389922186361365504");
        switch (sheetid) {
            case "0": {
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{ZB});
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.valueOf(isNewTemplate), new String[]{FJSFYBTSE});
                break;
            }
            case "1": {
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{FB1});
                break;
            }
            case "2": {
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{FB2});
                break;
            }
            case "3": {
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{FB3});
                break;
            }
            case "4": {
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{FB4});
                break;
            }
            case "5": {
                if (ncpList.contains(dataMap.get("tcvat_nsrxx#1#templateid"))) break;
            }
            case "8": {
                if (isNewTemplate) {
                    this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{FB5});
                    break;
                }
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{JMS});
                break;
            }
            case "6": {
                if (ncpList.contains(dataMap.get("tcvat_nsrxx#1#templateid"))) break;
            }
            case "9": {
                if (isNewTemplate) {
                    this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{JMS});
                    break;
                }
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{ASSIGN});
                break;
            }
        }
    }

    private void zzsxgmnsr(String sheetid, boolean isNewTemplate) {
        this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.FALSE, new String[]{XGMNSRZB, XGMNSRFLZL, XGMNSRFLZL2, XGMNSRMSXM});
        switch (sheetid) {
            case "0": {
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{XGMNSRZB});
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.valueOf(isNewTemplate), new String[]{FJSFYBTSE});
                break;
            }
            case "1": {
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{XGMNSRFLZL});
                break;
            }
            case "2": {
                if (isNewTemplate) {
                    this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{XGMNSRFLZL2});
                    break;
                }
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{XGMNSRMSXM});
                break;
            }
            case "3": {
                this.getView().getView(this.getPageCache().get("pageId")).setVisible(Boolean.TRUE, new String[]{XGMNSRMSXM});
                break;
            }
        }
    }

    protected String[] getTaxLimits() {
        String orgId = this.getPageCache().get(ORGID_KEY) != null ? this.getPageCache().get(ORGID_KEY) : "0";
        Map<String, Date> map = PeriodService.preTaxPeriod(orgId, new Date());
        Date startDate = map.get("startDate");
        Date endDate = map.get("endDate");
        String taxLimit = DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
        return new String[]{taxLimit};
    }

    public Map<String, String> getBizParams() {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(TAXPAYER_TYPE_KEY, this.getPageCache().get(TAXPAYER_TYPE_KEY));
        map.put("zlbid", this.getPageCache().get("zlbid"));
        map.put("registerType", this.getPageCache().get("registerType"));
        return map;
    }

    protected EngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String templateType, IPageCache pageCache) {
        pageCache.put("rulePurpose", "nssb");
        pageCache.put("draftpurpose", "nssb");
        return TaxDeclareHelper.buildEngineModel(orgId, skssqq, skssqz, templateType, pageCache, "nssb");
    }

    protected void setBtnStatus(String orgid, String startDate, String endDate, String operationStatus) {
        super.setBtnStatus(orgid, startDate, endDate, operationStatus);
        if ("edit".equals(operationStatus)) {
            String cachedTaxPayerType = this.getCachedTaxPayerType();
            String nowTaxPayerType = this.getPageCache().get("nowTaxPayerType");
            String templateType = StringUtil.isBlank((CharSequence)this.getPageCache().get(TAXPAYER_TYPE_KEY)) ? this.getTemplateType() : this.getPageCache().get(TAXPAYER_TYPE_KEY);
            Map map = this.chooseDeclareFormByDataType(orgid, templateType, startDate, endDate);
            this.getView().setVisible(Boolean.valueOf((cachedTaxPayerType == null || StringUtils.equals((CharSequence)cachedTaxPayerType, (CharSequence)nowTaxPayerType)) && StringUtils.equals((CharSequence)"1", (CharSequence)((String)map.get("datatype")))), new String[]{"recalc"});
            this.getView().setVisible(Boolean.valueOf((cachedTaxPayerType == null || StringUtils.equals((CharSequence)cachedTaxPayerType, (CharSequence)nowTaxPayerType)) && !"zzsybnsr_yz_fzjg".equals(nowTaxPayerType) && StringUtils.equals((CharSequence)"1", (CharSequence)((String)map.get("datatype")))), new String[]{"onekeygenerate"});
        }
    }

    protected boolean beforeLoadData(Date newValue) {
        String deadLine = TaxBaseDataUtils.getDeadLine((Long)Long.parseLong(this.getPageCache().get(ORGID_KEY)), (String)"zzs", (Date)newValue);
        if (StringUtils.isBlank((CharSequence)deadLine)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7a0e\u52a1\u7ec4\u7ec7\u5728\u6b64\u201c\u6240\u5c5e\u7a0e\u671f\u201d\u671f\u95f4\u5185\u672a\u542f\u7528\u589e\u503c\u7a0e\u7a0e\u79cd\u5361\u7247\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u201c\u6240\u5c5e\u7a0e\u671f\u8d77/\u6b62\u201d\u3002", (String)"TcvatDraftPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return true;
        }
        Map<String, Date> nssbDate = PeriodService.nowProvisionPeriod(newValue, deadLine);
        this.getPageCache().put("dateChanged", "true");
        this.getModel().setValue("skssqq", (Object)nssbDate.get("startDate"));
        this.getPageCache().put("dateChanged", "true");
        this.getModel().setValue("skssqz", (Object)nssbDate.get("endDate"));
        this.getPageCache().remove("dateChanged");
        return false;
    }

    protected void extendLoadData(Date startDate, Date endDate, Boolean needMsg) {
        this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"), needMsg);
    }

    protected String getUniKey(String orgId, String skssqq, String skssqz, String templateType) {
        return String.format("%1s_%2s_%3s_%4s", orgId, skssqq, skssqz, templateType);
    }
}

