/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.draft;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.vatrta.VatRtaService;
import kd.taxc.tcvat.common.dto.draft.DraftDto;
import kd.taxc.tcvat.formplugin.draft.TcvatDraftPlugin;
import org.apache.commons.lang3.ObjectUtils;

public class TcvatSjjtDraftPlugin
extends TcvatDraftPlugin {
    private static Log logger = LogFactory.getLog(TcvatSjjtDraftPlugin.class);
    private VatRtaService service = new VatRtaService();
    public static final String CHECKJTD_KEY = "checkjtd";
    public static final String DELETEJTD_KEY = "deletejtd";

    @Override
    protected String getDraftNumber(String draftpurpose, String readNumber, String draftNumberPrefix) {
        return readNumber.replaceAll("X", "VATACCURE");
    }

    @Override
    public Boolean checkDatas(Date startDate, Date endDate) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("skssqq") == null || customParams.get("skssqz") == null) {
            String cycle = PeriodService.getCycleByProvisionPlan(Collections.singletonList(Long.parseLong(this.getPageCache().get("orgid"))), startDate, endDate);
            logger.info("TcvatSjjtDraftPlugin \u5165\u53c2 " + this.getPageCache().get("orgid") + "- " + DateUtils.format((Date)startDate) + "- " + DateUtils.format((Date)endDate) + "\u8ba1\u63d0\u67e5\u8be2\u7ed3\u679c\uff1a" + cycle);
            if (StringUtils.isBlank((CharSequence)cycle)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"TcvatSjjtDraftPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            String taxpayertype = this.getPageCache().get("taxPayerType");
            if (StringUtils.isBlank((CharSequence)taxpayertype)) {
                taxpayertype = this.getTaxpayerType(this.getPageCache().get("orgid"), startDate, endDate);
            }
            if ("season".equals(cycle) && Arrays.asList("zzsybnsr_yz_zjg", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg").contains(taxpayertype)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u603b\u8ba1\u63d0\u5e95\u7a3f\u6682\u4e0d\u652f\u6301\u6309\u5b63\u8ba1\u63d0", (String)"TcvatSjjtDraftPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getModel().setValue("skssqq", null);
                this.getModel().setValue("skssqz", null);
                return Boolean.FALSE;
            }
            if ("year".equals(cycle)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u6682\u4e0d\u652f\u6301\u6309\u5e74\u8ba1\u63d0", (String)"TcvatSjjtDraftPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getModel().setValue("skssqq", null);
                this.getModel().setValue("skssqz", null);
                return Boolean.FALSE;
            }
        }
        return super.checkDatas(startDate, endDate);
    }

    @Override
    protected List<DraftDto> getDraftByCondition(Date startDate, Date endDate) {
        return this.tcvatDraftService.getAllSjjtDraftByCondition(this.getPageCache().get("orgid"), startDate, endDate);
    }

    @Override
    protected String[] getTaxLimits() {
        return new String[]{"season", "month"};
    }

    @Override
    protected boolean beforeLoadData(Date date) {
        String cycle = PeriodService.getCycleByProvisionPlan(Collections.singletonList(Long.parseLong(this.getPageCache().get("orgid"))), date, date);
        if (StringUtils.isBlank((CharSequence)cycle)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"TcvatSjjtDraftPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Map<String, Date> sjjtDate = PeriodService.nowProvisionPeriod(date, cycle);
        this.getModel().setValue("skssqq", (Object)sjjtDate.get("startDate"));
        this.getModel().setValue("skssqz", (Object)sjjtDate.get("endDate"));
        this.getPageCache().put("skssqq", DateUtils.format((Date)sjjtDate.get("startDate")));
        this.getPageCache().put("skssqz", DateUtils.format((Date)sjjtDate.get("endDate")));
        String templateType = this.getTemplateType();
        if (ObjectUtils.isNotEmpty((Object)templateType) && templateType.startsWith("orgmsg")) {
            this.getView().showErrorNotification(templateType.substring(6));
            return true;
        }
        return false;
    }

    @Override
    protected DynamicObject queryDynamicObject(String focuspage, String templateType, String orgId, String startdate, String enddate) {
        if ("1".equals(focuspage)) {
            String taxpayerType = this.getTaxpayerType(orgId, DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate));
            logger.info("sjjtdraft: taxpayertype : " + taxpayerType);
            return TcvatDraftService.queryPolicyConfirmId("sjjt", taxpayerType, templateType, orgId, startdate, enddate, this.getPageCache().get("planid"));
        }
        return null;
    }

    @Override
    protected void setButtonVisible(String focuspage) {
        super.setButtonVisible(focuspage);
        DynamicObject object = this.queryDraftBillObject(this.getTemplateType(), this.getPageCache().get("orgid"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), this.getPageCache().get("draftpurpose"));
        this.setBtnStatus(object);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateName = operate.getOperateName().getLocaleValue();
        String entityId = operate.getEntityId();
        DynamicObject object = this.queryDraftBillObject(this.getTemplateType(), this.getPageCache().get("orgid"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), this.getPageCache().get("draftpurpose"));
        switch (itemKey) {
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.setBtnStatus(object);
                break;
            }
            case "newjtd": {
                this.operateJtd(itemKey, entityId, operateName);
                break;
            }
            case "deletejtd": {
                this.operateJtd(itemKey, entityId, operateName);
                break;
            }
            case "checkjtd": {
                this.checkJtd(operateName, entityId);
            }
        }
    }

    private void setBtnStatus(DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            String billstatus = dynamicObject.getString("billstatus");
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"recalc"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"newjtd", CHECKJTD_KEY, DELETEJTD_KEY});
            }
            if ("B".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"newjtd", CHECKJTD_KEY, DELETEJTD_KEY});
                this.getView().setVisible(Boolean.FALSE, new String[]{"recalc"});
                if (dynamicObject.getString("generatebusinessdoc").equals("false")) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
                }
            }
            if ("C".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"newjtd", CHECKJTD_KEY, DELETEJTD_KEY});
                this.getView().setVisible(Boolean.FALSE, new String[]{"recalc"});
                if (dynamicObject.getString("generatebusinessdoc").equals("false")) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
                }
            }
        }
    }

    private void checkJtd(String operateName, String entityId) {
        String id = this.getPageCache().get("draftId");
        if (ObjectUtils.isNotEmpty((Object)id)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tcvat_sjjt_draft_query");
            String appId = this.getView().getFormShowParameter().getAppId();
            ListShowParameter parameter = this.service.getProvistonBillPageParameter(appId, dynamicObject.getString("org.id"), dynamicObject.getString("taxsystem.id"), dynamicObject.getString("billno"), String.join((CharSequence)",", Lists.newArrayList((Object[])new String[]{"001", "006", "019", "020"})));
            this.getView().showForm((FormShowParameter)parameter);
            String billEntity = dynamicObject.getDataEntityType().getName();
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801:%s\u67e5\u770b\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"TcvatSjjtDraftPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]), dynamicObject.getString("billno"));
            OperatorDialogUtils.operateDialog((String)"zzs", (String)billEntity, (String)operateName, (String)operateDescription);
        } else {
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801:%s\u67e5\u770b\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"TcvatSjjtDraftPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]), this.getModel().getValue("draftnumber"));
            OperatorDialogUtils.operateDialog((String)"zzs", (String)entityId, (String)operateName, (String)operateDescription);
        }
    }

    private void operateJtd(String itemKey, String entityId, String operateName) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)itemKey, (String)"tcvat_sjjt_draft_query", (Object[])new Object[]{this.getPageCache().get("draftId")}, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            this.getView().showOperationResult(operationResult);
            return;
        }
        if ("newjtd".equals(itemKey)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
        } else if (DELETEJTD_KEY.equals(itemKey)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
        }
        String msg = this.service.processJtdMsg(operationResult, entityId, operateName);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.getView().showSuccessNotification(msg);
        }
    }

    @Override
    protected boolean doCustomInAfterCreateNewData(String orgId, String skssqq, String skssqz) {
        boolean result = true;
        if ("sjjt".equals(this.getPageCache().get("draftpurpose"))) {
            Date startDate = (Date)this.getModel().getValue("skssqq");
            Date endDate = (Date)this.getModel().getValue("skssqz");
            this.getTaxpayerType(orgId, startDate, endDate);
            Boolean aBoolean = this.strategy.propertyChangedCheck(null, this.getPageCache(), this.getView());
            if (aBoolean.booleanValue()) {
                this.getModel().setValue("org", null);
            }
            result = aBoolean == false;
        }
        return result && super.doCustomInAfterCreateNewData(orgId, skssqq, skssqz);
    }
}

