/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.draft.rta;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.vatrta.VatRtaService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class VatRtaEditMultiPlugin
extends AbstractDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(VatRtaEditMultiPlugin.class);
    private static final String ID = "id";
    private static final String ORG = "org";
    private VatRtaService service = new VatRtaService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public String getSubmitMainTable() {
        return "tcvat_rta_query";
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (ORG.equals(name)) {
            long userId = RequestContext.get().getCurrUserId();
            String entityid = this.getView().getEntityId();
            String appid = this.getView().getFormShowParameter().getAppId();
            List<Long> orgList = this.service.queryYbnsrOrgIdsWithPerm(userId, appid, entityid);
            evt.getCustomQFilters().add(new QFilter(ID, "in", orgList));
        }
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        Date date = null;
        if (customParams != null) {
            date = (Date)customParams.get("date");
        }
        Map<String, Date> nssb = date == null ? PeriodService.getPreTaxPeriod("nssb", orgId, new Date()) : PeriodService.getNowTaxPeriod("nssb", orgId, date);
        Date startDate = nssb.get("startDate");
        Date endDate = DateUtils.getLastDateOfMonth2((Date)nssb.get("endDate"));
        getModel.setValue("skssqq", (Object)startDate);
        getModel.setValue("skssqz", (Object)endDate);
        getPageCache.put("skssqq", DateUtils.format((Date)startDate));
        getPageCache.put("skssqz", DateUtils.format((Date)endDate));
    }

    protected boolean checkArgsBeforeOpenInnerPage() {
        return true;
    }

    protected boolean isDefaultOrg() {
        return false;
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        return orgid != null && skssqq != null && skssqz != null;
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected String[] getTaxLimits() {
        return new String[]{"month", "season"};
    }

    public void init() {
        String id;
        if (StringUtils.isBlank((Object)this.getModel().getValue("billno")) && this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
        }
        if (StringUtils.isNotBlank((CharSequence)(id = this.getPageCache().get("cache_sbbid")))) {
            this.getModel().setValue(ID, (Object)id);
            DynamicObject vatRta = this.service.loadSingleVatRta(Long.parseLong(id));
            if (vatRta != null) {
                this.getModel().setValue("generatebusinessdoc", vatRta.get("generatebusinessdoc"));
            }
        }
    }

    protected void doAfterSuccessSave() {
        super.doAfterSuccessSave();
        String billno = (String)this.getModel().getValue("billno");
        DynamicObject dyo = this.service.queryOneVatRtaByBillno(billno);
        if (dyo != null) {
            this.getModel().setValue(ID, dyo.get(ID));
            this.getModel().setValue("generatebusinessdoc", dyo.get("generatebusinessdoc"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        FormOperate operate = (FormOperate)args.getSource();
        String entityId = operate.getEntityId();
        String operateName = operate.getOperateName().getLocaleValue();
        if ("viewjtdraft".equals(operateKey) || "viewsbb".equals(operateKey) || "viewsjjnd".equals(operateKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            if (org == null || skssqq == null || skssqz == null) {
                return;
            }
            Map<String, Object> taxPayerTypeMap = TaxDeclareHelper.getTaxPayerType(org.getString(ID), skssqq, skssqz);
            String taxpayertype = (String)taxPayerTypeMap.get("taxpayertype");
            if (StringUtils.isNotBlank((CharSequence)taxpayertype)) {
                if ("viewjtdraft".equals(operateKey)) {
                    String templatetype = "draft_" + taxpayertype + "_sjjt";
                    List<Long> ids = this.service.querySjjtDraftIds(org.getLong(ID), templatetype, skssqq, skssqz);
                    HashMap<String, Object> cusMap = new HashMap<String, Object>();
                    cusMap.put("draftpurpose", "sjjt");
                    cusMap.put("templatetype", templatetype);
                    this.showJointSearch("tcvat_sjjt_draft_query", ids, cusMap);
                    OperatorDialogUtils.operateDialog((String)"VAT_RTA", (String)entityId, (String)operateName, (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u67e5\u770b\u8ba1\u63d0\u5e95\u7a3f\u6210\u529f", (String)"VatRtaEditMultiPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]), this.getPageCache().get("billno")));
                } else if ("viewsbb".equals(operateKey)) {
                    List<Long> ids = this.service.querySbbIds(org.getLong(ID), taxpayertype, skssqq, skssqz);
                    this.showJointSearch("tcvat_zzs_declare_list", ids, Collections.emptyMap());
                    OperatorDialogUtils.operateDialog((String)"VAT_RTA", (String)entityId, (String)operateName, (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u67e5\u770b\u7533\u62a5\u8868\u6210\u529f", (String)"VatRtaEditMultiPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]), this.getPageCache().get("billno")));
                } else {
                    List<Long> ids = this.service.queryPayRecordIds(org.getLong(ID), taxpayertype, skssqq, skssqz);
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    customParams.put("menu", "pay");
                    this.showJointSearch("bdtaxr_pay_record", ids, customParams);
                    OperatorDialogUtils.operateDialog((String)"VAT_RTA", (String)entityId, (String)operateName, (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u67e5\u770b\u7a0e\u91d1\u7f34\u7eb3\u5355\u6210\u529f", (String)"VatRtaEditMultiPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]), this.getPageCache().get("billno")));
                }
            }
        } else if ("viewflowchart".equals(operateKey)) {
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            try {
                WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)this.getModel().getValue(ID), (OpenStyle)openStyle);
                OperatorDialogUtils.operateDialog((String)"VAT_RTA", (String)entityId, (String)operateName, (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u67e5\u770b\u6d41\u7a0b\u56fe\u6210\u529f", (String)"VatRtaEditMultiPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]), this.getPageCache().get("billno")));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"VatRtaEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        } else if ("newjtd".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)args.getOperateKey(), (String)"tcvat_rta_query", (Object[])new Object[]{this.getModel().getValue(ID)}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                this.getView().showOperationResult(operationResult);
                return;
            }
            String msg = this.service.processJtdMsg(operationResult, entityId, operateName);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showSuccessNotification(msg);
            }
            this.getModel().setValue("generatebusinessdoc", (Object)true);
        } else if ("deletejtd".equals(operateKey) && args.getOperationResult().isSuccess()) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)args.getOperateKey(), (String)"tcvat_rta_query", (Object[])new Object[]{this.getModel().getValue(ID)}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                this.getView().showOperationResult(operationResult);
                return;
            }
            String msg = this.service.processJtdMsg(operationResult, entityId, operateName);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showSuccessNotification(msg);
            }
            this.getModel().setValue("generatebusinessdoc", (Object)false);
        } else if (StringUtil.equals((CharSequence)operateKey, (CharSequence)"checkjtd") && args.getOperationResult().isSuccess()) {
            Object id = this.getModel().getValue(ID);
            if (ObjectUtils.isNotEmpty((Object)id)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tcvat_rta_query");
                String appId = this.getView().getFormShowParameter().getAppId();
                ListShowParameter parameter = this.service.getProvistonBillPageParameter(appId, dynamicObject.getString("org.id"), dynamicObject.getString("taxsystem.id"), dynamicObject.getString("billno"), dynamicObject.getString("taxtype.number"));
                this.getView().showForm((FormShowParameter)parameter);
                String billEntity = dynamicObject.getDataEntityType().getName();
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801:%s\u67e5\u770b\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"VatRtaEditMultiPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), this.getModel().getValue("billno"));
                OperatorDialogUtils.operateDialog((String)"zzs", (String)billEntity, (String)operateName, (String)operateDescription);
            } else {
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801:%s\u67e5\u770b\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"VatRtaEditMultiPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]), this.getModel().getValue("billno"));
                OperatorDialogUtils.operateDialog((String)"zzs", (String)entityId, (String)operateName, (String)operateDescription);
            }
        } else {
            super.afterDoOperation(args);
        }
    }

    private void showJointSearch(String entityName, List<Long> linkQueryPkIds, Map<String, Object> customParams) {
        if (CollectionUtils.isNotEmpty(linkQueryPkIds)) {
            this.getView().showForm((FormShowParameter)this.service.getJointSearchParameter(entityName, linkQueryPkIds, customParams));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u6570\u636e\u3002", (String)"VatRtaListPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (null == org) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"VatRtaEditMultiPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (e.getProperty().getName().equals(ORG)) {
            if (this.getModel().getDataEntity().getDate("skssqq") == null || this.getModel().getDataEntity().getDate("skssqz") == null) {
                this.getPageCache().put("orgid", this.getModel().getDataEntity().getString("org.id"));
                return;
            }
            Object object = changeData[0].getNewValue();
            String orgid = StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue() ? ((DynamicObject)changeData[0].getOldValue()).get(ID).toString() : org.getString(ID);
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
            if (checkResult) {
                this.getModel().beginInit();
                this.getModel().setValue(ORG, null);
                this.getModel().endInit();
                this.getView().updateView(ORG);
                return;
            }
            orgid = org.getString(ID);
            this.getPageCache().put("orgid", orgid);
            DynamicObject oldValueObj = (DynamicObject)changeData[0].getOldValue();
            this.getPageCache().put("oldorgid", null == oldValueObj ? null : oldValueObj.getString(ID));
            this.getModel().setValue(ID, null);
            this.getModel().setValue("generatebusinessdoc", (Object)false);
            this.getModel().setValue("billstatus", (Object)"A");
            this.initPeriod(this.getModel(), this.getPageCache(), orgid, null);
            if (this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
                this.getPageCache().remove("billno");
                this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.FALSE);
                this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
            }
        }
        if (e.getProperty().getName().equals("skssqq") || e.getProperty().getName().equals("skssqz")) {
            this.propertyChangedSq(e.getProperty().getName(), org.getString(ID));
        }
        this.init();
    }

    private void propertyChangedSq(String propertyName, String orgId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("date", this.getModel().getValue(propertyName));
        this.initPeriod(this.getModel(), this.getPageCache(), orgId, customParams);
        if (this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
            this.getPageCache().remove("billno");
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.FALSE);
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
        }
    }

    private void getDraftNumber(String sksqq, String sksqz) {
        String billno = this.getBillNumber(sksqq, sksqz);
        this.getModel().setValue("billno", (Object)billno);
        this.getModel().setDataChanged(false);
        this.getPageCache().put("billno", billno);
    }

    public String getTaxType() {
        return null;
    }

    public String getTemplateType() {
        return "VAT_RTA";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParamsMap = new HashMap<String, String>(1);
        this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
        return bizParamsMap;
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Map<String, Object> taxPayerTypeMap = TaxDeclareHelper.getTaxPayerType(org.getString(ID), (Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"));
        String taxPayerType = (String)taxPayerTypeMap.get("taxpayertype");
        extendParams.put("taxPayerType", taxPayerType);
        requestModel.setExtendParams(extendParams);
        return requestModel;
    }

    protected Long getCustomOrg(Map<String, Object> customParams) {
        ListView pView;
        List orgFilter;
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        Long orgId = RequestContext.get().getOrgId();
        if (parentView instanceof ListView && CollectionUtils.isNotEmpty((Collection)(orgFilter = (pView = (ListView)parentView).getControlFilters().getFilter("org.id"))) && StringUtils.isNotBlank((CharSequence)((String)orgFilter.get(0)))) {
            orgId = Long.valueOf((String)orgFilter.get(0));
        }
        long userId = RequestContext.get().getCurrUserId();
        String entityid = view.getEntityId();
        String appid = view.getFormShowParameter().getAppId();
        List<Long> orgList = this.service.queryYbnsrOrgIdsWithPerm(userId, appid, entityid);
        if (CollectionUtils.isNotEmpty(orgList)) {
            if (orgList.contains(orgId)) {
                this.getPageCache().put("orgid", orgId.toString());
                return orgId;
            }
            return orgList.get(0);
        }
        return null;
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String billno = customParams.get("billno") == null ? null : customParams.get("billno").toString();
        this.getModel().setValue("billno", (Object)billno);
        this.getPageCache().put("billno", billno);
        return customParams;
    }

    protected QFilter getDeclareMainQueryParams() {
        return null;
    }

    protected String getUniKey() {
        logger.info("getUniKey");
        String orgId = this.getPageCache().get("orgid");
        String skssq = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String skssz = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        return String.format("%1s_%2s_%3s_%4s", orgId, skssq, skssz, this.getTemplateType());
    }

    protected void setExtendsControlsByBillstatus(String billstatus) {
        if (StringUtils.isNotBlank((CharSequence)billstatus)) {
            this.getView().setVisible(Boolean.valueOf("C".equals(billstatus)), new String[]{"newjtd"});
            this.getModel().setValue("billstatus", (Object)billstatus);
        }
    }

    protected boolean viewDialog() {
        return false;
    }

    private String getBillNumber(String skssqq, String skssqz) {
        DynamicObject dynamicObject = this.checkRecordIsExist(MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), this.getPageCache().get("orgid"), this.getTemplateType(), skssqq, skssqz);
        if (dynamicObject == null) {
            return this.createNumber();
        }
        return dynamicObject.getString("billno");
    }

    private String createNumber() {
        String billno = this.getPageCache().get("billno");
        if (StringUtils.isNotBlank((CharSequence)billno)) {
            return billno;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        if (org == null || skssqq == null || skssqz == null) {
            return null;
        }
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_rta_query");
        object.set(ORG, (Object)org);
        object.set("skssqq", (Object)skssqq);
        object.set("skssqz", (Object)skssqz);
        return DeclareServiceHelper.generateSBBNo((String)"tcvat_rta_query", (DynamicObject)object, (String)org.getString(ID));
    }

    private DynamicObject checkRecordIsExist(String maintable, String orgid, String type, String startDate, String endDate) {
        if (ObjectUtils.anyNull((Object[])new Object[]{maintable, orgid, type, startDate, endDate})) {
            return null;
        }
        return YbnsrService.queryMultiDeclareMain((String)maintable, (long)Long.parseLong(orgid), (String)type, (String)startDate, (String)endDate, (QFilter)this.getDeclareMainQueryParams());
    }
}

