/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.identification;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportList;
import kd.taxc.bdtaxr.common.adapter.ReportListAdapter;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.identification.InvoiceIdentificationService;
import kd.taxc.tcvat.formplugin.identification.abstraction.AbstractInvoiceIdentification;
import org.apache.commons.lang3.ObjectUtils;

public class InputInvoiceIdentificationReportPlugin
extends AbstractInvoiceIdentification
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(InputInvoiceIdentificationReportPlugin.class);
    public static final String BUTTON_REFRESH = "refresh";
    private static final String BUTTON_UNSIGN_KEY = "undosign";
    private static final String BUTTON_SIGN_KEY = "sign";
    private static final String FIELD_SEPARATER = ",";
    private static final String INPUT_INVOICE_SING_FORM_ID = "tcvat_invoice_sign_dialog";

    public void registerListener(EventObject e) {
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        customMap.put("customCaption", ResManager.loadKDString((String)"\u8fdb\u9879\u6807\u8bc6\u660e\u7ec6\u5217\u8868", (String)"InputInvoiceIdentificationReportPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        this.hyperLinkClick(hyperLinkClickEvent, "tcvat_input_sign_list", (IFormView)this.getView(), (IFormPlugin)this);
    }

    private void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent, String pageName, IFormView getView, IFormPlugin plugin) {
        DynamicObject type = hyperLinkClickEvent.getRowData();
        Map customMap = getView.getFormShowParameter().getCustomParams();
        ArrayList<String> invoicePkIdList = new ArrayList<String>();
        if (pageName.equals("tcvat_input_sign_list")) {
            invoicePkIdList.add(type.get("invoicecode") + type.getString("invoiceno"));
        } else {
            invoicePkIdList.add(type.getString("id"));
        }
        customMap.put("invoicePkIdList", invoicePkIdList);
        customMap.put("source", "signdetail");
        if ("count".equals(type.getString("type"))) {
            getView.showTipNotification(ResManager.loadKDString((String)"\u5408\u8ba1\u5217\u7684\u6570\u503c\u4e0d\u53ef\u4ee5\u70b9\u51fb\u4e0b\u94bb", (String)"InputInvoiceIdentificationReportPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)pageName, (IFormView)getView, (Map)customMap, (IFormPlugin)plugin);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_REFRESH)) {
            ReportList reportlist = (ReportList)this.getControl("reportlistap");
            reportlist.refresh();
            reportlist.clearEntryState();
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"selectall")) {
            ReportList reportlist = (ReportList)this.getControl("reportlistap");
            int size = reportlist.getReportModel().getRowCount();
            if (size <= 0) {
                return;
            }
            reportlist.selectRows(IntStream.rangeClosed(1, size).toArray(), 1);
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"cancelall")) {
            ReportList reportlist = (ReportList)this.getControl("reportlistap");
            reportlist.clearEntryState();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ReportList reportlist;
        DynamicObjectCollection rowCollection;
        boolean hasEmptyOrg;
        if (args.getSource() instanceof Donothing && BUTTON_SIGN_KEY.equals(((Donothing)args.getSource()).getOperateKey()) && (hasEmptyOrg = (rowCollection = ReportListAdapter.getSelectedRow((ReportList)(reportlist = (ReportList)this.getView().getControl("reportlistap")))).stream().anyMatch(e -> ObjectUtils.isEmpty((Object)e.get("org"))))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6807\u8bc6\u5931\u8d25\uff0c\u9009\u4e2d\u53d1\u7968\u4e2d\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53d1\u7968\u3002", (String)"InputInvoiceIdentificationReportPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        logger.info("satrt InputInvoiceIdentificationReportPlugin afterDoOperation");
        long start = System.currentTimeMillis();
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"autosign")) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("selected_org", this.getView().getPageCache().get("orgs"));
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_invoice_auto_sign", (IFormView)this.getView(), params, (IFormPlugin)this);
        } else {
            this.doOperation(afterDoOperationEventArgs, "tcvat_input_sign_list", (IFormView)this.getView(), this.getPageCache(), (IFormPlugin)this);
        }
        logger.info("end InputInvoiceIdentificationReportPlugin afterDoOperation\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
    }

    private void doOperation(AfterDoOperationEventArgs afterDoOperationEventArgs, String pageName, IFormView getView, IPageCache getPageCache, IFormPlugin plugin) {
        logger.info("satrt InputInvoiceIdentificationReportPlugin doOperation");
        long start = System.currentTimeMillis();
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        ReportList reportlist = (ReportList)getView.getControl("reportlistap");
        DynamicObjectCollection rowCollection = ReportListAdapter.getSelectedRow((ReportList)reportlist);
        IReportListModel model = reportlist.getReportModel();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_SIGN_KEY)) {
            if (rowCollection.size() == 0) {
                getView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6807\u8bc6\u7684\u6570\u636e\u884c", (String)"InputInvoiceIdentificationReportPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (null != model) {
                String currentTaxPeriod = DateUtils.format((Date)new Date(), (String)"yyyy-MM");
                HashMap<String, DynamicObjectCollection> dataMap = new HashMap<String, DynamicObjectCollection>();
                HashMap<String, String> orgMap = new HashMap<String, String>(rowCollection.size());
                HashMap<String, String> taxPeriodMap = new HashMap<String, String>(16);
                taxPeriodMap.put("currentTaxPeriod", currentTaxPeriod);
                DynamicObjectCollection declareDataCollection = InvoiceIdentificationService.queryZzsSbb(rowCollection, model, pageName, taxPeriodMap, dataMap, orgMap);
                currentTaxPeriod = (String)taxPeriodMap.get("currentTaxPeriod");
                if (declareDataCollection.size() > 0) {
                    for (DynamicObject declareData : declareDataCollection) {
                        String orgid = declareData.getString("org");
                        if (declareDataCollection.size() == 1) {
                            if (!StringUtils.equals((CharSequence)"declared", (CharSequence)declareData.getString("declarestatus"))) continue;
                            getView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6240\u5c5e\u671f\u201c%2$s\u201d\u7684\u589e\u503c\u7a0e\u5df2\u7533\u62a5\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8fdb\u9879\u6807\u8bc6", (String)"InputInvoiceIdentificationReportPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]), orgMap.get(orgid), currentTaxPeriod));
                            return;
                        }
                        if (declareDataCollection.size() <= 1 || !StringUtils.equals((CharSequence)"declared", (CharSequence)declareData.getString("declarestatus"))) continue;
                        getView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6240\u5c5e\u671f\u201c%2$s\u201d\u7684\u589e\u503c\u7a0e\u5df2\u7533\u62a5\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8fdb\u9879\u6807\u8bc6", (String)"InputInvoiceIdentificationReportPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]), orgMap.get(orgid), currentTaxPeriod));
                        dataMap.remove(orgid + FIELD_SEPARATER + currentTaxPeriod);
                    }
                }
                String subPageName = INPUT_INVOICE_SING_FORM_ID;
                if ("tcvat_rollout_sign_list".equals(pageName)) {
                    subPageName = "tcvat_rollout_query_frame";
                }
                Map<String, Object> customParams = InvoiceIdentificationService.buildCustomParams(pageName, dataMap, currentTaxPeriod);
                String operateName = ResManager.loadKDString((String)"\u8fdb\u9879\u6807\u8bc6", (String)"InputInvoiceIdentificationReportPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]);
                String operateDescription = ResManager.loadKDString((String)"\u8fdb\u9879\u53d1\u7968\u6807\u8bc6\u5f39\u7a97\u6253\u5f00\u6210\u529f", (String)"InputInvoiceIdentificationReportPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]);
                OperatorDialogUtils.operateDialog((String)"zzs", (String)"tcvat_invoice_identity", (String)operateName, (String)operateDescription);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)subPageName, (IFormView)getView, customParams, (IFormPlugin)plugin);
            }
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BUTTON_UNSIGN_KEY) && null != model && model.getRowCount() > 0) {
            if (rowCollection.size() == 0) {
                getView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6807\u8bc6\u7684\u6570\u636e\u884c", (String)"InputInvoiceIdentificationReportPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Map<String, Object> customParams = InvoiceIdentificationService.undosign(rowCollection, pageName);
            String operateName = ResManager.loadKDString((String)"\u53d6\u6d88\u6807\u8bc6", (String)"InputInvoiceIdentificationReportPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u53d6\u6d88\u660e\u7ec6\u5f39\u7a97\u6253\u5f00\u6210\u529f", (String)"InputInvoiceIdentificationReportPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]);
            OperatorDialogUtils.operateDialog((String)"zzs", (String)"tcvat_invoice_identity", (String)operateName, (String)operateDescription);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)pageName, (IFormView)getView, customParams, (IFormPlugin)plugin);
        }
        logger.info("end InputInvoiceIdentificationReportPlugin doOperation\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
    }
}

