/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.identification.abstraction;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;

public class AbstractInvoiceSign
extends AbstractFormPlugin {
    private static final String SIGN_THREE_KEY = "sign3";
    private static final String SIGN_RATE_KEY = "signrate";
    private static final String BTN_OK = "btnok";
    private static final String CURRENT_AMOUNT = "currentsigntaxamount";
    private static final String SIGN_RULE_RADIO_GROUP_KEY = "ruleradio";
    private static final String RULE_1 = "1";
    private static final String RULE_2 = "2";
    private static final String RULE_3 = "3";
    private static final String AVALIABLE_AMOUNT = "avaliabletaxamount";
    private static final String CACHE_KEY = "input_sign";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        for (Map.Entry entry : customParams.entrySet()) {
            String key = (String)entry.getKey();
            if ("rowSize".equals(key) || "valueMap".equals(key)) continue;
            Object value = entry.getValue();
            this.getModel().setValue(key, value);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{CURRENT_AMOUNT});
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String radioKey = (String)model.getValue(SIGN_RULE_RADIO_GROUP_KEY);
        BigDecimal percent = (BigDecimal)model.getValue(SIGN_RATE_KEY);
        this.initForRadio(model, view, radioKey, percent);
        this.getPageCache().put("input_signrowSize", String.valueOf(customParams.get("rowSize")));
        this.getPageCache().put("input_signvalueMap", (String)customParams.get("valueMap"));
        customParams.remove("rowSize");
        customParams.remove("valueMap");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (SIGN_RULE_RADIO_GROUP_KEY.equals(name) || SIGN_RATE_KEY.equals(name)) {
            String radiogroupfield = (String)model.getValue(SIGN_RULE_RADIO_GROUP_KEY);
            BigDecimal percent = (BigDecimal)model.getValue(SIGN_RATE_KEY);
            this.initForRadio(model, view, radiogroupfield, percent);
        }
    }

    private void initForRadio(IDataModel model, IFormView view, String radioKey, BigDecimal percent) {
        BigDecimal param = (BigDecimal)model.getValue(AVALIABLE_AMOUNT);
        Integer count = (Integer)this.getView().getFormShowParameter().getCustomParams().get("rowSize");
        if (null == count) {
            count = 1;
        }
        if (count > 1) {
            view.setEnable(Boolean.FALSE, new String[]{SIGN_THREE_KEY});
        }
        if (RULE_1.equals(radioKey)) {
            model.setValue(CURRENT_AMOUNT, (Object)param);
            view.setEnable(Boolean.FALSE, new String[]{CURRENT_AMOUNT});
            view.setEnable(Boolean.FALSE, new String[]{SIGN_RATE_KEY});
        } else if (RULE_2.equals(radioKey)) {
            BigDecimal val = percent.multiply(param).divide(new BigDecimal("100"));
            model.setValue(CURRENT_AMOUNT, (Object)val);
            view.setEnable(Boolean.FALSE, new String[]{CURRENT_AMOUNT});
            view.setEnable(Boolean.TRUE, new String[]{SIGN_RATE_KEY});
        } else if (RULE_3.equals(radioKey)) {
            model.setValue(CURRENT_AMOUNT, (Object)"");
            model.setValue(SIGN_RATE_KEY, (Object)"");
            view.setEnable(Boolean.TRUE, new String[]{CURRENT_AMOUNT});
            view.setEnable(Boolean.FALSE, new String[]{SIGN_RATE_KEY});
        }
    }
}

