/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.identification.output.jzjtproduct;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcvat.business.service.identification.output.jzjtproduct.JzjtProductEditService;

public class JzjtProductEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private JzjtProductEditService jzjtProductEditService = new JzjtProductEditService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("jzjtproject");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit textEdit = (TextEdit)this.getControl("number");
        textEdit.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateEdit endDateEdit = (DateEdit)this.getView().getControl("enddate");
        endDateEdit.setMinDate((Date)this.getModel().getValue("startdate"));
        DynamicObject jzjtproject = (DynamicObject)this.getModel().getValue("jzjtproject");
        if (null == jzjtproject) {
            return;
        }
        if ("jmxmmc_jzjt_3".equals(jzjtproject.getString("number"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
        }
        if ("jmxmmc_jzjt_1".equals(jzjtproject.getString("number"))) {
            FieldEdit productclassify = (FieldEdit)this.getControl("productclassify");
            productclassify.setMustInput(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        if (null == org) {
            return;
        }
        Long orgid = this.checkOrgid(org.getLong("id"));
        this.getModel().setValue("orgid", (Object)orgid);
        this.setDefaultJzjtProjectAndDate(org.getLong("id"));
    }

    void setDefaultJzjtProjectAndDate(Long orgid) {
        DynamicObjectCollection queryFillingJmxmCollection = this.jzjtProductEditService.queryJzjtProject(orgid);
        List jmxmmcidList = queryFillingJmxmCollection.stream().map(q -> q.getLong("jmxmmc")).distinct().collect(Collectors.toList());
        if (jmxmmcidList.size() == 1) {
            DynamicObject fillingObject = (DynamicObject)queryFillingJmxmCollection.get(0);
            this.getModel().setValue("jzjtproject", (Object)fillingObject.getLong("jmxmmc"));
            DateEdit startDateEdit = (DateEdit)this.getView().getControl("startdate");
            startDateEdit.setMinDate(fillingObject.getDate("bayxqq"));
            this.getModel().setValue("enddate", (Object)fillingObject.getDate("bayxqz"));
            DateEdit endDateEdit = (DateEdit)this.getView().getControl("enddate");
            endDateEdit.setMaxDate(fillingObject.getDate("bayxqz"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject jzjtproject;
        String name = e.getProperty().getName();
        if ("orgid".equals(name)) {
            Long orgid = ((DynamicObject)e.getChangeSet()[0].getOldValue()).getLong("id");
            if (null == (orgid = this.checkOrgid(orgid))) {
                this.getModel().setValue("orgid", null);
                return;
            }
            this.setDefaultJzjtProjectAndDate(orgid);
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        if (this.checkDateIsNull(org, name)) {
            return;
        }
        if (("number".equals(name) || "name".equals(name)) && Objects.isNull(jzjtproject = (DynamicObject)this.getModel().getValue("jzjtproject"))) {
            this.getModel().setValue(name, null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5373\u5f81\u5373\u9000\u9879\u76ee\u201d\u3002", (String)"JzjtProductEditPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if ("jzjtproject".equals(name)) {
            if (this.checkDateIsNull(org, null)) {
                return;
            }
            jzjtproject = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.getModel().setValue("number", null);
            this.getModel().setValue("name", null);
            if (Objects.isNull(jzjtproject)) {
                return;
            }
            FieldEdit productclassify = (FieldEdit)this.getControl("productclassify");
            if ("jmxmmc_jzjt_1".equals(jzjtproject.getString("number"))) {
                productclassify.setMustInput(true);
            } else {
                productclassify.setMustInput(false);
            }
            if ("jmxmmc_jzjt_3".equals(jzjtproject.getString("number"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"name"});
            }
            DynamicObjectCollection fillingCollection = this.jzjtProductEditService.queryJzjtProject(org.getLong("id"), jzjtproject.getLong("id"));
            if (!CollectionUtils.isEmpty((Collection)fillingCollection)) {
                DynamicObject fillingObject = (DynamicObject)fillingCollection.get(0);
                this.getModel().setValue("startdate", (Object)fillingObject.getDate("bayxqq"));
                DateEdit startDateEdit = (DateEdit)this.getView().getControl("startdate");
                startDateEdit.setMinDate(fillingObject.getDate("bayxqq"));
                this.getModel().setValue("enddate", (Object)fillingObject.getDate("bayxqz"));
                DateEdit endDateEdit = (DateEdit)this.getView().getControl("enddate");
                endDateEdit.setMaxDate(fillingObject.getDate("bayxqz"));
            }
        }
    }

    private Long checkOrgid(Long orgid) {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (String)"tcvat", (String)this.getView().getEntityId(), (String)"47150e89000000ac");
        if (taxResult.isSuccess()) {
            List data = (List)taxResult.getData();
            if (data.contains(orgid)) {
                return orgid;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6240\u9009\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u662f\u5426\u662f\u5df2\u5ba1\u6838\u7684\u53ef\u7528\u7eb3\u7a0e\u4e3b\u4f53\u3002", (String)"JzjtProductEditPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            return null;
        }
        this.getView().showErrorNotification(taxResult.getMessage());
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (name.equals("jzjtproject")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
            if (this.checkDateIsNull(org, null)) {
                event.setCancel(true);
                return;
            }
            DynamicObjectCollection queryFillingJmxmCollection = this.jzjtProductEditService.queryJzjtProject(org.getLong("id"));
            List jmxmmcidList = queryFillingJmxmCollection.stream().map(q -> q.getLong("jmxmmc")).distinct().collect(Collectors.toList());
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", jmxmmcidList));
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u9879\u76ee", (String)"JzjtProductEditPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)"number", (CharSequence)key)) {
            DynamicObject jzjtproject = (DynamicObject)this.getModel().getValue("jzjtproject");
            if (Objects.isNull(jzjtproject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5373\u5f81\u5373\u9000\u9879\u76ee\u201d\u3002", (String)"JzjtProductEditPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            List<Long> idList = this.jzjtProductEditService.getBizdefLeafNodeIds(jzjtproject);
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tpo_tcvat_bizdef_entity", (boolean)false);
            parameter.getListFilterParameter().setFilter(new QFilter("id", "in", idList).and(new QFilter("status", "=", (Object)"1")));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "number"));
            parameter.setCaption(ResManager.loadKDString((String)"\u8d44\u6e90\u7efc\u5408\u5229\u7528\u4ea7\u54c1\u53ca\u52b3\u52a1\u76ee\u5f55", (String)"JzjtProductEditPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)parameter);
        }
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)"number", (CharSequence)key) && returnData != null) {
            ListSelectedRow row = ((ListSelectedRowCollection)returnData).get(0);
            this.getModel().setValue("number", (Object)row.getNumber());
            this.getModel().setValue("name", (Object)row.getName());
        }
        super.closedCallBack(evt);
    }

    private boolean checkDateIsNull(DynamicObject orgid, String name) {
        if (null == orgid) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"JzjtProductEditPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return true;
        }
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (EmptyCheckUtils.isAnyEmpty((Object[])new Object[]{startdate, enddate})) {
            if (StringUtils.isBlank((CharSequence)this.getPageCache().get("JzjtDateChanged"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u6709\u6548\u671f\u8d77/\u6b62\u201d\u3002", (String)"JzjtProductEditPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            } else {
                this.getPageCache().remove("JzjtDateChanged");
            }
            return true;
        }
        if (((Date)startdate).after((Date)enddate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6709\u6548\u671f\u8d77\u201d\u9700\u5c0f\u4e8e\u201c\u6709\u6548\u671f\u6b62\u201d\u3002", (String)"JzjtProductEditPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]));
            if (name != null) {
                this.getPageCache().put("JzjtDateChanged", "true");
                this.getModel().setValue(name, null);
            }
            return true;
        }
        return false;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map data = e.getSourceData();
        Map jzjtProjectMap = (Map)data.get("jzjtproject");
        String jzjtProjectNumber = (String)jzjtProjectMap.get("number");
        DynamicObject jzjtProject = QueryServiceHelper.queryOne((String)"tpo_tcvat_bizdef_entity", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)jzjtProjectNumber)});
        if (null != jzjtProject) {
            jzjtProjectMap.put("id", jzjtProject.getLong("id"));
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        String name;
        String number;
        DynamicObject productObject;
        String val;
        DynamicObject jzjtproject = (DynamicObject)this.getModel().getValue("jzjtproject");
        if (null == jzjtproject) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"JzjtProductEditPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("jmxmmc_jzjt_1".equals(jzjtproject.getString("number")) && (val = (String)this.getModel().getValue("productclassify")) == null) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u4ea7\u54c1\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"JzjtProductEditPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("jmxmmc_jzjt_3".equals(jzjtproject.getString("number")) && (productObject = QueryServiceHelper.queryOne((String)"tpo_tcvat_bizdef_entity", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(number = (String)this.getModel().getValue("number"))), new QFilter("value", "=", (Object)(name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue()))})) == null) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u8d44\u6e90\u7efc\u5408\u5229\u7528\u4ea7\u54c1\u53ca\u52b3\u52a1\u76ee\u5f55\u4e0d\u5b58\u5728\u8be5\u4ea7\u54c1\u7f16\u7801\u548c\u4ea7\u54c1\u540d\u79f0\u3002", (String)"JzjtProductEditPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }
}

