/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.jzjt;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.tcvat.business.service.jzjt.JzjtService;

public class TcvatSbbSelectPlugin
extends AbstractFormPlugin {
    private JzjtService jzjtService = new JzjtService();

    public void initialize() {
        super.initialize();
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("orgId");
        if (orgId != null) {
            long org = Long.parseLong(orgId);
            QFilter orgFilter = new QFilter("org", "=", (Object)org);
            QFilter templatetypeFilter = new QFilter("type", "=", (Object)"zzsybnsr");
            QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
            BillList billList = (BillList)this.getControl("billlistap");
            FilterParameter filterParameter = billList.getFilterParameter();
            filterParameter.getQFilters().add(orgFilter);
            filterParameter.getQFilters().add(templatetypeFilter);
            filterParameter.getQFilters().add(billstatusFilter);
            billList.addPackageDataListener(evt -> {
                DynamicObject data = evt.getRowData();
                AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
                String type = data.getString("type");
                if ("type".equals(columnDesc.getKey())) {
                    evt.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""));
                }
            });
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        if ("btok".equals(source.getKey())) {
            BillList list = (BillList)this.getControl("billlistap");
            Object[] primaryKeyValues = list.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeyValues.length > 0) {
                String pkId = (String)this.getView().getFormShowParameter().getCustomParams().get("pkId");
                DynamicObject exists = this.jzjtService.queryOneTsjsDraftBySbbId((Long)primaryKeyValues[0]);
                if (exists != null && !exists.getString("id").equals(pkId)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u8be5\u589e\u503c\u7a0e\u7533\u62a5\u8868\u5df2\u88ab\u7f16\u53f7\u4e3a%s\u7684\u9000\u7a0e\u8ba1\u7b97\u5e95\u7a3f\u5f15\u7528", (String)"TcvatSbbSelectPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), exists.getString("billno")));
                    return;
                }
                this.getView().returnDataToParent(primaryKeyValues[0]);
            }
            this.getView().close();
        }
    }
}

