/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.jzjt;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclarePageOpenHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.tcvat.business.service.jzjt.JzjtService;
import org.apache.commons.collections4.CollectionUtils;

public class TsjsDraftEditMultiPlugin
extends AbstractDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(TsjsDraftEditMultiPlugin.class);
    private static final String VIEW_SBB = "viewsbb";
    private static final String AUDIT_KEY = "audit";
    private static final String ID = "id";
    private static final String ORG = "org";
    private static final String ZZSSBB = "zzssbb";
    private static final String SBBID = "sbbid";
    private JzjtService jzjtService = new JzjtService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ZZSSBB});
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"edit", "recalc", "save", "cancel", "submit", AUDIT_KEY});
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((TextEdit)evt.getSource()).getKey();
        if (ZZSSBB.equals(key)) {
            if (this.getModel().getValue(ORG) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7a0e\u52a1\u7ec4\u7ec7", (String)"TsjsDraftEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("tcvat_sbb_select");
            parameter.getOpenStyle().setShowType(ShowType.NonModal);
            parameter.setCustomParam("orgId", (Object)this.getPageCache().get("orgid"));
            parameter.setCustomParam("pkId", (Object)this.getPageCache().get("cache_sbbid"));
            CloseCallBack sbbSelect = new CloseCallBack((IFormPlugin)this, "sbbSelect");
            parameter.setCloseCallBack(sbbSelect);
            this.getView().showForm(parameter);
        }
    }

    public String getSubmitMainTable() {
        return "tcvat_tsjs_draft_query";
    }

    protected void beforeLoadFromHyperLinkClick(Map<String, Object> customParams) {
        super.beforeLoadFromHyperLinkClick(customParams);
        Object sbbid = customParams.get(SBBID);
        if (sbbid != null) {
            DynamicObject sbb = YbnsrService.queryYbnsr((String)sbbid.toString());
            if (sbb != null) {
                this.getModel().setValue(ZZSSBB, sbb.get("billno"));
            }
            this.getModel().setValue(SBBID, sbbid);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (ORG.equals(name)) {
            long userId = RequestContext.get().getCurrUserId();
            String entityid = this.getView().getEntityId();
            String appid = this.getView().getFormShowParameter().getAppId();
            List<Long> orgList = this.jzjtService.queryYbnsrJzjtFilingTaxMainOrgIdsWithPerm(userId, appid, entityid);
            evt.getCustomQFilters().add(new QFilter(ID, "in", orgList));
        }
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
    }

    protected boolean checkArgsBeforeOpenInnerPage() {
        return true;
    }

    protected boolean isDefaultOrg() {
        return false;
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        return orgid != null && skssqq != null && skssqz != null;
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected String[] getTaxLimits() {
        return new String[]{"month", "season"};
    }

    public void init() {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String key = args.getOperateKey();
        if (VIEW_SBB.equals(key)) {
            if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
                Long sbbid = (Long)this.getModel().getValue(SBBID);
                if (sbbid == null || sbbid == 0L || YbnsrService.queryYbnsr((String)sbbid.toString()) == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u67e5\u770b\u7684\u7533\u62a5\u8868\u3002", (String)"TsjsDraftEditMultiPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                DeclarePageOpenHelper.linkDeclarePageByPkId((IFormView)this.getView(), (Object)sbbid);
            }
        } else {
            super.afterDoOperation(args);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Long sbbId;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("sbbSelect".equals(actionId) && (sbbId = (Long)evt.getReturnData()) != null) {
            this.getModel().setValue(SBBID, (Object)sbbId);
            this.getPageCache().put(SBBID, sbbId.toString());
            DynamicObject sbb = YbnsrService.queryYbnsr((String)sbbId.toString());
            this.getModel().setValue(ZZSSBB, sbb.get("billno"));
            this.getModel().setValue("skssqq", sbb.get("skssqq"));
            this.getModel().setValue("skssqz", sbb.get("skssqz"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (null == org) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"TsjsDraftEditMultiPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (e.getProperty().getName().equals(ORG)) {
            if (this.getModel().getDataEntity().getDate("skssqq") == null || this.getModel().getDataEntity().getDate("skssqz") == null) {
                this.getPageCache().put("orgid", this.getModel().getDataEntity().getString("org.id"));
                return;
            }
            Object object = changeData[0].getNewValue();
            String orgid = StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue() ? ((DynamicObject)changeData[0].getOldValue()).get(ID).toString() : org.getString(ID);
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
            if (checkResult) {
                this.getModel().beginInit();
                this.getModel().setValue(ORG, null);
                this.getModel().endInit();
                this.getView().updateView(ORG);
                return;
            }
            orgid = org.getString(ID);
            this.getPageCache().put("orgid", orgid);
            DynamicObject oldValueObj = (DynamicObject)changeData[0].getOldValue();
            this.getPageCache().put("oldorgid", null == oldValueObj ? null : oldValueObj.getString(ID));
            this.getModel().setValue(ZZSSBB, null);
            this.getModel().setValue(SBBID, null);
            this.getModel().setValue("billstatus", (Object)"A");
            if (this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
                this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
                this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.FALSE);
            }
        }
        if (e.getProperty().getName().equals("skssqq") && this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.FALSE);
        }
        if (e.getProperty().getName().equals("skssqz") && this.getModel().getValue("skssqq") != null && this.getModel().getValue("skssqz") != null) {
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, Boolean.FALSE);
        }
        this.init();
    }

    private void getDraftNumber(String sksqq, String sksqz) {
        String billno = this.getBillNumber(sksqq, sksqz);
        this.getModel().setValue("billno", (Object)billno);
        this.getModel().setDataChanged(false);
        this.getPageCache().put("billno", billno);
    }

    public String getTaxType() {
        return null;
    }

    public String getTemplateType() {
        return "jzjt_tsjsdg";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParamsMap = new HashMap<String, String>(1);
        bizParamsMap.put("billno", this.getModel().getDataEntity().getString("billno"));
        bizParamsMap.put(SBBID, this.getModel().getDataEntity().getString(SBBID));
        return bizParamsMap;
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        requestModel.setExtendParams(extendParams);
        return requestModel;
    }

    protected Long getCustomOrg(Map<String, Object> customParams) {
        IFormView view = this.getView();
        Long orgId = RequestContext.get().getOrgId();
        long userId = RequestContext.get().getCurrUserId();
        String entityid = view.getEntityId();
        String appid = view.getFormShowParameter().getAppId();
        List<Long> orgList = this.jzjtService.queryYbnsrJzjtFilingTaxMainOrgIdsWithPerm(userId, appid, entityid);
        if (CollectionUtils.isNotEmpty(orgList)) {
            if (orgList.contains(orgId)) {
                return orgId;
            }
            return orgList.get(0);
        }
        return null;
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String billno = customParams.get("billno") == null ? null : customParams.get("billno").toString();
        this.getModel().setValue("billno", (Object)billno);
        this.getPageCache().put("billno", billno);
        return customParams;
    }

    protected QFilter getDeclareMainQueryParams() {
        return null;
    }

    protected String getUniKey() {
        logger.info("getUniKey");
        String orgId = this.getPageCache().get("orgid");
        String skssq = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String skssz = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        return String.format("%1s_%2s_%3s_%4s", orgId, skssq, skssz, this.getTemplateType());
    }

    protected void setExtendsControlsByBillstatus(String billstatus) {
        if (StringUtils.isNotBlank((CharSequence)billstatus) && !"new".equals(billstatus)) {
            this.getModel().setValue("billstatus", (Object)billstatus);
        }
    }

    protected boolean viewDialog() {
        return false;
    }

    private String getBillNumber(String skssqq, String skssqz) {
        DynamicObject dynamicObject = this.checkRecordIsExist(MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), this.getPageCache().get("orgid"), this.getTemplateType(), skssqq, skssqz);
        if (dynamicObject == null) {
            return this.createNumber();
        }
        return dynamicObject.getString("billno");
    }

    private String createNumber() {
        return DeclareServiceHelper.generateSBBNo((String)"tcvat_tsjs_draft_query");
    }

    private DynamicObject checkRecordIsExist(String maintable, String orgid, String type, String startDate, String endDate) {
        return YbnsrService.queryMultiDeclareMain((String)maintable, (long)Long.parseLong(orgid), (String)type, (String)startDate, (String)endDate, (QFilter)this.getDeclareMainQueryParams());
    }
}

