/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.jzjt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiQueryListPlugin;
import kd.taxc.tcvat.business.service.jzjt.JzjtService;
import org.apache.commons.collections4.CollectionUtils;

public class TsjsDraftListPlugin
extends AbstractDeclareReportMultiQueryListPlugin {
    private static final String SBBID = "sbbid";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private JzjtService jzjtService = new JzjtService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        ListSelectedRowCollection selectedRows;
        Button source = (Button)evt.getSource();
        if ("btnok".equals(source.getKey()) && (selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows()).size() > 5) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\u3002\u8bf7\u6700\u591a\u9009\u62e95\u884c\u6570\u636e\u751f\u6210\u7533\u8bf7\u8868\u3002", (String)"TsjsDraftListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            if ("org.name".equals(column.getFieldName())) {
                long userId = RequestContext.get().getCurrUserId();
                String entityid = ((ListView)this.getView()).getBillFormId();
                String appid = this.getView().getFormShowParameter().getAppId();
                List<DynamicObject> taxpayers = this.jzjtService.queryYbnsrOrgIdsWithPerm(userId, appid, entityid);
                Set<Long> orgIdSet = taxpayers.stream().map(o -> o.getLong("orgid.id")).collect(Collectors.toSet());
                CommonFilterColumn typeColumn = (CommonFilterColumn)column;
                List comboItems = typeColumn.getComboItems();
                List<ComboItem> comboItemList = this.jzjtService.buildOrgComboItems(comboItems, taxpayers, orgIdSet);
                typeColumn.setComboItems(comboItemList);
                long orgId = RequestContext.get().getOrgId();
                if (orgIdSet.contains(orgId)) {
                    column.setDefaultValue(String.valueOf(orgId));
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(taxpayers)) continue;
                column.setDefaultValue(String.valueOf(taxpayers.get(0).getLong("orgid.id")));
                continue;
            }
            if (!"jzjttype.fbasedataid.value".equals(column.getFieldName())) continue;
            DynamicObjectCollection jzjtTypes = this.jzjtService.queryJzjtType();
            CommonFilterColumn typeColumn = (CommonFilterColumn)column;
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            for (DynamicObject jzjtType : jzjtTypes) {
                ComboItem comboItem = new ComboItem(new LocaleString(jzjtType.getString("value")), jzjtType.getString("id"));
                comboItems.add(comboItem);
            }
            typeColumn.setComboItems(comboItems);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("tssqb_billno".equals(args.getFieldName())) {
            args.setCancel(true);
            BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            if (currentSelectedRowInfo == null) {
                return;
            }
            DynamicObject object = this.jzjtService.loadSingleTssqbByTsjsDraftId(currentSelectedRowInfo.getPrimaryKeyValue());
            if (object != null) {
                Map<String, Object> customParams = this.jzjtService.buildMultiSbbCustomParams(object, (sqb, map) -> {
                    DynamicObjectCollection jzjtdraft = sqb.getDynamicObjectCollection("jzjtdraft");
                    if (CollectionUtils.isNotEmpty((Collection)jzjtdraft)) {
                        map.put("draftIds", jzjtdraft.stream().map(j -> j.getString("fbasedataid.id")).collect(Collectors.joining(",")));
                    }
                });
                String type = object.getString("templatetype.number");
                this.showDeclarePage(StringUtils.trimToEmpty((String)type), customParams, null, object);
            }
        } else {
            super.billListHyperLinkClick(args);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("org.id".equalsIgnoreCase(args.getFieldName())) {
            long userId = RequestContext.get().getCurrUserId();
            String entityid = ((ListView)this.getView()).getBillFormId();
            String appid = this.getView().getFormShowParameter().getAppId();
            List<DynamicObject> taxpayers = this.jzjtService.queryYbnsrOrgIdsWithPerm(userId, appid, entityid);
            QFilter orgQfilter = new QFilter("id", "in", (Object)taxpayers.stream().map(o -> o.getLong("orgid.id")).toArray());
            args.getQfilters().add(orgQfilter);
        } else if ("jzjttype.fbasedataid.id".equalsIgnoreCase(args.getFieldName())) {
            QFilter bizQfilter = new QFilter("bizdef.number", "=", (Object)"jmxmmc_jzjt");
            QFilter statsFilter = new QFilter("status", "=", (Object)Boolean.TRUE);
            args.getQfilters().add(bizQfilter);
            args.getQfilters().add(statsFilter);
        }
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject d = e.getRowData();
        if ("tssqzt".equals(columnDesc.getKey())) {
            DynamicObjectCollection entryentity;
            DynamicObject tssqb;
            if (d.getDynamicObjectType().getProperties().containsKey((Object)"entryentity.tssqb") && (tssqb = d.getDynamicObject("entryentity.tssqb")) != null && CollectionUtils.isNotEmpty((Collection)(entryentity = tssqb.getDynamicObjectCollection("entryentity")))) {
                String bljd = ((DynamicObject)entryentity.get(0)).getString("bljd");
                ComboProp property = (ComboProp)entryentity.getDynamicObjectType().getProperty("bljd");
                e.setFormatValue((Object)property.getItemByName(bljd));
            }
        } else if ("taxperiod".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)d.getDate("skssqq"), (Date)d.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        }
    }

    protected void setExtendCustomParams(Map<String, Object> customParams, DynamicObject object) {
        DynamicObject jzjtObject = this.jzjtService.loadSingleTsjsDraft(object.getPkValue());
        DynamicObjectCollection entryentity = jzjtObject.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
            customParams.put(SBBID, ((DynamicObject)entryentity.get(0)).getString(SBBID));
        }
    }

    public String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected List<String> getTemplateTypeList() {
        return Collections.singletonList("jzjt_tsjsdg");
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        if ("new".equals(operateKey)) {
            String querytype = this.getQuerytype(evt.getOperateKey());
            HashMap<String, String> custom = new HashMap<String, String>(16);
            custom.put("type", querytype);
            this.showDeclarePage(querytype, custom, null, null);
        } else if ("createsqb".equals(evt.getOperateKey())) {
            if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() > 5) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\u3002\u8bf7\u6700\u591a\u9009\u62e95\u884c\u6570\u636e\u751f\u6210\u7533\u8bf7\u8868\u3002", (String)"TsjsDraftListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                DynamicObject[] drafts = this.jzjtService.loadTsjsDraft(primaryKeyValues);
                StringBuilder message = this.jzjtService.checkBeforeCreateSqb(drafts, selectedRows);
                if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                    String[] messages = message.toString().split(SEPARATOR);
                    if (messages.length == 1) {
                        this.getView().showErrorNotification(message.toString());
                    } else {
                        this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                        OperationResult operationResult = new OperationResult();
                        operationResult.setSuccess(false);
                        operationResult.setMessage(message.toString());
                        this.getView().showOperationResult(operationResult);
                    }
                    return;
                }
                HashMap<String, String> custom = new HashMap<String, String>(16);
                custom.put("type", "jzjt_tssqb");
                custom.put("orgId", drafts[0].getString("org.id"));
                custom.put("draftIds", Stream.of(drafts).map(o -> o.getString("id")).collect(Collectors.joining(",")));
                this.showDeclarePage("jzjt_tssqb", custom, null, null);
            }
        } else if ("viewflowchart".equals(evt.getOperateKey())) {
            super.afterDoOperation(evt);
        }
        billList.refresh();
    }
}

