/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.ncp;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.common.dto.base.ResponseDto;
import kd.taxc.tcvat.common.dto.draft.DraftDto;
import kd.taxc.tcvat.common.util.TcvatCommonUtil;
import org.apache.commons.collections4.CollectionUtils;

public class NcpDraftEditMultiPlugin
extends AbstractDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(NcpDraftEditMultiPlugin.class);
    private static String ID = "id";
    private static String ORG = "org";
    protected DraftDto draftDto = new DraftDto();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit hyncpmcid = (BasedataEdit)this.getControl("hyncpmcid");
        hyncpmcid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("hyncpmcid".equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org != null) {
                List ncpxmRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)org.getLong("id"), (RuleTypeEnum)RuleTypeEnum.NCPXM, null, (String)"nssb").get(RuleTypeEnum.NCPXM);
                List hyncpmcidList = ncpxmRuleList.stream().map(n -> n.getDynamicObject("hyncp").getLong("id")).distinct().collect(Collectors.toList());
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", hyncpmcidList));
            } else {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"NcpDraftEditMultiPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        Map<String, Date> map = PeriodService.getPreTaxPeriod((String)customParams.getOrDefault("draftpurpose", "nssb"), orgId, new Date());
        Date skssqq = map.get("startDate");
        Date skssqz = DateUtils.getLastDateOfMonth2((Date)map.get("endDate"));
        this.getModel().setValue("skssqq", (Object)skssqq);
        this.getPageCache().put("skssqq", DateUtils.format((Date)skssqq));
        this.getModel().setValue("skssqz", (Object)skssqz);
        this.getPageCache().put("skssqz", DateUtils.format((Date)skssqz));
    }

    protected boolean checkArgsBeforeOpenInnerPage() {
        String orgid = this.getPageCache().get("orgid");
        return !this.orgExtendCheck(orgid);
    }

    private boolean orgExtendCheck(String orgid) {
        DynamicObjectCollection categoryentryentity;
        if (!TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)Long.valueOf(orgid)).isSuccess()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"NcpDraftEditMultiPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            return true;
        }
        ResponseDto<String> isybnsr = TcvatCommonUtil.isYbnsr(orgid);
        if (!isybnsr.getSuccess().booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u65b9\u6cd5\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"NcpDraftEditMultiPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return true;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.valueOf(orgid)));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && (EmptyCheckUtils.isEmpty((Object)(categoryentryentity = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) || "none".equals(((DynamicObject)categoryentryentity.get(0)).get("farmdeducttype")))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u3010%s\u3011\u4e0d\u9002\u7528\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u65b9\u6cd5\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"NcpDraftEditMultiPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]), ((DynamicObject)((List)result.getData()).get(0)).getDynamicObject("orgid").getString("name")));
            return true;
        }
        return false;
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        if (StringUtil.isBlank((CharSequence)orgid)) {
            return false;
        }
        if ("2".equals(this.getView().getFormShowParameter().getCustomParams().get("datatype"))) {
            return true;
        }
        if (this.getModel().getValue("hyncpmcid") != null) {
            return true;
        }
        List ncpxmRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)Long.valueOf(orgid), (RuleTypeEnum)RuleTypeEnum.NCPXM, null, (String)"nssb").get(RuleTypeEnum.NCPXM);
        if (CollectionUtils.isNotEmpty((Collection)ncpxmRuleList)) {
            DynamicObject ncpRule = (DynamicObject)ncpxmRuleList.get(0);
            this.getModel().setValue("hyncpmcid", (Object)ncpRule.getDynamicObject("hyncp").getLong("id"));
            this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
            return true;
        }
        this.getModel().setValue("hyncpmcid", null);
        this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8017\u7528\u519c\u4ea7\u54c1", (String)"NcpDraftEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        return false;
    }

    protected boolean isDefaultOrg() {
        return false;
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected String[] getTaxLimits() {
        return new String[]{"month", "season"};
    }

    public void init() {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String taxLimit;
        Boolean needMsg;
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"NcpDraftEditMultiPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (e.getProperty().getName().equals(ORG)) {
            boolean isImport;
            Object object = changeData[0].getNewValue();
            if (Objects.nonNull(object) && (isImport = SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"ncpjzjtsbbyr", (long)((DynamicObject)object).getLong("id")))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u8bbe\u7f6e\u4e3a\u901a\u8fc7\u5f15\u5165\u65b9\u5f0f\u751f\u6210\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u8ba1\u7b97\u62b5\u6263\u5e95\u7a3f\uff0c\u5982\u9700\u53d8\u66f4\u8bf7\u524d\u5f80\u3010\u57fa\u7840\u670d\u52a1\u4e91\u3011\u2192\u3010\u516c\u5171\u8bbe\u7f6e\u3011\u2192\u3010\u53c2\u6570\u914d\u7f6e\u3011\u2192\u3010\u7cfb\u7edf\u53c2\u6570\u3011\u589e\u503c\u7a0e\u5e94\u7528\u4e2d\u4fee\u6539\u53c2\u6570\u8bbe\u7f6e\u3002", (String)"NcpDraftEditMultiPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.getModel().setValue(ORG, null);
                return;
            }
            if (this.getModel().getDataEntity().getDate("skssqq") == null || this.getModel().getDataEntity().getDate("skssqz") == null) {
                this.getPageCache().put("orgid", this.getModel().getDataEntity().getString("org.id"));
                return;
            }
            String orgid = StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue() ? ((DynamicObject)changeData[0].getOldValue()).get("id").toString() : org.getString(ID);
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
            if (this.orgExtendCheck(orgid) || checkResult) {
                this.getModel().beginInit();
                this.getModel().setValue(ORG, null);
                this.getModel().endInit();
                this.getView().updateView(ORG);
                return;
            }
            orgid = org.getString(ID);
            this.getPageCache().put("orgid", orgid);
            DynamicObject oldValueObj = (DynamicObject)changeData[0].getOldValue();
            this.getPageCache().put("oldorgid", null == oldValueObj ? null : oldValueObj.getString(ID));
            List ncpxmRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)Long.valueOf(orgid), (RuleTypeEnum)RuleTypeEnum.NCPXM, null, (String)"nssb").get(RuleTypeEnum.NCPXM);
            if (!CollectionUtils.isNotEmpty((Collection)ncpxmRuleList)) {
                this.getModel().setValue(ORG, changeData[0].getOldValue());
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%s\u3011\u672a\u7ef4\u62a4\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u89c4\u5219\uff0c\u8bf7\u5728\u589e\u503c\u7a0e\u7533\u62a5\u9879\u914d\u7f6e\u4e2d\u8fdb\u884c\u914d\u7f6e", (String)"NcpDraftEditMultiPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), org.getString("name")));
                return;
            }
            DynamicObject ncpRule = (DynamicObject)ncpxmRuleList.get(0);
            this.getModel().setValue("hyncpmcid", (Object)ncpRule.getDynamicObject("hyncp").getLong("id"));
            this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, this.isNeedRefresh());
        }
        if (e.getProperty().getName().equals("skssqq")) {
            if (null == this.getModel().getValue("hyncpmcid")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8017\u7528\u519c\u4ea7\u54c1", (String)"NcpDraftEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("skssqq") == null) {
                this.getModel().setValue("skssqq", changeData[0].getOldValue());
                return;
            }
            needMsg = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("needMsg")) ? Boolean.valueOf(this.getPageCache().get("needMsg")) : Boolean.TRUE;
            taxLimit = TaxDeclareHelper.getDeadLine("nssb", org.getString("id"), (Date)changeData[0].getNewValue(), this.getModel().getDataEntity().getDate("skssqz"));
            this.beforeLoadData((Date)changeData[0].getNewValue(), taxLimit);
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), needMsg, this.isNeedRefresh());
        }
        if (e.getProperty().getName().equals("skssqz")) {
            if (null == this.getModel().getValue("hyncpmcid")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8017\u7528\u519c\u4ea7\u54c1", (String)"NcpDraftEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("skssqz") == null) {
                this.getModel().setValue("skssqz", changeData[0].getOldValue());
                return;
            }
            needMsg = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("needMsg")) ? Boolean.valueOf(this.getPageCache().get("needMsg")) : Boolean.TRUE;
            taxLimit = TaxDeclareHelper.getDeadLine("nssb", org.getString("id"), this.getModel().getDataEntity().getDate("skssqq"), (Date)changeData[0].getNewValue());
            this.beforeLoadData((Date)changeData[0].getNewValue(), taxLimit);
            this.getDraftNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), needMsg, this.isNeedRefresh());
        }
        if (e.getProperty().getName().equals("hyncpmcid")) {
            if (null == changeData[0].getNewValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8017\u7528\u519c\u4ea7\u54c1", (String)"NcpDraftEditMultiPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("hyncpmcid", ((DynamicObject)changeData[0].getNewValue()).getString("id"));
            this.getDraftNumber(DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")), DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")));
            this.loadData(this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), Boolean.FALSE, this.isNeedRefresh());
        }
        this.getPageCache().remove("needMsg");
        this.init();
    }

    protected void beforeLoadData(Date date, String taxlimit) {
        Map<String, Date> dateMap = PeriodService.provisionPeriod(date, TaxDeclareHelper.getPreTaxLimitType(taxlimit), DateUtils::getPeriodByTaxLimit);
        this.getModel().beginInit();
        this.getModel().setValue("skssqq", (Object)dateMap.get("startDate"));
        this.getModel().setValue("skssqz", (Object)dateMap.get("endDate"));
        this.getModel().endInit();
        this.getModel().updateCache();
        this.getView().updateView("skssqq");
        this.getView().updateView("skssqz");
        this.getPageCache().put("skssqq", DateUtils.format((Date)dateMap.get("startDate")));
        this.getPageCache().put("skssqz", DateUtils.format((Date)dateMap.get("endDate")));
    }

    protected Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        super.isValidDates(startDate, endDate, needMsg);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.draftDto.setOrgId(org.getLong("id"));
        this.draftDto.setStartDate(startDate);
        this.draftDto.setEndDate(endDate);
        if (!TaxDeclareHelper.validByTaxLimit(this.draftDto)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u671f\u95f4\u4e0e\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"NcpDraftEditMultiPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return true;
    }

    private void getDraftNumber(String sksqq, String sksqz) {
        String billno = this.getBillNumber(sksqq, sksqz);
        this.getModel().setValue("billno", (Object)billno);
        this.getModel().setDataChanged(false);
        this.getPageCache().put("billno", billno);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    private boolean isNeedRefresh() {
        return !QueryServiceHelper.exists((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (QFilter[])new QFilter[]{this.setDefaultQfilter()});
    }

    private QFilter setDefaultQfilter() {
        Long hyncpmcid = ((DynamicObject)this.getModel().getValue("hyncpmcid")).getLong("id");
        String draftpurpose = (String)this.getModel().getValue("draftpurpose");
        return new QFilter(ORG, "=", (Object)Long.valueOf(this.getModel().getDataEntity().getString("org.id"))).and("skssqq", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqq")))).and("skssqz", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)this.getModel().getDataEntity().getDate("skssqz")))).and("templatetype", "=", (Object)this.getTemplateType()).and("draftpurpose", "=", (Object)draftpurpose).and("hyncpmcid", "=", (Object)hyncpmcid);
    }

    public String getTaxType() {
        return null;
    }

    public String getTemplateType() {
        if ("2".equals(this.getView().getFormShowParameter().getCustomParams().get("datatype"))) {
            return "ncpdg_import";
        }
        if ("1".equals(this.getView().getFormShowParameter().getCustomParams().get("datatype"))) {
            return "ncpdg";
        }
        return "ncpdg";
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParamsMap = new HashMap<String, String>(1);
        bizParamsMap.put("billno", this.getModel().getDataEntity().getString("billno"));
        DynamicObject hyncp = (DynamicObject)this.getModel().getValue("hyncpmcid");
        bizParamsMap.put("hyncpmcid", null != hyncp ? hyncp.getString("id") : null);
        bizParamsMap.put("draftpurpose", (String)this.getModel().getValue("draftpurpose"));
        return bizParamsMap;
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        requestModel.setExtendParams(extendParams);
        return requestModel;
    }

    protected Long getCustomOrg(Map<String, Object> customParams) {
        Long orgId = RequestContext.get().getOrgId();
        this.getPageCache().put("orgid", String.valueOf(orgId));
        return orgId;
    }

    protected boolean checkNcpOrgConfig(Long orgid) {
        if (SystemParamUtil.getZeroDeclareParameter((String)"tcvat", (String)"ncpjzjtsbbyr", (long)orgid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u8bbe\u7f6e\u4e3a\u901a\u8fc7\u5f15\u5165\u65b9\u5f0f\u751f\u6210\u519c\u4ea7\u54c1\u6838\u5b9a\u6263\u9664\u8ba1\u7b97\u62b5\u6263\u5e95\u7a3f\uff0c\u5982\u9700\u53d8\u66f4\u8bf7\u524d\u5f80\u3010\u57fa\u7840\u670d\u52a1\u4e91\u3011\u2192\u3010\u516c\u5171\u8bbe\u7f6e\u3011\u2192\u3010\u53c2\u6570\u914d\u7f6e\u3011\u2192\u3010\u7cfb\u7edf\u53c2\u6570\u3011\u589e\u503c\u7a0e\u5e94\u7528\u4e2d\u4fee\u6539\u53c2\u6570\u8bbe\u7f6e\u3002", (String)"NcpDraftEditMultiPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String billno = customParams.get("billno") == null ? null : customParams.get("billno").toString();
        this.getModel().setValue("billno", (Object)billno);
        this.getPageCache().put("billno", billno);
        return customParams;
    }

    protected QFilter getDeclareMainQueryParams() {
        if (this.getModel().getValue("hyncpmcid") != null) {
            String draftpurpose = (String)this.getModel().getValue("draftpurpose");
            QFilter filter = new QFilter("draftpurpose", "=", (Object)draftpurpose);
            Long hyncpmcid = ((DynamicObject)this.getModel().getValue("hyncpmcid")).getLong("id");
            filter.and("hyncpmcid", "=", (Object)hyncpmcid);
            return filter;
        }
        return null;
    }

    protected String getUniKey() {
        logger.info("getUniKey");
        String orgId = this.getPageCache().get("orgid");
        String skssq = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String skssz = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        if (!"2".equals(this.getView().getFormShowParameter().getCustomParams().get("datatype"))) {
            String hyncpmcid = ((DynamicObject)this.getModel().getValue("hyncpmcid")).getString("id");
            String draftpurpose = (String)this.getModel().getValue("draftpurpose");
            return String.format("%1s_%2s_%3s_%4s_%5s_%6s", orgId, skssq, skssz, hyncpmcid, draftpurpose, this.getTemplateType());
        }
        return String.format("%1s_%2s_%3s_%4s", orgId, skssq, skssz, this.getTemplateType());
    }

    protected boolean viewDialog() {
        return false;
    }

    private String getBillNumber(String skssqq, String skssqz) {
        DynamicObject dynamicObject = this.checkRecordIsexist(MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), this.getPageCache().get("orgid"), this.getTemplateType(), skssqq, skssqz);
        if (dynamicObject == null) {
            return this.createNumber();
        }
        return dynamicObject.getString("billno");
    }

    private String createNumber() {
        return DeclareServiceHelper.generateSBBNo((String)"tcvat_ncp_draft_main");
    }

    private DynamicObject checkRecordIsexist(String maintable, String orgid, String type, String startDate, String endDate) {
        return YbnsrService.queryMultiDeclareMain((String)maintable, (long)Long.parseLong(orgid), (String)type, (String)startDate, (String)endDate, (QFilter)this.getDeclareMainQueryParams());
    }

    protected void beforeLoadFromHyperLinkClick(Map<String, Object> customParams) {
        if (Objects.nonNull(customParams.get("hyncpmcid"))) {
            this.getPageCache().put("hyncpmcid", (String)customParams.get("hyncpmcid"));
            this.getModel().setValue("hyncpmcid", (Object)Long.valueOf(this.getPageCache().get("hyncpmcid")));
        } else {
            BasedataEdit control = (BasedataEdit)this.getView().getControl("hyncpmcid");
            control.setMustInput(false);
            control.setVisible("hyncpmcid", false);
        }
    }
}

