/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.ncp;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tcvat.common.util.ZzsOrgCheckUtil;

public class NcpStandardListPlugin
extends AbstractListPlugin {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIds();
            args.getCustomQFilters().add(new QFilter("id", "in", listTaxResult.getData()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List cmmFilters = args.getCommonFilterColumns();
        for (FilterColumn cmmFilter : cmmFilters) {
            String fieldName = cmmFilter.getFieldName();
            if (!"useorg.id".equals(fieldName)) continue;
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("init"))) {
                return;
            }
            Long orgid = null;
            cmmFilter.setDefaultValue(null);
            long orgId = RequestContext.get().getOrgId();
            TaxResult taxcMainByOrgId = TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId);
            if (Boolean.TRUE.equals(taxcMainByOrgId.getData())) {
                orgid = orgId;
            } else {
                TaxResult orgIdTaxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
                List orgIdList = (List)orgIdTaxResult.getData();
                for (Long id : orgIdList) {
                    String failInfo = ZzsOrgCheckUtil.checkOrg(id.toString(), "tcvat_ncpkc_standard");
                    if (!StringUtils.isBlank((CharSequence)failInfo)) continue;
                    orgid = id;
                    break;
                }
            }
            if (orgid != null) {
                this.getPageCache().put("createOrg", orgid.toString());
                cmmFilter.setDefaultValue(orgid.toString());
                this.getPageCache().put("init", "1");
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "tbldel", "tbldisable", "tblassign", "bar_manage"});
        }
    }
}

