/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.ncp;

import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.tcvat.business.service.ncp.NcpkcStandardService;

public class NcpkcStandardPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private NcpkcStandardService ncpkcStandardService = new NcpkcStandardService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit cpmcEdit = (BasedataEdit)this.getControl("cpmc");
        BasedataEdit hyncpmcEdit = (BasedataEdit)this.getControl("hyncpmc");
        cpmcEdit.addBeforeQuickAddNewListener(evt -> evt.getShowParameter().getOpenStyle().setShowType(ShowType.NonModal));
        hyncpmcEdit.addBeforeQuickAddNewListener(evt -> evt.getShowParameter().getOpenStyle().setShowType(ShowType.NonModal));
        BasedataEdit base = (BasedataEdit)this.getView().getControl("useorg");
        if (Objects.nonNull(base)) {
            base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        OrgUtils.addFilterByConditionBeforeF7Select((Object)event, (IFormView)this.getView(), null, null, null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        String name = e.getProperty().getName();
        if ("enddate".equals(name)) {
            Date enddate = (Date)changeSet[0].getNewValue();
            Date startdate = (Date)this.getModel().getValue("startdate");
            String errMsg = this.ncpkcStandardService.checkDate(startdate, enddate);
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                this.getView().showTipNotification(errMsg);
                this.getModel().setValue("enddate", changeSet[0].getOldValue());
            }
        }
    }
}

