/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.ncp.batchimport;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class NcpDeclareNameImportPlugin
extends BatchImportPlugin {
    protected int getBatchImportSize() {
        return 1;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> partList = billdatas.iterator();
        TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (Long)1L);
        Set<Object> orgNumberSet = new HashSet(8);
        if (listTaxResult != null && listTaxResult.getData() != null && !((List)listTaxResult.getData()).isEmpty()) {
            orgNumberSet = ((List)listTaxResult.getData()).stream().filter(l -> null != l.getDynamicObject("org")).map(l -> l.getDynamicObject("org").getString("number")).collect(Collectors.toSet());
        }
        HashSet<String> excelOrgNumberSet = new HashSet<String>(1);
        while (partList.hasNext()) {
            ImportBillData data = partList.next();
            Integer index = data.getStartIndex();
            String orgNumber = (String)data.getData().getJSONObject("orgid").get("number");
            Date startdate = null;
            Date enddate = null;
            try {
                Date lastDateOfMonth;
                String startdateStr = data.getData().getString("startdate");
                String enddateStr = data.getData().getString("enddate");
                startdate = DateUtils.stringToDate2((String)startdateStr);
                enddate = DateUtils.stringToDate2((String)enddateStr);
                Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)startdate);
                if (startdate.compareTo(firstDateOfMonth) != 0) {
                    logger.log(index, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5b8c\u6574\u7684\u6708\u4efd\u3002", (String)"NcpDeclareNameImportPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0])).fail();
                    this.remove(billdatas, partList);
                    continue;
                }
                if (null != enddate && enddate.compareTo(lastDateOfMonth = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)enddate))) != 0) {
                    logger.log(index, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5b8c\u6574\u7684\u6708\u4efd\u3002", (String)"NcpDeclareNameImportPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0])).fail();
                    this.remove(billdatas, partList);
                    continue;
                }
                if (null != enddate && startdate.after(enddate)) {
                    logger.log(index, ResManager.loadKDString((String)"\u201c\u6709\u6548\u671f\u8d77\u201d\u9700\u5c0f\u4e8e\u201c\u6709\u6548\u671f\u6b62\u201d\u3002", (String)"NcpDeclareNameImportPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0])).fail();
                    this.remove(billdatas, partList);
                }
            }
            catch (NumberFormatException e) {
                logger.log(index, ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u8bf7\u4f7f\u7528\u6b63\u786e\u683c\u5f0fyyyy-MM-DD\u3002", (String)"NcpDeclareNameImportPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0])).fail();
                this.remove(billdatas, partList);
            }
            excelOrgNumberSet.add(orgNumber);
        }
        TaxResult listTaxResult1 = TaxcMainDataServiceHelper.queryTaxcMainByOrgNumbersWithNoStatus(new ArrayList(excelOrgNumberSet), (Long)1L);
        if (null != listTaxResult1 && listTaxResult1.getData() != null && ((List)listTaxResult1.getData()).size() > 0) {
            List orgidList = ((List)listTaxResult1.getData()).stream().map(l -> l.getDynamicObject("taxorg").getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection result = QueryServiceHelper.query((String)"tcvat_ncp_declare_name", (String)"id,number,name,startdate,enddate", (QFilter[])new QFilter[]{new QFilter("orgid", "in", orgidList)});
            block3: while (partList.hasNext()) {
                ImportBillData data = partList.next();
                Integer index = data.getStartIndex();
                String orgNumber = (String)data.getData().getJSONObject("orgid").get("number");
                String startdateStr = data.getData().getString("startdate");
                String enddateStr = data.getData().getString("enddate");
                Date startdate = DateUtils.stringToDate2((String)startdateStr);
                Date enddate = DateUtils.stringToDate2((String)enddateStr);
                Long orgid = 0L;
                if (null != listTaxResult1 && listTaxResult1.getData() != null && ((List)listTaxResult1.getData()).size() > 0) {
                    String enable = ((DynamicObject)((List)listTaxResult1.getData()).get(0)).getDynamicObject("taxorg").getString("status");
                    if ("0".equals(enable)) {
                        logger.log(index, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u53ef\u7528\uff0c\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91\u2192\u57fa\u7840\u8bbe\u7f6e\u2192\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406\u2192\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u4e2d\u542f\u7528\u3002", (String)"NcpDeclareNameImportPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0])).fail();
                        this.remove(billdatas, partList);
                        continue;
                    }
                    String status = ((DynamicObject)((List)listTaxResult1.getData()).get(0)).getString("billstatus");
                    if (!"C".equals(status)) {
                        logger.log(index, ResManager.loadKDString((String)"\u5f53\u524d\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e0d\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91\u2192\u57fa\u7840\u8bbe\u7f6e\u2192\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406\u2192\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u5ba1\u6838\u3002", (String)"NcpDeclareNameImportPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0])).fail();
                        this.remove(billdatas, partList);
                        continue;
                    }
                    orgid = ((DynamicObject)((List)listTaxResult1.getData()).get(0)).getDynamicObject("taxorg").getLong("id");
                }
                if (!orgNumberSet.contains(orgNumber)) {
                    logger.log(index, ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NcpDeclareNameImportPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0])).fail();
                    this.remove(billdatas, partList);
                    continue;
                }
                String ncpName = data.getData().getString("name");
                String ncpNumber = data.getData().getString("number");
                if (null == enddate) {
                    enddate = DateUtils.stringToDate2((String)"9999-12-31");
                }
                for (DynamicObject dynamicObject : result) {
                    if (orgid.compareTo(dynamicObject.getLong("id")) != 0 || enddate.before(dynamicObject.getDate("startdate")) || startdate.after(null == dynamicObject.getDate("enddate") ? new Date(9999, 12, 31) : dynamicObject.getDate("enddate"))) continue;
                    if (ncpNumber.equals(dynamicObject.getString("number"))) {
                        logger.log(index, ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u671f\u5185\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u53ef\u7528\u6570\u636e\uff08\u7a0e\u52a1\u7ec4\u7ec7\u3001\u7f16\u7801\u90fd\u76f8\u540c\uff09\u3002", (String)"NcpDeclareNameOp_0", (String)"taxc-tcvat", (Object[])new Object[0])).fail();
                        this.remove(billdatas, partList);
                        continue block3;
                    }
                    if (!ncpName.equals(dynamicObject.getString("name"))) continue;
                    logger.log(index, ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u671f\u5185\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u53ef\u7528\u6570\u636e\uff08\u7a0e\u52a1\u7ec4\u7ec7\u3001\u540d\u79f0\u90fd\u76f8\u540c\uff09\u3002", (String)"NcpDeclareNameOp_1", (String)"taxc-tcvat", (Object[])new Object[0])).fail();
                    this.remove(billdatas, partList);
                    continue block3;
                }
            }
        }
    }

    private void remove(List<ImportBillData> data, Iterator<ImportBillData> partList) {
        if (CollectionUtils.isNotEmpty(data)) {
            partList.remove();
        }
    }
}

