/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.tcvat.business.service.prepay.project.ProjectService;
import org.apache.commons.collections4.CollectionUtils;

public class ProjectFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ClickListener,
UploadListener,
AttachmentMarkListener {
    public static final String CSWHJSS = "cswhjss";
    public static final String PERSONALTAX = "personaltax";
    public static final String YHS = "yhs";
    public static final String SLJSJJ = "sljsjj";
    private static final Set<String> BDCList = new HashSet<String>(Arrays.asList("VAT_YJXMLX_004", "VAT_YJXMLX_005"));
    private static final Set<String> JZList = new HashSet<String>(Arrays.asList("VAT_YJXMLX_001", "VAT_YJXMLX_002", "VAT_YJXMLX_003"));
    private static String ATTACH_AREA = "attacharea";
    private static String ATTACH_AREA1 = "attacharea1";
    private static String ATTACH_LABEL = "attachlabel";
    private static String ATTACH_LABEL1 = "attachlabel1";
    private static String ATTACHMENT_PANELAP = "attachmentpanelap";
    private static String ATTACHMENT_PANELAP1 = "attachmentpanelap1";
    private static final String TAXORG = "taxorg";

    public void registerListener(EventObject e) {
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANELAP);
        panel.addMarkListener((AttachmentMarkListener)this);
        panel.addUploadListener((UploadListener)this);
        AttachmentPanel panel2 = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANELAP1);
        panel2.addMarkListener((AttachmentMarkListener)this);
        panel2.addUploadListener((UploadListener)this);
        this.addClickListeners(new String[]{ATTACH_AREA, ATTACH_AREA1});
        OrgEdit taxOrgEdit = (OrgEdit)this.getView().getControl(TAXORG);
        taxOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxation = (BasedataEdit)this.getControl("baseproject");
        taxation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            List taxOrgID = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrg((Long)org.getLong("id"), (Date)new Date());
            if (CollectionUtils.isNotEmpty((Collection)taxOrgID)) {
                List<Long> taxOrgIds = this.checkOrgPerm(taxOrgID);
                if (CollectionUtils.isNotEmpty(taxOrgIds)) {
                    this.getModel().setValue(TAXORG, (Object)taxOrgIds.get(0));
                } else if (taxOrgID.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5efa\u7acb\u4e86\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u6216\u8005\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u5f00\u542f\u4e86\u589e\u503c\u7a0e\u5361\u7247\u3002", (String)"ProjectFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4e1a\u52a1\u5355\u5143\u534f\u4f5c\u4e2d\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"ProjectFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
    }

    private void setMustInput() {
        boolean cswhjss = this.getModel().getDataEntity().getBoolean(CSWHJSS);
        ComboEdit zoneCtrl = (ComboEdit)this.getControl("zone");
        FieldProp zoneProperty = (FieldProp)this.getModel().getProperty("zone");
        if (!cswhjss) {
            zoneCtrl.setMustInput(false);
            zoneProperty.setMustInput(false);
        } else {
            zoneCtrl.setMustInput(true);
            zoneProperty.setMustInput(true);
        }
        boolean personaltax = this.getModel().getDataEntity().getBoolean(PERSONALTAX);
        TextEdit personalratioCtrl = (TextEdit)this.getControl("personalratio");
        FieldProp personalratioProperty = (FieldProp)this.getModel().getProperty("personalratio");
        if (!personaltax) {
            personalratioCtrl.setMustInput(false);
            personalratioProperty.setMustInput(false);
        } else {
            personalratioCtrl.setMustInput(true);
            personalratioProperty.setMustInput(true);
        }
        boolean yhs = this.getModel().getDataEntity().getBoolean(YHS);
        ComboEdit yhstaxbasisCtrl = (ComboEdit)this.getControl("yhstaxbasis");
        TextEdit yhsratioCtrl = (TextEdit)this.getControl("yhsratio");
        FieldProp yhstaxbasisProperty = (FieldProp)this.getModel().getProperty("yhstaxbasis");
        FieldProp yhsratioProperty = (FieldProp)this.getModel().getProperty("yhsratio");
        if (!yhs) {
            yhstaxbasisCtrl.setMustInput(false);
            yhsratioCtrl.setMustInput(false);
            yhstaxbasisProperty.setMustInput(false);
            yhsratioProperty.setMustInput(false);
        } else {
            yhstaxbasisCtrl.setMustInput(true);
            yhsratioCtrl.setMustInput(true);
            yhstaxbasisProperty.setMustInput(true);
            yhsratioProperty.setMustInput(true);
        }
        boolean sljsjj = this.getModel().getDataEntity().getBoolean(SLJSJJ);
        TextEdit sljsjjratioCtrl = (TextEdit)this.getControl("sljsjjratio");
        FieldProp sljsjjratioProperty = (FieldProp)this.getModel().getProperty("sljsjjratio");
        ComboEdit sljsjjbillingbasisCtrl = (ComboEdit)this.getControl("sljsjjbillingbasis");
        FieldProp sljsjjbillingbasisProperty = (FieldProp)this.getModel().getProperty("sljsjjbillingbasis");
        if (!sljsjj) {
            sljsjjratioCtrl.setMustInput(false);
            sljsjjbillingbasisCtrl.setMustInput(false);
            sljsjjbillingbasisProperty.setMustInput(false);
            sljsjjratioProperty.setMustInput(false);
        } else {
            sljsjjratioCtrl.setMustInput(true);
            sljsjjbillingbasisCtrl.setMustInput(true);
            sljsjjbillingbasisProperty.setMustInput(true);
            sljsjjratioProperty.setMustInput(true);
        }
        boolean ghjf = this.getModel().getDataEntity().getBoolean("ghjf");
        TextEdit ghjfratioCtrl = (TextEdit)this.getControl("ghjfratio");
        FieldProp ghjfratioProperty = (FieldProp)this.getModel().getProperty("ghjfratio");
        if (!ghjf) {
            ghjfratioCtrl.setMustInput(false);
            ghjfratioProperty.setMustInput(false);
        } else {
            ghjfratioCtrl.setMustInput(true);
            ghjfratioProperty.setMustInput(true);
        }
        boolean hjbhs = this.getModel().getDataEntity().getBoolean("hjbhs");
        TextEdit hjbhsratioCtrl = (TextEdit)this.getControl("hjbhsratio");
        FieldProp hjbhsratioProperty = (FieldProp)this.getModel().getProperty("hjbhsratio");
        if (!hjbhs) {
            hjbhsratioCtrl.setMustInput(false);
            hjbhsratioProperty.setMustInput(false);
        } else {
            hjbhsratioCtrl.setMustInput(true);
            hjbhsratioProperty.setMustInput(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject baseproject;
        String name = e.getProperty().getName();
        if ("org".equals(name)) {
            String orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getString("id")).orElse(null);
            if (orgId == null) {
                return;
            }
            List taxOrgID = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrg((Long)Long.valueOf(orgId), (Date)new Date());
            if (CollectionUtils.isNotEmpty((Collection)taxOrgID)) {
                OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)String.valueOf((Long)taxOrgID.get(0)), (String)"tcvat", (String)"zzs");
                this.getModel().setValue(TAXORG, taxOrgID.get(0));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4e1a\u52a1\u5355\u5143\u534f\u4f5c\u4e2d\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"ProjectFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        } else if ("split".equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            String splitFlag = (String)changeData[0].getNewValue();
            if ("1".equals(splitFlag)) {
                this.getModel().deleteEntryData("scontractentity");
                this.getModel().createNewEntryRow("scontractentity");
            }
        } else if (CSWHJSS.equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            Boolean notSelect = (Boolean)changeData[0].getNewValue();
            ComboEdit zoneCtrl = (ComboEdit)this.getControl("zone");
            FieldProp zoneProperty = (FieldProp)this.getModel().getProperty("zone");
            if (!notSelect.booleanValue()) {
                this.getModel().setValue("zone", null);
                zoneCtrl.setMustInput(false);
                zoneProperty.setMustInput(false);
            } else {
                zoneCtrl.setMustInput(true);
                zoneProperty.setMustInput(true);
            }
        } else if (PERSONALTAX.equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            Boolean notSelect = (Boolean)changeData[0].getNewValue();
            TextEdit personalratioCtrl = (TextEdit)this.getControl("personalratio");
            FieldProp personalratioProperty = (FieldProp)this.getModel().getProperty("personalratio");
            if (!notSelect.booleanValue()) {
                this.getModel().setValue("personalratio", null);
                personalratioCtrl.setMustInput(false);
                personalratioProperty.setMustInput(false);
            } else {
                personalratioCtrl.setMustInput(true);
                personalratioProperty.setMustInput(true);
            }
        } else if (YHS.equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            Boolean notSelect = (Boolean)changeData[0].getNewValue();
            ComboEdit yhstaxbasisCtrl = (ComboEdit)this.getControl("yhstaxbasis");
            TextEdit yhsratioCtrl = (TextEdit)this.getControl("yhsratio");
            FieldProp yhstaxbasisProperty = (FieldProp)this.getModel().getProperty("yhstaxbasis");
            FieldProp yhsratioProperty = (FieldProp)this.getModel().getProperty("yhsratio");
            if (!notSelect.booleanValue()) {
                this.getModel().setValue("yhsratio", null);
                this.getModel().setValue("yhstaxbasis", null);
                yhstaxbasisCtrl.setMustInput(false);
                yhsratioCtrl.setMustInput(false);
                yhstaxbasisProperty.setMustInput(false);
                yhsratioProperty.setMustInput(false);
            } else {
                this.getModel().setValue("yhstaxbasis", (Object)"0");
                yhstaxbasisCtrl.setMustInput(true);
                yhsratioCtrl.setMustInput(true);
                yhstaxbasisProperty.setMustInput(true);
                yhsratioProperty.setMustInput(true);
            }
        } else if (SLJSJJ.equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            Boolean notSelect = (Boolean)changeData[0].getNewValue();
            TextEdit sljsjjratioCtrl = (TextEdit)this.getControl("sljsjjratio");
            FieldProp sljsjjratioProperty = (FieldProp)this.getModel().getProperty("sljsjjratio");
            ComboEdit sljsjjbillingbasisCtrl = (ComboEdit)this.getControl("sljsjjbillingbasis");
            FieldProp sljsjjbillingbasisProperty = (FieldProp)this.getModel().getProperty("sljsjjbillingbasis");
            if (!notSelect.booleanValue()) {
                this.getModel().setValue("sljsjjbillingbasis", null);
                sljsjjratioCtrl.setMustInput(false);
                sljsjjbillingbasisCtrl.setMustInput(false);
                sljsjjbillingbasisProperty.setMustInput(false);
                sljsjjratioProperty.setMustInput(false);
            } else {
                this.getModel().setValue("sljsjjbillingbasis", null);
                sljsjjratioCtrl.setMustInput(true);
                sljsjjbillingbasisCtrl.setMustInput(true);
                sljsjjbillingbasisProperty.setMustInput(true);
                sljsjjratioProperty.setMustInput(true);
            }
        } else if ("ghjf".equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            Boolean notSelect = (Boolean)changeData[0].getNewValue();
            TextEdit ghjfratioCtrl = (TextEdit)this.getControl("ghjfratio");
            FieldProp ghjfratioProperty = (FieldProp)this.getModel().getProperty("ghjfratio");
            if (!notSelect.booleanValue()) {
                ghjfratioCtrl.setMustInput(false);
                ghjfratioProperty.setMustInput(false);
            } else {
                ghjfratioCtrl.setMustInput(true);
                ghjfratioProperty.setMustInput(true);
            }
        } else if ("hjbhs".equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            Boolean notSelect = (Boolean)changeData[0].getNewValue();
            TextEdit hjbhsratioCtrl = (TextEdit)this.getControl("hjbhsratio");
            FieldProp hjbhsratioProperty = (FieldProp)this.getModel().getProperty("hjbhsratio");
            if (!notSelect.booleanValue()) {
                hjbhsratioCtrl.setMustInput(false);
                hjbhsratioProperty.setMustInput(false);
            } else {
                hjbhsratioCtrl.setMustInput(true);
                hjbhsratioProperty.setMustInput(true);
            }
        } else if ("prepaytype".equals(name)) {
            ChangeData data = e.getChangeSet()[0];
            Object newValue = data.getNewValue();
            Object oldValue = data.getOldValue();
            if (JZList.contains(oldValue) && BDCList.contains(newValue)) {
                this.getModel().setValue("licensecode", null);
                this.getModel().setValue("cross", (Object)"0");
                this.getModel().setValue("start", null);
                this.getModel().setValue("end", null);
                this.getModel().setValue("split", (Object)"0");
                this.getModel().deleteEntryData("scontractentity");
            }
        } else if ("baseproject".equals(name) && (baseproject = (DynamicObject)this.getModel().getValue("baseproject")) != null) {
            this.getModel().setValue("name", (Object)baseproject.getString("name"));
            this.getModel().setValue("address", (Object)baseproject.getString("proaddress"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMustInput();
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        ProjectService.beforeImportData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals(TAXORG)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (Objects.isNull(org)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\uff01", (String)"ProjectFormPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            List orgList = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrg((Long)org.getLong("id"), (Date)new Date());
            if (CollectionUtils.isNotEmpty((Collection)orgList)) {
                List<Long> taxOrgIds = this.checkOrgPerm(orgList);
                if (CollectionUtils.isNotEmpty(taxOrgIds)) {
                    ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                    parameter.getListFilterParameter().setFilter(new QFilter("id", "in", taxOrgIds));
                } else if (orgList.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u9002\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5efa\u7acb\u4e86\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u6216\u8005\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u5f00\u542f\u4e86\u589e\u503c\u7a0e\u5361\u7247\u3002", (String)"ProjectFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                    evt.setCancel(Boolean.TRUE.booleanValue());
                } else {
                    evt.setCancel(Boolean.TRUE.booleanValue());
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u4e1a\u52a1\u5355\u5143\u534f\u4f5c\u4e2d\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u3002", (String)"ProjectFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
            }
        }
    }

    private List<Long> checkOrgPerm(List<Long> taxorgs) {
        Boolean flag = CollectionUtils.isNotEmpty(taxorgs) && taxorgs.size() == 1;
        ArrayList result = Lists.newArrayList();
        taxorgs.forEach(taxorg -> {
            Boolean license = LicenseCheckServiceHelper.check((Object)taxorg, null, (String)"tcvat");
            if (license.booleanValue() && flag.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6709\u8bb8\u53ef\u7684\u7a0e\u52a1\u7ec4\u7ec7", (String)"ProjectFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Boolean approve = (Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)taxorg).getData() == false;
            if (approve.booleanValue() && flag.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7a0e\u52a1\u7ec4\u7ec7\u662f\u5426\u5ba1\u6838\u901a\u8fc7\u3002", (String)"ProjectFormPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            boolean taxCategoryEnable = OrgCheckUtil.taxCategoryEnable((String)String.valueOf(taxorg), (IFormView)this.getView(), (String)"tcvat", (String)"zzs", (boolean)false);
            if (taxCategoryEnable && flag.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u542f\u7528\u4e86\u589e\u503c\u7a0e\u5361\u7247\u7684\u7a0e\u52a1\u7ec4\u7ec7", (String)"ProjectFormPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            if (!(license.booleanValue() || approve.booleanValue() || taxCategoryEnable)) {
                result.add(taxorg);
            }
        });
        return result;
    }
}

