/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.application;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class PrepayApplicationListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("startdate".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("startdate"), (String)DateUtils.YYYYMMDD_CHINESE);
            String skssqz = DateUtils.format((Date)data.getDate("enddate"), (String)DateUtils.YYYYMMDD_CHINESE);
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("prepaydeclare".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String pk = list.get(0).getPrimaryKeyValue().toString();
            DynamicObject perpayApplication = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"tcvat_prepay_application");
            if (this.isDeclareRepeat(perpayApplication)) {
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("tcvat_prepay_declare_home");
            parameter.setCustomParam("source", (Object)"application");
            parameter.setCustomParam("orgid", (Object)perpayApplication.getDynamicObject("org").getString("id"));
            parameter.setCustomParam("projectid", (Object)(null == perpayApplication.getDynamicObject("prepayproject") ? "" : perpayApplication.getDynamicObject("prepayproject").getString("id")));
            parameter.setCustomParam("readonly", (Object)Boolean.TRUE);
            parameter.setCustomParam("skssqq", (Object)perpayApplication.getDate("startdate"));
            parameter.setCustomParam("skssqz", (Object)perpayApplication.getDate("enddate"));
            parameter.setCustomParam("applyid", (Object)pk);
            parameter.setCustomParam("selected_taxorgid", (Object)perpayApplication.getDynamicObject("taxorg").getString("id"));
            this.getView().showForm(parameter);
        }
    }

    private boolean isDeclareRepeat(DynamicObject perpayApplication) {
        String declareNumber = perpayApplication.getString("declarenumber");
        if (StringUtils.isEmpty((CharSequence)declareNumber)) {
            return false;
        }
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"PrepayApplicationListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.None;
        String msg = String.format(ResManager.loadKDString((String)"\u6b64\u9884\u7f34\u7533\u8bf7\u5355\u5df2\u751f\u6210\u4e86\u9884\u7f34\u7533\u62a5\u8868\u3010%s\u3011\uff0c\u8bf7\u52ff\u91cd\u590d\u751f\u6210", (String)"PrepayApplicationListPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]), declareNumber);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, new ConfirmCallBackListener(), btnNameMaps);
        return true;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        DynamicObject application;
        ListSelectedRow currentSelectedRowInfo;
        BillList list;
        String fieldName = args.getFieldName();
        if ("declarenumber".equals(fieldName)) {
            args.setCancel(true);
            list = (BillList)args.getHyperLinkClickEvent().getSource();
            currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            application = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcvat_prepay_application");
            String declarenumber = application.getString("declarenumber");
            DynamicObject dyo = QueryServiceHelper.queryOne((String)"tcvat_prepay_declare_bill", (String)"id", (QFilter[])new QFilter[]{new QFilter("declareserialno", "=", (Object)declarenumber)});
            if (dyo == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"PrepayApplicationListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)dyo.get("id"), (String)"tcvat_prepay_declare_bill");
            String type = "zzsyjskb";
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("datasource", "hyperlink");
            customParams.put("orgid", object.getDynamicObject("accountorg").getString("id"));
            customParams.put("taxorg", object.getDynamicObject("org").getString("id"));
            customParams.put("sblx", "2");
            customParams.put("orgname", object.getDynamicObject("accountorg").getString("name"));
            customParams.put("declareserialno", object.getString("declareserialno"));
            customParams.put("projectid", object.getDynamicObject("prepayproject").getString("id"));
            Date skssqq = object.getDate("skssqq");
            Date skssqz = object.getDate("skssqz");
            customParams.put("templatetype", type);
            String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("applyid", String.valueOf(currentSelectedRowInfo.getPrimaryKeyValue()));
            String declarestatus = object.getString("declarestatus");
            String dataType = "1";
            if (!OrgCheckUtil.check((IFormView)this.getView(), (String)object.getDynamicObject("org").getString("id"), (String)"tcvat", (String)"zzs")) {
                this.showDeclarePageByTaxType(StringUtils.trimToEmpty((String)type), param, customParams, declarestatus, dataType);
            }
        }
        if ("crossnumber".equals(fieldName)) {
            args.setCancel(true);
            list = (BillList)args.getHyperLinkClickEvent().getSource();
            currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            application = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcvat_prepay_application");
            String checkno = application.getString("crossnumber");
            DynamicObject reportObj = QueryServiceHelper.queryOne((String)"tcvat_cross_tax_report", (String)"id", (QFilter[])new QFilter[]{new QFilter("checkno", "=", (Object)checkno)});
            if (reportObj == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8de8\u533a\u57df\u6d89\u7a0e\u4e8b\u9879\u62a5\u544a\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"PrepayApplicationListPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("tcvat_cross_tax_report");
            parameter.setPkId((Object)reportObj.getLong("id"));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void showDeclarePageByTaxType(String type, FormShowParameter param, Map<String, Object> customParams, String declarestatus, String dataType) {
        if (type.startsWith("zzs")) {
            if (StringUtils.equals((CharSequence)"declared", (CharSequence)declarestatus)) {
                param.setFormId("tcvat_prepay_declare_show");
            } else {
                param.setFormId("tcvat_prepay_declare_home");
            }
        } else if (StringUtils.equals((CharSequence)"declared", (CharSequence)declarestatus)) {
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
            param.setFormId("bdtaxr_declare_old");
        } else {
            param.setFormId("bdtaxr_declare_edit");
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getTaxDeclareCn());
            customParams.put("type", type);
        }
        if (StringUtils.equals((CharSequence)"2", (CharSequence)dataType) && !StringUtils.equals((CharSequence)"declared", (CharSequence)declarestatus) && !StringUtils.equals((CharSequence)"qysdsnb", (CharSequence)type)) {
            customParams.put("type", type);
            param.setFormId("bdtaxr_declare_edit");
            customParams.put("refresh", Boolean.FALSE);
            customParams.put("license", Boolean.FALSE);
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredEditingCn());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

