/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.application;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.prepay.application.PrepayApplicationService;

public class PrepayDeductDetailPlugin
extends AbstractFormPlugin {
    private PrepayApplicationService prepayApplicationService = new PrepayApplicationService();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List historyIdList = (List)customParams.get("historyIdList");
        List specialIdList = (List)customParams.get("specialIdList");
        List ordinaryIdList = (List)customParams.get("ordinaryIdList");
        List electricIdList = (List)customParams.get("electricIdList");
        DynamicObjectCollection invoiceCollection = PrepayApplicationService.queryDeductEntryData(specialIdList, ordinaryIdList, electricIdList);
        List collect = invoiceCollection.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        List<Long> historyCollect = historyIdList.stream().filter(o -> !collect.contains(o)).collect(Collectors.toList());
        DynamicObjectCollection historyCollection = PrepayApplicationService.queryInvoiceData(historyCollect, historyCollect, historyCollect);
        invoiceCollection.addAll((Collection)historyCollection);
        this.setDeductEntry(invoiceCollection, customParams);
    }

    private void setDeductEntry(DynamicObjectCollection invoiceCollection, Map<String, Object> customParams) {
        IDataModel model = this.getModel();
        model.beginInit();
        Map nowData = (Map)customParams.get("nowData");
        for (DynamicObject object : invoiceCollection) {
            int index = model.createNewEntryRow("entryentity");
            Long id = object.getLong("id");
            model.setValue("invoiceid", (Object)object.getLong("id"), index);
            model.setValue("baseinvoicetype", (Object)object.getDynamicObject("invoice_type").getLong("id"), index);
            if ("26".equals(object.getDynamicObject("invoice_type").getString("number")) || "27".equals(object.getDynamicObject("invoice_type").getString("number"))) {
                model.setValue("invoicecode", null, index);
            } else {
                model.setValue("invoicecode", (Object)object.getString("invoice_code"), index);
            }
            model.setValue("invoiceno", (Object)object.getString("invoice_no"), index);
            model.setValue("invoicedate", (Object)object.getDate("invoice_date"), index);
            model.setValue("salername", (Object)object.getString("saler_name"), index);
            model.setValue("maingoodsname", (Object)object.getString("main_goods_name"), index);
            model.setValue("invoiceamount", (Object)object.getBigDecimal("invoice_amount"), index);
            model.setValue("totaltaxamount", (Object)object.getBigDecimal("total_tax_amount"), index);
            BigDecimal total_amount = object.getBigDecimal("total_amount");
            BigDecimal total_deduct = object.getBigDecimal("total_deduct");
            model.setValue("totalamount", (Object)total_amount, index);
            if (nowData != null && nowData.containsKey(id.toString())) {
                String s = (String)nowData.get(id.toString());
                BigDecimal dtotaldeductTemp = BigDecimalUtil.subtractObject((Object)total_deduct, (Object)s);
                model.setValue("dtotaldeduct", (Object)dtotaldeductTemp, index);
                model.setValue("dremaindeduct", (Object)BigDecimalUtil.subtractObject((Object)total_amount, (Object)dtotaldeductTemp), index);
            } else {
                model.setValue("dtotaldeduct", (Object)total_deduct, index);
                model.setValue("dremaindeduct", (Object)object.getBigDecimal("remain_deduct"), index);
            }
            model.setValue("davaildeduct", (Object)object.getBigDecimal("avail_deduct"), index);
            model.setValue("remark", (Object)object.getString("remark"), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().getModel().updateCache();
    }

    public void click(EventObject evt) {
        Button btn;
        Object source = evt.getSource();
        if (source instanceof Button && (btn = (Button)source).getKey().equals("btnok")) {
            int[] selectRows;
            ArrayList<Long> specialList = new ArrayList<Long>();
            ArrayList<Long> ordinaryList = new ArrayList<Long>();
            ArrayList<Long> electricList = new ArrayList<Long>();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            for (int selectRow : selectRows = entry.getSelectRows()) {
                DynamicObject object = (DynamicObject)entryentity.get(selectRow);
                if ("2".equals(object.getDynamicObject("baseinvoicetype").getString("number")) || "4".equals(object.getDynamicObject("baseinvoicetype").getString("number"))) {
                    specialList.add(object.getLong("invoiceid"));
                }
                if ("1".equals(object.getDynamicObject("baseinvoicetype").getString("number")) || "3".equals(object.getDynamicObject("baseinvoicetype").getString("number"))) {
                    ordinaryList.add(object.getLong("invoiceid"));
                }
                if (!"26".equals(object.getDynamicObject("baseinvoicetype").getString("number")) && !"27".equals(object.getDynamicObject("baseinvoicetype").getString("number"))) continue;
                electricList.add(object.getLong("invoiceid"));
            }
            HashMap<String, ArrayList<Long>> result = new HashMap<String, ArrayList<Long>>();
            result.put("specialList", specialList);
            result.put("ordinaryList", ordinaryList);
            result.put("electricList", electricList);
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }
}

