/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.crosstax;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.common.constant.CrossTaxConstant;

public class CrossTaxListPlugin
extends AbstractListPlugin
implements CrossTaxConstant {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (this.isF7Page()) {
            List listColumns = args.getListColumns();
            listColumns.removeIf(column -> !pops.contains(column.getListFieldKey()));
            args.setListColumns(listColumns);
        }
    }

    private boolean isF7Page() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String formId = listShowParameter.getFormId();
        return formId.contains("f7");
    }

    public void setFilter(SetFilterEvent e) {
        Map map;
        Object orgid;
        super.setFilter(e);
        if (null == e) {
            return;
        }
        List qFilterList = e.getQFilters();
        IFormView view = this.getView().getParentView();
        if (null != view && null != (orgid = (map = view.getFormShowParameter().getCustomParams()).get("orgid"))) {
            qFilterList.add(new QFilter("org", "=", (Object)Long.valueOf(String.valueOf(orgid))));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        List applicationIdList;
        DynamicObjectCollection applicationCollection;
        super.afterDoOperation(evt);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("orgid", "");
        if (null == evt.getOperationResult()) {
            return;
        }
        List PkIdList = evt.getOperationResult().getSuccessPkIds();
        DynamicObjectCollection crossReportCollection = QueryServiceHelper.query((String)"tcvat_cross_tax_report", (String)"org,checkno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)PkIdList)});
        List checkNoList = crossReportCollection.stream().filter(c -> StringUtil.isNotBlank((CharSequence)c.getString("checkno"))).map(c -> c.getString("checkno")).distinct().collect(Collectors.toList());
        if ("application".equals(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            applicationCollection = QueryServiceHelper.query((String)"tcvat_prepay_application", (String)"id", (QFilter[])new QFilter[]{new QFilter("crossnumber", "in", checkNoList)});
            applicationIdList = applicationCollection.stream().map(a -> a.getLong("id")).distinct().collect(Collectors.toList());
            if (applicationIdList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f34\u7533\u8bf7\u5355\u5c1a\u672a\u751f\u6210, \u8bf7\u91cd\u65b0\u9009\u62e9", (String)"CrossTaxListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
            for (Long pkid : applicationIdList) {
                linkQueryPkIdCollection.add((Object)new LinkQueryPkId((Object)pkid));
            }
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tcvat_prepay_application", null, (IFormView)this.getView(), customParams, (LinkQueryPkIdCollection)linkQueryPkIdCollection);
        }
        if ("report".equals(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            applicationCollection = QueryServiceHelper.query((String)"tcvat_prepay_application", (String)"declarenumber", (QFilter[])new QFilter[]{new QFilter("crossnumber", "in", checkNoList)});
            applicationIdList = applicationCollection.stream().filter(a -> StringUtil.isNotBlank((CharSequence)a.getString("declarenumber"))).map(a -> a.getString("declarenumber")).distinct().collect(Collectors.toList());
            if (applicationIdList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f34\u7533\u62a5\u8868\u5c1a\u672a\u751f\u6210, \u8bf7\u91cd\u65b0\u9009\u62e9", (String)"CrossTaxListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection reportCollection = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"id", (QFilter[])new QFilter[]{new QFilter("declareserialno", "in", applicationIdList)});
            List reportIdList = reportCollection.stream().map(a -> a.getLong("id")).distinct().collect(Collectors.toList());
            LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
            for (Long pkid : reportIdList) {
                linkQueryPkIdCollection.add((Object)new LinkQueryPkId((Object)pkid));
            }
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tcvat_prepay_declare_bill", null, (IFormView)this.getView(), customParams, (LinkQueryPkIdCollection)linkQueryPkIdCollection);
        }
    }
}

