/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.declare.query;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.tcvat.business.service.declare.DeclareShowService;

public class PrepayDeclareShowPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final Map<String, String> prepayPageMap = new HashMap<String, String>(16);

    public void registerListener(EventObject e) {
        this.addClickListeners(DeclareShowService.getTabKeys());
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DeclareShowService.initBaseData(customParams, this.getModel());
        this.getModel().setValue("declareserialno", customParams.get("declareserialno"));
        this.getModel().setValue("prepayproject", customParams.get("projectid"));
        DeclareShowService.setActiveTab("tabpageap1", this.getView(), prepayPageMap);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (Arrays.asList(DeclareShowService.getTabKeys()).contains(key)) {
            this.getView().getFormShowParameter().getCustomParams().put("taxPayerType", "zzsyjskb");
            DeclareShowService.setActiveTab(key, this.getView(), prepayPageMap);
        }
    }

    public void tabSelected(TabSelectEvent event) {
        this.getView().getFormShowParameter().getCustomParams().put("taxPayerType", "zzsyjskb");
        DeclareShowService.showTab(event.getTabKey(), this.getView(), prepayPageMap);
    }

    static {
        prepayPageMap.put("tabpageap1", "bdtaxr_declare_old");
        prepayPageMap.put("tabpageap2", "tcvat_project_accountlist");
        prepayPageMap.put("tabpageap4", "tcvat_prepay_rule_his");
    }
}

