/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.prepay.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.common.enums.SharingPlanOperateEnum;
import org.apache.commons.collections.CollectionUtils;

public class PrepaySharingPlanEdit
extends AbstractBillPlugIn
implements SelectRowsEventListener {
    private static final String ORG = "org";
    private static final String ITEM_CLOSE = "bar_close";
    private static final String systemType = "taxc-tcvat";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String PLANENTITY = "planentity";
    private static final String RULEENTITY = "ruleentity";
    private static final String PROJECTENTITY = "projectentity";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848", (String)"PrepaySharingPlanEdit_11", (String)systemType, (Object[])new Object[0]));
    }

    public void initialize() {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.addSelectRowsListener((SelectRowsEventListener)this);
        Toolbar toolbarMain = (Toolbar)this.getControl("tbmain");
        toolbarMain.addItemClickListener((ItemClickListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"flex_addorg", "vector_addorg", "label_addorg", "label_moreorg", "labelcreate"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = this.getOrgid(customParams);
        if (orgid != null) {
            this.getModel().setValue(ORG, orgid);
        }
        if ((org = (DynamicObject)this.getModel().getValue(ORG)) != null && !customParams.containsKey("initialized")) {
            String orgId = org.getString("id");
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put("orgid", orgId);
            custom.put("initialized", Boolean.TRUE);
            QFilter filter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId));
            DynamicObject plan = QueryServiceHelper.queryOne((String)"tcvat_prepay_sharingplan", (String)"id", (QFilter[])new QFilter[]{filter});
            if (plan != null) {
                this.showBill(plan.getLong("id"), custom);
            } else {
                this.showBill(null, custom);
            }
        }
    }

    public Object getOrgid(Map<String, Object> customParams) {
        DynamicObject dynamicObject;
        Object orgId = customParams.get("orgid");
        if (orgId != null) {
            return orgId;
        }
        if (this.getView().getParentView() != null && (dynamicObject = (DynamicObject)this.getView().getParentView().getModel().getValue(ORG)) != null) {
            return dynamicObject.getLong("id");
        }
        List orgs = OrgViewServiceHelper.getAllPermissionOrgs((String)"tcvat_prepay_sharingplan", (String)"10");
        if (orgs != null && !orgs.isEmpty()) {
            return ((Map)orgs.get(0)).get("id");
        }
        return RequestContext.get().getOrgId();
    }

    private void updateAddLableName() {
        DynamicObjectCollection projectentity = this.getModel().getEntryEntity(PROJECTENTITY);
        if (null == projectentity || projectentity.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_moreorg"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_addorg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_moreorg"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_addorg"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.resetPlanName(0);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(RULEENTITY);
        this.setFilter(entity);
    }

    public void afterBindData(EventObject e) {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.selectCard(Integer.valueOf(0));
        planentity.selectRowsChanged(Collections.singletonList(0), null);
        this.updateAddLableName();
        this.setVisible();
    }

    private void setVisible() {
        int row = this.getModel().getEntryRowCount(PLANENTITY);
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", PLANENTITY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", PLANENTITY});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (ORG.equals(e.getProperty().getName())) {
            this.getModel().setDataChanged(false);
            HashMap<String, Object> custom = new HashMap<String, Object>();
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (org != null && newValue != null && oldValue != null) {
                String orgid = org.getString("id");
                custom.put("orgid", orgid);
                QFilter filter = new QFilter(ORG, "=", (Object)Long.parseLong(orgid));
                DynamicObject plan = QueryServiceHelper.queryOne((String)"tcvat_prepay_sharingplan", (String)"id", (QFilter[])new QFilter[]{filter});
                if (plan != null) {
                    this.showBill(plan.getLong("id"), custom);
                } else {
                    this.showBill(null, custom);
                }
            } else if (newValue == null) {
                this.getModel().setValue(ORG, (Object)oldValue);
            }
        } else if ("planname".equals(e.getProperty().getName())) {
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            int[] selectRows = planentity.getSelectRows();
            if (selectRows.length > 0 && !"true".equals(this.getPageCache().get("refresh"))) {
                this.getModel().setValue("name", e.getChangeSet()[0].getNewValue(), selectRows[0]);
            }
            this.updateAddLableName();
        } else if ("prepayproject".equals(e.getProperty().getName())) {
            this.updateAddLableName();
        }
    }

    private void showBill(Object pkId, Map<String, Object> customParams) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        billShowParameter.getCustomParams().putAll(customParams);
        if (pkId != null) {
            billShowParameter.setPkId(pkId);
            this.getModel().setValue("id", pkId);
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
            billShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            billShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().invokeOperation("refresh");
    }

    private void refreshRuleList() {
        BillList list = (BillList)this.getControl("billlistap");
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(RULEENTITY);
        if (entity != null) {
            for (DynamicObject object : entity) {
                ids.add(object.getLong("ruleid"));
            }
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        filterParameter.setFilter(idsFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        filterParameter.setFilter(enableFilter);
        list.setFilterParameter((FilterParameter)filterParameter);
        list.refreshData();
    }

    private void setFilter(DynamicObjectCollection entity) {
        BillList list = (BillList)this.getControl("billlistap");
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (entity != null) {
            for (DynamicObject object : entity) {
                ids.add(object.getLong("ruleid"));
            }
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        filterParameter.setFilter(idsFilter);
        list.setFilterParameter((FilterParameter)filterParameter);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Vector && "vector_addorg".equals(((Vector)source).getKey()) || source instanceof Label && "label_addorg".equals(((Label)source).getKey()) || source instanceof Label && "label_moreorg".equals(((Label)source).getKey()) || source instanceof Container && "flex_addorg".equals(((Container)source).getKey())) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            this.showProjectSelect();
        } else if (source instanceof Label && "labelcreate".equals(((Label)source).getKey())) {
            Button button = (Button)this.getControl("button_addplan");
            button.click();
        }
    }

    private void showProjectSelect() {
        DynamicObject org;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u88ab\u5171\u4eab\u7684\u9879\u76ee", (String)"PrepaySharingPlanEdit_0", (String)systemType, (Object[])new Object[0]));
        Optional<DynamicObject> optional = this.getModel().getEntryEntity(PLANENTITY).stream().filter(s -> this.isCurrentSelect(s.getInt("seq") - 1)).findFirst();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("caption", ResManager.loadKDString((String)"\u9009\u62e9\u88ab\u5171\u4eab\u7684\u9879\u76ee", (String)"PrepaySharingPlanEdit_0", (String)systemType, (Object[])new Object[0]));
        if (optional.isPresent()) {
            DynamicObject planentity = optional.get();
            DynamicObjectCollection projectentity = planentity.getDynamicObjectCollection(PROJECTENTITY);
            Object[] prepayprojects = projectentity.stream().map(p -> p.get("prepayproject.id")).toArray();
            customParams.put("selected", prepayprojects);
        }
        if ((org = (DynamicObject)this.getModel().getValue(ORG)) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PrepaySharingPlanEdit_1", (String)systemType, (Object[])new Object[0]));
            return;
        }
        parameter.setFormId("tcvat_select_prepayprj");
        parameter.getOpenStyle().setShowType(ShowType.NonModal);
        parameter.setCustomParams(customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tcvat_select_prepayprj"));
        this.getView().showForm(parameter);
    }

    private boolean checkPlanNotSelected() {
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] selectedRows = planentity.getSelectRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5171\u4eab\u65b9\u6848\u88ab\u9009\u4e2d\uff0c\u8bf7\u5148\u6dfb\u52a0\u5171\u4eab\u65b9\u6848\u3002", (String)"PrepaySharingPlanEdit_2", (String)systemType, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        if (newRows != null && newRows.size() > 0) {
            Integer startRowIndex = (Integer)newRows.get(0);
            this.resetPlanName(startRowIndex);
        }
        this.updateAddLableName();
        this.refreshRuleList();
    }

    private void resetPlanName(Integer startRowIndex) {
        DynamicObject[] planentities;
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        if ((planentities = this.getModel().getEntryEntity(PLANENTITY, startRowIndex.intValue(), startRowIndex + 1)) != null && planentities.length > 0) {
            this.getModel().setValue("planname", (Object)planentities[0].getString("name"));
        } else {
            this.getModel().setValue("planname", (Object)"");
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (e.getEntryProp().getName().equals(PLANENTITY)) {
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (rowDataEntities != null && rowDataEntities.length > 0) {
                int rowIndex = rowDataEntities[0].getRowIndex();
                planentity.selectCard(Integer.valueOf(rowIndex));
                planentity.selectRowsChanged(Collections.singletonList(rowIndex), null);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals(PLANENTITY)) {
            this.resetPlanName(e.getRowIndexs()[0] - 1);
            this.refreshRuleList();
            this.updateAddLableName();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        EntryGrid planentity;
        int[] rows;
        Object[] ids;
        if ("tcvat_select_prepayprj".equals(evt.getActionId())) {
            Object[] prjIds = (Object[])evt.getReturnData();
            if (prjIds != null) {
                EntryGrid planentity2 = (EntryGrid)this.getControl(PLANENTITY);
                int[] selectRows = planentity2.getSelectRows();
                int planIndex = selectRows[0];
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, planIndex);
                this.getModel().deleteEntryData(PROJECTENTITY);
                for (Object id : prjIds) {
                    int index = this.getModel().createNewEntryRow(PROJECTENTITY);
                    this.getModel().setValue("prepayproject", id, index, planIndex);
                }
            }
        } else if ("tcvat_select_pre_rule".equals(evt.getActionId()) && (ids = (Object[])evt.getReturnData()) != null && (rows = (planentity = (EntryGrid)this.getControl(PLANENTITY)).getSelectRows()) != null && rows.length > 0) {
            int planindex = rows[0];
            this.getModel().deleteEntryData(RULEENTITY);
            for (Object id : ids) {
                int ruleindex = this.getModel().createNewEntryRow(RULEENTITY);
                this.getModel().setValue("ruleid", id, ruleindex, planindex);
            }
            this.refreshRuleList();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DeleteEntry deleteEntry;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            int planCount = this.getModel().getEntryRowCount(PLANENTITY);
            if (planCount == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"PrepaySharingPlanEdit_3", (String)systemType, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection planentity = this.getModel().getEntryEntity(PLANENTITY);
            HashSet<String> planMap = new HashSet<String>(planentity.size());
            for (int row = 0; row < planentity.size(); ++row) {
                String errMsg;
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, row);
                int orgCount = this.getModel().getEntryRowCount(PROJECTENTITY);
                String planName = ((DynamicObject)planentity.get(row)).getString("name");
                if (StringUtils.isBlank((CharSequence)planName)) {
                    errMsg = ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u65b9\u6848\u540d\u79f0\u3002", (String)"PrepaySharingPlanEdit_4", (String)systemType, (Object[])new Object[0]);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    EntryGrid entrye = (EntryGrid)this.getControl(PLANENTITY);
                    int[] selectRows = entrye.getSelectRows();
                    if (selectRows.length > 0) {
                        this.getModel().setEntryCurrentRowIndex(PLANENTITY, selectRows[0]);
                    }
                    return;
                }
                if (planMap.contains(planName)) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\uff08%s\uff09\u91cd\u590d\uff0c\u8bf7\u8bbe\u7f6e\u4e0d\u540c\u7684\u65b9\u6848\u540d\u79f0\u3002", (String)"PrepaySharingPlanEdit_5", (String)systemType, (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    EntryGrid entrye = (EntryGrid)this.getControl(PLANENTITY);
                    int[] selectRows = entrye.getSelectRows();
                    if (selectRows.length > 0) {
                        this.getModel().setEntryCurrentRowIndex(PLANENTITY, selectRows[0]);
                    }
                    return;
                }
                planMap.add(planName);
                if (orgCount == 0) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u88ab\u5171\u4eab\u8303\u56f4\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u88ab\u5171\u4eab\u7684\u8303\u56f4\u3002", (String)"PrepaySharingPlanEdit_6", (String)systemType, (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    EntryGrid entrye = (EntryGrid)this.getControl(PLANENTITY);
                    int[] selectRows = entrye.getSelectRows();
                    if (selectRows.length > 0) {
                        this.getModel().setEntryCurrentRowIndex(PLANENTITY, selectRows[0]);
                    }
                    return;
                }
                DynamicObjectCollection ruleentity = this.getModel().getEntryEntity(RULEENTITY);
                if (!ruleentity.isEmpty()) continue;
                String errMsg2 = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u5171\u4eab\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5171\u4eab\u89c4\u5219\u3002", (String)"PrepaySharingPlanEdit_7", (String)systemType, (Object[])new Object[0]), planName);
                this.getView().showErrorNotification(errMsg2);
                args.setCancel(true);
                EntryGrid entrye = (EntryGrid)this.getControl(PLANENTITY);
                int[] selectRows = entrye.getSelectRows();
                if (selectRows.length > 0) {
                    this.getModel().setEntryCurrentRowIndex(PLANENTITY, selectRows[0]);
                }
                return;
            }
            EntryGrid entrye = (EntryGrid)this.getControl(PLANENTITY);
            this.getModel().setEntryCurrentRowIndex(PLANENTITY, entrye.getSelectRows()[0]);
        } else if (args.getSource() instanceof Refresh) {
            this.getPageCache().put("refresh", "true");
        } else if (args.getSource() instanceof DeleteEntry && "deleteproject".equals((deleteEntry = (DeleteEntry)args.getSource()).getOperateKey())) {
            args.setCancel(true);
            EntryGrid entrye = (EntryGrid)this.getControl(PROJECTENTITY);
            String orgName = this.getModel().getEntryRowEntity(PROJECTENTITY, entrye.getSelectRows()[0]).getString("prepayproject.name");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("projectDeleteConform", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PrepaySharingPlanEdit_8", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"PrepaySharingPlanEdit_9", (String)systemType, (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u5c06\u201c%1$s\u201d\u4ece\u201c%2$s\u201d\u65b9\u6848\u7684\u5171\u4eab\u8303\u56f4\u4e2d\u5254\u9664\uff1f", (String)"PrepaySharingPlanEdit_10", (String)systemType, (Object[])new Object[0]), orgName, this.getModel().getValue("planname"));
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    private boolean isCurrentSelect(int row) {
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] rows = planentity.getSelectRows();
        return Arrays.stream(rows).allMatch(s -> s == row);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Map<String, String> operateMap;
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("selectrule")) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put("orgid", ((DynamicObject)this.getModel().getValue(ORG)).get("id"));
            DynamicObjectCollection ruleentity = this.getModel().getEntryEntity(RULEENTITY);
            custom.put(RULEENTITY, ruleentity);
            ArrayList<Long> ids = new ArrayList<Long>();
            if (ruleentity != null) {
                for (DynamicObject object : ruleentity) {
                    ids.add(object.getLong("ruleid"));
                }
            }
            custom.put("selected", ids);
            DynamicObjectCollection projectentity = this.getModel().getEntryEntity(PROJECTENTITY);
            if (projectentity != null && !projectentity.isEmpty()) {
                Set prepayTypeSet = projectentity.stream().map(o -> o.getString("prepayproject.prepaytype")).collect(Collectors.toSet());
                custom.put("prepayTypeSet", prepayTypeSet);
            }
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_select_pre_rule", (IFormView)this.getView(), custom, (IFormPlugin)this);
        } else if (args.getSource() instanceof DeleteEntry) {
            DeleteEntry deleteEntry = (DeleteEntry)args.getSource();
            if ("deleteplan".equals(deleteEntry.getOperateKey())) {
                DynamicObject dynamicObject = this.getModel().getDataEntity(true);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                Map<String, String> operateMap2 = SharingPlanOperateEnum.getOperateMap(args.getOperateKey());
                if (!operateMap2.isEmpty() && this.getModel().getValue(ORG) != null) {
                    OperatorDialogUtils.operateDialog((String)"zzs", (String)"tcvat_prepay_sharingplan", (String)operateMap2.get("name"), (String)String.format(operateMap2.get("description"), ((DynamicObject)this.getModel().getValue(ORG)).getString("name")));
                }
            }
        } else if (args.getOperateKey().equals("refresh")) {
            if ("true".equals(this.getPageCache().get("refresh"))) {
                this.getPageCache().put("refresh", "false");
            }
        } else if (args.getOperateKey().equals("save") && !(operateMap = SharingPlanOperateEnum.getOperateMap(args.getOperateKey())).isEmpty() && this.getModel().getValue(ORG) != null) {
            OperatorDialogUtils.operateDialog((String)"zzs", (String)"tcvat_prepay_sharingplan", (String)operateMap.get("name"), (String)String.format(operateMap.get("description"), ((DynamicObject)this.getModel().getValue(ORG)).getString("name")));
        }
        this.setVisible();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String resultMsg;
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)ITEM_CLOSE) && StringUtil.isNotBlank((CharSequence)(resultMsg = this.checkChangeData()))) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ITEM_CLOSE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"PrepaySharingPlanEdit_12", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"PrepaySharingPlanEdit_13", (String)systemType, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PrepaySharingPlanEdit_14", (String)systemType, (Object[])new Object[0]);
            this.getView().showConfirm(msg, resultMsg, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    private String checkChangeData() {
        DynamicObjectCollection planCollection = this.getModel().getEntryEntity(PLANENTITY);
        if (planCollection.isEmpty()) {
            return "";
        }
        StringBuilder msg = new StringBuilder();
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((String)"tcvat_prepay_sharingplan", (String)"id,name,autoshar,creator,createtime,ruleentity,ruleentity.ruleid,ruleentity.id,projectentity,projectentity.orgid,orgentity.prepayproject", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue("id"))});
        if (Objects.isNull(plan)) {
            String name = ResManager.loadKDString((String)"\u65b0\u589e\u5171\u4eab\u65b9\u6848\u5747\u672a\u4fdd\u5b58\uff01", (String)"PrepaySharingPlanEdit_15", (String)systemType, (Object[])new Object[0]);
            msg.append(name);
            return msg.toString();
        }
        Map<String, DynamicObject> oldPlanMap = plan.getDynamicObjectCollection(PLANENTITY).stream().collect(Collectors.toMap(a -> a.getString("id"), b -> b));
        for (DynamicObject newPlan : planCollection) {
            String name;
            StringBuilder words = new StringBuilder();
            String newName = newPlan.getString("name");
            String id = newPlan.getString("id");
            if (!oldPlanMap.containsKey(id)) {
                String name2 = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u4e3a\u65b0\u589e\u65b9\u6848\u8fd8\u672a\u4fdd\u5b58\uff01", (String)"PrepaySharingPlanEdit_16", (String)systemType, (Object[])new Object[0]), newName);
                if (StringUtil.isBlank((CharSequence)msg)) {
                    msg.append(name2);
                    continue;
                }
                msg.append(SEPARATOR).append(name2);
                continue;
            }
            DynamicObject oldPlan = oldPlanMap.get(id);
            List ruleEntityList = oldPlan.getDynamicObjectCollection(RULEENTITY).stream().map(o -> o.getString("ruleid")).collect(Collectors.toList());
            List projectEntityList = oldPlan.getDynamicObjectCollection(PROJECTENTITY).stream().map(o -> o.getString("id")).collect(Collectors.toList());
            String oldName = oldPlan.getString("name");
            ArrayList ruleList = new ArrayList();
            DynamicObjectCollection ruleCol = newPlan.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().forEach(ruleRow -> ruleList.add(ruleRow.getString("ruleid")));
            List projectList = newPlan.getDynamicObjectCollection(PROJECTENTITY).stream().map(e -> e.getString("id")).collect(Collectors.toList());
            if (!newName.equals(oldName)) {
                name = ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"PrepaySharingPlanEdit_17", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!CollectionUtils.isEqualCollection(ruleList, ruleEntityList)) {
                name = ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u5361\u7247", (String)"PrepaySharingPlanEdit_18", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!CollectionUtils.isEqualCollection(projectList, projectEntityList)) {
                name = ResManager.loadKDString((String)"\u88ab\u5171\u4eab\u8303\u56f4", (String)"PrepaySharingPlanEdit_19", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            name = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u53d8\u66f4\u5b57\u6bb5\uff1a", (String)"PrepaySharingPlanEdit_20", (String)systemType, (Object[])new Object[0]), newName);
            if (!StringUtil.isNotBlank((CharSequence)words)) continue;
            words.deleteCharAt(words.lastIndexOf(","));
            if (StringUtil.isBlank((CharSequence)msg)) {
                msg.append(name).append((CharSequence)words);
                continue;
            }
            msg.append(SEPARATOR).append(name).append((CharSequence)words);
        }
        return msg.toString();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (org.apache.commons.lang.StringUtils.equals((String)"projectDeleteConform", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                EntryGrid entrye = (EntryGrid)this.getControl(PROJECTENTITY);
                this.getModel().deleteEntryRows(PROJECTENTITY, entrye.getSelectRows());
                this.updateAddLableName();
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                return;
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)ITEM_CLOSE) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().close();
        }
    }
}

