/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rollout.apportion;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.IncomeEngine;
import kd.taxc.tcvat.business.service.transfer.apportion.InputApportionService;

public class InputApportionDialogPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(InputApportionDialogPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String PAGE_ACCOUNT_SUMMARY = "tcvat_account_summary";
    private static final String ROLLOUT_DETAIL_ENTITY = "tcvat_rollout_register";
    private static final String COMMON_FIELDS = "id,registercoshareid, org,modifier,apportiontype,createtime,rollouttaxperiod,consumertype,rollouttype,remark,currentregistertaxamount,projectincome,incomesummary,apportionrate,apportiontaxamount";
    private static final String FIELD_SEPARATER = ",";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String source = (String)showParameter.getCustomParam("source");
        if ("apportioncalculate".equals(source)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u644a\u8ba1\u7b97", (String)"InputApportionDialogPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if ("undoapportion".equals(source)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u644a", (String)"InputApportionDialogPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List idList = (List)customParams.get("idList");
        QFilter qFilter = new QFilter("id", "in", (Object)idList.stream().map(Long::parseLong).toArray());
        IDataModel model = this.getModel();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ROLLOUT_DETAIL_ENTITY, (String)COMMON_FIELDS, (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects.size() > 0) {
            HashMap<String, QFilter> paramMap = new HashMap<String, QFilter>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                QFilter orgFilter = new QFilter("org", "=", (Object)dynamicObject.getLong("org"));
                QFilter qFilter2 = new QFilter("taxperiod", "=", (Object)dynamicObject.getString("rollouttaxperiod"));
                paramMap.put(dynamicObject.getString("org") + FIELD_SEPARATER + dynamicObject.getString("rollouttaxperiod") + FIELD_SEPARATER + dynamicObject.getString("rollouttype"), orgFilter.and(qFilter2));
            }
            HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(16);
            ArrayList<String> errors = new ArrayList<String>(16);
            for (Map.Entry entry : paramMap.entrySet()) {
                String[] initParams = ((String)entry.getKey()).split(FIELD_SEPARATER);
                BigDecimal incomeSummary = new BigDecimal(0);
                BigDecimal projectIncome = new BigDecimal(0);
                DynamicObjectCollection dynamicIncomeSummary = QueryServiceHelper.query((String)PAGE_ACCOUNT_SUMMARY, (String)"sum(taxamount) as taxamount", (QFilter[])new QFilter[]{(QFilter)entry.getValue()});
                if (dynamicIncomeSummary.size() == 0) {
                    DynamicObjectCollection dynamicProjectIncome;
                    IncomeEngine engine = new IncomeEngine();
                    try {
                        String taxPeriod = initParams[1];
                        Date date = DateUtils.stringToDate((String)taxPeriod, (String)"yyyy-MM");
                        TcvatEngineModel engineModel = TaxDeclareHelper.buildEngineModel(initParams[0], DateUtils.getFirstDateOfMonthStr((Date)date, (String)"yyyy-MM-dd"), DateUtils.getLastDateOfMonthStr((Date)date, (String)"yyyy-MM-dd"), "zzsybnsr", null, "nssb");
                        engineModel.addCustom("taxperiod", taxPeriod);
                        engine.setEngineModel(engineModel);
                        engine.call();
                    }
                    catch (Exception ex) {
                        errors.add(ThrowableHelper.toString((Exception)ex));
                    }
                    dynamicIncomeSummary = QueryServiceHelper.query((String)PAGE_ACCOUNT_SUMMARY, (String)"sum(taxamount) as taxamount", (QFilter[])new QFilter[]{(QFilter)entry.getValue()});
                    if (dynamicIncomeSummary.size() > 0) {
                        incomeSummary = ((DynamicObject)dynamicIncomeSummary.get(0)).getBigDecimal(0);
                    }
                    QFilter taxMethodFilter = new QFilter("taxmethod", "=", (Object)ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536", (String)"InputApportionDialogPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0])).or(new QFilter("taxmethod", "=", (Object)ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536", (String)"InputApportionDialogPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0])));
                    if ("1".equals(initParams[2])) {
                        taxMethodFilter = new QFilter("taxmethod", "=", (Object)ResManager.loadKDString((String)"\u514d\u7a0e", (String)"InputApportionDialogPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]));
                    }
                    if ((dynamicProjectIncome = QueryServiceHelper.query((String)PAGE_ACCOUNT_SUMMARY, (String)"sum(taxamount) as taxamount", (QFilter[])new QFilter[]{(QFilter)entry.getValue(), taxMethodFilter})).size() > 0) {
                        projectIncome = ((DynamicObject)dynamicProjectIncome.get(0)).getBigDecimal(0);
                    }
                } else {
                    incomeSummary = ((DynamicObject)dynamicIncomeSummary.get(0)).getBigDecimal(0);
                    QFilter taxMethodFilter = new QFilter("taxmethod", "=", (Object)ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536", (String)"InputApportionDialogPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0])).or(new QFilter("taxmethod", "=", (Object)ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536", (String)"InputApportionDialogPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0])));
                    DynamicObjectCollection dynamicProjectIncome = QueryServiceHelper.query((String)PAGE_ACCOUNT_SUMMARY, (String)"sum(taxamount) as taxamount", (QFilter[])new QFilter[]{(QFilter)entry.getValue(), taxMethodFilter});
                    if (dynamicProjectIncome.size() > 0) {
                        projectIncome = ((DynamicObject)dynamicProjectIncome.get(0)).getBigDecimal(0);
                    }
                }
                dataMap.put((String)entry.getKey() + "projectIncome", projectIncome);
                dataMap.put((String)entry.getKey() + "incomeSummary", incomeSummary);
            }
            logger.error(((Object)errors).toString());
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", dynamicObjects.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("registercoshareid", dynamicObject.get("registercoshareid"), rowIndex);
                model.setValue("org", dynamicObject.get("org"), rowIndex);
                model.setValue("apportioncreatetime", dynamicObject.get("createtime"), rowIndex);
                model.setValue("modifier", dynamicObject.get("modifier"), rowIndex);
                model.setValue("rollouttaxperiod", dynamicObject.get("rollouttaxperiod"), rowIndex);
                model.setValue("consumertype", dynamicObject.get("consumertype"), rowIndex);
                model.setValue("rollouttype", dynamicObject.get("rollouttype"), rowIndex);
                model.setValue("apportionremark", dynamicObject.get("remark"), rowIndex);
                model.setValue("currentregistertaxamount", dynamicObject.get("currentregistertaxamount"), rowIndex);
                BigDecimal projectIncome = (BigDecimal)dataMap.get(dynamicObject.getString("org") + FIELD_SEPARATER + dynamicObject.getString("rollouttaxperiod") + FIELD_SEPARATER + dynamicObject.getString("rollouttype") + "projectIncome");
                BigDecimal incomeSummary = (BigDecimal)dataMap.get(dynamicObject.getString("org") + FIELD_SEPARATER + dynamicObject.getString("rollouttaxperiod") + FIELD_SEPARATER + dynamicObject.getString("rollouttype") + "incomeSummary");
                model.setValue("projectincome", (Object)projectIncome, rowIndex);
                model.setValue("incomesummary", (Object)incomeSummary, rowIndex);
                BigDecimal rate = new BigDecimal("0.00");
                if (incomeSummary.compareTo(BigDecimal.ZERO) != 0) {
                    rate = projectIncome.divide(incomeSummary, 6, 4);
                }
                model.setValue("apportionrate", (Object)(rate.multiply(new BigDecimal(100)).setScale(2, 4) + "%"), rowIndex);
                BigDecimal apportionTaxAmount = dynamicObject.getBigDecimal("currentregistertaxamount").multiply(rate).setScale(2, 4);
                model.setValue("apportiontaxamount", (Object)apportionTaxAmount, rowIndex);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        int index = changeData.getRowIndex();
        Object projectIncome = this.getModel().getValue("projectincome", index);
        Object incomeSummary = this.getModel().getValue("incomesummary", index);
        Object apportionRate = this.getModel().getValue("apportionrate", index);
        Object currentSignTaxAmount = this.getModel().getValue("currentregistertaxamount");
        if (StringUtils.equals((CharSequence)"projectincome", (CharSequence)propertyName)) {
            if (BigDecimalUtil.setScale((Object)newValue).compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u6536\u5165\u4e0d\u5141\u8bb8\u4fee\u6539\u4e3a\u8d1f\u6570", (String)"InputApportionDialogPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            projectIncome = newValue;
        }
        if (StringUtils.equals((CharSequence)"incomesummary", (CharSequence)propertyName)) {
            if (BigDecimalUtil.setScale((Object)newValue).compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u5165\u603b\u989d\u4e0d\u5141\u8bb8\u4fee\u6539\u4e3a\u8d1f\u6570", (String)"InputApportionDialogPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            incomeSummary = newValue;
        }
        Object object = apportionRate = BigDecimalUtil.divideObject((Object)projectIncome, (Object)incomeSummary, (int)6, (int)4) == null ? Integer.valueOf(0) : BigDecimalUtil.divideObject((Object)projectIncome, (Object)incomeSummary, (int)6, (int)4);
        if (BigDecimalUtil.setScale((Object)apportionRate).compareTo(new BigDecimal("1.00")) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5212\u5206\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e1", (String)"InputApportionDialogPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("apportiontaxamount", (Object)BigDecimalUtil.multiplyObject((Object)currentSignTaxAmount, (Object)apportionRate, (int)2, (int)4), index);
        apportionRate = BigDecimalUtil.multiplyObject((Object)apportionRate, (Object)100, (int)2, (int)4) + "%";
        this.getModel().setValue("apportionrate", apportionRate, index);
    }

    public void click(EventObject evt) {
        DynamicObject dynamicObject;
        int i;
        Control control = (Control)evt.getSource();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u4fdd\u5b58\u7684\u5206\u644a\u8ba1\u7b97\u6570\u636e", (String)"InputApportionDialogPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        boolean flag = true;
        for (i = 0; i < rows.length; ++i) {
            dynamicObject = this.getModel().getEntryRowEntity("entryentity", rows[i]);
            BigDecimal projectIncome = dynamicObject.getBigDecimal("projectincome");
            BigDecimal incomeSummary = dynamicObject.getBigDecimal("incomesummary");
            if (projectIncome.compareTo(BigDecimal.ZERO) >= 0 && incomeSummary.compareTo(BigDecimal.ZERO) >= 0) continue;
            flag = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e2d\u5b58\u5728\u9879\u76ee\u6536\u5165\u6216\u6536\u5165\u603b\u989d\u662f\u8d1f\u6570\u7684\u60c5\u51b5\uff0c\u8be5\u884c\u6570\u636e\u4e0d\u652f\u6301\u5206\u644a\u8ba1\u7b97\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u6216\u5220\u9664\u8be5\u6570\u636e\u518d\u8fdb\u884c\u5206\u644a\u8ba1\u7b97\u3002", (String)"InputApportionDialogPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        if (flag) {
            for (i = 0; i < rows.length; ++i) {
                dynamicObject = this.getModel().getEntryRowEntity("entryentity", rows[i]);
                BigDecimal apportionTaxAmount = dynamicObject.getBigDecimal("apportiontaxamount");
                BigDecimal currentRegisterTaxAmount = dynamicObject.getBigDecimal("currentregistertaxamount");
                if (apportionTaxAmount.compareTo(BigDecimal.ZERO) > 0 && apportionTaxAmount.compareTo(currentRegisterTaxAmount) <= 0) continue;
                flag = false;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u644a\u7a0e\u989d\u5e94\u5927\u4e8e0\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u672c\u6b21\u767b\u8bb0\u7a0e\u989d\uff0c\u8bf7\u4fee\u6539\u6570\u636e", (String)"InputApportionDialogPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        int isvoucherCount = 0;
        if (flag) {
            for (int i2 = 0; i2 < rows.length; ++i2) {
                DynamicObject object = this.getModel().getEntryRowEntity("entryentity", rows[i2]);
                DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle((Object)object.getLong("id"), (String)ROLLOUT_DETAIL_ENTITY);
                if (dynamicObjects.getBoolean("isvoucher")) {
                    ++isvoucherCount;
                    continue;
                }
                list.add(this.getModel().getEntryRowEntity("entryentity", rows[i2]));
            }
        }
        if (BTN_OK.equals(control.getKey())) {
            if (!CollectionUtils.isEmpty(list)) {
                InputApportionService.saveApportionCalcData(list);
                this.getView().close();
            }
            if (isvoucherCount > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u4e0b\u63a8\u51ed\u8bc1\u7684\u6570\u636e, \u4e0d\u5141\u8bb8\u53d8\u66f4\u64cd\u4f5c", (String)"InputApportionDialogPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
    }
}

