/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.common.enums.RuleTypeStrategyEnum;

public abstract class AbstractRuleCollectTreeListPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    protected static final String PRIVATE_STR = "private";
    protected static final String PUBLIC_STR = "public";
    protected static final String COPY = "copy";
    protected static final String ALLOCATIONSHAREPLAN = "allocationshareplan";
    protected final RuleService ruleService = new RuleService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long parent = Long.valueOf(customParams.get("parent").toString());
        this.getTreeModel().getTreeFilter().add(new QFilter("parent", "=", (Object)parent));
        ((TreeListModel)this.getTreeModel()).getQueryParas().put("order", "createtime asc");
        TreeNode root = this.getTreeModel().getRoot();
        root.setText(this.getRootNodeName());
        super.refreshNode(e);
    }

    public String getRootNodeName() {
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractRuleCollectTreeListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams.get("orgid")) {
            return;
        }
        List commonFilters = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.startsWith("org.")) continue;
            filterColumn.setDefaultValues(new Object[]{customParams.get("orgid")});
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().contains("org")) {
            OrgUtils.listFilterByIsTaxpayerAndEnableAndAudit((BeforeFilterF7SelectEvent)args);
        }
    }

    public void setFilter(SetFilterEvent e) {
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currentNode = root.getTreeNode(currentNodeId, 100);
        if (root.getId().equals(currentNode.getId())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long parent = Long.valueOf(customParams.get("parent").toString());
            QFilter qFilter = new QFilter("group.parent", "=", (Object)parent);
            e.getQFilters().add(qFilter);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(String.valueOf(this.getTreeModel().getCurrentNodeId()));
        if (this.getTreeModel().getRoot().getId().equals(currentNode.getId())) {
            return;
        }
        List<IListColumn> customListColumn = RuleTypeStrategyEnum.getStrategyByGroupId(currentNode.getId()).getListColumnByRuleType();
        List listColumns = args.getListColumns();
        listColumns.addAll(6, customListColumn);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            String operationKey = ((Donothing)args.getSource()).getOperateKey();
            if (ALLOCATIONSHAREPLAN.equals(operationKey)) {
                Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                DynamicObjectCollection ruleCollection = QueryServiceHelper.query((String)"tcvat_all_rule_config", (String)"org,taxpayertype,ruletype,deductproject", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
                HashSet<String> orgidSet = new HashSet<String>(8);
                HashSet<String> taxPayerTypeSet = new HashSet<String>(2);
                boolean hasPrivateRule = false;
                boolean hasSjkceDiffRule = false;
                for (DynamicObject dynamicObject : ruleCollection) {
                    orgidSet.add(dynamicObject.getString("org"));
                    taxPayerTypeSet.add(dynamicObject.getString("taxpayertype"));
                    if (PRIVATE_STR.equals(dynamicObject.getString("ruletype"))) {
                        hasPrivateRule = true;
                    }
                    if (!"bqsjkce".equals(dynamicObject.getString("deductproject"))) continue;
                    hasSjkceDiffRule = true;
                }
                if (orgidSet.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u521b\u5efa\u7ec4\u7ec7\u7684\u53ef\u5206\u914d\u89c4\u5219\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractRuleCollectTreeListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                if (hasPrivateRule) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81ea\u7528\u89c4\u5219\u4e0d\u80fd\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractRuleCollectTreeListPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                if (taxPayerTypeSet.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7eb3\u7a0e\u4eba\u7c7b\u578b\u4e00\u81f4\u7684\u53d6\u6570\u89c4\u5219\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u3002", (String)"AbstractRuleCollectTreeListPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                if (hasSjkceDiffRule) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6263\u9664\u9879\u76ee\u201d=\u201c\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u201d\u7684\u89c4\u5219\u914d\u7f6e\u6682\u4e0d\u652f\u6301\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002\u5982\u60f3\u5c06\u201c\u6263\u9664\u9879\u76ee\u201d=\u201c\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u201d\u7684\u89c4\u5219\u914d\u7f6e\u5171\u4eab\uff0c\u8bf7\u5230\u201c\u589e\u503c\u7a0e>\u57fa\u7840\u8bbe\u7f6e>\u7533\u62a5\u89c4\u5219\u5171\u4eab\u65b9\u6848\u201d\u4e2d\u914d\u7f6e\u3002", (String)"AbstractRuleCollectTreeListPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)this.sharePlanFormId(), (boolean)true);
                listShowParameter.setCustomParam("ruleidarray", Arrays.asList(primaryKeyValues));
                QFilter taxPayerTypeFilter = new QFilter("taxpayertype", "=", (Object)((DynamicObject)ruleCollection.get(0)).getString("taxpayertype"));
                QFilter createOrgFilter = new QFilter("createorg", "=", (Object)((DynamicObject)ruleCollection.get(0)).getLong("org"));
                listShowParameter.getListFilterParameter().setFilter(taxPayerTypeFilter);
                listShowParameter.getListFilterParameter().setFilter(createOrgFilter);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ALLOCATIONSHAREPLAN));
                this.getView().showForm((FormShowParameter)listShowParameter);
                return;
            }
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            if (PRIVATE_STR.equals(operationKey) || PUBLIC_STR.equals(operationKey)) {
                String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
                TreeNode root = this.getTreeModel().getRoot();
                TreeNode currentNode = root.getTreeNode(currentNodeId, 100);
                if (root.getId().equals(currentNode.getId())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219\u5206\u7ec4\u5b50\u8282\u70b9\u3002", (String)"AbstractRuleCollectTreeListPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String formId = RuleTypeStrategyEnum.getStrategyByGroupId(currentNodeId).getFormId();
                baseShowParameter.setCustomParam("groupId", (Object)currentNodeId);
                baseShowParameter.setFormId(formId);
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                baseShowParameter.setStatus(OperationStatus.ADDNEW);
                baseShowParameter.getShowParameter().getCustomParams().put("ruletype", operationKey);
                Long createOrgId = this.getCreateOrgId();
                baseShowParameter.getShowParameter().getCustomParams().put("createorg", createOrgId);
                if (createOrgId.compareTo(0L) != 0 && !this.checkBeforeAddRule(createOrgId, operationKey, formId)) {
                    return;
                }
                this.getView().showForm((FormShowParameter)baseShowParameter);
                return;
            }
            if (COPY.equals(operationKey)) {
                Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                if (primaryKeyValues.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"AbstractRuleCollectTreeListPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                DynamicObject ruleObject = QueryServiceHelper.queryOne((String)"tcvat_sbx_rule_config", (String)"ruletype,group,org", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValues[0])});
                String formId = RuleTypeStrategyEnum.getStrategyByGroupId(ruleObject.getString("group")).getFormId();
                long orgid = ruleObject.getLong("org");
                if (((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgid).getData()).booleanValue()) {
                    baseShowParameter.getShowParameter().getCustomParams().put("createorg", orgid);
                }
                baseShowParameter.setFormId(formId);
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                baseShowParameter.setStatus(OperationStatus.ADDNEW);
                baseShowParameter.getShowParameter().getCustomParams().put("iscopy", Boolean.TRUE);
                baseShowParameter.getShowParameter().getCustomParams().put("isCopyRelateEntity", Boolean.FALSE);
                baseShowParameter.getShowParameter().getCustomParams().put("CopyEmptyRow", Boolean.FALSE);
                baseShowParameter.getShowParameter().getCustomParams().put("ruletype", ruleObject.getString("ruletype"));
                baseShowParameter.setPkId(primaryKeyValues[0]);
                this.getView().showForm((FormShowParameter)baseShowParameter);
                return;
            }
        }
    }

    protected boolean checkBeforeAddRule(Long createOrgId, String ruleType, String formId) {
        return true;
    }

    public Long getCreateOrgId() {
        List selectedMainOrgIds = this.getSelectedMainOrgIds();
        Long orgId = selectedMainOrgIds.size() != 1 ? Long.valueOf(RequestContext.get().getOrgId()) : (Long)selectedMainOrgIds.get(0);
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId).getData()).booleanValue()) {
            TaxResult orgIdList;
            orgId = 0L;
            TaxResult result = PermDataServiceHelper.getUserHasPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"40");
            if (null != result && ((List)result.getData()).size() > 0 && (orgIdList = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds((List)((List)result.getData()))).isSuccess() && ((List)orgIdList.getData()).size() > 0) {
                orgId = ((DynamicObject)((List)orgIdList.getData()).get(0)).getLong("taxorg.id");
            }
        }
        return orgId;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (ALLOCATIONSHAREPLAN.equals(closedCallBackEvent.getActionId())) {
            DynamicObject[] sharePlanArray;
            Object returnData = closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            BillList list = (BillList)this.getControl("billlistap");
            Object[] ruleIds = list.getSelectedRows().getPrimaryKeyValues();
            List sharePlanSelectedRow = (List)closedCallBackEvent.getReturnData();
            List sharePlanidList = sharePlanSelectedRow.stream().map(s -> s.getPrimaryKeyValue()).collect(Collectors.toList());
            for (DynamicObject sharePlan : sharePlanArray = BusinessDataServiceHelper.load((Object[])sharePlanidList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.sharePlanFormId()))) {
                DynamicObjectCollection ruleentity = sharePlan.getDynamicObjectCollection("ruleentity");
                for (Object ruleId : ruleIds) {
                    DynamicObject entryObject = ruleentity.addNew();
                    entryObject.set("rule", ruleId);
                }
            }
            SaveServiceHelper.save((DynamicObject[])sharePlanArray);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\uff01", (String)"AbstractRuleCollectTreeListPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if ("downloadrule".equals(closedCallBackEvent.getActionId())) {
            ArrayList orgList = this.getControlFilters().getFilters().get("org.id") == null ? new ArrayList(0) : ((ControlFilter)this.getControlFilters().getFilters().get("org.id")).getValue();
            ArrayList ruletypeList = this.getControlFilters().getFilters().get("ruletype") == null ? new ArrayList(0) : ((ControlFilter)this.getControlFilters().getFilters().get("ruletype")).getValue();
            Object returnData = closedCallBackEvent.getReturnData();
            if (CollectionUtils.isEmpty(orgList) || CollectionUtils.isEmpty(ruletypeList) || null == returnData) {
                return;
            }
            Long org = Long.parseLong(String.valueOf(orgList.get(0)));
            String ruleType = String.valueOf(ruletypeList.get(0));
            List sharePlanSelectedRow = (List)returnData;
            List ruleList = sharePlanSelectedRow.stream().map(s -> (Long)s.getPrimaryKeyValue()).collect(Collectors.toList());
            TaxResult downloadResult = ServiceInvokeUtils.invokeTaxcTpoService(Map.class, (String)"PresetRuleService", (String)"downloadRule", (Object[])new Object[]{ruleList, org, ruleType});
            if (downloadResult != null) {
                this.getView().showMessage((String)downloadResult.getData());
            }
        }
    }

    protected abstract String sharePlanFormId();

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        Long pkid = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject ruleObject = QueryServiceHelper.queryOne((String)"tcvat_sbx_rule_config", (String)"group,issystem", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
        String groupId = ruleObject.getString("group");
        String formId = RuleTypeStrategyEnum.getStrategyByGroupId(groupId).getFormId();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)pkid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("groupId", (Object)groupId);
        Boolean modifyPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"tcvat", (String)list.getEntityId(), (String)"4715a0df000000ac");
        showParameter.setStatus(modifyPermission != false ? OperationStatus.EDIT : OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

