/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.tcvat.business.service.rule.BillFilterOperService;

public class BillFilterOperPlugin
extends AbstractFormPlugin
implements BeforeFilterF7SelectListener {
    private static final String BillFilter_entityNumber = "entityNumber";
    public static final String CustParamKey_FilterJson = "sdfasdfasdfasd";
    public static final String ORGID = "orgid";
    private static final String KEY_FILTERDESCRIPTION = "filterdescription";
    public static final String KEY_FILTER_VALUE = "filtervalue";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_BTNOK = "btnok";
    private static final String Key_filtergridap = "filtergridap";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNCANCEL, KEY_BTNOK});
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        this.initFilterCondition(entityNumber);
        String filterJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_FilterJson);
        if (!StringUtils.isBlank((CharSequence)filterJson)) {
            this.setDataFilter(filterJson);
        }
    }

    private void initFilterCondition(String entityNumber) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ((DynamicProperty)entityType.getFields().get("baseinvoicetype")).setAlias("fbaseinvoicetype");
        ((DynamicProperty)entityType.getFields().get("invoicestatus")).setAlias("finvoicestatus");
        ((DynamicProperty)entityType.getFields().get("buyername")).setAlias("fbuyername");
        ((DynamicProperty)entityType.getFields().get("buyertaxno")).setAlias("fbuyertaxno");
        ((DynamicProperty)entityType.getFields().get("remark")).setAlias("fremark");
        ((DynamicProperty)entityType.getFields().get("drawer")).setAlias("fdrawer");
        ((DynamicProperty)entityType.getFields().get("issuetype")).setAlias("issuetype");
        ((DynamicProperty)entityType.getFields().get("buyertype")).setAlias("fbuyertype");
        ((EntityType)entityType.getAllEntities().get("items")).setAlias("fentryentity");
        ((DynamicProperty)((EntityType)entityType.getAllEntities().get("items")).getFields().get("goodsname")).setAlias("fgoodsname");
        ((DynamicProperty)((EntityType)entityType.getAllEntities().get("items")).getFields().get("unit")).setAlias("funit");
        ((DynamicProperty)((EntityType)entityType.getAllEntities().get("items")).getFields().get("unitprice")).setAlias("funitprice");
        ((DynamicProperty)((EntityType)entityType.getAllEntities().get("items")).getFields().get("specification")).setAlias("fspecification");
        ((DynamicProperty)((EntityType)entityType.getAllEntities().get("items")).getFields().get("goodscode")).setAlias("fgoodscode");
        ((DynamicProperty)((EntityType)entityType.getAllEntities().get("items")).getFields().get("taxpremark")).setAlias("ftaxpremark");
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        BillFilterOperService.renameFieldCaption(filterColumns);
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.SetValue(fc);
        this.getView().updateView(Key_filtergridap);
    }

    private void setDataFilter(String dataFilter) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        filterGrid.SetValue(filterCondition);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            this.returnDataToParent();
        } else if (KEY_BTNCANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        Map<String, Object> ret = this.getConfig();
        String err = (String)ret.get("err");
        if (!StringUtils.isBlank((CharSequence)err)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6761\u4ef6\u914d\u7f6e\u4e0d\u5b8c\u6574", (String)"BillFilterOperPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), err, MessageTypes.Default);
        } else {
            this.getView().returnDataToParent(ret);
            this.getView().close();
        }
    }

    private Map<String, Object> getConfig() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        if (filteList == null || filteList.isEmpty()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(KEY_FILTER_VALUE, "");
            data.put(KEY_FILTERDESCRIPTION, "");
            return data;
        }
        List filterColumns = filterGrid.getFilterColumns();
        BillFilterOperService.renameFieldCaption(filterColumns);
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        String desc = filterBuilder.getFilterObject().getFilter();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KEY_FILTER_VALUE, filterJson);
        data.put(KEY_FILTERDESCRIPTION, desc.replaceAll(ResManager.loadKDString((String)"\u5355\u636e\u4f53.", (String)"BillFilterOperPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), ""));
        return data;
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        if ("bd_invoicetype".equals(beforeFilterF7SelectEvent.getRefEntityId())) {
            QFilter q = new QFilter("number", "in", Arrays.asList("2", "4", "27"));
            beforeFilterF7SelectEvent.addCustomQFilter(q);
        }
    }
}

