/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.history.BaseDataHistoryService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tcvat.business.service.rule.RuleHistoryService;
import org.apache.commons.collections.CollectionUtils;

public class RuleHistoryQueryPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String INCOMEENTRY = "incomeentry";
    private static final String ROLLOUTENTRY = "rolloutentry";
    private static final String DIFFENTRY = "diffentry";
    private static final String ACCTENTRYENTITY = "acctentryentity";
    private static final String INVOICEENTRYENTITY = "invoiceentryentity";
    private static final String ORG = "orgid";
    private static final String TCVAT_N_ROLLOUTRULE = "tcvat_rule_rollout";

    public void initialize() {
        CardEntry incomecardList = (CardEntry)this.getView().getControl(INCOMEENTRY);
        incomecardList.addSelectRowsListener((SelectRowsEventListener)this);
        CardEntry rolloutcardList = (CardEntry)this.getView().getControl(ROLLOUTENTRY);
        rolloutcardList.addSelectRowsListener((SelectRowsEventListener)this);
        CardEntry diffcardList = (CardEntry)this.getView().getControl(DIFFENTRY);
        diffcardList.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("from") != null) {
            this.loadHistory();
        }
    }

    public void afterBindData(EventObject e) {
        int count1 = this.getModel().getEntryRowCount(INCOMEENTRY);
        int count2 = this.getModel().getEntryRowCount(ROLLOUTENTRY);
        int count3 = this.getModel().getEntryRowCount(DIFFENTRY);
        if (count1 > 0) {
            this.initSelect(INCOMEENTRY, 0);
        } else if (count2 > 0) {
            this.initSelect(ROLLOUTENTRY, 0);
        } else if (count3 > 0) {
            this.initSelect(DIFFENTRY, 0);
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        List rows = evt.getNewRows();
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            this.clearEntry(ACCTENTRYENTITY, INVOICEENTRYENTITY);
            Object id = this.getModel().getValue(cardEntry.getEntryKey() + "id", ((Integer)rows.get(0)).intValue());
            if (INCOMEENTRY.equals(cardEntry.getEntryKey())) {
                this.clearEntrySelectedStatus(ROLLOUTENTRY, DIFFENTRY);
                this.setInvoiceEntry("INCOME" + id);
                this.setAccEntry("INCOME" + id, ResManager.loadKDString((String)"\u672a\u5f00\u7968\u6536\u5165\u53d6\u6570\u89c4\u5219", (String)"RuleHistoryQueryPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), true);
            } else if (ROLLOUTENTRY.equals(cardEntry.getEntryKey())) {
                this.clearEntrySelectedStatus(INCOMEENTRY, DIFFENTRY);
                this.setAccEntry("ROLL_OUT" + id, ResManager.loadKDString((String)"\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"RuleHistoryQueryPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), false);
            } else if (DIFFENTRY.equals(cardEntry.getEntryKey())) {
                this.clearEntrySelectedStatus(INCOMEENTRY, ROLLOUTENTRY);
                this.setAccEntry("DIFF" + id, ResManager.loadKDString((String)"\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"RuleHistoryQueryPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), false);
            }
        }
    }

    private void setInvoiceEntry(String key) {
        String json = this.getPageCache().get(key);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            JSONObject object = JSONObject.parseObject((String)json);
            JSONArray invoiceentity = object.getJSONArray("invoiceentity");
            this.getModel().beginInit();
            for (int i = 0; i < invoiceentity.size(); ++i) {
                int index = this.getModel().createNewEntryRow(INVOICEENTRYENTITY);
                JSONObject entry = invoiceentity.getJSONObject(i);
                this.getModel().setValue("invoicebizname", (Object)entry.getString("invoicebizname"), index);
                this.getModel().setValue("invoicetaxrate", (Object)entry.getString("invoicetaxrate"), index);
                this.getModel().setValue("invoicefiltercondition", (Object)entry.getString("invoicefiltercondition"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(INVOICEENTRYENTITY);
        }
    }

    private void setAccEntry(String key, String labelText, boolean showinvoiceentryflex) {
        Label labelap = (Label)this.getControl("labelap");
        labelap.setText(labelText);
        this.getView().setVisible(Boolean.valueOf(showinvoiceentryflex), new String[]{"invoiceentryflex"});
        String json = this.getPageCache().get(key);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            JSONObject object = JSONObject.parseObject((String)json);
            RuleHistoryService.setValue(this.getModel(), object, "entryentity", "", "acct");
        }
    }

    private void clearEntrySelectedStatus(String ... entrys) {
        for (String entry : entrys) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(entry);
            cardEntry.addSelectRowsListener((SelectRowsEventListener)this);
            cardEntry.selectRows(-1);
        }
    }

    private void initSelect(String entry, int row) {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        newList.add(row);
        ArrayList<Integer> oldList = new ArrayList<Integer>();
        oldList.add(-1);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entry);
        cardEntry.selectRowsChanged(newList, oldList);
        cardEntry.selectCard(Integer.valueOf(row));
    }

    private void loadHistory() {
        this.clearEntry(INCOMEENTRY, ROLLOUTENTRY, DIFFENTRY, ACCTENTRYENTITY, INVOICEENTRYENTITY);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        long orgId = Long.parseLong((String)customParams.get(ORG));
        String json = BaseDataHistoryService.queryBaseDataHistory((long)orgId, (String)"tcvat_rule", (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
        if (!StringUtils.isEmpty((CharSequence)json)) {
            JSONObject object = JSONObject.parseObject((String)json);
            JSONArray incomeRules = object.getJSONArray("INCOME");
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)TCVAT_N_ROLLOUTRULE, (String)"jzjt");
            RuleHistoryService.setTcvatRule(this.getModel(), this.getPageCache(), object, "roll_out", jzjtMap);
            RuleHistoryService.setTcvatRule(this.getModel(), this.getPageCache(), object, "diff", jzjtMap);
            if (incomeRules != null && incomeRules.size() > 0) {
                this.getModel().beginInit();
                for (int i = 0; i < incomeRules.size(); ++i) {
                    JSONObject jsonObject = incomeRules.getJSONObject(i);
                    this.getPageCache().put("INCOME" + jsonObject.getString("id"), SerializationUtils.toJsonString((Object)jsonObject));
                    int index = this.getModel().createNewEntryRow(INCOMEENTRY);
                    this.getModel().setValue("incomeentryid", (Object)jsonObject.getLong("id"), index);
                    this.getModel().setValue("incomerulename", (Object)jsonObject.getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("incomeruletaxation", (Object)jsonObject.getJSONObject("taxation").getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("taxrate", (Object)jsonObject.getJSONObject("taxrate").getJSONObject("name").getString("zh_CN"), index);
                    this.getModel().setValue("incomeorg", (Object)jsonObject.getJSONObject("org").getString("name"), index);
                    this.getModel().setValue("incomeruletype", (Object)jsonObject.getString("ruletype"), index);
                    this.getModel().setValue("incomeenable", (Object)jsonObject.getString("enable"), index);
                }
                this.getModel().endInit();
                this.getView().updateView(INCOMEENTRY);
            }
        }
        this.visibleEntry(INCOMEENTRY, ROLLOUTENTRY, DIFFENTRY);
    }

    private void visibleEntry(String ... entryNames) {
        for (String entry : entryNames) {
            int count = this.getModel().getEntryRowCount(entry);
            if (count == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{entry});
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{entry});
        }
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }
}

