/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.OrgService;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.formplugin.rule.AbstractRuleCollectTreeListPlugin;

public class SbxRuleCollectTreeListPlugin
extends AbstractRuleCollectTreeListPlugin
implements TreeNodeClickListener {
    private Set<String> ruleFormIdSet = new HashSet<String>(){
        {
            this.add("tcvat_rule_rollout");
            this.add("tcvat_rule_deduct");
            this.add("tcvat_rule_perpre");
            this.add("tcvat_rule_mdts");
        }
    };

    @Override
    public String getRootNodeName() {
        return ResManager.loadKDString((String)"\u7533\u62a5\u9879\u89c4\u5219", (String)"SbxRuleCollectTreeListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]);
    }

    @Override
    protected boolean checkBeforeAddRule(Long createOrgId, String ruleType, String formId) {
        boolean isybnsr;
        boolean existTypeChange = RuleService.loadTaxPayerTypeChangeRecord(String.valueOf(createOrgId), ruleType);
        DynamicObjectCollection list = null;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(createOrgId));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            list = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity");
        }
        if (this.ruleFormIdSet.contains(formId) && !(isybnsr = this.ruleService.isybnsr(list, ruleType, false))) {
            String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
            TreeNode root = this.getTreeModel().getRoot();
            TreeNode currentNode = root.getTreeNode(currentNodeId, 100);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%1$s\u201c\u975e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528%2$s\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"SbxRuleCollectTreeListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), ((DynamicObject)((List)result.getData()).get(0)).getString("orgid.name"), currentNode.getText()));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (null != args.getOperationResult() && args.getOperationResult().getAllErrorOrValidateInfo().size() == 0) {
            ListSelectedRowCollection listSelectedData;
            Object[] primaryKeyValues;
            boolean exists;
            if ("enable".equals(operateKey) && (exists = QueryServiceHelper.exists((String)"tcvat_rule_wkpsr", (QFilter[])new QFilter[]{new QFilter("rulename", "in", (Object)(primaryKeyValues = (listSelectedData = operate.getListSelectedData()).getPrimaryKeyValues())), new QFilter("enable", "=", (Object)"0")}))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("enable", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u540c\u65f6\u542f\u7528\u5173\u8054\u7684\u672a\u5f00\u7968\u6536\u5165\u53f0\u8d26\u89c4\u5219\uff1f", (String)"IncomeRulePlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            }
            if ("downloadrule".equals(operateKey)) {
                boolean valiableOrg;
                ArrayList ruletypeList;
                ArrayList orgList = this.getControlFilters().getFilters().get("org.id") == null ? new ArrayList(0) : ((ControlFilter)this.getControlFilters().getFilters().get("org.id")).getValue();
                List list = ruletypeList = this.getControlFilters().getFilters().get("ruletype") == null ? new ArrayList(0) : ((ControlFilter)this.getControlFilters().getFilters().get("ruletype")).getValue();
                if (CollectionUtils.isEmpty(orgList) || orgList.size() != 1 || StringUtil.isBlank((CharSequence)String.valueOf(orgList.get(0)))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u8bf7\u9009\u4e2d\u5355\u4e2a\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"IncomeRulePlugin_18", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                if (CollectionUtils.isEmpty(ruletypeList) || ruletypeList.size() != 1 || StringUtil.isBlank((CharSequence)String.valueOf(ruletypeList.get(0)))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u7684\u89c4\u5219\u7c7b\u578b\u3002", (String)"IncomeRulePlugin_19", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                String org = String.valueOf(orgList.get(0));
                TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(org));
                boolean bl = valiableOrg = result.isSuccess() && result.getData() != null;
                if (!valiableOrg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u672a\u5ba1\u6838\u6216\u4f7f\u7528\u72b6\u6001\u4e3a\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"IncomeRulePlugin_20", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                String ruleType = String.valueOf(ruletypeList.get(0));
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"tpo_rule", (boolean)true);
                listShowParameter.setCustomParam("org", (Object)org);
                listShowParameter.setCustomParam("ruleType", (Object)ruleType);
                listShowParameter.setCustomParam("parent", RuleService.VAT_RULE_ROOT_ID);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
            if ("batchdownloadrule".equals(operateKey)) {
                RequestContext context;
                Long orgId;
                List<Long> allPermOrgs = OrgService.getAllPermOrgs("tpo", "tpo_rule", "47150e89000000ac");
                if (!allPermOrgs.contains(orgId = Long.valueOf((context = RequestContext.get()).getOrgId()))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u9884\u5236\u53d6\u6570\u89c4\u5219\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SbxRuleCollectTreeListPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                showParameter.setBillFormId("tpo_rule");
                showParameter.setCustomParam("operateSource", (Object)"downloadFromBusiness");
                showParameter.setCustomParam("operateType", (Object)operateKey);
                showParameter.setCustomParam("org", (Object)orgId);
                showParameter.setCustomParam("parent", RuleService.VAT_RULE_ROOT_ID);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        Object[] primaryKeyValues;
        DynamicObject[] wkpsrRule;
        List<Long> wkpsrId;
        OperationResult resultesult;
        String callBackId = evt.getCallBackId();
        if ("enable".equals(callBackId) && MessageBoxResult.Yes == evt.getResult() && (resultesult = OperationServiceHelper.executeOperate((String)"enable", (String)"tcvat_rule_wkpsr", (Object[])(wkpsrId = Arrays.stream(wkpsrRule = BusinessDataServiceHelper.load((String)"tcvat_rule_wkpsr", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("rulename", "in", (Object)(primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues())), new QFilter("enable", "=", (Object)"0")})).map(w -> w.getLong("id")).collect(Collectors.toList())).toArray(new Long[0]), (OperateOption)OperateOption.create())).isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u672a\u5f00\u7968\u6536\u5165\u89c4\u5219\u542f\u7528\u6210\u529f\u3002", (String)"IncomeRulePlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    @Override
    protected String sharePlanFormId() {
        return "tcvat_sbx_shareplan";
    }
}

