/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.common.enums.SharingPlanOperateEnum;
import org.apache.commons.collections.CollectionUtils;

@Deprecated
public class SharingPlanEdit
extends AbstractBillPlugIn
implements SelectRowsEventListener,
TabSelectListener {
    private static final String TABAP = "tabap";
    private static final String CURRENT_TAB = "current_tab";
    private static final String ORG = "org";
    public static final String SYNSRLX = "synsrlx";
    private static final String ITEM_CLOSE = "bar_close";
    private static final String systemType = "taxc-tcvat";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String PLANENTITY = "planentity";
    private static final String RULEENTITY = "ruleentity";
    private static final String ORGENTITY = "orgentity";
    private Boolean exchange = Boolean.FALSE;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848", (String)"SharingPlanEdit_11", (String)systemType, (Object[])new Object[0]));
    }

    public void initialize() {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.addSelectRowsListener((SelectRowsEventListener)this);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"flex_addorg", "vector_addorg", "label_addorg", "label_moreorg", "labelcreate"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        Toolbar toolbarMain = (Toolbar)this.getControl("tbmain");
        toolbarMain.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue(ORG, this.getOrgid(customParams));
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            Long orgid = PermissionUtils.getDefaultOrgId();
            this.getModel().setValue(ORG, (Object)orgid);
        }
        org = (DynamicObject)this.getModel().getValue(ORG);
        String formId = (String)customParams.get("formId");
        if (org != null && !customParams.containsKey("initialized")) {
            String orgId = org.getString("id");
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put("orgid", orgId);
            custom.put("initialized", Boolean.TRUE);
            QFilter filter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId));
            DynamicObject plan = null;
            if (StringUtils.isNotEmpty((CharSequence)formId)) {
                plan = QueryServiceHelper.queryOne((String)formId, (String)"id", (QFilter[])new QFilter[]{filter});
            }
            if (plan != null) {
                this.showBill(plan.getLong("id"), custom);
            } else {
                this.showBill(null, custom);
            }
        }
    }

    public Object getOrgid(Map<String, Object> customParams) {
        Object orgId = customParams.get("orgid");
        if (orgId != null) {
            return orgId;
        }
        return "";
    }

    private void updateAddLableName() {
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity(ORGENTITY);
        if (null == orgEntity || orgEntity.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_moreorg"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_addorg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_moreorg"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_addorg"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.resetPlanName(0);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(RULEENTITY);
        List tabList = ((Tab)this.getControl(TABAP)).getItems();
        for (Control tab : tabList) {
            String key = tab.getKey();
            this.setFilter(entity, key.replace("tab", ""));
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.selectCard(Integer.valueOf(0));
        planentity.selectRowsChanged(Collections.singletonList(0), null);
        this.updateAddLableName();
        this.setVisible();
    }

    private void setVisible() {
        int row = this.getModel().getEntryRowCount(PLANENTITY);
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", PLANENTITY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", PLANENTITY});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (ORG.equals(e.getProperty().getName())) {
            this.getModel().setDataChanged(false);
            HashMap<String, Object> custom = new HashMap<String, Object>();
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (org != null && newValue != null && oldValue != null) {
                String orgid = org.getString("id");
                custom.put("orgid", orgid);
                QFilter filter = new QFilter(ORG, "=", (Object)Long.parseLong(orgid));
                DynamicObject plan = QueryServiceHelper.queryOne((String)formId, (String)"id", (QFilter[])new QFilter[]{filter});
                if (plan != null) {
                    this.showBill(plan.getLong("id"), custom);
                } else {
                    this.showBill(null, custom);
                }
            } else if (newValue == null) {
                this.getModel().setValue(ORG, (Object)oldValue);
            }
        } else if ("planname".equals(e.getProperty().getName())) {
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            int[] selectRows = planentity.getSelectRows();
            if (selectRows.length > 0 && !"true".equals(this.getPageCache().get("refresh"))) {
                this.getModel().setValue("name", e.getChangeSet()[0].getNewValue(), selectRows[0]);
            }
            this.updateAddLableName();
        } else if ("autoshar".equals(e.getProperty().getName())) {
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            int[] selectRows = planentity.getSelectRows();
            if (selectRows.length > 0 && !"true".equals(this.getPageCache().get("refresh"))) {
                this.getModel().setValue("entryautoshar", e.getChangeSet()[0].getNewValue(), selectRows[0]);
            }
        } else if ("orgid".equals(e.getProperty().getName())) {
            this.updateAddLableName();
        } else if (SYNSRLX.equals(e.getProperty().getName())) {
            ChangeData[] changeSet = e.getChangeSet();
            String newValue = (String)changeSet[0].getNewValue();
            String refresh = this.getPageCache().get("refresh" + newValue);
            if (StringUtils.isNotBlank((CharSequence)refresh)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5237\u65b0\u3002", (String)"SharingPlanEdit_12", (String)systemType, (Object[])new Object[0]));
            }
            if (!this.exchange.booleanValue()) {
                int count1;
                int count = this.getModel().getEntryRowCount(ORGENTITY);
                if (count + (count1 = this.getModel().getEntryRowCount(RULEENTITY)) > 0) {
                    String oldValue = (String)changeSet[0].getOldValue();
                    this.getPageCache().put("refresh" + oldValue, "true");
                }
                this.getModel().deleteEntryData(ORGENTITY);
                this.getModel().deleteEntryData(RULEENTITY);
            }
            List tabList = ((Tab)this.getControl(TABAP)).getItems();
            for (Control tab : tabList) {
                String key = tab.getKey();
                this.refreshRuleList(key.replace("tab", ""));
            }
            if ("ybnsr".equals(newValue)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"rollouttab", "deducttab", "mdtstab"});
            } else if ("xgmnsr".equals(newValue)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"rollouttab", "deducttab", "mdtstab"});
            }
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            int[] selectRows = planentity.getSelectRows();
            if (selectRows.length > 0 && this.getModel().getEntryRowCount(PLANENTITY) > selectRows[0]) {
                this.getModel().setValue("taxpayertype", (Object)newValue, selectRows[0]);
            }
        }
    }

    private void showBill(Object pkId, Map<String, Object> customParams) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        billShowParameter.getCustomParams().putAll(customParams);
        if (pkId != null) {
            billShowParameter.setPkId(pkId);
            this.getModel().setValue("id", pkId);
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
            billShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            billShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().invokeOperation("refresh");
    }

    private void refreshRuleList(String type) {
        BillList list = (BillList)this.getControl(type + "list");
        if (list == null) {
            return;
        }
        if ("wkpsr".equals(type)) {
            list.addPackageDataListener(evt -> {
                AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
                DynamicObject rowData = evt.getRowData();
                String key = columnDesc.getKey();
                if ("name".equals(key)) {
                    DynamicObject rulename = rowData.getDynamicObject("rulename");
                    ComboProp property = (ComboProp)rulename.getDynamicObjectType().getProperty("jzjt");
                    String itemByName = property.getItemByName(rulename.getString("jzjt"));
                    evt.setFormatValue((Object)itemByName);
                }
            });
        }
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(RULEENTITY);
        if (entity != null) {
            for (DynamicObject object : entity) {
                if (!type.equals(object.getString("type"))) continue;
                ids.add(object.getLong("ruleid"));
            }
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        filterParameter.setFilter(idsFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        filterParameter.setFilter(enableFilter);
        list.setFilterParameter((FilterParameter)filterParameter);
        list.refreshData();
    }

    private void setFilter(DynamicObjectCollection entity, String type) {
        BillList list = (BillList)this.getControl(type + "list");
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (entity != null) {
            for (DynamicObject object : entity) {
                if (!type.equals(object.getString("type"))) continue;
                ids.add(object.getLong("ruleid"));
            }
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        filterParameter.setFilter(idsFilter);
        list.setFilterParameter((FilterParameter)filterParameter);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Vector && "vector_addorg".equals(((Vector)source).getKey()) || source instanceof Label && "label_addorg".equals(((Label)source).getKey()) || source instanceof Label && "label_moreorg".equals(((Label)source).getKey()) || source instanceof Container && "flex_addorg".equals(((Container)source).getKey())) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            this.showOrgSelect();
        } else if (source instanceof Label && "labelcreate".equals(((Label)source).getKey())) {
            Button button = (Button)this.getControl("button_addplan");
            button.click();
        }
    }

    private boolean checkPlanNotSelected() {
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] selectedRows = planentity.getSelectRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5171\u4eab\u65b9\u6848\u88ab\u9009\u4e2d\uff0c\u8bf7\u5148\u6dfb\u52a0\u5171\u4eab\u65b9\u6848\u3002", (String)"SharingPlanEdit_0", (String)systemType, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void showOrgSelect() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)2);
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u88ab\u5171\u4eab\u7ec4\u7ec7", (String)"SharingPlanEdit_1", (String)systemType, (Object[])new Object[0]));
        Optional<DynamicObject> optional = this.getModel().getEntryEntity(PLANENTITY).stream().filter(s -> this.isCurrentSelect(s.getInt("seq") - 1)).findFirst();
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        if (optional.isPresent()) {
            DynamicObject planentity = optional.get();
            DynamicObjectCollection orgEntity = planentity.getDynamicObjectCollection(ORGENTITY);
            for (DynamicObject entity : orgEntity) {
                ListSelectedRow row = new ListSelectedRow();
                DynamicObject org = entity.getDynamicObject("orgid");
                row.setName(org.getString("name"));
                row.setNumber(org.getString("number"));
                row.setPrimaryKeyValue(org.get("id"));
                listSelectedRowCollection.add((Object)row);
            }
        }
        parameter.setListSelectedRowCollection(listSelectedRowCollection);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"SharingPlanEdit_2", (String)systemType, (Object[])new Object[0]));
            return;
        }
        List filters = parameter.getListFilterParameter().getQFilters();
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add(org.getLong("id"));
        List<Long> subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)OrgUtils.getLocalDefaultViewId(), orgList, (boolean)true);
        subOrgIds = this.filterByCondition(subOrgIds);
        filters.add(new QFilter("id", "in", (Object)subOrgIds.toArray()));
        filters.add(new QFilter("id", "in", TaxcMainDataServiceHelper.queryTaxcMainOrgIds().getData()));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectorg"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private List<Long> filterByCondition(List<Long> subOrgIds) {
        String synsrlx = (String)this.getModel().getValue(SYNSRLX);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(subOrgIds);
        subOrgIds = ((List)result.getData()).stream().filter(d -> {
            DynamicObjectCollection categoryentryentity = d.getDynamicObjectCollection("categoryentryentity");
            if (EmptyCheckUtils.isEmpty((Object)categoryentryentity)) {
                return false;
            }
            DynamicObject object = (DynamicObject)categoryentryentity.get(0);
            return Objects.equals(object.getString("enable"), "1") && Objects.equals(object.getString("taxpayertype"), synsrlx);
        }).map(s -> s.getLong("taxorg.id")).collect(Collectors.toList());
        return subOrgIds;
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        if (newRows != null && newRows.size() > 0) {
            Integer startRowIndex = (Integer)newRows.get(0);
            this.resetPlanName(startRowIndex);
            Tab tab = (Tab)this.getControl(TABAP);
            tab.selectTab(tab.getCurrentTab());
        }
        this.updateAddLableName();
    }

    private void resetPlanName(Integer startRowIndex) {
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        this.exchange = Boolean.TRUE;
        DynamicObject[] planentities = this.getModel().getEntryEntity(PLANENTITY, startRowIndex.intValue(), startRowIndex + 1);
        if (planentities != null && planentities.length > 0) {
            this.getModel().setValue("planname", (Object)planentities[0].getString("name"));
            String synsrlx = planentities[0].getString("taxpayertype");
            this.getModel().setValue(SYNSRLX, (Object)(StringUtil.isEmpty((CharSequence)synsrlx) ? "ybnsr" : synsrlx));
            if (planentities[0].getDynamicObjectType().getProperties().containsKey((Object)"entryautoshar")) {
                this.getModel().setValue("autoshar", (Object)planentities[0].getBoolean("entryautoshar"));
            }
        } else {
            this.getModel().setValue("planname", (Object)"");
            this.getModel().setValue("autoshar", (Object)Boolean.FALSE);
        }
        this.exchange = Boolean.FALSE;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (e.getEntryProp().getName().equals(PLANENTITY)) {
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (rowDataEntities != null && rowDataEntities.length > 0) {
                int rowIndex = rowDataEntities[0].getRowIndex();
                planentity.selectCard(Integer.valueOf(rowIndex));
                planentity.selectRowsChanged(Collections.singletonList(rowIndex), null);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals(PLANENTITY)) {
            this.resetPlanName(e.getRowIndexs()[0] - 1);
            this.refreshRuleList("income");
            this.refreshRuleList("rollout");
            this.refreshRuleList("deduct");
            this.refreshRuleList("diff");
            this.refreshRuleList("deduction");
            this.updateAddLableName();
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] rows = planentity.getSelectRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        this.refreshRuleList(tabKey.replace("tab", ""));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        block6: {
            EntryGrid planentity;
            int[] rows;
            Map idmap;
            block5: {
                if (!"selectorg".equals(evt.getActionId())) break block5;
                ListSelectedRowCollection orgs = (ListSelectedRowCollection)evt.getReturnData();
                if (orgs == null) break block6;
                EntryGrid planentity2 = (EntryGrid)this.getControl(PLANENTITY);
                int[] selectRows = planentity2.getSelectRows();
                int planIndex = selectRows[0];
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, planIndex);
                this.getModel().deleteEntryData(ORGENTITY);
                for (ListSelectedRow selectedRow : orgs) {
                    int index = this.getModel().createNewEntryRow(ORGENTITY);
                    this.getModel().setValue("orgid", selectedRow.getPrimaryKeyValue(), index, planIndex);
                }
                break block6;
            }
            if ("tcvat_select_rule".equals(evt.getActionId()) && (idmap = (Map)evt.getReturnData()) != null && (rows = (planentity = (EntryGrid)this.getControl(PLANENTITY)).getSelectRows()) != null && rows.length > 0) {
                int planindex = rows[0];
                this.getModel().deleteEntryData(RULEENTITY);
                for (Map.Entry entry : idmap.entrySet()) {
                    Object[] value;
                    String type = (String)entry.getKey();
                    for (Object id : value = (Object[])entry.getValue()) {
                        int ruleindex = this.getModel().createNewEntryRow(RULEENTITY);
                        this.getModel().setValue("type", (Object)type, ruleindex, planindex);
                        this.getModel().setValue("ruleid", id, ruleindex, planindex);
                    }
                }
                List tabList = ((Tab)this.getControl(TABAP)).getItems();
                for (Control tab : tabList) {
                    String key = tab.getKey();
                    this.refreshRuleList(key.replace("tab", ""));
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DeleteEntry deleteEntry;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            int planCount;
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"SharingPlanEdit_13", (String)systemType, (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((planCount = this.getModel().getEntryRowCount(PLANENTITY)) == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"SharingPlanEdit_3", (String)systemType, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection planentity = this.getModel().getEntryEntity(PLANENTITY);
            HashSet<String> planMap = new HashSet<String>(planentity.size());
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(PLANENTITY);
            for (int row = 0; row < planentity.size(); ++row) {
                String errMsg;
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, row);
                int orgCount = this.getModel().getEntryRowCount(ORGENTITY);
                String planName = ((DynamicObject)planentity.get(row)).getString("name");
                if (this.isCurrentSelect(row)) {
                    ((DynamicObject)planentity.get(row)).set("taxpayertype", this.getModel().getValue(SYNSRLX));
                }
                if (planMap.contains(planName)) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\uff08%s\uff09\u91cd\u590d\uff0c\u8bf7\u8bbe\u7f6e\u4e0d\u540c\u7684\u65b9\u6848\u540d\u79f0\u3002", (String)"SharingPlanEdit_4", (String)systemType, (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    return;
                }
                planMap.add(planName);
                if (orgCount == 0) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u88ab\u5171\u4eab\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u88ab\u5171\u4eab\u7ec4\u7ec7\u3002", (String)"SharingPlanEdit_5", (String)systemType, (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection ruleentity = this.getModel().getEntryEntity(RULEENTITY);
                if (ruleentity.size() == 0) {
                    String errMsg2 = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u5171\u4eab\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5171\u4eab\u89c4\u5219\u3002", (String)"SharingPlanEdit_6", (String)systemType, (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg2);
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection orgentity = this.getModel().getEntryEntity(ORGENTITY);
                String selectType = (String)this.getModel().getValue(SYNSRLX);
                List orgIds = orgentity.stream().map(entity -> entity.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
                TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(orgIds);
                List unMatchObject = ((List)result.getData()).stream().filter(d -> EmptyCheckUtils.isNotEmpty((Object)d.getDynamicObjectCollection("categoryentryentity"))).filter(d -> !selectType.equals(((DynamicObject)d.getDynamicObjectCollection("categoryentryentity").get(0)).getString("taxpayertype"))).limit(4L).collect(Collectors.toList());
                if (unMatchObject.size() <= 0 || !this.isCurrentSelect(row)) continue;
                String orgName = unMatchObject.stream().map(u -> TaxOrgUtil.getTaxpayer((DynamicObject)u.getDynamicObject("taxorg"))).collect(Collectors.joining("\u3001"));
                if (4 == unMatchObject.size()) {
                    orgName = orgName + "...";
                }
                String errMsg3 = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0e\u5171\u4eab\u65b9\u6848\u4e2d\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b\u4e0d\u4e00\u81f4, \u8bf7\u4fee\u6539\u5171\u4eab\u8303\u56f4\u3002", (String)"SharingPlanEdit_7", (String)systemType, (Object[])new Object[0]), orgName);
                this.getView().showErrorNotification(errMsg3);
                args.setCancel(true);
                return;
            }
            this.getModel().setEntryCurrentRowIndex(PLANENTITY, currentRowIndex);
        } else if (args.getSource() instanceof Refresh) {
            this.getPageCache().put("refresh", "true");
            this.getPageCache().remove("refreshybnsr");
            this.getPageCache().remove("refreshxgmnsr");
        } else if (args.getSource() instanceof DeleteEntry && "deleteorg".equals((deleteEntry = (DeleteEntry)args.getSource()).getOperateKey())) {
            args.setCancel(true);
            EntryGrid entrye = (EntryGrid)this.getControl(ORGENTITY);
            entrye.getSelectRows();
            String orgName = this.getModel().getEntryRowEntity(ORGENTITY, entrye.getSelectRows()[0]).getString("orgid.name");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgDeleteConform", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"SharingPlanEdit_8", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"SharingPlanEdit_9", (String)systemType, (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u5c06\u201c%1$s\u201d\u4ece\u201c%2$s\u201d\u65b9\u6848\u7684\u5171\u4eab\u8303\u56f4\u4e2d\u5254\u9664\uff1f", (String)"SharingPlanEdit_10", (String)systemType, (Object[])new Object[0]), orgName, this.getModel().getValue("planname"));
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    private boolean isCurrentSelect(int row) {
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] rows = planentity.getSelectRows();
        return Arrays.stream(rows).allMatch(s -> s == row);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("editrule")) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put(ORG, this.getModel().getValue(ORG));
            custom.put(RULEENTITY, this.getModel().getEntryEntity(RULEENTITY));
            Tab tabap = (Tab)this.getControl(TABAP);
            custom.put(CURRENT_TAB, tabap.getCurrentTab());
            custom.put("hideRollType", this.getModel().getValue(SYNSRLX).equals("xgmnsr"));
            custom.put("taxpayertype", this.getModel().getValue(SYNSRLX));
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_select_rule", (IFormView)this.getView(), custom, (IFormPlugin)this);
        } else if (args.getSource() instanceof DeleteEntry) {
            DeleteEntry deleteEntry = (DeleteEntry)args.getSource();
            if ("deleteplan".equals(deleteEntry.getOperateKey())) {
                DynamicObject dynamicObject = this.getModel().getDataEntity(true);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                this.getPageCache().remove("refreshybnsr");
                this.getPageCache().remove("refreshxgmnsr");
                Map<String, String> operateMap = SharingPlanOperateEnum.getOperateMap(args.getOperateKey());
                if (!operateMap.isEmpty() && this.getModel().getValue(ORG) != null) {
                    OperatorDialogUtils.operateDialog((String)"zzs", (String)this.getView().getFormShowParameter().getFormId(), (String)operateMap.get("name"), (String)String.format(operateMap.get("description"), ((DynamicObject)this.getModel().getValue(ORG)).getString("name")));
                }
            }
        } else if ("newplan".equals(args.getOperateKey())) {
            this.getModel().setValue(SYNSRLX, (Object)"ybnsr");
        } else if (args.getOperateKey().equals("refresh")) {
            if ("true".equals(this.getPageCache().get("refresh"))) {
                this.getPageCache().put("refresh", "false");
            }
        } else if (args.getOperateKey().equals("save")) {
            this.getPageCache().remove("refreshybnsr");
            this.getPageCache().remove("refreshxgmnsr");
            Map<String, String> operateMap = SharingPlanOperateEnum.getOperateMap(args.getOperateKey());
            if (!operateMap.isEmpty() && this.getModel().getValue(ORG) != null) {
                OperatorDialogUtils.operateDialog((String)"zzs", (String)this.getView().getFormShowParameter().getFormId(), (String)operateMap.get("name"), (String)String.format(operateMap.get("description"), ((DynamicObject)this.getModel().getValue(ORG)).getString("name")));
            }
        }
        this.setVisible();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String resultMsg;
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)ITEM_CLOSE) && StringUtil.isNotBlank((CharSequence)(resultMsg = this.checkChangeData()))) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ITEM_CLOSE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingPlanEdit_14", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingPlanEdit_15", (String)systemType, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingPlanEdit_16", (String)systemType, (Object[])new Object[0]);
            this.getView().showConfirm(msg, resultMsg, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    private String checkChangeData() {
        DynamicObjectCollection planCollection = this.getModel().getEntryEntity(PLANENTITY);
        if (planCollection.isEmpty()) {
            return "";
        }
        String entity = this.getModel().getDataEntityType().getName();
        StringBuilder msg = new StringBuilder();
        Long planId = (Long)this.getModel().getValue("id");
        if (planId == null || planId == 0L) {
            String name = ResManager.loadKDString((String)"\u65b0\u589e\u5171\u4eab\u65b9\u6848\u5747\u672a\u4fdd\u5b58\uff01", (String)"SharingPlanEdit_17", (String)systemType, (Object[])new Object[0]);
            msg.append(name);
            return msg.toString();
        }
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)entity);
        Map<String, DynamicObject> oldPlanMap = plan.getDynamicObjectCollection(PLANENTITY).stream().collect(Collectors.toMap(a -> a.getString("id"), b -> b));
        for (DynamicObject newPlan : planCollection) {
            String oldAutoshar;
            String newAutoshar;
            String name;
            StringBuilder words = new StringBuilder();
            String newName = newPlan.getString("name");
            String id = newPlan.getString("id");
            if (!oldPlanMap.containsKey(id)) {
                String name2 = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u4e3a\u65b0\u589e\u65b9\u6848\u8fd8\u672a\u4fdd\u5b58\uff01", (String)"SharingPlanEdit_18", (String)systemType, (Object[])new Object[0]), newName);
                if (StringUtil.isBlank((CharSequence)msg)) {
                    msg.append(name2);
                    continue;
                }
                msg.append(SEPARATOR).append(name2);
                continue;
            }
            DynamicObject oldPlan = oldPlanMap.get(id);
            List ruleEntityList = oldPlan.getDynamicObjectCollection(RULEENTITY).stream().map(o -> o.getString("ruleid")).collect(Collectors.toList());
            List orgEntityList = oldPlan.getDynamicObjectCollection(ORGENTITY).stream().map(o -> o.getString("orgid_id")).collect(Collectors.toList());
            String oldName = oldPlan.getString("name");
            String oldTaxPayerType = oldPlan.getString("taxpayertype");
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = newPlan.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().forEach(ruleRow -> ruleList.add(ruleRow.getString("ruleid")));
            DynamicObjectCollection orgCol = newPlan.getDynamicObjectCollection(ORGENTITY);
            orgCol.stream().forEach(orgRow -> orgList.add(orgRow.getDynamicObject("orgid").getString("id")));
            String newTaxPayerType = newPlan.getString("taxpayertype");
            if (!newName.equals(oldName)) {
                name = ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"SharingPlanEdit_19", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!newTaxPayerType.equals(oldTaxPayerType)) {
                name = ResManager.loadKDString((String)"\u9002\u7528\u7eb3\u7a0e\u4eba\u7c7b\u578b", (String)"SharingPlanEdit_20", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (oldPlan.containsProperty("entryautoshar") && newPlan.containsProperty("entryautoshar") && !(newAutoshar = newPlan.getString("entryautoshar")).equals(oldAutoshar = oldPlan.getString("entryautoshar"))) {
                String name3 = ResManager.loadKDString((String)"\u81ea\u52a8\u5171\u4eab", (String)"SharingPlanEdit_21", (String)systemType, (Object[])new Object[0]);
                words.append(name3).append(",");
            }
            if (!CollectionUtils.isEqualCollection(ruleList, ruleEntityList)) {
                name = ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u5361\u7247", (String)"SharingPlanEdit_22", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!CollectionUtils.isEqualCollection(orgList, orgEntityList)) {
                name = ResManager.loadKDString((String)"\u88ab\u5171\u4eab\u8303\u56f4", (String)"SharingPlanEdit_23", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            name = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u53d8\u66f4\u5b57\u6bb5\uff1a", (String)"SharingPlanEdit_24", (String)systemType, (Object[])new Object[0]), newName);
            if (!StringUtil.isNotBlank((CharSequence)words)) continue;
            words.deleteCharAt(words.lastIndexOf(","));
            if (StringUtil.isBlank((CharSequence)msg)) {
                msg.append(name).append((CharSequence)words);
                continue;
            }
            msg.append(SEPARATOR).append(name).append((CharSequence)words);
        }
        return msg.toString();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (org.apache.commons.lang.StringUtils.equals((String)"orgDeleteConform", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                EntryGrid entrye = (EntryGrid)this.getControl(ORGENTITY);
                this.getModel().deleteEntryRows(ORGENTITY, entrye.getSelectRows());
                this.updateAddLableName();
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                return;
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)ITEM_CLOSE) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().close();
        }
    }
}

