/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rule.shareplan.prepay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.shareplan.AbstractSharePlanFormPlugin;
import kd.taxc.tcvat.common.enums.RuleTypeStrategyEnum;
import kd.taxc.tcvat.common.enums.SharingPlanOperateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PrepaySharePlanFormPlugin
extends AbstractSharePlanFormPlugin
implements Consumer<BeforeF7ViewDetailEvent>,
AfterF7SelectListener {
    private String SEPARATOR = System.getProperty("line.separator");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OrgEdit taxOrgEdit = (OrgEdit)this.getControl("createorg");
        taxOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEntity = (BasedataEdit)this.getControl("prepayproject");
        orgEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit rule = (BasedataEdit)this.getView().getControl("rule");
        rule.addBeforeF7ViewDetailListener(this::accept);
        rule.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit prepayproject = (BasedataEdit)this.getView().getControl("prepayproject");
        prepayproject.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    protected void initData() {
        super.initData();
        this.planFieldMap.put("createorg", "carcreateorg");
    }

    protected void planAdd(AfterDoOperationEventArgs args) {
        this.getPageCache().put("createplan", "false");
        super.planAdd(args);
        this.getPageCache().put("createplan", "true");
    }

    protected void createNewPlan(int selectRow) {
        super.createNewPlan(selectRow);
        Long createOrg = null;
        TaxResult result = PermDataServiceHelper.getUserHasPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"10");
        if (result.isSuccess() && ((List)result.getData()).size() > 0) {
            List enableOrgidList = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"10", (boolean)false);
            ((List)result.getData()).retainAll(enableOrgidList);
            createOrg = ((List)result.getData()).size() > 0 ? (Long)((List)result.getData()).get(0) : Long.valueOf(0L);
        }
        this.getModel().setValue("createorg", createOrg);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String createplan;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("createorg".equals(key) && "true".equals(createplan = this.getPageCache().get("createplan"))) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (null == oldValue) {
                this.getPageCache().put("olddata", "");
            } else {
                this.getPageCache().put("olddata", "taxpayertype".equals(key) ? oldValue.toString() : ((DynamicObject)oldValue).getString("id"));
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
            this.showConfirmCallBack(confirmCallBacks);
        }
    }

    protected void showConfirmCallBack(ConfirmCallBackListener confirmCallBacks) {
        DynamicObjectCollection ruleEntity = this.getModel().getEntryEntity("ruleentity");
        long rule = ruleEntity.stream().filter(r -> null != r.getDynamicObject("rule")).count();
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentity");
        long org = orgEntity.stream().filter(r -> null != r.getDynamicObject("prepayproject")).count();
        if (rule == 0L && org == 0L) {
            return;
        }
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"PrepaySharePlanFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"PrepaySharePlanFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        String msg = String.format(ResManager.loadKDString((String)"\u4fee\u6539\u201c%s\u201d\u5c06\u6e05\u7a7a\u5171\u4eab\u89c4\u5219\u53ca\u5171\u4eab\u9879\u76ee\uff0c\r\n\u60a8\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"PrepaySharePlanFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]), ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"PrepaySharePlanFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"createorg")) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().deleteEntryData("ruleentity");
                this.getModel().deleteEntryData("orgentity");
                this.getView().invokeOperation("ruleadd");
                this.getView().invokeOperation("orgadd");
                DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
                if (null == createorg) {
                    return;
                }
            } else {
                this.getPageCache().put("createplan", "false");
                this.getModel().setValue("createorg", (Object)this.getPageCache().get("olddata"));
                this.getPageCache().put("createplan", "true");
            }
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"cardSwitch") && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getPageCache().put("createplan", "false");
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"cardSwitch")) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                String oldRow = this.getPageCache().get("oldRow");
                DynamicObjectCollection collection = this.getModel().getEntryEntity("planentity");
                DynamicObject oldObject = (DynamicObject)collection.get(Integer.parseInt(oldRow));
                DynamicObject planRow = this.loadPlanData(oldObject.getLong("id"));
                if (null != planRow) {
                    List ruleList = planRow.getDynamicObjectCollection("ruleentity").stream().map(o -> o.getString("rule.id")).collect(Collectors.toList());
                    List orgList = planRow.getDynamicObjectCollection("orgentity").stream().map(o -> o.getString("prepayproject_id")).collect(Collectors.toList());
                    oldObject.set("olddata", (Object)DynamicObjectSerializeUtil.serialize((Object[])new Object[]{planRow}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSharePlanEntityName())));
                    for (Map.Entry entry : this.planFieldMap.entrySet()) {
                        oldObject.set((String)entry.getValue(), planRow.get((String)entry.getKey()));
                    }
                    this.getModel().setEntryCurrentRowIndex("planentity", Integer.parseInt(oldRow));
                    this.getModel().deleteEntryData("ruleentity");
                    ruleList.stream().forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow("ruleentity");
                        this.getModel().setValue("rule", (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getModel().deleteEntryData("orgentity");
                    orgList.stream().forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow("orgentity");
                        this.getModel().setValue("prepayproject", (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getView().updateView("planentity");
                } else {
                    this.getModel().deleteEntryRow("planentity", Integer.parseInt(oldRow));
                }
                this.selectListRow(Integer.parseInt(this.getPageCache().get("newRow")));
            } else {
                this.selectListRow(Integer.parseInt(this.getPageCache().get("oldRow")));
            }
            return;
        }
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DeleteEntry deleteEntry;
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"save")) {
            String planName = ((DynamicObject)this.getModel().getEntryEntity("planentity").get(this.getSelectRows())).getString("carname");
            DynamicObjectCollection orgentiy = this.getModel().getEntryEntity("orgentity");
            List emptySeqList = orgentiy.stream().filter(o -> null == o.getDynamicObject("prepayproject")).map(o -> o.getInt("seq")).collect(Collectors.toList());
            for (int i = 1; i <= emptySeqList.size(); ++i) {
                this.getModel().deleteEntryRow("orgentity", (Integer)emptySeqList.get(i - 1) - i);
            }
            int orgentityCount = this.getModel().getEntryEntity("orgentity").getRowCount();
            if (orgentityCount == 0) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u88ab\u5171\u4eab\u9879\u76ee\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u88ab\u5171\u4eab\u9879\u76ee\u3002", (String)"PrepaySharePlanFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]), planName);
                this.getView().showErrorNotification(errMsg);
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection ruleentity = this.getModel().getEntryEntity("ruleentity");
            List ruleEmptySeqList = ruleentity.stream().filter(o -> null == o.getDynamicObject("rule")).map(o -> o.getInt("seq")).collect(Collectors.toList());
            for (int i = 1; i <= ruleEmptySeqList.size(); ++i) {
                this.getModel().deleteEntryRow("ruleentity", (Integer)ruleEmptySeqList.get(i - 1) - i);
            }
            int ruleentityCount = this.getModel().getEntryEntity("ruleentity").getRowCount();
            if (ruleentityCount == 0) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u5171\u4eab\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5171\u4eab\u89c4\u5219\u3002", (String)"PrepaySharePlanFormPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]), planName);
                this.getView().showErrorNotification(errMsg);
                args.setCancel(true);
                return;
            }
        }
        if (args.getSource() instanceof DeleteEntry && "deleteorg".equals((deleteEntry = (DeleteEntry)args.getSource()).getOperateKey())) {
            args.setCancel(true);
            EntryGrid entrye = (EntryGrid)this.getControl("orgentity");
            entrye.getSelectRows();
            String projectName = this.getModel().getEntryRowEntity("orgentity", entrye.getSelectRows()[0]).getString("prepayproject.name");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgDeleteConform", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"SharingPlanEdit_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"SharingPlanEdit_9", (String)"taxc-tcvat", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u5c06\u201c%1$s\u201d\u4ece\u201c%2$s\u201d\u65b9\u6848\u7684\u5171\u4eab\u8303\u56f4\u4e2d\u5254\u9664\uff1f", (String)"SharingPlanEdit_10", (String)"taxc-tcvat", (Object[])new Object[0]), projectName, this.getModel().getValue("planname"));
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        String userName = RequestContext.get().getUserName();
        Object number = this.getModel().getValue("number");
        DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"plandel")) {
            this.getPageCache().put("createplan", "false");
            Map<String, String> operateMap = SharingPlanOperateEnum.getOperateMap(args.getOperateKey());
            if (!operateMap.isEmpty() && this.getModel().getValue("createorg") != null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7528\u6237 %1$s \u5220\u9664\u4e86\u7f16\u7801\u4e3a %2$s \u521b\u5efa\u7ec4\u7ec7\u4e3a %3$s \u7684 %4$s \u5171\u4eab\u65b9\u6848", (String)"PrepaySharePlanFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]), userName, number, createorg.getString("name"), name.getLocaleValue());
                OperatorDialogUtils.operateDialog((String)"zzs", (String)"tcvat_prepay_shareplan_fo", (String)operateMap.get("name"), (String)msg);
            }
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"save")) {
            Map<String, String> operateMap;
            OperationResult result = args.getOperationResult();
            if (result.isSuccess()) {
                this.getPageCache().put("createplan", "false");
            }
            if (!(operateMap = SharingPlanOperateEnum.getOperateMap(args.getOperateKey())).isEmpty() && this.getModel().getValue("createorg") != null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7528\u6237 %1$s \u7f16\u8f91\u4fdd\u5b58\u4e86\u7f16\u7801\u4e3a %2$s \u521b\u5efa\u7ec4\u7ec7\u4e3a %3$s \u7684 %4$s \u5171\u4eab\u65b9\u6848", (String)"PrepaySharePlanFormPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]), userName, number, createorg.getString("name"), name.getLocaleValue());
                OperatorDialogUtils.operateDialog((String)"zzs", (String)"tcvat_prepay_shareplan_fo", (String)operateMap.get("name"), (String)msg);
            }
        }
        super.afterDoOperation(args);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String resultMsg;
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)"bar_close") && StringUtil.isNotBlank((CharSequence)(resultMsg = this.checkChangeData()))) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bar_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingPlanEdit_14", (String)"taxc-tcvat", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingPlanEdit_15", (String)"taxc-tcvat", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingPlanEdit_16", (String)"taxc-tcvat", (Object[])new Object[0]);
            this.getView().showConfirm(msg, resultMsg, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    private String checkChangeData() {
        DynamicObjectCollection planCollection = this.getModel().getEntryEntity("planentity");
        if (planCollection.isEmpty()) {
            return "";
        }
        DynamicObject newPlan = this.getPlanObject((DynamicObject)planCollection.get(this.getSelectRows()));
        StringBuilder msg = new StringBuilder();
        Long planId = (Long)this.getModel().getValue("id");
        if (planId == null || planId == 0L) {
            String name = ResManager.loadKDString((String)"\u65b0\u589e\u5171\u4eab\u65b9\u6848\u5747\u672a\u4fdd\u5b58\uff01", (String)"SharingPlanEdit_17", (String)"taxc-tcvat", (Object[])new Object[0]);
            msg.append(name);
            return msg.toString();
        }
        DynamicObject[] planObject = this.loadPlanDatas();
        Map<String, DynamicObject> oldPlanMap = Arrays.stream(planObject).collect(Collectors.toMap(a -> a.getString("id"), b -> b));
        StringBuilder words = new StringBuilder();
        String newName = newPlan.getLocaleString("name").getLocaleValue();
        String id = newPlan.getString("id");
        if (!oldPlanMap.containsKey(id)) {
            String name = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u4e3a\u65b0\u589e\u65b9\u6848\u8fd8\u672a\u4fdd\u5b58\uff01", (String)"SharingPlanEdit_18", (String)"taxc-tcvat", (Object[])new Object[0]), newName);
            if (StringUtil.isBlank((CharSequence)msg)) {
                msg.append(name);
            } else {
                msg.append(this.SEPARATOR).append(name);
            }
        } else {
            String oldAutoshar;
            String newAutoshar;
            String name;
            DynamicObject oldPlan = oldPlanMap.get(id);
            List ruleEntityList = oldPlan.getDynamicObjectCollection("ruleentity").stream().filter(r -> null != r.getDynamicObject("rule") && "1".equals(r.getString("rule.enable"))).map(o -> o.getString("rule.id")).collect(Collectors.toList());
            List orgEntityList = oldPlan.getDynamicObjectCollection("orgentity").stream().map(o -> o.getString("prepayproject.id")).collect(Collectors.toList());
            String oldName = oldPlan.getLocaleString("name").getLocaleValue();
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = newPlan.getDynamicObjectCollection("ruleentity");
            ruleCol.stream().filter(r -> null != r.getDynamicObject("rule") && "1".equals(r.getString("rule.enable"))).forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = newPlan.getDynamicObjectCollection("orgentity");
            orgCol.stream().filter(r -> null != r.getDynamicObject("prepayproject")).forEach(orgRow -> orgList.add(orgRow.getDynamicObject("prepayproject").getString("id")));
            if (!StringUtil.equals((CharSequence)newName, (CharSequence)oldName)) {
                name = ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"SharingPlanEdit_19", (String)"taxc-tcvat", (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (oldPlan.containsProperty("entryautoshar") && newPlan.containsProperty("entryautoshar") && !(newAutoshar = newPlan.getString("entryautoshar")).equals(oldAutoshar = oldPlan.getString("entryautoshar"))) {
                String name2 = ResManager.loadKDString((String)"\u81ea\u52a8\u5171\u4eab", (String)"SharingPlanEdit_21", (String)"taxc-tcvat", (Object[])new Object[0]);
                words.append(name2).append(",");
            }
            if (!CollectionUtils.isEqualCollection(ruleList, ruleEntityList)) {
                name = ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u5361\u7247", (String)"SharingPlanEdit_22", (String)"taxc-tcvat", (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!CollectionUtils.isEqualCollection(orgList, orgEntityList)) {
                name = ResManager.loadKDString((String)"\u5171\u4eab\u9879\u76ee\u8303\u56f4", (String)"PrepaySharePlanFormPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]);
                words.append(name).append(",");
            }
            name = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u53d8\u66f4\u5b57\u6bb5\uff1a", (String)"SharingPlanEdit_24", (String)"taxc-tcvat", (Object[])new Object[0]), newName);
            if (StringUtil.isNotBlank((CharSequence)words)) {
                words.deleteCharAt(words.lastIndexOf(","));
                if (StringUtil.isBlank((CharSequence)msg)) {
                    msg.append(name).append((CharSequence)words);
                } else {
                    msg.append(this.SEPARATOR).append(name).append((CharSequence)words);
                }
            }
        }
        return msg.toString();
    }

    protected boolean isDataChange(DynamicObject newRowPlan, DynamicObject planRow) {
        if (ObjectUtils.isNotEmpty((Object)planRow)) {
            DynamicObject newRowObject = this.getPlanObject(newRowPlan);
            List ruleEntityList = planRow.getDynamicObjectCollection("ruleentity").stream().filter(r -> null != r.getDynamicObject("rule") && "1".equals(r.getString("rule.enable"))).map(o -> o.getString("rule.id")).collect(Collectors.toList());
            List orgEntityList = planRow.getDynamicObjectCollection("orgentity").stream().map(o -> o.getString("prepayproject.id")).collect(Collectors.toList());
            List<String> planEntity = Arrays.asList(planRow.getString("number"), planRow.getString("name"));
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = newRowObject.getDynamicObjectCollection("ruleentity");
            ruleCol.stream().filter(r -> null != r.getDynamicObject("rule") && "1".equals(r.getString("rule.enable"))).forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = newRowObject.getDynamicObjectCollection("orgentity");
            orgCol.stream().forEach(orgRow -> orgList.add(orgRow.getString("prepayproject.id")));
            List<String> plan = Arrays.asList(newRowObject.getString("number"), newRowObject.getString("name"));
            if (!(CollectionUtils.isEqualCollection(plan, planEntity) && CollectionUtils.isEqualCollection(ruleList, ruleEntityList) && CollectionUtils.isEqualCollection(orgList, orgEntityList))) {
                return true;
            }
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        if (StringUtil.equalsIgnoreCase((CharSequence)event.getProperty().getName(), (CharSequence)"prepayproject")) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            DynamicObjectCollection prepayProjectCollection = this.getModel().getEntryEntity("orgentity");
            List prepayProjectId = prepayProjectCollection.stream().filter(o -> o.getPkValue() != null && o.getDynamicObject("prepayproject") != null).map(v -> v.getLong("prepayproject.id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "not in", prepayProjectId));
            TaxResult result = PermDataServiceHelper.getUserHasPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"10");
            if (result.isSuccess() && ((List)result.getData()).size() > 0) {
                qFilters.add(new QFilter("org", "in", result.getData()));
            }
            qFilters.add(new QFilter("projectstatus", "=", (Object)"going"));
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            event.getCustomQFilters().addAll(qFilters);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)event.getProperty().getName(), (CharSequence)"createorg")) {
            List createOrgList = new ArrayList(10);
            TaxResult result = PermDataServiceHelper.getUserHasPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"10");
            if (result.isSuccess() && ((List)result.getData()).size() > 0) {
                List enableOrgidList = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"10", (boolean)false);
                ((List)result.getData()).retainAll(enableOrgidList);
                createOrgList = (List)result.getData();
            }
            event.getCustomQFilters().add(new QFilter("id", "in", createOrgList));
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        if (afterF7SelectEvent.getInputValues().size() == 0) {
            return;
        }
        String entryKey = ((BasedataEdit)afterF7SelectEvent.getSource()).getEntryKey();
        if ("ruleentity".equalsIgnoreCase(entryKey)) {
            if (this.checkRuleData(Collections.singletonList(Long.valueOf(afterF7SelectEvent.getInputValues().get(0).toString())))) {
                return;
            }
            this.getView().invokeOperation("ruledel");
            this.getView().invokeOperation("ruleadd");
        }
    }

    private boolean checkRuleData(List<Long> ruleid) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tcvat_rule_prepay", (String)"prepayproject.prepaytype as prepaytype", (QFilter[])new QFilter[]{new QFilter("id", "in", ruleid)});
        boolean anyMatch = query.stream().collect(Collectors.groupingBy(rs -> rs.get("prepaytype"))).values().stream().anyMatch(p -> p.size() > 1);
        if (anyMatch) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u9884\u7f34\u9879\u76ee\u7c7b\u578b\u7684\u89c4\u5219\u4ec5\u80fd\u9009\u62e9\u4e00\u4e2a\u8fdb\u884c\u5171\u4eab\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PrepayRuleF7Plugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void setRuleFilter(BeforeF7SelectEvent event) {
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
        if (createOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"SbxSharePlanFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)createOrg.getLong("id"));
        QFilter ruletypeFilter = new QFilter("ruletype", "=", (Object)"public");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection rules = this.getModel().getEntryEntity("ruleentity");
        List ruleIds = rules.stream().filter(o -> o.getPkValue() != null && o.getDynamicObject("rule") != null).map(v -> v.getLong("rule.id")).collect(Collectors.toList());
        QFilter ruleIdsFilter = new QFilter("id", "not in", ruleIds);
        QFilter groupIdFilter = new QFilter("group.parent", "=", (Object)1870275165167180800L);
        event.getCustomQFilters().add(orgFilter);
        event.getCustomQFilters().add(ruletypeFilter);
        event.getCustomQFilters().add(groupIdFilter);
        event.getCustomQFilters().add(ruleIdsFilter);
        event.getCustomQFilters().add(enableFilter);
        event.getFormShowParameter().setCustomParam("parent", (Object)"1870275165167180800");
        ((ListShowParameter)event.getFormShowParameter()).setShowApproved(false);
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.addCustPlugin("kd.taxc.tcvat.formplugin.rule.shareplan.prepay.PrepayRuleF7Plugin");
    }

    protected DynamicObject[] loadPlanDatas() {
        List orgIdList = new ArrayList(10);
        TaxResult result = PermDataServiceHelper.getUserHasPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"10");
        if (result.isSuccess() && ((List)result.getData()).size() > 0) {
            orgIdList = (List)result.getData();
        }
        return BusinessDataServiceHelper.load((String)"tcvat_prepay_shareplan", (String)"id,status,enable,createorg,number,name,creator,createtime,modifier,modifytime,ruleentity.seq,orgentity.seq,ruleentity.rule,ruleentity.rule.prepayproject,orgentity.prepayproject,orgentity.org", (QFilter[])new QFilter[]{new QFilter("createorg", "in", orgIdList)}, (String)"createtime desc,ruleentity.seq asc,orgentity.seq asc");
    }

    protected DynamicObject loadPlanData(Long id) {
        return BusinessDataServiceHelper.loadSingle((String)"tcvat_prepay_shareplan", (String)"id,status,enable,createorg,number,name,creator,createtime,modifier,modifytime,ruleentity.seq,orgentity.seq,ruleentity.rule,ruleentity.rule.prepayproject,orgentity.prepayproject,orgentity.org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    protected String getSharePlanEntityName() {
        return "tcvat_prepay_shareplan";
    }

    protected void innerLoadData(DynamicObject planRow) {
        int rowIndex = this.getModel().createNewEntryRow("planentity");
        this.getModel().setValue("id", planRow.get("id"), rowIndex);
        this.setCardViewField(planRow, rowIndex);
        this.getModel().setValue("creator", planRow.get("creator"), rowIndex);
        this.getModel().setValue("createtime", planRow.get("createtime"), rowIndex);
        this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId(), rowIndex);
        this.getModel().setValue("modifytime", (Object)new Date(), rowIndex);
        this.getModel().setValue("olddata", (Object)DynamicObjectSerializeUtil.serialize((Object[])new Object[]{planRow}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSharePlanEntityName())), rowIndex);
        this.getModel().setEntryCurrentRowIndex("planentity", rowIndex);
        DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection("ruleentity");
        ruleCol.stream().filter(r -> "1".equalsIgnoreCase(r.getString("rule.enable"))).forEach(ruleRow -> {
            int subRowIndex = this.getModel().createNewEntryRow("ruleentity");
            this.getModel().setValue("rule", ruleRow.get("rule"), subRowIndex);
            this.getModel().setValue("ruleentryid", ruleRow.get("id"), subRowIndex);
            this.getModel().setValue("project", ruleRow.get("rule.prepayproject.id"), subRowIndex);
        });
        DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection("orgentity");
        orgCol.stream().forEach(orgRow -> {
            int subRowIndex = this.getModel().createNewEntryRow("orgentity");
            this.getModel().setValue("org", (Object)orgRow.getDynamicObject("prepayproject").getLong("org.id"), subRowIndex);
            this.getModel().setValue("orgentryid", orgRow.get("id"), subRowIndex);
            this.getModel().setValue("prepayproject", orgRow.get("prepayproject"), subRowIndex);
        });
    }

    protected void afterRestPlanName(Integer startRowIndex) {
        DynamicObject[] planentities;
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        if ((planentities = this.getModel().getEntryEntity("planentity", startRowIndex.intValue(), startRowIndex + 1)) != null && planentities.length > 0) {
            if (planentities[0].getLong("id") == 0L) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"createorg"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"createorg"});
            }
        }
    }

    protected boolean beforeSavePlan() {
        boolean anyMatch;
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
        if (createOrg != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)createOrg.getLong("id")).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"PrepaySharePlanFormPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection planentityCollection = this.getModel().getEntryEntity("planentity");
        int planCount = planentityCollection.getRowCount();
        if (planCount == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"SbxSharePlanFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        HashSet<String> planMap = new HashSet<String>(planentityCollection.size());
        for (int row = 0; row < planentityCollection.size(); ++row) {
            String planName = ((DynamicObject)planentityCollection.get(row)).getString("carname");
            String planCreateOrg = ((DynamicObject)planentityCollection.get(row)).getDynamicObject("carcreateorg").getString("id");
            String uniqueFields = planName + planCreateOrg;
            if (planMap.contains(uniqueFields)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\uff08%s\uff09\u91cd\u590d\uff0c\u8bf7\u8bbe\u7f6e\u4e0d\u540c\u7684\u65b9\u6848\u540d\u79f0\u3002", (String)"SbxSharePlanFormPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]), planName);
                this.getView().showErrorNotification(errMsg);
                return false;
            }
            planMap.add(uniqueFields);
        }
        DynamicObjectCollection ruleEntity = this.getModel().getEntryEntity("ruleentity");
        if (ruleEntity != null && !ruleEntity.isEmpty() && (anyMatch = ruleEntity.stream().filter(p -> StringUtil.isNotBlank((CharSequence)p.getString("project.prepaytype"))).collect(Collectors.groupingBy(rs -> rs.get("project.prepaytype"))).values().stream().anyMatch(p -> p.size() > 1))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u9884\u7f34\u9879\u76ee\u7c7b\u578b\u7684\u89c4\u5219\u4ec5\u80fd\u9009\u62e9\u4e00\u4e2a\u8fdb\u884c\u5171\u4eab\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PrepayRuleF7Plugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected DynamicObject getPlanObject(DynamicObject row) {
        Long planId = row.getLong("id");
        DynamicObject planObject = BusinessDataServiceHelper.newDynamicObject((String)this.getSharePlanEntityName());
        if (!ObjectUtils.isEmpty((Object)planId) && planId > 0L) {
            planObject = this.loadPlanData(planId);
        } else {
            planObject.set("creator", row.get("creator"));
            planObject.set("createtime", row.get("createtime"));
        }
        this.setPlanField(planObject, row);
        planObject.set("modifier", row.get("modifier"));
        planObject.set("modifytime", row.get("modifytime"));
        planObject.set("status", (Object)"C");
        planObject.set("enable", (Object)1);
        DynamicObjectCollection ruleCol = row.getDynamicObjectCollection("ruleentity");
        DynamicObjectCollection ruleCollection = planObject.getDynamicObjectCollection("ruleentity");
        ruleCollection.clear();
        Stream.iterate(0, i -> i + 1).limit(ruleCol.size()).forEach(index -> {
            DynamicObject rule = (DynamicObject)ruleCol.get(index.intValue());
            DynamicObject ruleRow = ruleCollection.addNew();
            ruleRow.set("seq", index);
            ruleRow.set("id", rule.get("ruleentryid"));
            ruleRow.set("rule", rule.get("rule"));
        });
        DynamicObjectCollection orgCol = row.getDynamicObjectCollection("orgentity");
        DynamicObjectCollection orgCollection = planObject.getDynamicObjectCollection("orgentity");
        orgCollection.clear();
        Stream.iterate(0, i -> i + 1).limit(orgCol.size()).forEach(index -> {
            DynamicObject org = (DynamicObject)orgCol.get(index.intValue());
            DynamicObject orgRow = orgCollection.addNew();
            orgRow.set("seq", index);
            orgRow.set("id", org.get("orgentryid"));
            orgRow.set("prepayproject", org.get("prepayproject"));
            orgRow.set("org", org.get("prepayproject.org.id"));
        });
        return planObject;
    }

    protected void setVisible() {
        super.setVisible();
        int row = this.getModel().getEntryRowCount("planentity");
        if (row > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_del"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_del"});
        }
    }

    public void accept(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        beforeF7ViewDetailEvent.setCancel(true);
        Object pkId = beforeF7ViewDetailEvent.getPkId();
        DynamicObject prepayRuleObject = QueryServiceHelper.queryOne((String)"tcvat_all_rule_config", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        String formId = RuleTypeStrategyEnum.getStrategyByGroupId(prepayRuleObject.getString("group")).getFormId();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId(pkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

