/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxcmain.TaxcMainBusiness;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.enums.RuleCodeEnum;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.impt.TcvatRuleEntryEntityEnum;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.tcvat.business.service.rule.DeductRuleService;
import kd.taxc.tcvat.common.util.TcvatCommonUtil;
import kd.taxc.tcvat.formplugin.rules.VatRateSetHandler;
import org.apache.commons.lang3.ObjectUtils;

public class DeductRulePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private DeductRuleService deductRuleService = new DeductRuleService();
    private static final List<String> pops = Lists.newArrayList((Object[])new String[]{"table", "table1", "table11", "amountfield11", "deducttype"});

    public void registerListener(EventObject event) {
        pops.forEach(s -> {
            BasedataEdit object = (BasedataEdit)this.getControl((String)s);
            object.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryentity11 = this.getModel().getEntryEntity("entryentity11");
        for (int i = 0; i < entryentity11.size(); ++i) {
            DynamicObject table11 = ((DynamicObject)entryentity11.get(i)).getDynamicObject("table11");
            DynamicObject amount = ((DynamicObject)entryentity11.get(i)).getDynamicObject("amountfield11");
            if (null == amount || null == table11) continue;
            boolean bigDecimalType = TcvatCommonUtil.isNumericType(table11.getString("entityname"), amount.getString("fieldname"));
            this.getView().setEnable(Boolean.valueOf(bigDecimalType), i, new String[]{"datatype11"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org;
        String ruletype;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object createorg = customParams.get("createorg");
        if (null != createorg) {
            this.getModel().setValue("org", createorg);
            customParams.remove("createorg");
            customParams.remove("orgid");
        }
        if ("private".equals(ruletype = (String)this.getModel().getValue("ruletype")) && null != (org = (DynamicObject)this.getModel().getValue("org"))) {
            List ybnsrIdList;
            TaxResult listTaxResult = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj((String)TaxcMainConstant.ENTITYNAME, (String)TaxcMainConstant.TAXC_MAIN_CARD_FILED, (String)"TaxcMainMService", (String)"queryTaxcMainZzsByOrgId", (Object[])new Object[]{Collections.singletonList(org.getLong("id")), TaxationsysMappingEnum.CHN.getId()});
            if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData()) && (ybnsrIdList = TaxcMainBusiness.queryTaxcMainByIsYbnsr((List)((List)listTaxResult.getData()))) != null && !ybnsrIdList.isEmpty()) {
                return;
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u975e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u8fdb\u9879\u62b5\u6263\u89c4\u5219\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"DeductRulePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), new Object[0]));
            this.getModel().setValue("org", (Object)0L);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject deductType;
        DynamicObject org;
        String ruletype;
        String eventName = e.getProperty().getName();
        if ("org".equals(eventName) && "private".equals(ruletype = (String)this.getModel().getValue("ruletype")) && null != (org = (DynamicObject)this.getModel().getValue("org"))) {
            List ybnsrIdList;
            TaxResult listTaxResult = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj((String)TaxcMainConstant.ENTITYNAME, (String)TaxcMainConstant.TAXC_MAIN_CARD_FILED, (String)"TaxcMainMService", (String)"queryTaxcMainZzsByOrgId", (Object[])new Object[]{Collections.singletonList(org.getLong("id")), TaxationsysMappingEnum.CHN.getId()});
            if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData()) && (ybnsrIdList = TaxcMainBusiness.queryTaxcMainByIsYbnsr((List)((List)listTaxResult.getData()))) != null && !ybnsrIdList.isEmpty()) {
                return;
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u975e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u8fdb\u9879\u62b5\u6263\u89c4\u5219\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"DeductRulePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), new Object[0]));
            this.getModel().setValue("org", (Object)0L);
        }
        if ("deducttype".equals(eventName) && null != (deductType = (DynamicObject)e.getChangeSet()[0].getNewValue()) && deductType.getString("number").equals("VAT_JXDK_BQDK_9")) {
            this.getModel().deleteEntryData("entryentity");
        }
        if ("rulepurpose".equals(eventName) && !this.deductRuleService.validDeductTypeByRulePurpose((String)this.getModel().getValue("rulepurpose"), (DynamicObject)this.getModel().getValue("deducttype")).get()) {
            this.getModel().setValue("deducttype", null);
        }
        if (Objects.equals("amountfield11", eventName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject amount = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (null == amount) {
                return;
            }
            DynamicObject table11 = (DynamicObject)this.getModel().getValue("table11");
            if (table11 == null) {
                return;
            }
            boolean bigDecimalType = TcvatCommonUtil.isNumericType(table11.getString("entityname"), amount.getString("fieldname"));
            if (!bigDecimalType) {
                this.getModel().setValue("datatype11", (Object)"zjjs");
            }
            this.getView().setEnable(Boolean.valueOf(bigDecimalType), rowIndex, new String[]{"datatype11"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        String name = evt.getProperty().getName();
        if (name.startsWith("table")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            String ruleType = RuleCodeEnum.getRuleType((String)formId);
            QFilter filter = new QFilter("basedataid.billno", "=", (Object)ruleType);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
        }
        if (evt.getProperty().getName().equals("deducttype")) {
            String rulepurpose = (String)this.getModel().getValue("rulepurpose");
            formShowParameter.getTreeFilterParameter().setQFilters(Collections.singletonList(new QFilter("number", "in", Arrays.asList("VAT_JXDK_BQDK", "VAT_JXDK_DDK"))));
            formShowParameter.getListFilterParameter().setQFilters(this.deductRuleService.getListFilterParameterByRulePurpose(rulepurpose));
            formShowParameter.getListFilterParameter().setOrderBy("id");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u62b5\u6263\u7c7b\u578b", (String)"DeductRulePlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (operateKey.startsWith("newentry")) {
            int[] selectRows;
            String suffix = operateKey.replace("newentry", "");
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity" + suffix);
            for (int selectRow : selectRows = entryGrid.getSelectRows()) {
                this.getModel().setValue("bizname" + suffix, this.getModel().getValue("name"), selectRow);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String operateKey = ((Donothing)args.getSource()).getOperateKey();
            EntryGrid entryentity = (EntryGrid)this.getControl(operateKey);
            if (null == entryentity) {
                return;
            }
            int focusRow = entryentity.getEntryState().getFocusRow();
            String vatrate = (String)this.getModel().getValue(operateKey + "confjson", focusRow);
            String entitySuffix = operateKey.replace("entryentity", "");
            String datatype = (String)this.getModel().getValue("datatype" + entitySuffix, focusRow);
            if (datatype.equals(DataType.ZJQS.getCode()) && "tcvat_rule_deduct".equals(this.getView().getEntityId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u884c\u7684\u53d6\u6570\u65b9\u5f0f\u7b49\u4e8e\u201d\u76f4\u63a5\u53d6\u6570\u201c\uff0c\u65e0\u9700\u914d\u7f6e\u201d\u9ad8\u7ea7\u914d\u7f6e\u201c\u3002", (String)"DeductRulePlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            this.openAdvancedConfPage(vatrate, operateKey);
        }
        if (args.getSource() instanceof Save) {
            VatRateSetHandler.doSetVatRateWhileZJQS(this.getModel(), TcvatRuleEntryEntityEnum.TCVAT_RULE_DEDUCT);
        }
    }

    private void openAdvancedConfPage(String vatrate, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tcvat_advance_config");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formshowParameter.getCustomParams().put("vatrate", vatrate);
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        String actionId = evt.getActionId();
        if (evt.getActionId().startsWith("entryentity") && (filterData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(evt.getActionId());
            this.getModel().setValue(actionId + "conf", (Object)"rate", currentRowIndex);
            this.getModel().setValue(actionId + "confjson", filterData.get("vatrate"), currentRowIndex);
        }
    }
}

