/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvat.business.service.rule.RuleService;

public class DiffRulePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private RuleService ruleService = new RuleService();
    private static final String DEFAULT_RULE_CODE = "RULE-VAT-DIFF-0000";
    private static Map<String, String> map = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        BasedataEdit difftype = (BasedataEdit)this.getControl("difftype");
        difftype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl("table");
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table1 = (BasedataEdit)this.getControl("table1");
        table1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject difftype = (DynamicObject)this.getModel().getValue("difftype");
        if (difftype != null) {
            BasedataEdit difftypeCtrl = (BasedataEdit)this.getControl("deductiontype");
            difftypeCtrl.setMustInput("VAT_CEKCLX_008".equals(difftype.getString("number")));
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object createorg;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object ruletype = customParams.get("ruletype");
        if (null == ruletype) {
            this.getModel().setValue("ruletype", (Object)"private");
        }
        if (null != (createorg = customParams.get("createorg"))) {
            this.getModel().setValue("org", createorg);
            customParams.remove("createorg");
            customParams.remove("orgid");
        }
        this.setTaxPayerType();
        DynamicObject difftype = (DynamicObject)this.getModel().getValue("difftype");
        if (difftype != null) {
            BasedataEdit difftypeCtrl = (BasedataEdit)this.getControl("deductiontype");
            difftypeCtrl.setMustInput("VAT_CEKCLX_008".equals(difftype.getString("number")));
        }
    }

    public void setTaxPayerType() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null == org) {
            return;
        }
        String taxpayertype = this.ruleService.getTaxPayerTypeBYOrgId(org.getLong("id"));
        this.getModel().setValue("taxPayerType", (Object)taxpayertype);
        if (Objects.nonNull(taxpayertype) && "xgmnsr".equals(taxpayertype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"jzjt"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if ("org".equals(eventName)) {
            this.setTaxPayerType();
        }
        if ("" != e.getChangeSet()[0].getOldValue() && ("taxpayertype".equals(eventName) || "number".equals(eventName))) {
            this.getModel().setValue("difftype", null);
            this.getView().setVisible("xgmnsr".equals(e.getChangeSet()[0].getNewValue()) ? Boolean.FALSE : Boolean.TRUE, new String[]{"jzjt"});
            this.getModel().setValue("jzjt", (Object)"0");
        } else if ("deductproject".equals(eventName)) {
            Object deductProject = this.getModel().getValue("deductproject");
            if ("bqfse".equals(deductProject)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap1", "advconap11"});
            } else if ("bqsjkce".equals(deductProject)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap1", "advconap11"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            } else if ("fseandkce".equals(deductProject)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap", "advconap1"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap11"});
            }
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("entryentity1");
            this.getModel().deleteEntryData("entryentity11");
        } else if ("difftype".equals(eventName)) {
            boolean equals;
            this.getModel().deleteEntryData("entryentity");
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            BasedataEdit difftypeCtrl = (BasedataEdit)this.getControl("deductiontype");
            boolean isMsxm = newValue != null && "VAT_CEKCLX_008".equals(newValue.getString("number"));
            difftypeCtrl.setMustInput(isMsxm);
            boolean bl = equals = e.getChangeSet()[0].getNewValue() != null && e.getChangeSet()[0].getNewValue().equals(e.getChangeSet()[0].getOldValue());
            if (!equals) {
                this.getModel().setValue("qzkce", (Object)false);
                this.getModel().deleteEntryData("entryentity1");
            }
            if (e.getChangeSet()[0].getOldValue() != null && "VAT_CEKCLX_008".equals(((DynamicObject)e.getChangeSet()[0].getOldValue()).getString("number")) && this.getModel().getValue("taxpayertype").equals("ybnsr")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap", "advconap1"});
            }
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("deductproject");
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
            if (!isMsxm) {
                combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d", (String)"DiffDeductionPlgin_3", (String)"taxc-tcvat", (Object[])new Object[0])), "bqfse"));
                combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d", (String)"DiffDeductionPlgin_7", (String)"taxc-tcvat", (Object[])new Object[0])), "bqsjkce"));
            } else {
                combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d", (String)"DiffDeductionPlgin_3", (String)"taxc-tcvat", (Object[])new Object[0])), "bqfse"));
                combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d", (String)"DiffDeductionPlgin_7", (String)"taxc-tcvat", (Object[])new Object[0])), "bqsjkce"));
                combos.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d\u548c\u5b9e\u9645\u6263\u9664\u989d", (String)"DiffRulePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0])), "fseandkce"));
            }
            comboEdit.setComboItems(combos);
        } else if ("jzjt".equals(eventName)) {
            Object jzjt = this.getModel().getValue("jzjt");
            if ("1".equals(jzjt) && "0".equals(e.getChangeSet()[0].getOldValue())) {
                this.getModel().setValue("qzkce", (Object)false);
                this.getModel().deleteEntryData("entryentity1");
            }
        } else if ("qzkce".equals(eventName)) {
            boolean qzkce = (Boolean)this.getModel().getValue("qzkce");
            if (qzkce) {
                this.getModel().deleteEntryData("entryentity1");
            }
            this.getView().setVisible(Boolean.valueOf(!qzkce), new String[]{"entryentity1"});
        } else if ("minswitch".equals(eventName)) {
            boolean minswitch = (Boolean)this.getModel().getValue("minswitch");
            if (minswitch) {
                this.getModel().deleteEntryData("entryentity1");
            }
            this.getView().setVisible(Boolean.valueOf(!minswitch), new String[]{"entryentity1"});
        } else if ("equalsjkce".equals(eventName)) {
            boolean equalsjkce = (Boolean)this.getModel().getValue("equalsjkce");
            if (equalsjkce) {
                this.getModel().deleteEntryData("entryentity11");
            }
            this.getView().setVisible(Boolean.valueOf(!equalsjkce), new String[]{"entryentity11"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        String typepayertype = (String)this.getModel().getValue("taxpayertype");
        if (Objects.nonNull(typepayertype) && "xgmnsr".equals(typepayertype) && evt.getProperty().getName().equals("difftype")) {
            formShowParameter.getListFilterParameter().setFilter(new QFilter("number", "in", (Object)new String[]{"VAT_CEKCLX_005", "VAT_CEKCLX_006", "VAT_CEKCLX_008", "VAT_CEKCLX_009"}));
        }
        if (Objects.nonNull(typepayertype) && "ybnsr".equals(typepayertype) && evt.getProperty().getName().equals("difftype")) {
            formShowParameter.getListFilterParameter().setFilter(new QFilter("number", "!=", (Object)"VAT_CEKCLX_009"));
        }
        if (evt.getProperty().getName().equals("table") || evt.getProperty().getName().equals("table1")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            String number = null;
            DynamicObject difftype = (DynamicObject)this.getModel().getValue("difftype");
            if (difftype != null) {
                number = difftype.getString("number");
            }
            String ruleCode = map.getOrDefault(number, DEFAULT_RULE_CODE);
            QFilter filter = new QFilter("basedataid.billno", "in", Arrays.asList(ruleCode, DEFAULT_RULE_CODE));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
        }
    }

    static {
        map.put("VAT_CEKCLX_001", "RULE-VAT-DIFF-0001");
        map.put("VAT_CEKCLX_002", "RULE-VAT-DIFF-0002");
        map.put("VAT_CEKCLX_003", "RULE-VAT-DIFF-0003");
        map.put("VAT_CEKCLX_004", "RULE-VAT-DIFF-0004");
        map.put("VAT_CEKCLX_005", "RULE-VAT-DIFF-0005");
        map.put("VAT_CEKCLX_006", "RULE-VAT-DIFF-0006");
        map.put("VAT_CEKCLX_007", "RULE-VAT-DIFF-0007");
        map.put("VAT_CEKCLX_008", "RULE-VAT-DIFF-0008");
    }
}

