/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class IncomeRuleSelectPlugin
extends AbstractFormPlugin
implements FilterContainerInitListener,
SearchClickListener {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String caption = (String)formShowParameter.getCustomParam("caption");
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            formShowParameter.setCaption(caption);
        }
    }

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.setBillFormId("tcvat_rule_income");
            filterContainer.setNeedShareScheme(false);
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        }
        Object orgId = this.getView().getFormShowParameter().getCustomParam("orgid");
        Object ruletype = this.getView().getFormShowParameter().getCustomParam("ruletype");
        BillList list = (BillList)this.getControl("billlistap");
        list.addSetFilterListener(args -> {
            List qFilters = args.getQFilters();
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            qFilters.add(new QFilter("taxpayertype", "=", (Object)"ybnsr"));
            qFilters.add(new QFilter("ruletype", "=", ruletype));
            qFilters.add(new QFilter("org", "=", orgId));
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filtergridview", "schemefilterview"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.addSearchClickListener((SearchClickListener)this);
        }
        this.addClickListeners(new String[]{"btnok"});
    }

    public void filterContainerInit(FilterContainerInitEvent evt) {
        List fastFilterColumns = evt.getFastFilterColumns();
        List columns = fastFilterColumns.stream().filter(f -> "name".equals(f.getFieldName())).collect(Collectors.toList());
        fastFilterColumns.clear();
        fastFilterColumns.addAll(columns);
        evt.getCommonFilterColumns().clear();
        evt.getSchemeFilterColumns().clear();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if ("btnok".equals(key)) {
            BillList list = (BillList)this.getControl("billlistap");
            Object[] primaryKeyValues = list.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeyValues.length > 0) {
                Object pkId = this.getView().getFormShowParameter().getCustomParams().get("pkId");
                DynamicObject exists = QueryServiceHelper.queryOne((String)"tcvat_rule_wkpsr", (String)"id", (QFilter[])new QFilter[]{new QFilter("rulename", "=", primaryKeyValues[0])});
                if (exists != null && !exists.get("id").equals(pkId)) {
                    DynamicObject query = QueryServiceHelper.queryOne((String)"tcvat_rule_income", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValues[0])});
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u201c%s\u201d\u89c4\u5219\u5df2\u88ab\u5f15\u7528", (String)"IncomeRuleSelectPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), query.getString("name")));
                    return;
                }
            }
            this.getView().returnDataToParent((Object)primaryKeyValues);
            this.getView().close();
        }
    }

    public void click(SearchClickEvent searchClickEvent) {
        BillList list = (BillList)this.getControl("billlistap");
        list.clearSelection();
        FilterParameter filterParameter = new FilterParameter(searchClickEvent.getFastQFilters(), null);
        List qFilters = filterParameter.getQFilters();
        Object orgId = this.getView().getFormShowParameter().getCustomParam("orgid");
        Object ruletype = this.getView().getFormShowParameter().getCustomParam("ruletype");
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("taxpayertype", "=", (Object)"ybnsr"));
        qFilters.add(new QFilter("ruletype", "=", ruletype));
        qFilters.add(new QFilter("org", "=", orgId));
        list.setQueryFilterParameter(filterParameter);
        this.getView().updateView("billlistap");
    }
}

