/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;
import kd.taxc.tcvat.business.service.rule.NcpRuleConfService;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.common.dto.base.ResponseDto;

public class NcpRuleConfPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener {
    private static final Log logger = LogFactory.getLog(NcpRuleConfPlugin.class);
    private Set<String> productKeys = new HashSet<String>(Arrays.asList("productadd", "productup", "productdown", "productlabel", "cardflexpanelap2", "cardflexpanelap3", "cardflexpanelap4", "cardflexpanelap5", "cardflexpanelap7", "product_image", "labelap_modifydate", "labelap_cpmc", "labelap_dhzsfs", "labelap_enable", "labelap_disable"));
    private Set<String> ncpKeys = new HashSet<String>(Arrays.asList("ncpadd", "ncpup", "ncpdown", "ncplabel", "cardflexpanelap11", "cardflexpanelap21", "cardflexpanelap31", "cardflexpanelap41", "cardflexpanelap51", "cardflexpanelap71", "ncp_image", "labelap_modifydate1", "labelap_hyncpmc", "labelap_ylfl", "labelap_enable1", "labelap_disable1"));
    private static String TREE_ORG = "treeviewap";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String PRODUCT = "product";
    private static final String NCP = "ncp";
    private static final String RULE_TYPE = "ruleType";
    private static final String CURRENT_TAB = "CURRENT_TAB";
    private NcpRuleConfService ncpRuleConfService = new NcpRuleConfService();

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_ORG);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(this::orgSearchListener);
        this.addClickListeners(this.productKeys.toArray(new String[0]));
        this.addClickListeners(this.ncpKeys.toArray(new String[0]));
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String ruletype = (String)this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if (null == ruletype) {
            this.getPageCache().put(RULE_TYPE, "private");
        } else {
            this.getPageCache().put(RULE_TYPE, ruletype);
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        this.getPageCache().put(CURRENT_TAB, "productruletab");
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        String issystem = "0";
        if (this.productKeys.contains(key)) {
            this.doClick(key, issystem, PRODUCT);
        } else if (this.ncpKeys.contains(key)) {
            this.doClick(key, issystem, NCP);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        HasPermOrgResult hasPermOrgResult;
        String nodeName;
        ResponseDto response;
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        String current = this.getPageCache().get(CURRENT_NODE);
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
        if (nodeId.equals(current)) {
            current = null;
            this.getPageCache().put(CURRENT_NODE, "0");
        }
        if (!"0".equals((response = this.ncpRuleConfService.checkTreeNode(nodeId, nodeName = treeNode != null ? treeNode.getText() : null, hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView()))).getCode())) {
            if ("2".equals(response.getCode())) {
                this.getView().showTipNotification(response.getMsg());
            } else if ("1".equals(response.getCode())) {
                this.getView().showErrorNotification(response.getMsg());
            }
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            return;
        }
        pageCache.put(CURRENT_NODE, nodeId);
        String tab = pageCache.get(CURRENT_TAB);
        boolean existTypeChange = RuleService.loadTaxPayerTypeChangeRecord(this.getPageCache().get(CURRENT_NODE), this.getPageCache().get(RULE_TYPE));
        pageCache.put("existTypeChange", existTypeChange ? "true" : "false");
        if (null != tab) {
            if ("productruletab".equals(tab)) {
                this.loadProductRule();
            } else if ("ncpruletab".equals(tab)) {
                this.loadNcpRule();
            }
        } else {
            this.loadProductRule();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.refreshData();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tab = tabSelectEvent.getTabKey();
        this.getPageCache().put(CURRENT_TAB, tab);
        if ("productruletab".equals(tab)) {
            this.loadProductRule();
        } else if ("ncpruletab".equals(tab)) {
            this.loadNcpRule();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.refreshData();
    }

    private void doClick(String key, String issystem, String type) {
        Object pkid;
        EntryGrid entryGrid = (EntryGrid)this.getControl(type + "entity");
        int[] selectRows = entryGrid.getSelectRows();
        Object object = pkid = selectRows.length > 0 ? this.getModel().getValue(type + "id", selectRows[0]) : null;
        if (key.startsWith(type)) {
            pkid = null;
        }
        if (PRODUCT.equals(type)) {
            this.openRuleForm("tcvat_ncp_product_rule", pkid, issystem);
        } else {
            this.openRuleForm("tcvat_ncp_rule", pkid, issystem);
        }
    }

    private void refreshData() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        treeView.deleteAllNodes();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    private void orgSearchListener(SearchEnterEvent event) {
        IPageCache pageCache = this.getPageCache();
        String treeCache = pageCache.get(TREE_ORG);
        if (treeCache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"NcpRuleConfPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
        ArrayList<String> dataKey = new ArrayList<String>();
        dataKey.add("number");
        List nodes = SearchUtil.getList((String)event.getText(), (TreeNode)root, dataKey);
        if (!nodes.isEmpty()) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)((TreeNode)nodes.get(0)).getId());
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"NcpRuleConfPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
    }

    private void openRuleForm(String formId, Object pkid, String issystem) {
        String orgId = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"NcpRuleConfPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(formId);
        if (pkid == null) {
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
            IPageCache pageCache = this.getPageCache();
            TreeView treeView = (TreeView)this.getControl(TREE_ORG);
            TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)orgId);
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            String nodeName = treeNode != null ? treeNode.getText() : null;
            ResponseDto response = this.ncpRuleConfService.checkTreeNode(orgId, nodeName, hasPermOrgResult);
            if (!"0".equals(response.getCode())) {
                if ("2".equals(response.getCode())) {
                    this.getView().showTipNotification(response.getMsg());
                } else if ("1".equals(response.getCode())) {
                    this.getView().showErrorNotification(response.getMsg());
                }
                return;
            }
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkid);
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("orgid", orgId);
        customParams.put("ruletype", (String)this.getView().getFormShowParameter().getCustomParams().get("ruletype"));
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setStatus("1".equals(issystem) ? OperationStatus.VIEW : OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void checkNode(TreeView treeView, IPageCache cache) {
        String status;
        Object orgid = this.getView().getFormShowParameter().getCustomParam("orgid");
        String currentTab = (String)this.getView().getFormShowParameter().getCustomParam(CURRENT_TAB);
        if (currentTab != null) {
            this.getPageCache().put(CURRENT_TAB, currentTab);
            Tab tabap = (Tab)this.getControl("tabap");
            tabap.activeTab(currentTab);
        }
        if (orgid != null) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)String.valueOf(orgid));
            return;
        }
        if (cache.get(CURRENT_NODE) != null && "1".equals(status = OrgUtils.getOrgStatusById((String)cache.get(CURRENT_NODE))) && ((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(cache.get(CURRENT_NODE))).getData()).booleanValue()) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)cache.get(CURRENT_NODE));
            return;
        }
        DynamicObject org = null;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getModel().getDataEntityType().getProperties().containsKey((Object)"org")) {
            org = (DynamicObject)parentView.getModel().getValue("org");
        }
        if (org != null && "1".equals(org.getString("enable")) && ((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)org.getString("id"));
        } else {
            orgid = RequestContext.get().getOrgId();
            try {
                String status2 = OrgUtils.getOrgStatusById((String)String.valueOf(orgid));
                if ("1".equals(status2)) {
                    HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
                    if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(orgid)) {
                        String orgname = OrgUtils.getOrgNameById((String)String.valueOf(orgid));
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NcpRuleConfPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
                        return;
                    }
                    TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)String.valueOf(orgid));
                    return;
                }
            }
            catch (Exception e) {
                logger.error("\u5f53\u524d\u7528\u6237\u4e1a\u52a1\u5355\u5143 \u4e0d\u5728 \u7a0e\u52a1\u4e91\u91cc ", (Throwable)e);
            }
            TreeUtils.checkFirstNode((IPageCache)cache, (TreeView)treeView);
        }
    }

    private void loadProductRule() {
        long orgId = Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE));
        String ruleType = this.getPageCache().get(RULE_TYPE);
        DynamicObjectCollection rules = this.ncpRuleConfService.queryProductRules(orgId, ruleType);
        Map dhzsfsMap = MetadataUtil.getComboItemsMap((String)"tcvat_ncp_product_rule", (String)"dhzsfs");
        this.loadRule(PRODUCT, rules, (rule, row) -> {
            this.getModel().setValue("cpmc", rule.get("cpmc"), row.intValue());
            this.getModel().setValue("dhzsfs", dhzsfsMap.get(rule.getString("dhzsfs")), row.intValue());
        });
    }

    private void loadNcpRule() {
        long orgId = Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE));
        String ruleType = this.getPageCache().get(RULE_TYPE);
        DynamicObjectCollection rules = this.ncpRuleConfService.queryNcpRules(orgId, ruleType);
        Map ylflMap = MetadataUtil.getComboItemsMap((String)"tcvat_ncp_rule", (String)"ylfl");
        this.loadRule(NCP, rules, (rule, row) -> {
            this.getModel().setValue("hyncpmc", rule.get("hyncpmc"), row.intValue());
            this.getModel().setValue("ylfl", ylflMap.get(rule.getString("ylfl")), row.intValue());
        });
    }

    private void loadRule(String type, DynamicObjectCollection rules, BiConsumer<DynamicObject, Integer> diySetValueFunc) {
        logger.info(SerializationUtils.toJsonString((Object)this.getModel().getDataEntity(true)));
        if (this.getModel().getDataEntityType().getProperty(type + "entity") != null) {
            this.getModel().deleteEntryData(type + "entity");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow(type + "entity");
                this.getModel().setValue(type + "id", rule.get("id"), row);
                this.getModel().setValue(type + "rulename", (Object)rule.getString("name"), row);
                this.getModel().setValue(type + "modifydate", rule.get("modifytime"), row);
                this.getModel().setValue(type + "enable", rule.get("enable"), row);
                String ruletype = rule.getString("ruletype");
                this.getModel().setValue(type + "ruletype", (Object)ruletype, row);
                diySetValueFunc.accept(rule, row);
                this.setBackgroundAndImage(row, type);
            }
            this.getModel().endInit();
            this.getView().updateView(type + "entity");
        }
    }

    private void setBackgroundAndImage(int row, String type) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        String ruleType = this.getPageCache().get(RULE_TYPE);
        if ("private".equals(ruleType)) {
            propertiesMap.put("bc", "#FFF2E9");
            propertiesMap.put("src", "/icons/pc/label/swy_zy_61_61.png");
        } else {
            propertiesMap.put("bc", "#E7F0FF");
            propertiesMap.put("src", "/icons/pc/label/swy_fp_61_61.png");
        }
        pmap.put(type + "_flex", propertiesMap);
        pmap.put(type + "_image", propertiesMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod(type + "entity", "setCustomProperties", new Object[]{row, pmap});
    }
}

