/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tcvat.common.util.TcvatCommonUtil;
import org.apache.commons.compress.utils.Sets;

public class RuleInvoicePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener {
    private static Log logger = LogFactory.getLog(RuleInvoicePlugin.class);
    private static final String TREE_ORG = "treeviewap";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String CURRENT_TAB = "CURRENT_TAB";
    private static final String INCOMEPROJECTTAB = "incomeprojecttab";
    private static final String ENTITY_INCOMEPROJECT = "tcvat_rule_incomeproject";
    private static final String ENTITY_OUTPUTPROJECT = "tcvat_rule_outputproject";
    private static final Set<String> incomeProjectKeys = Sets.newHashSet((Object[])new String[]{"incomeprojectup", "incomeprojectdown", "incomeprojectadd", "incomeprojectlabel", "income_flex1", "cardflexpanelap7", "cardflexpanelap2", "cardflexpanelap3", "cardflexpanelap4"});
    private static final Set<String> outputProjectKeys = Sets.newHashSet((Object[])new String[]{"outputprojectup", "outputprojectdown", "outputprojectadd", "outputprojectlabel", "output_flex1", "cardflexpanelap71", "cardflexpanelap21", "cardflexpanelap31", "cardflexpanelap41"});

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_ORG);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    public void registerListener(EventObject e) {
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(this::orgSearchListener);
        this.addClickListeners(incomeProjectKeys.toArray(new String[0]));
        this.addClickListeners(outputProjectKeys.toArray(new String[0]));
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void orgSearchListener(SearchEnterEvent event) {
        IPageCache pageCache = this.getPageCache();
        String treeCache = pageCache.get(TREE_ORG);
        if (treeCache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"RuleInvoicePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
        ArrayList<String> dataKey = new ArrayList<String>();
        dataKey.add("number");
        List nodes = SearchUtil.getList((String)event.getText(), (TreeNode)root, dataKey);
        if (!nodes.isEmpty()) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)((TreeNode)nodes.get(0)).getId());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"RuleInvoicePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        this.getPageCache().put(CURRENT_TAB, INCOMEPROJECTTAB);
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    public void click(EventObject evt) {
        EntryGrid entryGrid;
        Boolean hasRule = this.judgeHasRule(this.getPageCache().get(CURRENT_NODE));
        if (!hasRule.booleanValue()) {
            return;
        }
        Boolean success = TcvatCommonUtil.isYbnsr(this.getPageCache().get(CURRENT_NODE)).getSuccess();
        if (!success.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u5373\u5f81\u5373\u9000\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"RuleInvoicePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        String issystem = "0";
        Object pkid = null;
        if (incomeProjectKeys.contains(key)) {
            entryGrid = (EntryGrid)this.getControl("incomeprojectentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length > 0) {
                pkid = this.getModel().getValue("incomeid", selectRows[0]);
                issystem = Optional.ofNullable((String)this.getModel().getValue("ruleissystem", selectRows[0])).orElse("0");
            }
            if (key.contains("incomeproject")) {
                pkid = null;
            }
            this.openRuleForm(ENTITY_INCOMEPROJECT, pkid, issystem);
        } else if (outputProjectKeys.contains(key)) {
            entryGrid = (EntryGrid)this.getControl("outputprojectentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length > 0) {
                pkid = this.getModel().getValue("outputid", selectRows[0]);
                issystem = Optional.ofNullable((String)this.getModel().getValue("ruleissystem1", selectRows[0])).orElse("0");
            }
            if (key.contains("outputproject")) {
                pkid = null;
            }
            this.openRuleForm(ENTITY_OUTPUTPROJECT, pkid, issystem);
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl(TREE_ORG)), (String[])btns, (String)TREE_ORG);
        }
    }

    private void openRuleForm(String formId, Object pkid, String issystem) {
        String orgId = this.getPageCache().get(CURRENT_NODE);
        String taxPayerType = this.getPageCache().get("taxpayertype");
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"RuleInvoicePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(formId);
        if (pkid == null) {
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkid);
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("orgid", orgId);
        customParams.put("ruletype", "private");
        customParams.put("taxpayertype", taxPayerType);
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setStatus("1".equals(issystem) ? OperationStatus.VIEW : OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        Boolean hasRule = this.judgeHasRule(nodeId);
        if (!hasRule.booleanValue()) {
            evt.setCancel(true);
            return;
        }
        Boolean success = TcvatCommonUtil.isYbnsr(nodeId).getSuccess();
        if (!success.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u5373\u5f81\u5373\u9000\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"RuleInvoicePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        pageCache.put(CURRENT_NODE, nodeId);
        String tab = pageCache.get(CURRENT_TAB);
        if (StringUtils.isNotEmpty((CharSequence)tab) && INCOMEPROJECTTAB.equals(tab)) {
            this.loadInvoiceRule();
        } else if (StringUtils.isNotEmpty((CharSequence)tab) && "outputprojecttab".equals(tab)) {
            this.loadOutputInvoiceRule();
        }
    }

    private Boolean judgeHasRule(String nodeId) {
        DynamicObject dy;
        if (StringUtil.isBlank((CharSequence)nodeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"RuleInvoicePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return false;
        }
        IPageCache pageCache = this.getPageCache();
        String current = this.getPageCache().get(CURRENT_NODE);
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(nodeId))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleInvoicePlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]), treeNode.getText()));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            return false;
        }
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(nodeId)).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"RuleInvoicePlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            return false;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(nodeId)));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            DynamicObjectCollection list = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity");
            dy = (DynamicObject)list.get(0);
            if (Objects.isNull(((DynamicObject)((List)result.getData()).get(0)).getString("taxorg.unifiedsocialcode"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u201c%s\u201d\u5c1a\u672a\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u5148\u5230\u57fa\u7840\u6570\u636e-\u7a0e\u52a1\u4fe1\u606f\u754c\u9762\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f\u3002", (String)"RuleInvoicePlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]), treeNode.getText()));
                TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
                return false;
            }
            if (Objects.equals("0", dy.getString("enable"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u589e\u503c\u7a0e\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u8fdb\u884c\u542f\u7528\u3002", (String)"RuleInvoicePlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]), treeNode.getText()));
                TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
                return false;
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f\u3002", (String)"RuleInvoicePlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            return false;
        }
        pageCache.put("taxpayertype", dy.getString("taxpayertype"));
        return true;
    }

    private void loadInvoiceRule() {
        if (this.getModel().getDataEntityType().getProperty("incomeprojectentity") != null) {
            this.getModel().deleteEntryData("incomeprojectentity");
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)ENTITY_INCOMEPROJECT, (String)"sign");
            QFilter org = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE)));
            String fields = "id,org.name as org,org.status as status,ruletype,enable,name,modifytime,sign,issystem";
            DynamicObjectCollection rules = QueryServiceHelper.query((String)ENTITY_INCOMEPROJECT, (String)fields, (QFilter[])new QFilter[]{org}, (String)"modifytime desc");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("incomeprojectentity");
                this.getModel().setValue("incomeid", rule.get("id"), row);
                this.getModel().setValue("incomerulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("incomemodifydate", rule.get("modifytime"), row);
                this.getModel().setValue("jzjt", jzjtMap.get(rule.getString("sign")), row);
                this.getModel().setValue("ruleissystem", rule.get("issystem"), row);
                this.getModel().setValue("incomeenable", (Object)rule.getString("enable"), row);
            }
            this.getModel().endInit();
            this.getView().updateView("incomeprojectentity");
        }
    }

    private void loadOutputInvoiceRule() {
        if (this.getModel().getDataEntityType().getProperty("outputprojectentity") != null) {
            this.getModel().deleteEntryData("outputprojectentity");
            Map jzjtMap = MetadataUtil.getComboItemsMap((String)ENTITY_OUTPUTPROJECT, (String)"sign");
            QFilter org = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE)));
            String fields = "id,org.name as org,org.status as status,ruletype,enable,name,modifytime,sign,issystem";
            DynamicObjectCollection rules = QueryServiceHelper.query((String)ENTITY_OUTPUTPROJECT, (String)fields, (QFilter[])new QFilter[]{org}, (String)"modifytime desc");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("outputprojectentity");
                this.getModel().setValue("outputid", rule.get("id"), row);
                this.getModel().setValue("outputrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("outputmodifydate", rule.get("modifytime"), row);
                this.getModel().setValue("jzjt1", jzjtMap.get(rule.getString("sign")), row);
                this.getModel().setValue("ruleissystem1", rule.get("issystem"), row);
                this.getModel().setValue("incomeenable1", (Object)rule.getString("enable"), row);
            }
            this.getModel().endInit();
            this.getView().updateView("outputprojectentity");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.refreshData();
        }
    }

    private void refreshData() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        treeView.deleteAllNodes();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.refreshData();
    }

    private void checkNode(TreeView treeView, IPageCache cache) {
        String status;
        if (cache.get(CURRENT_NODE) != null && "1".equals(status = OrgUtils.getOrgStatusById((String)cache.get(CURRENT_NODE))) && ((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(cache.get(CURRENT_NODE))).getData()).booleanValue()) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)cache.get(CURRENT_NODE));
            return;
        }
        DynamicObject org = null;
        try {
            org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        }
        catch (Exception ee) {
            logger.error((Throwable)ee);
            org = null;
        }
        if (org != null && "1".equals(org.getString("enable")) && ((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)org.getString("id"));
        } else {
            Long orgid = RequestContext.get().getOrgId();
            try {
                String status2 = OrgUtils.getOrgStatusById((String)String.valueOf(orgid));
                if ("1".equals(status2)) {
                    HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
                    if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(orgid)) {
                        String orgname = OrgUtils.getOrgNameById((String)String.valueOf(orgid));
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleInvoicePlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]), orgname));
                        return;
                    }
                    TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)String.valueOf(orgid));
                    return;
                }
            }
            catch (Exception e) {
                logger.error("\u5f53\u524d\u7528\u6237\u4e1a\u52a1\u5355\u5143 \u4e0d\u5728 \u7a0e\u52a1\u4e91\u91cc ", (Throwable)e);
            }
            TreeUtils.checkFirstNode((IPageCache)cache, (TreeView)treeView);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put(CURRENT_TAB, tabKey);
        if (INCOMEPROJECTTAB.equals(tabKey)) {
            this.loadInvoiceRule();
        } else if ("outputprojecttab".equals(tabKey)) {
            this.loadOutputInvoiceRule();
        }
    }
}

