/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxcmain.TaxcMainBusiness;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import org.apache.commons.lang3.ObjectUtils;

public class WkpsrTzRulePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BUSINESS_TYPE = "businesstype";
    private static final String INCOME_RULE_ENTITY = "tcvat_rule_income";
    private static final String WKPSR_RULE_ENTITY = "tcvat_rule_wkpsr";
    private static final String WKPSR_RULE_ENTITY_INH = "tcvat_rule_wkpsr_inh";

    public void registerListener(EventObject e) {
        BasedataEdit rulename = (BasedataEdit)this.getControl("rulename");
        rulename.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("rulename", null);
        this.getModel().setValue("name", null);
        this.getModel().deleteEntryData("invoiceentity");
        this.getModel().deleteEntryData("entryentity1");
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org;
        Object createorg;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (WKPSR_RULE_ENTITY_INH.equals(this.getView().getFormShowParameter().getFormId())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)WKPSR_RULE_ENTITY);
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            String billno = codeRuleService.getNumber(WKPSR_RULE_ENTITY, dynamicObject, null);
            this.getModel().setValue("number", (Object)billno);
        }
        if (null != (createorg = customParams.get("createorg"))) {
            this.getModel().setValue("org", createorg);
            customParams.remove("createorg");
            customParams.remove("orgid");
        }
        if (null != (org = (DynamicObject)this.getModel().getValue("org"))) {
            List ybnsrIdList;
            TaxResult listTaxResult = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj((String)TaxcMainConstant.ENTITYNAME, (String)TaxcMainConstant.TAXC_MAIN_CARD_FILED, (String)"TaxcMainMService", (String)"queryTaxcMainZzsByOrgId", (Object[])new Object[]{Collections.singletonList(org.getLong("id")), TaxationsysMappingEnum.CHN.getId()});
            if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData()) && (ybnsrIdList = TaxcMainBusiness.queryTaxcMainByIsYbnsr((List)((List)listTaxResult.getData()))) != null && !ybnsrIdList.isEmpty()) {
                return;
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u975e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u672a\u5f00\u7968\u53f0\u8d26\u89c4\u5219\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"WkpsrTzRulePlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]), new Object[0]));
            this.getModel().setValue("org", (Object)0L);
        }
        this.loadIncomeRuleEntry();
    }

    public void afterBindData(EventObject e) {
        MulBasedataDynamicObjectCollection businesstype;
        DynamicObject rulename;
        Map customParams;
        Object createorg;
        if (WKPSR_RULE_ENTITY_INH.equals(this.getView().getFormShowParameter().getFormId())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
        if (null != (createorg = (customParams = this.getView().getFormShowParameter().getCustomParams()).get("createorg"))) {
            this.getModel().setValue("org", createorg);
            customParams.remove("createorg");
        }
        if ((rulename = (DynamicObject)this.getModel().getValue("rulename")) != null && (businesstype = (MulBasedataDynamicObjectCollection)this.getModel().getValue(BUSINESS_TYPE)).isEmpty()) {
            this.getModel().setValue(BUSINESS_TYPE, rulename.get(BUSINESS_TYPE));
        }
        this.loadIncomeRuleEntry();
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("rulename".equals(name) && !"setItemByNumber".equals(evt.getSourceMethod())) {
            evt.setCancel(true);
            HashMap<String, Object> custom = new HashMap<String, Object>();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            custom.put("orgid", null == org ? Long.valueOf(0L) : org.get("id"));
            custom.put("ruletype", this.getModel().getValue("ruletype"));
            custom.put("pkId", this.getModel().getValue("id"));
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_rule_inome_select", (IFormView)this.getView(), custom, (IFormPlugin)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if ("enable".equals(operate.getOperateKey())) {
            Long id = (Long)this.getModel().getValue("id");
            DynamicObject enable = QueryServiceHelper.queryOne((String)WKPSR_RULE_ENTITY, (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (enable != null && "1".equals(enable.getString("enable"))) {
                return;
            }
            DynamicObject rulename = (DynamicObject)this.getModel().getValue("rulename");
            if (rulename == null) {
                return;
            }
            Long incomeRuleId = rulename.getLong("id");
            DynamicObject incomeRule = QueryServiceHelper.queryOne((String)INCOME_RULE_ENTITY, (String)"id,ruletype,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)incomeRuleId), new QFilter("enable", "=", (Object)"0")});
            if (incomeRule != null) {
                String menuName = ResManager.loadKDString((String)"\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e", (String)"WkpsrTzRulePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u5f15\u7528\u7684\u6536\u5165\u9879\u76ee\u89c4\u5219\u5c1a\u672a\u542f\u7528\uff0c\u8bf7\u5148\u524d\u5f80\u3010%1$s\u3011\u542f\u7528\u3010\u7f16\u7801\uff1a%2$s,\u540d\u79f0\uff1a%3$s\u3011\u6536\u5165\u89c4\u5219\uff0c\u518d\u5bf9\u672c\u89c4\u5219\u8fdb\u884c\u542f\u7528\u3002", (String)"WkpsrTzRulePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]), menuName, incomeRule.getString("number"), incomeRule.getString("name")), MessageBoxOptions.OK);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            this.loadIncomeRuleEntry();
            if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newValue;
        if ("rulename".equals(e.getProperty().getName()) && (newValue = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            this.loadIncomeRuleEntry();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object[] ids;
        if ("tcvat_rule_inome_select".equals(evt.getActionId()) && (ids = (Object[])evt.getReturnData()) != null && ids.length > 0) {
            Long id = (Long)ids[0];
            this.getModel().setValue("rulename", (Object)id);
        }
    }

    private void loadIncomeRuleEntry() {
        this.getModel().deleteEntryData("invoiceentity");
        this.getModel().deleteEntryData("entryentity1");
        DynamicObject rulename = (DynamicObject)this.getModel().getValue("rulename");
        if (rulename != null) {
            DynamicObjectCollection entryentity1;
            long ruleId = rulename.getLong("id");
            DynamicObject incomeRule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)INCOME_RULE_ENTITY);
            this.getModel().setValue("name", (Object)incomeRule.getString("name"));
            DynamicObjectCollection wkpsrqsgz = incomeRule.getDynamicObjectCollection("invoiceentity");
            if (!wkpsrqsgz.isEmpty()) {
                this.getModel().beginInit();
                for (DynamicObject entry : wkpsrqsgz) {
                    int row = this.getModel().createNewEntryRow("invoiceentity");
                    this.getModel().setValue("invoicebizname", entry.get("invoicebizname"), row);
                    this.getModel().setValue("table12", entry.get("table12"), row);
                    this.getModel().setValue("invoicetaxrate", entry.get("invoicetaxrate"), row);
                    this.getModel().setValue("amountfield12", entry.get("amountfield12"), row);
                    this.getModel().setValue("absolute12", entry.get("absolute12"), row);
                    this.getModel().setValue("datatype12", entry.get("datatype12"), row);
                    this.getModel().setValue("datadirection12", entry.get("datadirection12"), row);
                    this.getModel().setValue("invoicefiltercondition", entry.get("invoicefiltercondition"), row);
                }
                this.getModel().endInit();
                this.getView().updateView("invoiceentity");
            }
            if (!(entryentity1 = incomeRule.getDynamicObjectCollection("entryentity1")).isEmpty()) {
                this.getModel().beginInit();
                for (DynamicObject entry : entryentity1) {
                    int row = this.getModel().createNewEntryRow("entryentity1");
                    this.getModel().setValue("bizname1", entry.get("bizname1"), row);
                    this.getModel().setValue("table1", entry.get("table1"), row);
                    this.getModel().setValue("amountfield1", entry.get("amountfield1"), row);
                    this.getModel().setValue("absolute1", entry.get("absolute1"), row);
                    this.getModel().setValue("datatype1", entry.get("datatype1"), row);
                    this.getModel().setValue("datadirection1", entry.get("datadirection1"), row);
                    this.getModel().setValue("filtercondition1", entry.get("filtercondition1"), row);
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity1");
            }
        }
    }
}

