/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.rules.refund;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.taxcmain.TaxcMainBusiness;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.impt.TcvatRuleEntryEntityEnum;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.tcvat.formplugin.rules.VatRateSetHandler;
import org.apache.commons.lang3.ObjectUtils;

public class RefundRulePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String REFUND_TYPE = "refundtype";
    private static List<String> SPECIAL_REFUND_TYPE = Arrays.asList("xxqy", "ybqy", "wxqy");

    public void registerListener(EventObject e) {
        BasedataEdit refundtype = (BasedataEdit)this.getControl(REFUND_TYPE);
        refundtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object createorg = customParams.get("createorg");
        if (null != createorg) {
            this.getModel().setValue("org", createorg);
            customParams.remove("createorg");
            customParams.remove("orgid");
        }
        if (null != (org = (DynamicObject)this.getModel().getValue("org"))) {
            List ybnsrIdList;
            TaxResult listTaxResult = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj((String)TaxcMainConstant.ENTITYNAME, (String)TaxcMainConstant.TAXC_MAIN_CARD_FILED, (String)"TaxcMainMService", (String)"queryTaxcMainZzsByOrgId", (Object[])new Object[]{Collections.singletonList(org.getLong("id")), TaxationsysMappingEnum.CHN.getId()});
            if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData()) && (ybnsrIdList = TaxcMainBusiness.queryTaxcMainByIsYbnsr((List)((List)listTaxResult.getData()))) != null && !ybnsrIdList.isEmpty()) {
                return;
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u975e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u7559\u62b5\u9000\u7a0e\u89c4\u5219\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"RefundRulePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]), new Object[0]));
            this.getModel().setValue("org", (Object)0L);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (REFUND_TYPE.equals(e.getProperty().getName())) {
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getCustomParams().put("taxtype", "1");
            formShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("number", "=", (Object)"sqthxm"));
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9000\u7a0e\u4f01\u4e1a\u7c7b\u578b", (String)"RefundRulePlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject refundtype;
        VatRateSetHandler.doSetVatRateWhileZJQS(this.getModel(), TcvatRuleEntryEntityEnum.TCVAT_RULE_REFUND);
        if (args.getSource() instanceof Save && ObjectUtils.isNotEmpty((Object)(refundtype = (DynamicObject)this.getModel().getValue(REFUND_TYPE)))) {
            this.getModel().clearNoDataRow();
            String number = refundtype.getString("number");
            if (!(SPECIAL_REFUND_TYPE.contains(number) || this.getModel().getEntryEntity("entryentity1").getRowCount() != 0 && this.getModel().getEntryEntity("entryentity2").getRowCount() != 0)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u81f3\u5c11\u914d\u7f6e\u4e00\u884c", (String)"RefundRulePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.getModel().getEntryEntity("entryentity").getRowCount() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u81f3\u5c11\u914d\u7f6e\u4e00\u884c", (String)"RefundRulePlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (operateKey.startsWith("newentry")) {
            int[] selectRows;
            String suffix = operateKey.replace("newentry", "");
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity" + suffix);
            for (int selectRow : selectRows = entryGrid.getSelectRows()) {
                this.getModel().setValue("bizname" + suffix, this.getModel().getValue("name"), selectRow);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String number;
        DynamicObject refundtype;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("org".equals(name)) {
            DynamicObject newOrg = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (null != org) {
                List ybnsrIdList;
                TaxResult listTaxResult = ServiceInvokeUtils.invokeTaxcTctbServiceWithObj((String)TaxcMainConstant.ENTITYNAME, (String)TaxcMainConstant.TAXC_MAIN_CARD_FILED, (String)"TaxcMainMService", (String)"queryTaxcMainZzsByOrgId", (Object[])new Object[]{Collections.singletonList(org.getLong("id")), TaxationsysMappingEnum.CHN.getId()});
                if (listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData()) && (ybnsrIdList = TaxcMainBusiness.queryTaxcMainByIsYbnsr((List)((List)listTaxResult.getData()))) != null && !ybnsrIdList.isEmpty()) {
                    return;
                }
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u975e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528\u7559\u62b5\u9000\u7a0e\u89c4\u5219\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"RefundRulePlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]), new Object[0]));
                this.getModel().setValue("org", (Object)0L);
            }
        }
        if (REFUND_TYPE.equals(name) && ObjectUtils.isNotEmpty((Object)(refundtype = (DynamicObject)this.getModel().getValue(REFUND_TYPE))) && SPECIAL_REFUND_TYPE.contains(number = refundtype.getString("number"))) {
            this.getModel().deleteEntryData("entryentity1");
            this.getModel().deleteEntryData("entryentity2");
        }
    }
}

