/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.taxrefund;

import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.tcvat.business.service.taxrefund.AccountServiceHelper;
import kd.taxc.tcvat.formplugin.taxrefund.AbstractRefundInitListPlugin;

public class TaxTotalDataListPlugin
extends AbstractRefundInitListPlugin {
    AccountServiceHelper accountServiceHelper = new AccountServiceHelper();

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        if ("deletedata".equals(key)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deletedata", (IFormPlugin)this);
            Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
            Set<String> conflictOrgName = this.accountServiceHelper.checkTaxRefundApply(primaryKeyValues);
            if (!CollectionUtils.isEmpty(conflictOrgName)) {
                String orgName = String.join((CharSequence)"\r\n", conflictOrgName);
                String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %s \u5b58\u5728\u9000\u7a0e\u7533\u8bf7\u8bb0\u5f55,\u65e0\u6cd5\u76f4\u63a5\u5220\u9664\u3002", (String)"TaxTotalDataListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), orgName);
                this.getView().showConfirm(msg, MessageBoxOptions.OK, confirmCallBacks);
                return;
            }
            conflictOrgName = this.accountServiceHelper.conflictOrgName(primaryKeyValues);
            if (!CollectionUtils.isEmpty(conflictOrgName)) {
                String orgName = String.join((CharSequence)"\r\n", conflictOrgName);
                String msg1 = ResManager.loadKDString((String)"\u8be5\u521d\u59cb\u5316\u6570\u636e\u5df2\u88ab\u53f0\u8d26\u5f15\u7528\uff0c\r\n\u5c06\u540c\u6b65\u5220\u9664\u53f0\u8d26\u6570\u636e\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"TaxTotalDataListPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]);
                String msg2 = String.format(ResManager.loadKDString((String)"\r\n \u5df2\u88ab\u5f15\u7528\u7684\u7ec4\u7ec7:\r\n%s", (String)"TaxTotalDataListPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]), orgName);
                this.getView().showConfirm(msg1 + msg2, MessageBoxOptions.OKCancel, confirmCallBacks);
                return;
            }
            if (CollectionUtils.isEmpty(conflictOrgName)) {
                String msg1 = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"TaxTotalDataListPlugin_7", (String)"taxc-tcvat", (Object[])new Object[0]), primaryKeyValues.length);
                this.getView().showConfirm(msg1, MessageBoxOptions.OKCancel, confirmCallBacks);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("Yes".equals(evt.getResultValue())) {
            BillList billList = (BillList)this.getControl("billlistap");
            Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
            this.accountServiceHelper.deleteAllData(primaryKeyValues);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaxTotalDataListPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            billList.refresh();
        }
    }
}

