/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.taxrefund.apply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiQueryListPlugin;

public class TaxRefundMultiQueryListPlugin
extends AbstractDeclareReportMultiQueryListPlugin {
    protected void setExtendCustomParams(Map<String, Object> customParams, DynamicObject object) {
        customParams.put("version", object.getString("accountsettype"));
    }

    public String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected List<String> getTemplateTypeList() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("tcvat_taxrefund");
        return types;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if ("new".equals(evt.getOperateKey())) {
            String querytype = this.getQuerytype(evt.getOperateKey());
            HashMap<String, String> custom = new HashMap<String, String>(16);
            custom.put("type", querytype);
            this.showDeclarePage(querytype, custom, null, null);
        }
        if ("viewflowchart".equals(evt.getOperateKey())) {
            super.afterDoOperation(evt);
        }
        if ("viewtaxrefund".equals(evt.getOperateKey())) {
            ListSelectedRowCollection list = ((BillList)this.getControl("billlistap")).getSelectedRows();
            Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(collect) && collect.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"TaxRefundMultiQueryListPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                return;
            }
            Object pkId = list.get(0).getPrimaryKeyValue();
            DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"tcvat_tax_refund_apply");
            if (declare != null) {
                QFilter filter = new QFilter("declarenum", "=", (Object)declare.getString("billno")).and("taxcategory", "=", (Object)1L);
                boolean exists = QueryServiceHelper.exists((String)"tpo_tax_refund_info", (QFilter[])new QFilter[]{filter});
                if (!exists) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u672a\u751f\u6210\u9000\u7a0e\u5355\u3002", (String)"TaxRefundMultiQueryListPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, String> customerParams = new HashMap<String, String>();
                customerParams.put("declaretype", "tcvat_taxrefund");
                customerParams.put("startdate", "");
                customerParams.put("declarenum", declare.getString("billno"));
                QFilter billListFilter = new QFilter("declaretype", "=", (Object)"tcvat_taxrefund").and(new QFilter("declarenum", "=", (Object)declare.getString("billno")));
                PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tpo_tax_refund_info", (IFormView)this.getView(), customerParams, null, (QFilter)billListFilter);
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (("wsq".equals(operateKey) || "ysq".equals(operateKey) || "zyts".equals(operateKey) || "yts".equals(operateKey)) && args.getListSelectedData().size() > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5355\u884c\u8fdb\u884c\u6807\u8bc6\u3002", (String)"TssqbListPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            return;
        }
        super.beforeDoOperation(args);
    }
}

