/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.opplugin.account.fdckf;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckBatchImportPlugin;

public class EstateSalesConfirmLedgerImportPlugin
extends AbstractLicenseCheckBatchImportPlugin {
    public String getDefaultKeyFields() {
        return "org,project,stage,skssqq,skssqz";
    }

    public String getAppId() {
        return "tcvat";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        HashSet<String> stageNumbers = new HashSet<String>();
        for (ImportBillData data : billdatas) {
            JSONArray entryentity = (JSONArray)data.getData().get((Object)"entryentity");
            for (Object o : entryentity) {
                JSONObject jsonObject = (JSONObject)o;
                BigDecimal dqqrxse = jsonObject.getString("dqqrxse") == null ? BigDecimal.ZERO : new BigDecimal(jsonObject.getString("dqqrxse"));
                BigDecimal qyjebhs = jsonObject.getString("qyjebhs") == null ? BigDecimal.ZERO : new BigDecimal(jsonObject.getString("qyjebhs"));
                BigDecimal dqqrxsebl = qyjebhs.compareTo(BigDecimal.ZERO) > 0 ? dqqrxse.divide(qyjebhs, 4, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                jsonObject.put("dqqrxsebl", (Object)dqqrxsebl.toPlainString());
                BigDecimal dqkpxse = jsonObject.getString("dqkpxse") == null ? BigDecimal.ZERO : new BigDecimal(jsonObject.getString("dqkpxse"));
                BigDecimal dqwkpxse = dqqrxse.subtract(dqkpxse);
                jsonObject.put("dqwkpxse", (Object)dqwkpxse.toPlainString());
                BigDecimal wqkpxse = jsonObject.getString("wqkpxse") == null ? BigDecimal.ZERO : new BigDecimal(jsonObject.getString("wqkpxse"));
                jsonObject.put("ljkpxse", (Object)wqkpxse.add(dqkpxse).toPlainString());
                BigDecimal wqwkpxse = jsonObject.getString("wqwkpxse") == null ? BigDecimal.ZERO : new BigDecimal(jsonObject.getString("wqwkpxse"));
                jsonObject.put("ljwkpxse", (Object)wqwkpxse.add(dqwkpxse).toPlainString());
            }
            JSONObject stage = (JSONObject)data.getData().get((Object)"stage");
            if (stage == null) continue;
            stageNumbers.add(stage.getString("number"));
        }
        DynamicObjectCollection stageQuery = QueryServiceHelper.query((String)"bastax_stage", (String)"number,name,id,taxproject.number", (QFilter[])new QFilter[]{new QFilter("number", "in", stageNumbers)});
        Map<String, List<DynamicObject>> stagenumberGroup = stageQuery.stream().collect(Collectors.groupingBy(a -> a.getString("number")));
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData data = it.next();
            int index = data.getStartIndex();
            JSONObject project = (JSONObject)data.getData().get((Object)"project");
            JSONObject stage = (JSONObject)data.getData().get((Object)"stage");
            if (stage == null || project == null) continue;
            String projectnumber = project.getString("number");
            String stagenumber = stage.getString("number");
            List<DynamicObject> projects = stagenumberGroup.get(stagenumber);
            if (projects != null) {
                Optional<DynamicObject> first = projects.stream().filter(a -> Objects.equals(a.getString("taxproject.number"), projectnumber)).findFirst();
                if (first.isPresent()) {
                    stage.put("id", (Object)first.get().getLong("id"));
                    continue;
                }
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6b64\u5de5\u7a0b\u9879\u76ee\u5206\u671f\u4e0e\u586b\u5199\u7684\u7a0e\u52a1\u9879\u76ee\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EstateSalesConfirmLedgerImportPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]), new Object[0])).fail();
                it.remove();
                continue;
            }
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6b64\u5de5\u7a0b\u9879\u76ee\u5206\u671f\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EstateSalesConfirmLedgerImportPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]), new Object[0])).fail();
            it.remove();
        }
        super.beforeSave(billdatas, logger);
    }
}

